/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.HeapDumpMBean;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class HeapDump
implements HeapDumpMBean {
    private static final Logger logger = Logger.getLogger(HeapDump.class.getName());
    private volatile boolean enabled = true;
    private volatile int maxHeaps = 1;
    private volatile int currentHeaps = 0;
    private volatile long quietPeriodMillis = 86400000L;
    long lastDumpMillis = 0L;
    private String[] cmd = new String[]{"jmap", "-dump:live,format=b,file=%file", "%pid"};
    private String outputFileName = "dumpfile_%pid.hprof";

    @Override
    public long getPid() {
        return Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    @Override
    public String[] getCmd() {
        return this.cmd;
    }

    @Override
    public void setCmd(String[] cmd) {
        this.cmd = cmd;
    }

    @Override
    public String getOutputFileName() {
        return this.outputFileName;
    }

    @Override
    public void setOutputFileName(String name) {
        this.outputFileName = name;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public int getMaxHeaps() {
        return this.maxHeaps;
    }

    @Override
    public void setMaxHeaps(int maxHeaps) {
        this.maxHeaps = maxHeaps;
    }

    @Override
    public int getCurrentHeaps() {
        return this.currentHeaps;
    }

    @Override
    public void setCurrentHeaps(int currentHeaps) {
        this.currentHeaps = currentHeaps;
    }

    @Override
    public long getQuietPeriod() {
        return this.quietPeriodMillis;
    }

    @Override
    public void setQuietPeriod(long millis) {
        this.quietPeriodMillis = millis;
    }

    @Override
    public String createHeapDump() throws IOException, InterruptedException {
        int ch;
        File file = new File(this.subsPid(this.getOutputFileName()));
        if (file.exists()) {
            logger.fine("Deleting file " + file.getAbsolutePath());
            file.delete();
        }
        String[] cmd = this.subsCmd();
        ProcessBuilder processBuilder = new ProcessBuilder(cmd).redirectErrorStream(true);
        Process process = processBuilder.start();
        InputStream is = process.getInputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((ch = is.read()) != -1) {
            os.write((byte)ch);
        }
        String res = os.toString();
        process.waitFor();
        logger.info("Cmd " + Arrays.asList(cmd) + " returns: " + res);
        return res;
    }

    @Override
    public boolean onMemoryShortage() {
        return this.createDumpIfAppropriate(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createDumpIfAppropriate(long currentTimeMillis) {
        if (!this.isEnabled()) {
            return false;
        }
        HeapDump heapDump = this;
        synchronized (heapDump) {
            if (this.maxHeaps <= this.currentHeaps) {
                return false;
            }
            if (currentTimeMillis - this.lastDumpMillis < this.quietPeriodMillis) {
                return false;
            }
            ++this.currentHeaps;
            this.lastDumpMillis = currentTimeMillis;
        }
        try {
            this.createHeapDump();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cmd " + Arrays.asList(this.cmd) + " throws: " + e, e);
            return false;
        }
    }

    private String[] subsCmd() {
        ArrayList<String> res = new ArrayList<String>();
        for (String c : this.cmd) {
            res.add(this.subsPid(this.subsFileName(c)));
        }
        return res.toArray(new String[res.size()]);
    }

    private String subsPid(String arg) {
        return arg.replaceAll("%pid", String.valueOf(this.getPid()));
    }

    private String subsFileName(String arg) {
        return arg.replaceAll("%file", this.getOutputFileName());
    }
}

