/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.AbstractQueryPacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class IdQueryPacket
extends AbstractQueryPacket {
    private static final long serialVersionUID = 1L;
    private String _className;
    private int _version;
    private int _propertiesLength;
    private Object[] _values;
    private int _idFieldIndex;
    private int _routingFieldIndex;
    private AbstractProjectionTemplate _projectionTemplate;
    private transient String _uid;
    private static final byte HAS_CLASS_NAME = 1;
    private static final byte HAS_VERSION = 2;
    private static final byte HAS_PROPERTIES = 4;
    private static final byte HAS_ID = 8;
    private static final byte HAS_ROUTING = 16;
    private static final byte HAS_PROJECTION = 32;

    public IdQueryPacket() {
    }

    public IdQueryPacket(Object id, Object routing, int version, ITypeDesc typeDesc, QueryResultTypeInternal resultType, AbstractProjectionTemplate projectionTemplate) {
        super(typeDesc, resultType);
        this._version = version;
        this._projectionTemplate = projectionTemplate;
        this._className = typeDesc.getTypeName();
        this._propertiesLength = typeDesc.getNumOfFixedProperties();
        this._idFieldIndex = typeDesc.getIdentifierPropertyId();
        this._routingFieldIndex = typeDesc.getRoutingPropertyId();
        this.initValues(id, routing);
    }

    private void initValues(Object id, Object routing) {
        int index;
        this._values = new Object[this._propertiesLength];
        if (id != null && (index = this._idFieldIndex) >= 0) {
            this._values[index] = id;
        }
        if (routing != null && (index = this._routingFieldIndex) >= 0) {
            this._values[index] = routing;
        }
    }

    @Override
    public void setUID(String uid) {
        this._uid = uid;
    }

    @Override
    public String getUID() {
        return this._uid;
    }

    @Override
    public String getTypeName() {
        return this._className;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public Object[] getFieldValues() {
        return this._values;
    }

    @Override
    protected int getIdentifierFieldIndex() {
        return this._idFieldIndex;
    }

    @Override
    public Object getRoutingFieldValue() {
        return this._routingFieldIndex == -1 ? null : this._values[this._routingFieldIndex];
    }

    @Override
    public AbstractProjectionTemplate getProjectionTemplate() {
        return this._projectionTemplate;
    }

    @Override
    public void setProjectionTemplate(AbstractProjectionTemplate projectionTemplate) {
        this._projectionTemplate = projectionTemplate;
    }

    @Override
    public boolean isIdQuery() {
        return true;
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.deserialize(in, version);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.deserialize(in, PlatformLogicalVersion.getLogicalVersion());
    }

    private final void deserialize(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        if ((flags & 1) != 0) {
            this._className = IOUtils.readRepetitiveString(in);
        }
        if ((flags & 2) != 0) {
            this._version = in.readInt();
        }
        if ((flags & 4) != 0) {
            this._propertiesLength = in.readInt();
        }
        Object id = null;
        if ((flags & 8) != 0) {
            this._idFieldIndex = in.readInt();
            id = IOUtils.readObject(in);
        }
        Object routing = null;
        if ((flags & 0x10) != 0) {
            this._routingFieldIndex = in.readInt();
            routing = IOUtils.readObject(in);
        }
        if ((flags & 0x20) != 0) {
            this._projectionTemplate = (AbstractProjectionTemplate)IOUtils.readObject(in);
        }
        this.initValues(id, routing);
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        this.serialize(out, version);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.serialize(out, PlatformLogicalVersion.getLogicalVersion());
    }

    private final void serialize(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        Object id = this.getID();
        Object routing = this.getRoutingFieldValue();
        byte flags = this.buildFlags(id, routing, version);
        out.writeByte(flags);
        if (this._className != null) {
            IOUtils.writeRepetitiveString(out, this._className);
        }
        if (this._version != 0) {
            out.writeInt(this._version);
        }
        if (this._propertiesLength != 0) {
            out.writeInt(this._propertiesLength);
        }
        if (id != null) {
            out.writeInt(this._idFieldIndex);
            IOUtils.writeObject(out, id);
        }
        if (routing != null) {
            out.writeInt(this._routingFieldIndex);
            IOUtils.writeObject(out, routing);
        }
        if (this._projectionTemplate != null && version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            IOUtils.writeObject(out, this._projectionTemplate);
        }
    }

    private byte buildFlags(Object id, Object routing, PlatformLogicalVersion version) {
        byte flags = 0;
        if (this._className != null) {
            flags = (byte)(flags | 1);
        }
        if (this._version != 0) {
            flags = (byte)(flags | 2);
        }
        if (this._propertiesLength != 0) {
            flags = (byte)(flags | 4);
        }
        if (id != null) {
            flags = (byte)(flags | 8);
        }
        if (routing != null) {
            flags = (byte)(flags | 0x10);
        }
        if (this._projectionTemplate != null && version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            flags = (byte)(flags | 0x20);
        }
        return flags;
    }
}

