/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.server.space.SpaceInstanceConfig;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.server.SpaceCustomComponent;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.j_spaces.core.Constants;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.filters.FiltersInfo;
import com.j_spaces.sadapter.datasource.DataAdaptorIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.UnmarshalException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

@InternalApi
public class JSpaceAttributes
extends Properties
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int SERIAL_VERSION = 1;
    private JSpaceAttributes _dCacheProperties;
    private ClusterPolicy _clusterPolicy;
    private SpaceClusterInfo _clusterInfo;
    private FiltersInfo[] _filtersInfo;
    private Properties _blobStoreProperties = new Properties();
    private Properties _customProperties = new Properties();
    @Deprecated
    public boolean m_isClustered;

    public JSpaceAttributes() {
    }

    public JSpaceAttributes(Properties prop) {
        super(prop);
    }

    public JSpaceAttributes(String schemaName, Properties customProperties, boolean isLoadSpaceOnStartup) {
        this.setSchemaName(schemaName);
        this.setCustomProperties(customProperties);
        this.setLoadOnStartup(isLoadSpaceOnStartup);
    }

    public JSpaceAttributes(String schemaName, boolean isLoadSpaceOnStartup) {
        this.setSchemaName(schemaName);
        this.setLoadOnStartup(isLoadSpaceOnStartup);
    }

    public JSpaceAttributes(String schemaName, String clusterConfigURL) {
        this.setSchemaName(schemaName);
        this.setClusterConfigURL(clusterConfigURL);
        if (clusterConfigURL != null) {
            this.setClustered(true);
        }
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        if (value != null) {
            return super.setProperty(key, value);
        }
        return null;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t --- JSpaceAttributes ---\n");
        sb.append("\n\t DCache properties -\t ");
        StringUtils.appendProperties(sb, this.getDCacheProperties());
        sb.append('\n');
        sb.append("\n\t Cluster Info -\t");
        sb.append(this.getClusterInfo());
        sb.append('\n');
        sb.append("\n\t Filters configuration -\t");
        sb.append(Arrays.toString(this.getFiltersInfo()));
        sb.append('\n');
        sb.append("\n\t Custom properties -\t ");
        StringUtils.appendProperties(sb, this.getCustomProperties());
        sb.append('\n');
        sb.append("\n\t Properties\n\t ");
        StringUtils.appendProperties(sb, this);
        sb.append('\n');
        return sb.toString();
    }

    public boolean isPersistent() {
        return Boolean.valueOf(this.getProperty("space-config.persistent.enabled", Constants.StorageAdapter.PERSISTENT_ENABLED_DEFAULT));
    }

    public void setPersistent(boolean isPersistent) {
        this.setProperty("space-config.persistent.enabled", String.valueOf(isPersistent));
    }

    public boolean isQPAutoCommit() {
        return Boolean.valueOf(this.getProperty("space-config.QueryProcessor.auto_commit", Constants.QueryProcessorInfo.QP_AUTO_COMMIT_DEFAULT));
    }

    public void setQPAutoCommit(boolean isQPAutoCommit) {
        this.setProperty("space-config.QueryProcessor.auto_commit", String.valueOf(isQPAutoCommit));
    }

    public boolean isQPParserCaseSensetivity() {
        return Boolean.valueOf(this.getProperty("space-config.QueryProcessor.parser_case_sensetivity", Constants.QueryProcessorInfo.QP_PARSER_CASE_SENSETIVITY_DEFAULT));
    }

    public void setQPParserCaseSensetivity(boolean isQPParserCaseSensetivity) {
        this.setProperty("space-config.QueryProcessor.parser_case_sensetivity", String.valueOf(isQPParserCaseSensetivity));
    }

    public boolean isQPTraceExecTime() {
        return Boolean.valueOf(this.getProperty("space-config.QueryProcessor.trace_exec_time", Constants.QueryProcessorInfo.QP_TRACE_EXEC_TIME_DEFAULT));
    }

    public void setQPTraceExecTime(boolean isQPTraceExecTime) {
        this.setProperty("space-config.QueryProcessor.trace_exec_time", String.valueOf(isQPTraceExecTime));
    }

    public int getQpSpaceReadLeaseTime() {
        return Integer.parseInt(this.getProperty("space-config.QueryProcessor.space_read_lease_time", Constants.QueryProcessorInfo.QP_SPACE_READ_LEASE_TIME_DEFAULT));
    }

    public void setQpSpaceReadLeaseTime(int qpSpaceReadLeaseTime) {
        this.setProperty("space-config.QueryProcessor.space_read_lease_time", String.valueOf(qpSpaceReadLeaseTime));
    }

    public long getQpSpaceWriteLeaseTime() {
        return Long.parseLong(this.getProperty("space-config.QueryProcessor.space_write_lease", Constants.QueryProcessorInfo.QP_SPACE_WRITE_LEASE_DEFAULT));
    }

    public void setQpSpaceWriteLeaseTime(long qpSpaceWriteLeaseTime) {
        this.setProperty("space-config.QueryProcessor.space_write_lease", String.valueOf(qpSpaceWriteLeaseTime));
    }

    public int getQpTransactionTimeout() {
        return Integer.parseInt(this.getProperty("space-config.QueryProcessor.transaction_timeout", Constants.QueryProcessorInfo.QP_TRANSACTION_TIMEOUT_DEFAULT));
    }

    public void setQpTransactionTimeout(int qpTransactionTimeout) {
        this.setProperty("space-config.QueryProcessor.transaction_timeout", String.valueOf(qpTransactionTimeout));
    }

    public String getQpDateFormat() {
        return this.getProperty("space-config.QueryProcessor.date_format", "yyyy-MM-dd");
    }

    public void setQpDateFormat(String qpDateFormat) {
        this.setProperty("space-config.QueryProcessor.date_format", qpDateFormat);
    }

    public String getQpDateTimeFormat() {
        return this.getProperty("space-config.QueryProcessor.datetime_format", "yyyy-MM-dd HH:mm:ss");
    }

    public void setQpDateTimeFormat(String qpDateTimeFormat) {
        this.setProperty("space-config.QueryProcessor.datetime_format", qpDateTimeFormat);
    }

    public String getQpTimeFormat() {
        return this.getProperty("space-config.QueryProcessor.time_format", "HH:mm:ss");
    }

    public void setQpTimeFormat(String qpTimeFormat) {
        this.setProperty("space-config.QueryProcessor.time_format", qpTimeFormat);
    }

    public String isEngineMemoryUsageEnabled() {
        return this.getProperty("space-config.engine.memory_usage.enabled", "true");
    }

    public void setEngineMemoryUsageEnabled(String isMemoryUsageEnabled) {
        this.setProperty("space-config.engine.memory_usage.enabled", isMemoryUsageEnabled);
    }

    public void setEngineMemoryUsageHighPercentageRatio(String highPercentageRatio) {
        this.setProperty("space-config.engine.memory_usage.high_watermark_percentage", highPercentageRatio);
    }

    public String getEngineMemoryUsageHighPercentageRatio() {
        return this.getProperty("space-config.engine.memory_usage.high_watermark_percentage", "95");
    }

    public void setEngineMemoryUsageWriteOnlyBlockPercentageRatio(String blockPercentageRatio) {
        this.setProperty("space-config.engine.memory_usage.write_only_block_percentage", String.valueOf(blockPercentageRatio));
    }

    public String getEngineMemoryUsageWriteOnlyBlockPercentageRatio() {
        return this.getProperty("space-config.engine.memory_usage.write_only_block_percentage", "85");
    }

    public void setEngineMemoryWriteOnlyCheckPercentageRatio(String writeOnlyCheckPercentageRatio) {
        this.setProperty("space-config.engine.memory_usage.write_only_check_percentage", String.valueOf(writeOnlyCheckPercentageRatio));
    }

    public String getEngineMemoryWriteOnlyCheckPercentageRatio() {
        return this.getProperty("space-config.engine.memory_usage.write_only_check_percentage", "76");
    }

    public void setEngineMemoryUsageLowPercentageRatio(String lowPercentageRatio) {
        this.setProperty("space-config.engine.memory_usage.low_watermark_percentage", String.valueOf(lowPercentageRatio));
    }

    public String getEngineMemoryUsageLowPercentageRatio() {
        return this.getProperty("space-config.engine.memory_usage.low_watermark_percentage", "75");
    }

    public String isEngineMemoryExplicitGSEnabled() {
        return this.getProperty("space-config.engine.memory_usage.explicit-gc", "false");
    }

    public void setEngineMemoryExplicitGSEnabled(String isMemoryExplicitGSEnabled) {
        this.setProperty("space-config.engine.memory_usage.explicit-gc", isMemoryExplicitGSEnabled);
    }

    public String isEngineMemoryGCBeforeShortageEnabled() {
        return this.getProperty("space-config.engine.memory_usage.gc-before-shortage", "true");
    }

    public void setEngineMemoryGCBeforeShortageEnabled(String gcBeforeShortage) {
        this.setProperty("space-config.engine.memory_usage.gc-before-shortage", gcBeforeShortage);
    }

    public void setEngineMemoryUsageRetryCount(String retryCount) {
        this.setProperty("space-config.engine.memory_usage.retry_count", retryCount);
    }

    public String getEngineMemoryUsageRetryCount() {
        return this.getProperty("space-config.engine.memory_usage.retry_count", "5");
    }

    public void setEngineMemoryUsageEvictionBatchSize(String evictionBatchSize) {
        this.setProperty("space-config.engine.memory_usage.eviction_batch_size", evictionBatchSize);
    }

    public String getEngineMemoryUsageEvictionBatchSize() {
        return this.getProperty("space-config.engine.memory_usage.eviction_batch_size", "500");
    }

    public void setEngineMaxThreads(String maxThreads) {
        this.setProperty("space-config.engine.max_threads", maxThreads);
    }

    public String getEngineMaxThreads() {
        return this.getProperty("space-config.engine.max_threads", "64");
    }

    public void setEngineMinThreads(String minThreads) {
        this.setProperty("space-config.engine.min_threads", minThreads);
    }

    public String getEngineMinThreads() {
        return this.getProperty("space-config.engine.min_threads", "1");
    }

    public void setDCacheConfigName(String dCacheConfigName) {
        this.setProperty("space-config.dist-cache.config-name", dCacheConfigName);
    }

    public String getDCacheConfigName() {
        return this.getProperty("space-config.dist-cache.config-name", "DefaultConfig");
    }

    public void setNotifyRetries(String notifyRetries) {
        this.setProperty("space-config.notifier-retries", notifyRetries);
    }

    public String getNotifyRetries() {
        return this.getProperty("space-config.notifier-retries", String.valueOf("3"));
    }

    public void setConnectionRetries(String connectionRetries) {
        this.setProperty("space-config.retries", connectionRetries);
    }

    public String getConnectionRetries() {
        return this.getProperty("space-config.retries", String.valueOf("10"));
    }

    public void setSerializationType(int serializationType) {
        this.setProperty("space-config.serialization-type", String.valueOf(serializationType));
    }

    public int getSerializationType() {
        return Integer.parseInt(this.getProperty("space-config.serialization-type", String.valueOf(Constants.Engine.ENGINE_SERIALIZATION_TYPE_DEFAULT)));
    }

    public boolean isPrivate() {
        return Boolean.valueOf(this.getProperty("space-config.isPrivate", Constants.LookupManager.LOOKUP_IS_PRIVATE_DEFAULT));
    }

    public void setPrivate(boolean isPrivate) {
        this.setProperty("space-config.isPrivate", String.valueOf(isPrivate));
    }

    public void setExpirationTimeInterval(String expirationTimeInterval) {
        this.setProperty("space-config.lease_manager.expiration_time_interval", expirationTimeInterval);
    }

    public String getExpirationTimeInterval() {
        return this.getProperty("space-config.lease_manager.expiration_time_interval", String.valueOf(10000L));
    }

    public void setExpirationTimeRecentDeletes(String expirationTimeRecentDeletes) {
        this.setProperty("space-config.lease_manager.expiration_time_recent_deletes", expirationTimeRecentDeletes);
    }

    public String getExpirationTimeRecentDeletes() {
        return this.getProperty("space-config.lease_manager.expiration_time_recent_deletes", String.valueOf(180000L));
    }

    public void setExpirationTimeRecentUpdate(String expirationTimeRecentUpdates) {
        this.setProperty("space-config.lease_manager.expiration_time_recent_updates", expirationTimeRecentUpdates);
    }

    public String getExpirationTimeRecentUpdates() {
        return this.getProperty("space-config.lease_manager.expiration_time_recent_deletes", String.valueOf(180000L));
    }

    public void setExpirationStaleReplicas(String expirationStaleReplicas) {
        this.setProperty("space-config.lease_manager.expiration_stale_replicas", expirationStaleReplicas);
    }

    public String getExpirationStaleReplicas() {
        return this.getProperty("space-config.lease_manager.expiration_stale_replicas", String.valueOf(300000L));
    }

    public void setSpaceState(String spaceState) {
        this.setProperty("space-config.space_state", spaceState);
    }

    public String getSpaceState() {
        return this.getProperty("space-config.space_state");
    }

    public void setSchemaName(String schemaName) {
        this.setProperty("space-config.schema", schemaName);
    }

    public String getSchemaName() {
        return this.getProperty("space-config.schema", null);
    }

    public void setLoadOnStartup(boolean isLoadOnStartup) {
        this.setProperty("load-on-startup", String.valueOf(isLoadOnStartup));
    }

    public boolean isLoadOnStartup() {
        return Boolean.valueOf(this.getProperty("load-on-startup", Boolean.FALSE.toString()));
    }

    public void setCacheManagerSize(String cacheManagerSize) {
        this.setProperty("space-config.engine.cache_size", cacheManagerSize);
    }

    public String getCacheManagerSize() {
        return this.getProperty("space-config.engine.cache_size", "100000");
    }

    public void setCachePolicy(String cachePolicy) {
        this.setProperty("space-config.engine.cache_policy", cachePolicy);
    }

    public String getCachePolicy() {
        return this.getProperty("space-config.engine.cache_policy", String.valueOf(1));
    }

    public boolean isClustered() {
        return Boolean.valueOf(this.getProperty("space-config.cluster.enabled", Constants.Cluster.IS_CLUSTER_SPACE_DEFAULT));
    }

    public void setClustered(boolean isClustered) {
        this.setProperty("space-config.cluster.enabled", String.valueOf(isClustered));
        this.m_isClustered = isClustered;
    }

    public void setClusterConfigURL(String clusterConfigURL) {
        this.setProperty("space-config.cluster.config-url", clusterConfigURL);
    }

    public String getClusterConfigURL() {
        return this.getProperty("space-config.cluster.config-url", "none");
    }

    public void setJMSRmiPort(String rmiPort) {
        this.setProperty("space-config.jms.connections.rmi-port", rmiPort);
    }

    public String getJMSRmiPort() {
        return this.getProperty("space-config.jms.connections.rmi-port", "10098");
    }

    public void setJMSTopicNames(String topicNames) {
        this.setProperty("space-config.jms.administrated-destinations.topics.topic-names", topicNames);
    }

    public String getJMSTopicNames() {
        return this.getProperty("space-config.jms.administrated-destinations.topics.topic-names", "MyTopic,TempTopic");
    }

    public void setJMSQueueNames(String queueNames) {
        this.setProperty("space-config.jms.administrated-destinations.queues.queue-names", queueNames);
    }

    public String getJMSQueueNames() {
        return this.getProperty("space-config.jms.administrated-destinations.queues.queue-names", "MyQueue,TempQueue");
    }

    public void setCustomProperties(Properties customProperties) {
        this._customProperties.clear();
        this._customProperties.putAll((Map<?, ?>)customProperties);
    }

    public Properties getCustomProperties() {
        return this._customProperties;
    }

    public void setFiltersInfo(FiltersInfo[] filtersInfo) {
        this._filtersInfo = filtersInfo;
    }

    public void setFilterInfoAt(FiltersInfo filterInfo, int index) {
        this._filtersInfo[index] = filterInfo;
    }

    public FiltersInfo[] getFiltersInfo() {
        return this._filtersInfo;
    }

    public void setClusterPolicy(ClusterPolicy clusterPolicy) {
        this._clusterPolicy = clusterPolicy;
    }

    public ClusterPolicy getClusterPolicy() {
        return this._clusterPolicy;
    }

    public void setDCacheProperties(JSpaceAttributes dCacheProperties) {
        this._dCacheProperties = dCacheProperties;
    }

    public JSpaceAttributes getDCacheProperties() {
        return this._dCacheProperties;
    }

    public boolean isMirrorServiceEnabled() {
        return Boolean.valueOf(this.getProperty("space-config.mirror-service.enabled", "false"));
    }

    public void setMirrorServiceEnabled(boolean isMirrorServiceEnabled) {
        this.setProperty("space-config.mirror-service.enabled", String.valueOf(isMirrorServiceEnabled));
    }

    public void setMaxClassLoaders(int maxClassLoaders) {
        this.setProperty("space-config.remote-code.max-class-loaders", String.valueOf(maxClassLoaders));
    }

    public String getMaxClassLoaders() {
        return this.getProperty("space-config.remote-code.max-class-loaders", "3");
    }

    public void setSupportCodeChange(boolean enableTaskReloading) {
        this.setProperty("space-config.remote-code.support.code.change", String.valueOf(enableTaskReloading));
    }

    public String getSupportCodeChange() {
        return this.getProperty("space-config.remote-code.support.code.change", "true");
    }

    public String getDataSourceClass() {
        return this.getProperty("space-config.external-data-source.data-source-class", "org.openspaces.persistency.hibernate.DefaultHibernateExternalDataSource");
    }

    public SpaceInstanceConfig getSpaceInstanceConfig() {
        return (SpaceInstanceConfig)this.getCustomProperties().get("space-config");
    }

    public Map<String, SpaceCustomComponent> getCustomComponents() {
        SpaceInstanceConfig config = this.getSpaceInstanceConfig();
        return config != null ? config.getCustomComponents() : null;
    }

    public SpaceDataSource getSpaceDataSourceInstance() {
        return (SpaceDataSource)this.getCustomProperties().get("external-data-source.space-data-source");
    }

    public String getSpaceDataSourceClassName() {
        return this.getCustomProperties().getProperty("space-config.external-data-source.space-data-source-class");
    }

    public SpaceSynchronizationEndpoint getSynchronizationEndpointInstance() {
        return (SpaceSynchronizationEndpoint)this.getCustomProperties().get("external-data-source.space-sync-endpoint");
    }

    public String getSynchronizationEndpointClassName() {
        return this.getCustomProperties().getProperty("space-config.external-data-source.space-sync-endpoint-class");
    }

    public void setDataSourceClass(String className) {
        this.setProperty("space-config.external-data-source.data-source-class", className);
    }

    public String getDataPropertiesFile() {
        return this.getProperty("space-config.external-data-source.init-properties-file", "");
    }

    public void setDataPropertiesFile(String propertiesFile) {
        this.setProperty("space-config.external-data-source.init-properties-file", propertiesFile);
    }

    public String getDataClass() {
        return this.getProperty("space-config.external-data-source.data-class", Constants.DataAdapter.DATA_CLASS_DEFAULT);
    }

    public String getQueryBuilderClass() {
        return this.getProperty("space-config.external-data-source.query-builder-class", Constants.DataAdapter.QUERY_BUILDER_PROP_DEFAULT);
    }

    public void setQueryBuilderClass(String className) {
        this.setProperty("space-config.external-data-source.query-builder-class", className);
    }

    public void setDataClass(String className) {
        this.setProperty("space-config.external-data-source.data-class", className);
    }

    public String getUsage() {
        return this.getProperty("space-config.external-data-source.usage", "read-write");
    }

    public void setUsage(String usage) {
        this.setProperty("space-config.external-data-source.usage", usage);
    }

    public boolean isSupportsInheritanceEnabled() {
        return Boolean.valueOf(this.getProperty("space-config.external-data-source.supports-inheritance", "true"));
    }

    public void setSupportsInheritanceEnabled(boolean isSupportsInheritanceEnabled) {
        this.setProperty("space-config.external-data-source.supports-inheritance", String.valueOf(isSupportsInheritanceEnabled));
    }

    public boolean isSupportsVersionEnabled() {
        return Boolean.valueOf(this.getProperty("space-config.external-data-source.supports-version", "false"));
    }

    public void setSupportsVersionEnabled(boolean isSupportsVersionEnabled) {
        this.setProperty("space-config.external-data-source.supports-version", String.valueOf(isSupportsVersionEnabled));
    }

    public boolean isSupportsPartialUpdateEnabled() {
        return Boolean.valueOf(this.getProperty("space-config.external-data-source.supports-partial-update", "false"));
    }

    public void setSupportsPartialUpdateEnabled(boolean isSupportsPartialUpdateEnabled) {
        this.setProperty("space-config.external-data-source.supports-partial-update", String.valueOf(isSupportsPartialUpdateEnabled));
    }

    public boolean isSupportsRemoveByIdEnabled() {
        return Boolean.valueOf(this.getProperty("space-config.external-data-source.supports-remove-by-id", "false"));
    }

    public void setSupportsRemoveByIdEnabled(boolean isSupportsRemoveByIdEnabled) {
        this.setProperty("space-config.external-data-source.supports-remove-by-id", String.valueOf(isSupportsRemoveByIdEnabled));
    }

    public boolean getDataSourceSharedIteratorMode() {
        return Boolean.valueOf(this.getProperty("space-config.external-data-source.shared-iterator.enabled", "true"));
    }

    public void setDataSourceSharedIteratorMode(boolean enabled) {
        this.setProperty("space-config.external-data-source.shared-iterator.enabled", String.valueOf(enabled));
    }

    public long getDataSourceSharedIteratorTimeToLive() {
        String leaseManagerExpirationTimeRecentDeletes = this.getExpirationTimeRecentDeletes();
        String leaseManagerExpirationTimeRecentUpdates = this.getExpirationTimeRecentUpdates();
        String dataSourceShareIteratorTTLDefault = DataAdaptorIterator.getDataSourceShareIteratorTTLDefault(Long.parseLong(leaseManagerExpirationTimeRecentDeletes), Long.parseLong(leaseManagerExpirationTimeRecentUpdates));
        return Long.valueOf(this.getProperty("space-config.external-data-source.shared-iterator.time-to-live", dataSourceShareIteratorTTLDefault));
    }

    public void setDataSourceSharedIteratorTimeToLive(long timeToLive) {
        this.setProperty("space-config.external-data-source.shared-iterator.time-to-live", String.valueOf(timeToLive));
    }

    public String getProxyConnectionMode() {
        return this.getProperty("space-config.proxy-settings.connection-monitor", "all");
    }

    public void setProxyConnectionMode(String connectionMode) {
        this.setProperty("space-config.proxy-settings.connection-monitor", connectionMode);
    }

    public long getProxyMonitorFrequency() {
        return Long.parseLong(this.getProperty("space-config.proxy-settings.ping-frequency", Constants.SpaceProxy.OldRouter.MONITOR_FREQUENCY_DEFAULT));
    }

    public void setProxyMonitorFrequency(long frequency) {
        this.setProperty("space-config.proxy-settings.ping-frequency", String.valueOf(frequency));
    }

    public long getProxyDetectorFrequency() {
        return Long.parseLong(this.getProperty("space-config.proxy-settings.lookup-frequency", Constants.SpaceProxy.OldRouter.DETECTOR_FREQUENCY_DEFAULT));
    }

    public void setProxyDetectorFrequency(long frequency) {
        this.setProperty("space-config.proxy-settings.lookup-frequency", String.valueOf(frequency));
    }

    public int getProxyConnectionRetries() {
        return Integer.parseInt(this.getProperty("space-config.proxy-settings.connection-retries", "10"));
    }

    public void setProxyConnectionRetries(int connectionRetries) {
        this.setProperty("space-config.proxy-settings.connection-retries", String.valueOf(connectionRetries));
    }

    @Deprecated
    public int getBlobStoreCapacityGB() {
        String blobStoreCapacityGB = this.getProperty("blobStoreCapacityGB", "-1");
        return Integer.parseInt(blobStoreCapacityGB);
    }

    @Deprecated
    public int getBlobStoreCacheCapacityMB() {
        String blobStoreCacheCapacityMB = this.getProperty("blobStoreCacheSizeMB", "-1");
        return Integer.parseInt(blobStoreCacheCapacityMB);
    }

    @Deprecated
    public String getBlobStoreDevices() {
        return this.getProperty("blobStoreDevices");
    }

    @Deprecated
    public String getBlobStoreVolumeDir() {
        return this.getProperty("blobStoreVolumeDir");
    }

    @Deprecated
    public String getBlobStoreDurabilityLevel() {
        return this.getProperty("blobStoreDurabilityLevel");
    }

    @Deprecated
    public boolean isBlobstorePersistent() {
        return Boolean.parseBoolean(this.getProperty("space-config.engine.blobstore_persistent", "false"));
    }

    @Deprecated
    public int getBlobStoreCacheSize() {
        return Integer.parseInt(this.getProperty("space-config.engine.blobstore_cache_size", "10000"));
    }

    public Properties getBlobStoreProperties() {
        return this._blobStoreProperties;
    }

    public void setBlobStoreProperties(Properties blobstoreProperties) {
        this._blobStoreProperties.clear();
        this._blobStoreProperties.putAll((Map<?, ?>)blobstoreProperties);
    }

    public int getZookeeperConnectionTimeout() {
        return Integer.parseInt(this.getSystemProperty("space-config.leader-election.zookeeper.connection-timeout", this.getProperty("space-config.leader-election.zookeeper.connection-timeout", "5000")));
    }

    public void setZookeeperConnectionTimeout(long connectionTimeout) {
        this.setProperty("space-config.leader-election.zookeeper.connection-timeout", String.valueOf(connectionTimeout));
    }

    public int getZookeeperSessionTimeout() {
        return Integer.parseInt(this.getSystemProperty("space-config.leader-election.zookeeper.session-timeout", this.getProperty("space-config.leader-election.zookeeper.session-timeout", "15000")));
    }

    public void setZookeeperSessionTimeout(long sessionTimeout) {
        this.setProperty("space-config.leader-election.zookeeper.session-timeout", String.valueOf(sessionTimeout));
    }

    public int getZookeeperRetryTimeout() {
        return Integer.parseInt(this.getSystemProperty("space-config.leader-election.zookeeper.retry-timeout", this.getProperty("space-config.leader-election.zookeeper.retry-timeout", Constants.LeaderSelector.RETRY_TIMEOUT_DEFAULT)));
    }

    public void setZookeeperRetryTimeout(long retryTimeout) {
        this.setProperty("space-config.leader-election.zookeeper.retry-timeout", String.valueOf(retryTimeout));
    }

    public int getZookeeperRetryInterval() {
        return Integer.parseInt(this.getSystemProperty("space-config.leader-election.zookeeper.retry-interval", this.getProperty("space-config.leader-election.zookeeper.retry-interval", "100")));
    }

    public void setZookeeperRetryInterval(long retryInterval) {
        this.setProperty("space-config.leader-election.zookeeper.retry-interval", String.valueOf(retryInterval));
    }

    private String getSystemProperty(String key, String def) {
        return System.getProperty(key, def);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this._customProperties != null) {
            this._customProperties.clear();
        }
        if (this._dCacheProperties != null) {
            this._dCacheProperties.clear();
        }
    }

    public SpaceClusterInfo getClusterInfo() {
        return this._clusterInfo;
    }

    public void setClusterInfo(SpaceClusterInfo _clusterInfo) {
        this._clusterInfo = _clusterInfo;
    }

    private byte buildFlags(PlatformLogicalVersion version) {
        byte flags = 0;
        if (this._dCacheProperties != null) {
            flags = (byte)(flags | 1);
        }
        if (this._clusterPolicy != null) {
            flags = (byte)(flags | 2);
        }
        if (this._filtersInfo != null) {
            flags = (byte)(flags | 4);
        }
        if (this._customProperties != null) {
            flags = (byte)(flags | 8);
        }
        if (this.m_isClustered) {
            flags = (byte)(flags | 0x10);
        }
        if (this._blobStoreProperties != null && version.greaterOrEquals(PlatformLogicalVersion.v11_0_0)) {
            flags = (byte)(flags | 0x40);
        }
        return flags;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1) {
            throw new UnmarshalException("Class [" + this.getClass().getName() + "] received version [" + version + "] does not match local version [" + 1 + "]. Please sure you are using the same version on both ends.");
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
        byte flags = in.readByte();
        if (flags == 0) {
            return;
        }
        if ((flags & 1) != 0) {
            this._dCacheProperties = (JSpaceAttributes)in.readObject();
        }
        if ((flags & 2) != 0) {
            this._clusterPolicy = new ClusterPolicy();
            this._clusterPolicy.readExternal(in);
        }
        if ((flags & 4) != 0) {
            this._filtersInfo = (FiltersInfo[])in.readObject();
        }
        if ((flags & 8) != 0) {
            this._customProperties = (Properties)in.readObject();
        }
        boolean bl = this.m_isClustered = (flags & 0x10) != 0;
        if ((flags & 0x20) != 0) {
            this._clusterInfo = new SpaceClusterInfo();
            this._clusterInfo.readExternal(in);
        }
        if ((flags & 0x40) != 0) {
            this._blobStoreProperties = (Properties)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        boolean serializeClusterInfo = this._clusterInfo != null && version.greaterOrEquals(PlatformLogicalVersion.v11_0_0);
        out.writeInt(1);
        out.writeInt(this.size());
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        byte flags = this.buildFlags(version);
        if (serializeClusterInfo) {
            flags = (byte)(flags | 0x20);
        }
        out.writeByte(flags);
        if (flags == 0) {
            return;
        }
        if (this._dCacheProperties != null) {
            out.writeObject(this._dCacheProperties);
        }
        if (this._clusterPolicy != null) {
            this._clusterPolicy.writeExternal(out);
        }
        if (this._filtersInfo != null) {
            out.writeObject(this._filtersInfo);
        }
        if (this._customProperties != null) {
            out.writeObject(this._customProperties);
        }
        if (serializeClusterInfo) {
            this._clusterInfo.writeExternal(out);
        }
        if (version.greaterOrEquals(PlatformLogicalVersion.v11_0_0) && this._blobStoreProperties != null) {
            out.writeObject(this._blobStoreProperties);
        }
    }

    private static interface BitMap {
        public static final byte _DCACHEPROPERTIES = 1;
        public static final byte _CLUSTERPOLICY = 2;
        public static final byte _FILTERSINFO = 4;
        public static final byte _CUSTOMPROPERTIES = 8;
        public static final byte M_ISCLUSTERED = 16;
        public static final byte M_CLUSTERINFO = 32;
        public static final byte _BLOBSTOREPROPERTIES = 64;
    }
}

