/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.admin.cli.RuntimeInfo;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.transaction.MahaloFactory;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.lookup.RegistrarFactory;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.utils.AbstractShutdownHook;
import com.gigaspaces.internal.utils.ValidationUtils;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.security.service.SecurityResolver;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.Constants;
import com.j_spaces.core.ContainerConfigFactory;
import com.j_spaces.core.CreateException;
import com.j_spaces.core.DestroyedFailedException;
import com.j_spaces.core.GracefulContainerShutDown;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.LRMIJSpaceContainer;
import com.j_spaces.core.LookupManager;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.SpaceConfigFactory;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.core.exception.InvalidServiceNameException;
import com.j_spaces.core.exception.SpaceConfigurationException;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.j_spaces.jmx.JMXProvider;
import com.j_spaces.kernel.Environment;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.SystemProperties;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.sadapter.datasource.DataAdaptorIterator;
import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.mahalo.TxnManager;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.start.NonActivatableServiceDescriptor;
import com.sun.jini.start.ServiceProxyAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jini.admin.Administrable;
import net.jini.config.ConfigurationException;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.export.Exporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import sun.security.provider.Sun;

@InternalApi
public class JSpaceContainerImpl
implements IJSpaceContainer,
IJSpaceContainerAdmin {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.container");
    private static final Logger licenseLogger = Logger.getLogger("com.gigaspaces.license");
    private static final long MAX_UNEXPORT_DELAY = 60000L;
    private static final String COLON = ":";
    private static final String SPACE_TAG = "JSpaces";
    private static final String SPACE_CONFIG = "space-config";
    public static final int STARTING_STATUS = 0;
    public static final int RUNNING_STATUS = 1;
    public static final int SHUTDOWN_STATUS = 2;
    private final LifeCycle _lifeCycle;
    private final String _schemaName;
    private final SpaceURL _url;
    private final Properties _customProperties;
    private final String _containerName;
    private final String _spaceName;
    private final String _clusterSchema;
    private final Object _lock;
    private final String _hostname;
    private final Exporter _containerExporter;
    private final long _startTime;
    private IJSpaceContainer _containerStub;
    private final ShutdownHook _shutdownHook;
    private ContainerEntry _containerEntry;
    private StringBuilder clusterConfigOutput;
    private Element m_rootContainerElement;
    private Element m_rootSpaceElement;
    private Document m_containerConfigFileDocument;
    private Document m_containerFileDocument;
    private Node m_spaceConfigNode;
    private LookupManager m_LookupMng;
    private File m_ContainerFile;
    private String m_FileNameWithoutExtention;
    private int m_containerStatus;
    private String m_configDirectory;
    private volatile ContainerConfig m_containerConfig;
    private String _rmiHostAndPort;
    private boolean isFirstSpaceCreated;
    private Map<String, SpaceConfig> _allSpaceSchemasMap;
    private NonActivatableServiceDescriptor.Created _reggieCreatedRef;
    private NonActivatableServiceDescriptor.Created _mahaloCreatedRef;

    public ContainerEntry getContainerEntry() {
        return this._containerEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerEntry getContainerEntry(String spaceName) throws NoSuchNameException {
        if (spaceName == null) {
            throw new IllegalArgumentException("The spaceName parameter can not be null.");
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._containerEntry == null || !this._spaceName.equals(spaceName)) {
                throw new NoSuchNameException("Space <" + spaceName + "> does not exist in <" + this._containerName + "> container.");
            }
            return this._containerEntry;
        }
    }

    public JSpaceContainerImpl(LifeCycle lifeCycle, String schemaName, SpaceURL spaceURL, Properties schemaProperties) throws Exception {
        block6: {
            this.m_containerStatus = 0;
            this._reggieCreatedRef = null;
            this._mahaloCreatedRef = null;
            this._startTime = System.currentTimeMillis();
            this._lifeCycle = lifeCycle;
            this._schemaName = schemaName;
            this._url = spaceURL;
            this._customProperties = schemaProperties;
            this._containerName = spaceURL.getContainerName();
            this._spaceName = spaceURL.getSpaceName();
            this._clusterSchema = spaceURL.getClusterSchema();
            this._lock = new Object();
            this._hostname = SystemInfo.singleton().network().getHost().getHostName();
            RuntimeInfo.logRuntimeInfo(_logger, "Starting space...");
            this._containerExporter = ServiceConfigLoader.getExporter();
            try {
                this._containerStub = new LRMIJSpaceContainer(this, (IJSpaceContainer)this._containerExporter.export((Remote)this), this._containerName);
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block6;
                _logger.log(Level.SEVERE, "Failed to exports the remote object for <" + this.getName() + "> container: ", ex);
            }
        }
        try {
            this.initContainer();
        }
        catch (Exception e) {
            try {
                this.shutdownInternal();
            }
            catch (Exception e2) {
                _logger.log(Level.FINE, "Could not shutdown cleanly after failed initialization.", e);
            }
            throw e;
        }
        this._shutdownHook = this.initShutdownHook();
    }

    public long getStartTime() {
        return this._startTime;
    }

    private static void initSecurity() {
        block2: {
            try {
                Security.addProvider(new Sun());
            }
            catch (SecurityException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, "Failed to add the sun.security.provider.Sun SecurityManager: " + e.toString(), e);
            }
        }
    }

    private ShutdownHook initShutdownHook() {
        ShutdownHook shutdownHook;
        block3: {
            shutdownHook = null;
            try {
                String addShutdownHook = JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.shutdown_hook", "true", true);
                if (addShutdownHook.equalsIgnoreCase("true")) {
                    shutdownHook = new ShutdownHook();
                    Runtime.getRuntime().addShutdownHook((Thread)((Object)shutdownHook));
                }
            }
            catch (Throwable t) {
                if (!_logger.isLoggable(Level.WARNING)) break block3;
                _logger.log(Level.WARNING, "Failed to add ShutdownHook for <" + this.getName() + "> container: ", t);
            }
        }
        return shutdownHook;
    }

    private void initContainer() throws Exception {
        this.m_containerStatus = 0;
        GSLogConfigLoader.getLoader();
        if (this._url != null) {
            String registeredRmiHostAndPort = this.loadRMIRegistry(this._url.getHost());
            this._url.setProperty("host", registeredRmiHostAndPort);
            JProperties.getContainerProperties(this._containerName).setProperty("com.j_spaces.core.container.directory_services.jndi.url", registeredRmiHostAndPort);
        }
        String prevGroups = JSpaceContainerImpl.setLookupgroups(this._url.getProperty("groups"));
        String prevLocators = JSpaceContainerImpl.setLookupLocators(this._customProperties.getProperty("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host"));
        this._reggieCreatedRef = JSpaceContainerImpl.createLookupServiceIfNeeded(this._containerName);
        this._mahaloCreatedRef = JSpaceContainerImpl.createMahaloIfNeeded(this._containerName);
        SystemInfo.singleton().lookup().setGroups(prevGroups);
        SystemInfo.singleton().lookup().setLocators(prevLocators);
        this.m_LookupMng = new LookupManager(this.getName());
        this.xmlInit();
        if (this.isJMXEnabled()) {
            block8: {
                try {
                    JMXProvider.registerContainerMBean(this._containerName, this);
                }
                catch (Throwable ex) {
                    if (!_logger.isLoggable(Level.WARNING)) break block8;
                    _logger.log(Level.WARNING, "Failed registering ContainerMBean: " + ex.toString(), ex);
                }
            }
            JMXProvider.registerTransportMBean(this._containerName);
            JMXProvider.registerLocalTimeMBean(this._containerName);
        } else if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, "MBean Server did not start since the JMX support is disabled.");
        }
        this.m_containerStatus = 1;
        if (Boolean.getBoolean("com.gs.env.report")) {
            StringBuilder envDumpInfo = this.getSystemDump();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("\n " + envDumpInfo.toString());
            }
        }
    }

    @Override
    public String getRuntimeConfigReport() {
        return this.getSystemDump().toString();
    }

    private StringBuilder getSystemDump() {
        StringBuilder envDumpInfo = new StringBuilder("\n\n==============================================================================================\n");
        envDumpInfo.append(JProperties.getContainerPropertiesDump(this._containerName));
        envDumpInfo.append(JProperties.getAllSpacesPropertiesDump());
        if (this.clusterConfigOutput != null) {
            envDumpInfo.append(this.clusterConfigOutput.toString());
        }
        envDumpInfo.append("Space initialized using SpaceURL:" + this._url);
        envDumpInfo.append(RuntimeInfo.getEnvironmentInfo(true));
        return envDumpInfo;
    }

    public IJSpaceContainer getContainerProxy() {
        return this._containerStub;
    }

    protected void unregister() {
        block4: {
            try {
                long endTime = SystemTime.timeMillis() + 60000L;
                boolean unexported = false;
                while (!unexported && SystemTime.timeMillis() < endTime) {
                    unexported = this._containerExporter.unexport(true);
                    if (unexported) continue;
                    Thread.yield();
                }
                if (!unexported) {
                    this._containerExporter.unexport(true);
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xmlInit() throws Exception {
        Object _containerFileName;
        String containerConfigURL = JProperties.getURL();
        File confDir = null;
        if (!JSpaceUtilities.isEmpty(containerConfigURL)) {
            confDir = new File(new File(containerConfigURL).getParent());
        }
        this.m_configDirectory = confDir != null && confDir.canRead() ? confDir.getPath() : SystemInfo.singleton().locations().config();
        URL containerXMLURL = ResourceLoader.findContainerXML(this._containerName);
        if (containerXMLURL != null) {
            this.m_ContainerFile = new File(new URI(containerXMLURL.toString()));
            _containerFileName = this.m_ContainerFile.getPath();
            this.m_FileNameWithoutExtention = ((String)_containerFileName).substring(0, ((String)_containerFileName).length() - ".xml".length());
        } else {
            this.m_FileNameWithoutExtention = SystemInfo.singleton().locations().config() + File.separator + this._containerName;
        }
        _containerFileName = this._lock;
        synchronized (_containerFileName) {
            if (this._containerEntry == null && this.m_ContainerFile == null && !JSpaceUtilities.isEmpty(this._spaceName)) {
                boolean isLoadOnStartup = false;
                if (!this.isFirstSpaceCreated && !JSpaceUtilities.isEmpty(this._spaceName)) {
                    isLoadOnStartup = true;
                }
                this.loadSpace(this._spaceName, new JSpaceAttributes(this._schemaName, this._customProperties, isLoadOnStartup));
                return;
            }
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (!JSpaceUtilities.isEmpty(containerConfigURL)) {
            this.m_containerConfigFileDocument = builder.parse(containerConfigURL);
            JSpaceUtilities.normalize(this.m_containerConfigFileDocument);
            NodeList spConfNL = this.m_containerConfigFileDocument.getElementsByTagName(SPACE_CONFIG);
            if (spConfNL.getLength() == 0) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("<space-config> tag does not exist in " + this.m_configDirectory + File.separator + this._containerName + ".xml file. Space config XML file of space will not be created.");
                }
            } else {
                this.m_spaceConfigNode = spConfNL.item(0);
            }
        }
        if (this.m_ContainerFile != null && this.m_ContainerFile.exists()) {
            this.loadSpacesFromXMLFile(builder);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("This container " + this._containerName + " loaded successful from " + this.m_ContainerFile + " XML file.");
            }
        }
    }

    public IJSpace createSpace(String spaceName, JSpaceAttributes spaceAttr) throws CreateException, RemoteException {
        if (spaceName == null) {
            throw new IllegalArgumentException("The spaceName parameter can not be null.");
        }
        spaceName = spaceName.trim();
        try {
            ValidationUtils.checkServiceNameForValidation(spaceName, "Space name");
        }
        catch (InvalidServiceNameException exc) {
            throw new CreateException("Invalid space name.", new InvalidServiceNameException(exc.getMessage()));
        }
        String fullSpaceName = JSpaceUtilities.createFullSpaceName(this._containerName, spaceName);
        System.setProperty("com.gs.container.name", this._containerName);
        System.setProperty("com.gs.space.name", spaceName);
        Object object = this._lock;
        synchronized (object) {
            if (!spaceName.equalsIgnoreCase(this._containerName) && this._containerEntry == null && this._spaceName.equals(spaceName)) {
                boolean isSpaceFileAreadyWasExists = new File(this.m_configDirectory + File.separator + spaceName + ".xml").exists();
                try {
                    SpaceImpl spaceImpl;
                    block19: {
                        String schemaFilePath;
                        InputStream schemaInputStream;
                        String schemaName = spaceAttr.getSchemaName();
                        if (schemaName != null && (schemaInputStream = ResourceLoader.getResourceStream(schemaFilePath = "config/schemas/" + schemaName + "-space-schema.xml")) == null) {
                            String schemasFolderPath = Environment.createSchemasFolderIfNotExists();
                            String schemaFileFullPath = schemasFolderPath + File.separator + schemaName + "-space-schema.xml";
                            spaceAttr.setProperty("space-config.schema", schemaName);
                            File schemaFile = new File(schemaFileFullPath);
                            SpaceConfigFactory.performSaveAs(schemaFile, spaceName, this._containerName, spaceAttr);
                        }
                        this.createSpaceXML(spaceName, spaceAttr);
                        Properties spaceProperties = JProperties.getSpaceProperties(fullSpaceName);
                        if (spaceAttr.getClusterConfigURL() != null && !spaceAttr.getClusterConfigURL().equals("none")) {
                            ClusterPolicy clusterPolicy = this.createClusterPolicy(spaceName, spaceAttr.getClusterConfigURL());
                            spaceAttr.setClustered(true);
                            spaceAttr.setClusterPolicy(clusterPolicy);
                            spaceProperties.put(fullSpaceName + "." + "space-config." + "cluster.enabled", String.valueOf(spaceAttr.isClustered()));
                            spaceProperties.put(fullSpaceName + "." + "space-config." + "cluster.config-url", spaceAttr.getClusterConfigURL());
                            JProperties.setSpaceProperties(fullSpaceName, spaceProperties);
                        }
                        JSpaceAttributes attr = (JSpaceAttributes)spaceAttr.clone();
                        spaceImpl = this.createSpaceImpl(spaceName, attr);
                        this._containerEntry = new ContainerEntry(spaceImpl, spaceAttr);
                        if (!Boolean.valueOf(spaceAttr.isPrivate()).booleanValue()) {
                            this.m_LookupMng.register(this._containerEntry.getClusteredSpaceProxy(), this._containerName);
                        }
                        try {
                            this.updateContainerXML();
                        }
                        catch (Exception ex) {
                            if (!_logger.isLoggable(Level.WARNING)) break block19;
                            _logger.log(Level.WARNING, "Fail to update " + this._containerName + " container XML", ex);
                        }
                    }
                    if (this.isJMXEnabled()) {
                        JMXProvider.registerSpaceMBean(spaceName, spaceImpl);
                    }
                    if (spaceImpl.getClusterPolicy() != null) {
                        return this.getClusteredSpace(spaceName);
                    }
                    return this.getSpace(spaceName);
                }
                catch (Exception ex) {
                    JProperties.removeSpaceProperties(fullSpaceName);
                    if (!isSpaceFileAreadyWasExists) {
                        File sf = new File(this.m_configDirectory + File.separator + spaceName + ".xml");
                        sf.delete();
                    }
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "Failed to create <" + spaceName + "> space", ex);
                    }
                    throw new CreateException("Failed to create <" + spaceName + "> space", ex);
                }
            }
            if (spaceName.equalsIgnoreCase(this._containerName)) {
                throw new CreateException("Could not create space <" + spaceName + "> since its name is the same name as container.");
            }
            throw new CreateException("Space <" + spaceName + "> already exists in <" + this._containerName + "> container.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySpace(String spaceName) throws DestroyedFailedException, RemoteException {
        if (spaceName == null) {
            throw new IllegalArgumentException("The spaceName parameter can not be null.");
        }
        Object object = this._lock;
        synchronized (object) {
            String fullSpaceName = JSpaceUtilities.createFullSpaceName(this._containerName, spaceName);
            if (this._containerEntry != null && this._spaceName.equals(spaceName)) {
                block16: {
                    NodeList spaceNodeList;
                    try {
                        this._containerEntry.getSpaceImpl().shutdown(true, false);
                    }
                    catch (RemoteException ex) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, "Failed to destroy <" + spaceName + "> space", ex);
                        }
                        throw new DestroyedFailedException("Failed to destroy <" + spaceName + "> space", ex);
                    }
                    String sourceDCacheConfigName = JProperties.getSpaceProperty(fullSpaceName, "dist-cache.config-name", "");
                    String fileName = sourceDCacheConfigName + "_DCache.xml";
                    String sourceDCacheConfigFile = this.m_configDirectory + File.separator + fileName;
                    if (!fileName.equals("DefaultConfig_DCache.xml")) {
                        new File(sourceDCacheConfigFile).delete();
                    }
                    JProperties.removeSpaceProperties(fullSpaceName);
                    if (this.m_rootContainerElement != null && (spaceNodeList = this.m_rootContainerElement.getElementsByTagName(spaceName)).getLength() != 0) {
                        int i = 0;
                        while (i < spaceNodeList.getLength()) {
                            Node parent = spaceNodeList.item(i).getParentNode();
                            parent.removeChild(spaceNodeList.item(i));
                        }
                    }
                    File sf = new File(this.m_configDirectory + File.separator + spaceName + ".xml");
                    sf.delete();
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.info("The <" + spaceName + "> space of <" + this._containerName + "> container was destroyed successfully.");
                    }
                    try {
                        this.updateContainerXML();
                    }
                    catch (Exception ex) {
                        if (!_logger.isLoggable(Level.WARNING)) break block16;
                        _logger.log(Level.WARNING, "Fail to update " + this._containerName + " container XML", ex);
                    }
                }
                if (this.isJMXEnabled()) {
                    JMXProvider.unregisterSpaceMBean(spaceName, this._containerName);
                }
            } else {
                throw new DestroyedFailedException("Space <" + spaceName + "> does not exist in <" + this._containerName + "> container.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSpaceNames() throws RemoteException {
        Object object = this._lock;
        synchronized (object) {
            String[] stringArray;
            if (this._containerEntry != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this._containerEntry.getName();
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
    }

    @Override
    public String getName() {
        return this._containerName;
    }

    @Override
    public IJSpace getSpace(String spaceName) throws NoSuchNameException {
        return this.getContainerEntry(spaceName).getNonClusteredSpaceProxy();
    }

    @Override
    public IJSpace getClusteredSpace(String spaceName) throws NoSuchNameException {
        return this.getContainerEntry(spaceName).getClusteredSpaceProxy();
    }

    @Override
    public SpaceURL getURL() throws RemoteException {
        return this._url;
    }

    @Override
    public void ping() {
    }

    public IRemoteJSpaceAdmin getSpaceAdmin(String spaceName) throws NoSuchNameException {
        return this.getContainerEntry(spaceName).getSpaceImpl();
    }

    @Override
    public void shutdown() throws RemoteException {
        if (!LRMIJSpaceContainer.isEmbeddedShutdownInvocation.get().booleanValue() && !Boolean.getBoolean("com.gs.enabled-backward-space-shutdown")) {
            throw new UnsupportedOperationException("shutting down a space is only allowed from the collocated proxy");
        }
        this.shutdownInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownInternal() {
        this._allSpaceSchemasMap = null;
        Object object = this;
        synchronized (object) {
            if (this.getContainerStatus() == 2) {
                return;
            }
            this.m_containerStatus = 2;
        }
        try {
            block34: {
                block33: {
                    object = this._lock;
                    synchronized (object) {
                        if (this._containerEntry != null) {
                            this._containerEntry.getSpaceImpl().shutdown(true, false);
                            if (this.isJMXEnabled()) {
                                JMXProvider.unregisterSpaceMBean(this._containerEntry.getSpaceImpl().getName(), this._containerName);
                            }
                        }
                    }
                    if (this.m_LookupMng != null) {
                        this.m_LookupMng.terminate();
                    }
                    if (this.isJMXEnabled()) {
                        try {
                            JMXProvider.unregisterContainerMBean(this);
                        }
                        catch (Exception ex) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block33;
                            _logger.log(Level.SEVERE, ex.toString(), ex);
                        }
                    }
                }
                try {
                    JMXProvider.unregisterTransportMBean(this._containerName);
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block34;
                    _logger.log(Level.SEVERE, ex.toString(), ex);
                }
            }
            this.unregister();
            JSpaceContainerImpl.destroyIfNeeded(this._reggieCreatedRef);
            JSpaceContainerImpl.destroyIfNeeded(this._mahaloCreatedRef);
            JSpaceContainerImpl ex = this;
            synchronized (ex) {
                this.notifyAll();
            }
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("Container <" + this._containerName + "> shutdown completed");
            }
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to shutdown <" + this._containerName + "> container", ex);
            }
        }
        finally {
            block36: {
                if (Boolean.getBoolean("com.gs.graceful-shutDown")) {
                    GracefulContainerShutDown.gracefulShutDown(this._containerName);
                }
                try {
                    if (this._shutdownHook != null) {
                        Runtime.getRuntime().removeShutdownHook((Thread)((Object)this._shutdownHook));
                    }
                }
                catch (Throwable t) {
                    if (!_logger.isLoggable(Level.WARNING)) break block36;
                    _logger.log(Level.WARNING, "Failed to remove ShutdownHook for <" + this.getName() + "> container: ", t);
                }
            }
        }
    }

    private static void destroyIfNeeded(NonActivatableServiceDescriptor.Created serviceRef) throws RemoteException {
        Object adminObject;
        if (serviceRef != null && serviceRef.proxy != null && serviceRef.proxy instanceof Administrable && (adminObject = ((Administrable)serviceRef.proxy).getAdmin()) instanceof DestroyAdmin) {
            ((DestroyAdmin)adminObject).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContainerStatus() {
        JSpaceContainerImpl jSpaceContainerImpl = this;
        synchronized (jSpaceContainerImpl) {
            return this.m_containerStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateContainerXML() throws IOException, ParserConfigurationException {
        Object object = this._lock;
        synchronized (object) {
            if (this._containerEntry == null) {
                return;
            }
        }
        if (this.m_ContainerFile != null && !this.m_ContainerFile.exists()) {
            this.m_ContainerFile.createNewFile();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Created new " + this.m_ContainerFile + " XML file for " + this._containerName + " container.");
            }
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.m_containerFileDocument = builder.newDocument();
        this.m_rootContainerElement = this.m_containerFileDocument.createElement(this._containerName);
        this.m_rootSpaceElement = this.m_containerFileDocument.createElement(SPACE_TAG);
        this.m_rootContainerElement.appendChild(this.m_rootSpaceElement);
        Object object2 = this._lock;
        synchronized (object2) {
            if (this._containerEntry != null) {
                this.updateContainerXMLTree(this._containerEntry.getName(), this._containerEntry.getSpaceAttributes());
            }
        }
        this.saveState();
    }

    public synchronized void updateContainerXMLTree(String spaceName, JSpaceAttributes spaceAttr) {
        if (this.m_rootSpaceElement == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Fail to update the " + this._containerName + " container XML file for " + spaceName + " space; the DOM element for spaces is null");
            }
            return;
        }
        spaceAttr = spaceAttr == null ? new JSpaceAttributes() : spaceAttr;
        NodeList spaceNL = this.m_rootSpaceElement.getElementsByTagName(spaceName);
        for (int i = 0; i < spaceNL.getLength(); ++i) {
            this.m_rootSpaceElement.removeChild(spaceNL.item(i));
        }
        Element jspaceElement = this.m_containerFileDocument.createElement(spaceName);
        this.m_rootSpaceElement.appendChild(jspaceElement);
        this.m_rootSpaceElement.appendChild(jspaceElement);
        Element propertiesElem = this.m_containerFileDocument.createElement("properties");
        Element schemaElem = this.m_containerFileDocument.createElement("schema");
        Text schemaText = null;
        schemaText = spaceAttr.getSchemaName() != null ? this.m_containerFileDocument.createTextNode(spaceAttr.getSchemaName()) : this.m_containerFileDocument.createTextNode("");
        Text propertiesText = null;
        propertiesText = spaceAttr.getCustomProperties() != null && spaceAttr.getCustomProperties().getProperty("properties") != null ? this.m_containerFileDocument.createTextNode(spaceAttr.getCustomProperties().getProperty("properties")) : this.m_containerFileDocument.createTextNode("");
        jspaceElement.appendChild(schemaElem).appendChild(schemaText);
        jspaceElement.appendChild(propertiesElem).appendChild(propertiesText);
        Element isLoadOnStartupElem = this.m_containerFileDocument.createElement("load-on-startup");
        Text isLoadOnStartupText = this.m_containerFileDocument.createTextNode(String.valueOf(spaceAttr.isLoadOnStartup()));
        jspaceElement.appendChild(isLoadOnStartupElem).appendChild(isLoadOnStartupText);
        this.saveState();
    }

    private String getNodeValueIfExists(Element parentNode, String nodeName) {
        Node child;
        String value = null;
        NodeList nl = parentNode.getElementsByTagName(nodeName);
        if (nl.getLength() > 0 && (child = nl.item(0).getFirstChild()) != null) {
            value = child.getNodeValue().trim();
        }
        return value;
    }

    private void loadSpacesFromXMLFile(DocumentBuilder builder) throws Exception {
        boolean isPrivate;
        JSpaceAttributes spaceAttr = null;
        String spaceSchemaName = null;
        String customSchemaProperties = null;
        boolean isLoadOnStartup = false;
        FileInputStream is = new FileInputStream(this.m_ContainerFile);
        this.m_containerFileDocument = builder.parse(is);
        this.m_rootContainerElement = this.m_containerFileDocument.getDocumentElement();
        JSpaceUtilities.normalize(this.m_rootContainerElement);
        this.m_rootSpaceElement = (Element)this.m_rootContainerElement.getFirstChild();
        Element spaceElement = (Element)this.m_rootSpaceElement.getFirstChild();
        while (spaceElement != null) {
            block10: {
                spaceAttr = null;
                spaceSchemaName = null;
                customSchemaProperties = null;
                String spaceName = spaceElement.getNodeName();
                if (spaceElement.getFirstChild() != null) {
                    spaceSchemaName = this.getNodeValueIfExists(spaceElement, "schema");
                    String isLoadOnStartupStr = this.getNodeValueIfExists(spaceElement, "load-on-startup");
                    isLoadOnStartupStr = JProperties.getPropertyFromSystem(isLoadOnStartupStr, Boolean.FALSE.toString());
                    isLoadOnStartup = Boolean.valueOf(isLoadOnStartupStr);
                    customSchemaProperties = this.getNodeValueIfExists(spaceElement, "properties");
                    if (this._spaceName != null && !this._spaceName.equals(spaceName) && !isLoadOnStartup) {
                        spaceElement = (Element)spaceElement.getNextSibling();
                        continue;
                    }
                    spaceAttr = new JSpaceAttributes(spaceSchemaName, isLoadOnStartup);
                    if (customSchemaProperties != null) {
                        spaceAttr.setCustomProperties(ResourceLoader.findCustomPropertiesObj(customSchemaProperties));
                        if (spaceAttr.getCustomProperties() != null) {
                            spaceAttr.getCustomProperties().setProperty("properties", customSchemaProperties);
                        }
                    }
                }
                try {
                    if (spaceAttr == null) {
                        spaceAttr = new JSpaceAttributes();
                        if (this._customProperties != null) {
                            spaceAttr.setCustomProperties(this._customProperties);
                        }
                    }
                    this.loadSpace(spaceName, spaceAttr);
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.WARNING)) break block10;
                    _logger.log(Level.WARNING, "Exception occurs during loading " + spaceName + " from xml.", ex);
                }
            }
            spaceElement = (Element)spaceElement.getNextSibling();
        }
        JSpaceAttributes spaceAttributes = this._containerEntry.getSpaceAttributes();
        boolean bl = isPrivate = spaceAttributes != null && spaceAttributes.isPrivate();
        if (!isPrivate) {
            this.m_LookupMng.register(this._containerEntry.getClusteredSpaceProxy(), this._containerName);
        }
    }

    private ClusterPolicy createClusterPolicy(String spaceName, String clusterConfigUrl) throws CreateException {
        ClusterPolicy clusterPolicy = null;
        try {
            ClusterXML clusXml = new ClusterXML(this._url, clusterConfigUrl, spaceName);
            this.clusterConfigOutput = clusXml.getClusterConfigDebugOutput();
            if (this.clusterConfigOutput != null && _logger.isLoggable(Level.FINE)) {
                _logger.fine("Cluster Config for space <" + spaceName + " > \n" + this.clusterConfigOutput.toString());
            }
            clusterPolicy = clusXml.createClusterPolicy(this._containerName + COLON + spaceName);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
            throw new CreateException("Failed to create cluster policy", ex);
        }
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.log(Level.CONFIG, clusterPolicy.toString());
        }
        return clusterPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpaceImpl loadSpace(String spaceName, JSpaceAttributes spaceAttr) throws ClassNotFoundException, IllegalAccessException, InstantiationException, CreateException, IOException, ConfigurationException, com.gigaspaces.config.ConfigurationException {
        try {
            ValidationUtils.checkServiceNameForValidation(spaceName, "Space name");
        }
        catch (InvalidServiceNameException exc) {
            throw new CreateException("Invalid space name.", new InvalidServiceNameException(exc.getMessage()));
        }
        System.setProperty("com.gs.container.name", this._containerName);
        System.setProperty("com.gs.space.name", spaceName);
        this.createSpaceXML(spaceName, spaceAttr);
        if (JSpaceUtilities.isEmpty(this._spaceName) && !Boolean.valueOf(spaceAttr.isLoadOnStartup()).booleanValue()) {
            return null;
        }
        String fullSpaceName = JSpaceUtilities.createFullSpaceName(this._containerName, spaceName);
        SpaceConfigReader configReader = new SpaceConfigReader(fullSpaceName);
        spaceAttr.setClustered(configReader.getBooleanSpaceProperty("cluster.enabled", configReader.getSpaceProperty("cluster.enabled", Constants.Cluster.IS_CLUSTER_SPACE_DEFAULT)));
        spaceAttr.setClusterConfigURL(configReader.getSpaceProperty("cluster.config-url", configReader.getSpaceProperty("cluster.config-url", "none")));
        if (Boolean.valueOf(spaceAttr.isClustered()).booleanValue() || !this.isFirstSpaceCreated && !JSpaceUtilities.isEmpty(this._clusterSchema)) {
            spaceAttr.setClustered(true);
            if (spaceAttr.getClusterConfigURL().trim().equals("")) {
                throw new CreateException("Cluster config URL not found in " + spaceName + ".xml file.");
            }
            ClusterPolicy clusterPolicy = this.createClusterPolicy(spaceName, spaceAttr.getClusterConfigURL());
            spaceAttr.setClusterPolicy(clusterPolicy);
        }
        spaceAttr.setPrivate(configReader.getBooleanSpaceProperty("isPrivate", Constants.LookupManager.LOOKUP_IS_PRIVATE_DEFAULT, false));
        spaceAttr.setPersistent(configReader.getBooleanSpaceProperty("persistent.enabled", Constants.StorageAdapter.PERSISTENT_ENABLED_DEFAULT, false));
        spaceAttr.setDataSourceClass(configReader.getSpaceProperty("external-data-source.data-source-class", "org.openspaces.persistency.hibernate.DefaultHibernateExternalDataSource", false));
        spaceAttr.setDataClass(configReader.getSpaceProperty("external-data-source.data-class", Constants.DataAdapter.DATA_CLASS_DEFAULT, false));
        spaceAttr.setQueryBuilderClass(configReader.getSpaceProperty("external-data-source.query-builder-class", Constants.DataAdapter.QUERY_BUILDER_PROP_DEFAULT, false));
        spaceAttr.setDataPropertiesFile(configReader.getSpaceProperty("external-data-source.init-properties-file", "", false));
        spaceAttr.setUsage(configReader.getSpaceProperty("external-data-source.usage", "read-write", false));
        spaceAttr.setSupportsInheritanceEnabled(configReader.getBooleanSpaceProperty("external-data-source.supports-inheritance", "true", false));
        spaceAttr.setSupportsVersionEnabled(configReader.getBooleanSpaceProperty("external-data-source.supports-version", "false", false));
        spaceAttr.setSupportsPartialUpdateEnabled(configReader.getBooleanSpaceProperty("external-data-source.supports-partial-update", "false", false));
        spaceAttr.setSupportsRemoveByIdEnabled(configReader.getBooleanSpaceProperty("external-data-source.supports-remove-by-id", "false", false));
        spaceAttr.setDataSourceSharedIteratorMode(configReader.getBooleanSpaceProperty("external-data-source.shared-iterator.enabled", "true", false));
        spaceAttr.setExpirationTimeInterval(configReader.getSpaceProperty("lease_manager.expiration_time_interval", String.valueOf(10000L)));
        spaceAttr.setExpirationTimeRecentDeletes(configReader.getSpaceProperty("lease_manager.expiration_time_recent_deletes", String.valueOf(180000L)));
        spaceAttr.setExpirationTimeRecentUpdate(configReader.getSpaceProperty("lease_manager.expiration_time_recent_updates", String.valueOf(180000L)));
        spaceAttr.setExpirationStaleReplicas(configReader.getSpaceProperty("lease_manager.expiration_stale_replicas", String.valueOf(300000L)));
        String dataSourceShareIteratorTTLDefault = DataAdaptorIterator.getDataSourceShareIteratorTTLDefault(Long.parseLong(spaceAttr.getExpirationTimeRecentDeletes()), Long.parseLong(spaceAttr.getExpirationTimeRecentUpdates()));
        spaceAttr.setDataSourceSharedIteratorTimeToLive(configReader.getLongSpaceProperty("external-data-source.shared-iterator.time-to-live", dataSourceShareIteratorTTLDefault, false));
        spaceAttr.setQPAutoCommit(configReader.getBooleanSpaceProperty("QueryProcessor.auto_commit", Constants.QueryProcessorInfo.QP_AUTO_COMMIT_DEFAULT, false));
        spaceAttr.setQPParserCaseSensetivity(configReader.getBooleanSpaceProperty("QueryProcessor.parser_case_sensetivity", Constants.QueryProcessorInfo.QP_PARSER_CASE_SENSETIVITY_DEFAULT, false));
        spaceAttr.setQPTraceExecTime(configReader.getBooleanSpaceProperty("QueryProcessor.trace_exec_time", Constants.QueryProcessorInfo.QP_TRACE_EXEC_TIME_DEFAULT, false));
        spaceAttr.setQpTransactionTimeout(configReader.getIntSpaceProperty("QueryProcessor.transaction_timeout", Constants.QueryProcessorInfo.QP_TRANSACTION_TIMEOUT_DEFAULT, false));
        spaceAttr.setQpSpaceReadLeaseTime(configReader.getIntSpaceProperty("QueryProcessor.space_read_lease_time", Constants.QueryProcessorInfo.QP_SPACE_READ_LEASE_TIME_DEFAULT, false));
        spaceAttr.setQpSpaceWriteLeaseTime(configReader.getLongSpaceProperty("QueryProcessor.space_write_lease", Constants.QueryProcessorInfo.QP_SPACE_WRITE_LEASE_DEFAULT, false));
        spaceAttr.setQpDateFormat(configReader.getSpaceProperty("QueryProcessor.date_format", "yyyy-MM-dd", false));
        spaceAttr.setQpDateTimeFormat(configReader.getSpaceProperty("QueryProcessor.datetime_format", "yyyy-MM-dd HH:mm:ss", false));
        spaceAttr.setQpTimeFormat(configReader.getSpaceProperty("QueryProcessor.time_format", "HH:mm:ss", false));
        spaceAttr.setMirrorServiceEnabled(configReader.getBooleanSpaceProperty("mirror-service.enabled", "false", false));
        spaceAttr.setMaxClassLoaders(configReader.getIntSpaceProperty("remote-code.max-class-loaders", "3"));
        spaceAttr.setSupportCodeChange(configReader.getBooleanSpaceProperty("remote-code.support.code.change", "true"));
        spaceAttr.setZookeeperConnectionTimeout(configReader.getIntSpaceProperty("leader-election.zookeeper.connection-timeout", "5000"));
        spaceAttr.setZookeeperSessionTimeout(configReader.getIntSpaceProperty("leader-election.zookeeper.session-timeout", "15000"));
        spaceAttr.setZookeeperRetryTimeout(configReader.getIntSpaceProperty("leader-election.zookeeper.retry-timeout", Constants.LeaderSelector.RETRY_TIMEOUT_DEFAULT));
        spaceAttr.setZookeeperRetryInterval(configReader.getIntSpaceProperty("leader-election.zookeeper.retry-interval", "100"));
        JSpaceAttributes attr = (JSpaceAttributes)spaceAttr.clone();
        SpaceImpl spaceImpl = this.createSpaceImpl(spaceName, attr);
        ContainerEntry containerEntry = new ContainerEntry(spaceImpl, spaceAttr);
        Object object = this._lock;
        synchronized (object) {
            this._containerEntry = containerEntry;
        }
        if (this.isJMXEnabled()) {
            JMXProvider.registerSpaceMBean(spaceName, spaceImpl);
        }
        if (!Boolean.valueOf(spaceAttr.isPrivate()).booleanValue()) {
            this.m_LookupMng.register(containerEntry.getClusteredSpaceProxy(), this._containerName);
        }
        spaceAttr.setProxyConnectionMode(configReader.getSpaceProperty("space-config.proxy-settings.connection-monitor", "all"));
        spaceAttr.setProxyMonitorFrequency(Long.parseLong(configReader.getSpaceProperty("space-config.proxy-settings.ping-frequency", Constants.SpaceProxy.OldRouter.MONITOR_FREQUENCY_DEFAULT)));
        spaceAttr.setProxyDetectorFrequency(Long.parseLong(configReader.getSpaceProperty("space-config.proxy-settings.lookup-frequency", Constants.SpaceProxy.OldRouter.DETECTOR_FREQUENCY_DEFAULT)));
        spaceAttr.setProxyConnectionRetries(Integer.parseInt(configReader.getSpaceProperty("space-config.proxy-settings.connection-retries", "10")));
        this.isFirstSpaceCreated = true;
        return spaceImpl;
    }

    private SpaceImpl createSpaceImpl(String spaceName, JSpaceAttributes attr) throws CreateException, IOException, ConfigurationException {
        return new SpaceImpl(spaceName, this._containerName, this, this._url, attr, this._customProperties, false, SecurityResolver.isSecurityEnabled(this._url), this._lifeCycle);
    }

    private boolean isJMXEnabled() {
        return Boolean.parseBoolean(System.getProperty("com.gs.jmx.enabled", SystemProperties.JMX_ENABLED_DEFAULT_VALUE));
    }

    private void createSpaceXML(String spaceName, JSpaceAttributes spaceAttr) throws com.gigaspaces.config.ConfigurationException {
        block24: {
            try {
                InputStream spaceSchemaInputStream = null;
                boolean schemaFileSetAndExists = false;
                String schemaName = spaceAttr.getSchemaName();
                String schemaFilePath = null;
                if (schemaName != null) {
                    ResourceLoader.SchemaProperties schemaProperties = ResourceLoader.findSpaceSchema(schemaName);
                    spaceSchemaInputStream = schemaProperties.getInputStream();
                    schemaFilePath = schemaProperties.getFullPath();
                    if (spaceSchemaInputStream != null) {
                        schemaFileSetAndExists = true;
                    } else if (_logger.isLoggable(Level.WARNING)) {
                        _logger.info("The requested space schema <" + schemaName + "> does not exist in the resource bundle");
                    }
                }
                String fullSpaceName = JSpaceUtilities.createFullSpaceName(this._containerName, spaceName);
                File spaceFile = new File(this.m_configDirectory + File.separator + spaceName + ".xml");
                if (spaceFile.exists()) {
                    if (schemaFileSetAndExists) {
                        JProperties.setUrlWithSchema(fullSpaceName, spaceAttr.getCustomProperties(), spaceSchemaInputStream);
                        Logger logger = Logger.getLogger("com.gigaspaces.core.config");
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Loaded the requested space schema < " + schemaName + " > to be used for the < " + spaceName + " > space configuration.");
                        }
                    } else {
                        JProperties.setUrlWithoutSchema(fullSpaceName, spaceAttr.getCustomProperties(), spaceFile.getPath());
                    }
                } else if (this.m_spaceConfigNode != null && !schemaFileSetAndExists) {
                    Element spaceNode = this.m_containerConfigFileDocument.createElement(spaceName);
                    JSpaceAttributes attr = (JSpaceAttributes)spaceAttr.clone();
                    Node spaceConfigNode = this.m_spaceConfigNode.cloneNode(true);
                    NodeList nList = spaceConfigNode.getChildNodes();
                    boolean perstNotExist = true;
                    for (int i = 0; i < nList.getLength() && perstNotExist; ++i) {
                        perstNotExist = !nList.item(i).getNodeName().equals("persistent");
                    }
                    if (perstNotExist && attr.isPersistent()) {
                        Element persist = this.m_containerConfigFileDocument.createElement("persistent");
                        Element perstEnabledClassNode = this.m_containerConfigFileDocument.createElement("enabled");
                        perstEnabledClassNode.appendChild(this.m_containerConfigFileDocument.createTextNode(Boolean.FALSE.toString()));
                        persist.appendChild(perstEnabledClassNode);
                        spaceConfigNode.appendChild(persist);
                    }
                    spaceNode.appendChild(spaceConfigNode);
                    PrintStream propStream = new PrintStream(new FileOutputStream(spaceFile.getPath()));
                    JSpaceUtilities.domWriter(spaceNode, propStream, " ");
                    propStream.flush();
                    propStream.close();
                    String spaceFileURL = spaceFile.getPath();
                    if (spaceAttr != null) {
                        if (spaceAttr.getClusterConfigURL() != null && !spaceAttr.getClusterConfigURL().equals("none")) {
                            spaceAttr.setClusterConfigURL(spaceAttr.getClusterConfigURL().replace('\\', '/'));
                        }
                        SpaceImpl.setConfig(spaceName, this._containerName, spaceAttr, spaceFileURL);
                    }
                    JProperties.setUrlWithoutSchema(fullSpaceName, spaceAttr.getCustomProperties(), spaceFileURL);
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.info("XML configuration file " + spaceName + ".xml created successfully");
                    }
                } else if (schemaFileSetAndExists) {
                    Logger logger;
                    JProperties.setUrlWithSchema(fullSpaceName, spaceAttr.getCustomProperties(), spaceSchemaInputStream);
                    Properties spaceProps = JProperties.getSpaceProperties(fullSpaceName);
                    if (this._url != null && this._clusterSchema != null && !this.isFirstSpaceCreated) {
                        spaceProps.setProperty(fullSpaceName + '.' + SPACE_CONFIG + '.' + "cluster.enabled", Boolean.TRUE.toString());
                    }
                    if ((logger = Logger.getLogger("com.gigaspaces.core.config")).isLoggable(Level.FINE)) {
                        logger.fine("Loaded the requested space schema < " + spaceAttr.getSchemaName() + " > to be used for the < " + spaceName + " > space configuration.");
                    }
                } else {
                    JProperties.setSpaceProperties(fullSpaceName, new Properties());
                }
                if (schemaFilePath != null) {
                    Properties spaceProperties = JProperties.getSpaceProperties(fullSpaceName);
                    spaceProperties.put("schemaFilePath", schemaFilePath);
                    JProperties.setSpaceProperties(fullSpaceName, spaceProperties);
                }
                this.putDCacheProperites(spaceName);
            }
            catch (com.gigaspaces.config.ConfigurationException sce) {
                throw sce;
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.WARNING)) break block24;
                _logger.log(Level.WARNING, ex.toString() + " exception occurred during < " + spaceName + " > space configuration setup.", ex);
            }
        }
    }

    private void putDCacheProperites(String spaceName) {
        String fullSpaceName = JSpaceUtilities.createFullSpaceName(this._containerName, spaceName);
        String dCacheConfigName = JProperties.getSpaceProperty(fullSpaceName, "dist-cache.config-name", "DefaultConfig");
        Properties spProp = JProperties.getSpaceProperties(fullSpaceName);
        if (spProp != null) {
            spProp.setProperty("space-config.dist-cache.config-name", dCacheConfigName);
        }
    }

    private synchronized void saveState() {
        block7: {
            try {
                File oldFile = new File(this.m_FileNameWithoutExtention + ".old");
                if (oldFile.exists()) {
                    oldFile.delete();
                } else if (this.m_ContainerFile != null) {
                    this.m_ContainerFile.renameTo(oldFile);
                }
                if (this.m_rootContainerElement != null) {
                    PrintStream attrStream = new PrintStream(new FileOutputStream(this.m_FileNameWithoutExtention + ".xml"));
                    JSpaceUtilities.domWriter(this.m_rootContainerElement, attrStream, "");
                    attrStream.close();
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("The " + this.m_ContainerFile + " XML file for " + this._containerName + " container has been updated");
                }
            }
            catch (FileNotFoundException ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block7;
                _logger.log(Level.SEVERE, "FileNotFoundException: ", ex);
            }
        }
    }

    @Override
    public ContainerConfig getConfig() throws RemoteException {
        if (this.m_containerConfig == null) {
            ContainerConfig containerConfig = new ContainerConfig();
            Map<String, SpaceConfig> spaceSchemasMap = this.createSpaceSchemasMap();
            containerConfig.setSpaceSchemasMap(spaceSchemasMap);
            containerConfig.containerName = this._containerName;
            containerConfig.homeDir = SystemInfo.singleton().getXapHome();
            containerConfig.containerHostName = this._hostname;
            containerConfig.setJndiEnabled(Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jndi.enabled", "false")));
            containerConfig.setJiniLusEnabled(Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jini_lus.enabled", "true")));
            containerConfig.unicastEnabled = Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.enabled", "false"));
            containerConfig.unicastURL = JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host", "", true);
            containerConfig.jndiUrl = JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jndi.url", null, false);
            if (SystemInfo.singleton().network().isPublicHostConfigured()) {
                JmxUrlData jmxUrlData = this.retrieveUrlData(containerConfig.jndiUrl);
                int port = jmxUrlData.getPort();
                containerConfig.setJndiPublicURL(SystemInfo.singleton().network().getPublicHostId() + port);
            }
            containerConfig.lookupGroups = JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jini_lus.groups", null, true);
            SpaceConfig defaultSpaceConfig = containerConfig.getSpaceSchemasMap().get("default");
            containerConfig.jmsEnabled = Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jms_services.enabled", "false"));
            containerConfig.jmsInternalJndiEnabled = Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jms_services.internal-jndi.internal-jndi-enabled", "false"));
            containerConfig.jmsExtJndiEnabled = Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jms_services.ext-jndi.ext-jndi-enabled", "false"));
            containerConfig.setSchemaName(this._schemaName);
            containerConfig.setShutdownHook(Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.shutdown_hook", "true")));
            containerConfig.setJndiEnabled(Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jndi.enabled", "false")));
            containerConfig.setJiniLusEnabled(Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jini_lus.enabled", "true")));
            containerConfig.setStartEmbeddedJiniLus(Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.directory_services.jini_lus.start-embedded-lus", "true")));
            containerConfig.setStartEmbeddedJiniMahalo(Boolean.valueOf(JProperties.getContainerProperty(this._containerName, "com.j_spaces.core.container.embedded-services.mahalo.start-embedded-mahalo", "false")));
            containerConfig.setJMXEnabled(this.isJMXEnabled());
            this.m_containerConfig = containerConfig;
        }
        return this.m_containerConfig;
    }

    private Map<String, SpaceConfig> createSpaceSchemasMap() {
        if (this._allSpaceSchemasMap == null) {
            HashMap<String, SpaceConfig> allSpaceSchemasMap;
            block10: {
                allSpaceSchemasMap = new HashMap<String, SpaceConfig>();
                try {
                    for (String schema : JSpaceContainerImpl.getAllSchemas()) {
                        SpaceConfig spaceConfig;
                        block9: {
                            ResourceLoader.SchemaProperties schemaProperties = ResourceLoader.findSpaceSchema(schema);
                            InputStream predefinedSchemaIs = schemaProperties.getInputStream();
                            Properties props = JProperties.convertXML(predefinedSchemaIs);
                            spaceConfig = null;
                            try {
                                spaceConfig = SpaceConfigFactory.createSpaceConfig(props, null, this._containerName, true, schemaProperties.getFullPath());
                            }
                            catch (SpaceConfigurationException exc) {
                                if (!_logger.isLoggable(Level.SEVERE)) break block9;
                                _logger.log(Level.SEVERE, "An exception occurred while loading space configuration for container: " + this._containerName, exc);
                            }
                        }
                        if (spaceConfig == null) continue;
                        allSpaceSchemasMap.put(spaceConfig.getSchemaName(), spaceConfig);
                    }
                    String schemasDirPath = SystemInfo.singleton().locations().config() + File.separator + "schemas";
                    File schemasDir = new File(schemasDirPath);
                    String[] allSchemaFiles = schemasDir.list();
                    if (allSchemaFiles == null) break block10;
                    for (String fileName : allSchemaFiles) {
                        SpaceConfig spaceConfig;
                        String schemaName;
                        block11: {
                            if (!fileName.endsWith("-space-schema.xml") || allSpaceSchemasMap.containsKey(schemaName = fileName.substring(0, fileName.indexOf("-space-schema.xml")))) continue;
                            String schemaFilePath = schemasDirPath + File.separator + fileName;
                            String fullSpaceSchemaLocation = "[" + ResourceLoader.SchemaProperties.getHostName() + "] " + schemaFilePath;
                            File schemaFile = new File(schemaFilePath);
                            FileInputStream fis = new FileInputStream(schemaFile);
                            JSpaceAttributes props = JProperties.convertXML(fis, true, this._customProperties);
                            spaceConfig = null;
                            try {
                                spaceConfig = SpaceConfigFactory.createSpaceConfig(props, null, this._containerName, true, fullSpaceSchemaLocation);
                            }
                            catch (SpaceConfigurationException exc) {
                                if (!_logger.isLoggable(Level.SEVERE)) break block11;
                                _logger.log(Level.SEVERE, "An exception occurred while loading space configuration for container: " + this._containerName, exc);
                            }
                        }
                        if (spaceConfig == null) continue;
                        spaceConfig.setSchemaName(schemaName);
                        allSpaceSchemasMap.put(schemaName, spaceConfig);
                    }
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block10;
                    _logger.log(Level.SEVERE, ex.toString(), ex);
                }
            }
            this._allSpaceSchemasMap = allSpaceSchemasMap;
        }
        return this._allSpaceSchemasMap;
    }

    private static String[] getAllSchemas() {
        return new String[]{"default", "javaspace", "cache", "persistent", "mirror"};
    }

    @Override
    public synchronized void setConfig(ContainerConfig config) throws RemoteException {
        try {
            String schemasFolderPath;
            File schemaConfigFile;
            String containerConfigURL = JProperties.getURL();
            if (containerConfigURL == null && !(schemaConfigFile = new File(containerConfigURL = (schemasFolderPath = Environment.createSchemasFolderIfNotExists()) + File.separator + this.getSchemaName() + "-container-schema.xml")).exists()) {
                ContainerConfigFactory.createContainerSchemaFile(this.getSchemaName(), containerConfigURL);
            }
            if (new File(containerConfigURL).exists()) {
                ContainerConfigFactory.updateFile(config, containerConfigURL, this.getSchemaName());
                String schemaName = config.getSchemaName();
                InputStream schemaInputStream = ResourceLoader.findContainerSchema(schemaName);
                JProperties.setInputStream(this._containerName, schemaInputStream, null);
            } else if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("Remote Access Denied. Unable to update the configuration file: " + containerConfigURL + " via FTP/HTTP protocol.");
            }
            this.m_containerConfig = null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.toString(), ex);
        }
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    private JmxUrlData retrieveUrlData(String hostAndPort) {
        if (hostAndPort != null && hostAndPort.indexOf(58) != -1) {
            boolean port = false;
            int portSeparator = hostAndPort.lastIndexOf(COLON);
            String hostName = hostAndPort.substring(0, portSeparator);
            int jndiPort = Integer.parseInt(hostAndPort.substring(portSeparator + 1));
            return new JmxUrlData(hostName, jndiPort);
        }
        return null;
    }

    private String loadRMIRegistry(String hostAndPort) throws Exception {
        block18: {
            String jndiFlag = this._url.getCustomProperties().getProperty("com.j_spaces.core.container.directory_services.jndi.enabled");
            if (!JSpaceUtilities.isEmpty(jndiFlag) && jndiFlag.equalsIgnoreCase("false")) {
                if (this._rmiHostAndPort == null) {
                    return hostAndPort;
                }
                return this._rmiHostAndPort;
            }
            if (this._rmiHostAndPort != null) {
                return this._rmiHostAndPort;
            }
            this._rmiHostAndPort = hostAndPort;
            JmxUrlData jmxData = this.retrieveUrlData(hostAndPort);
            if (jmxData != null) {
                try {
                    int jndiPort = 0;
                    String hostName = jmxData.getUrl();
                    jndiPort = jmxData.getPort();
                    String registryPortStr = System.getProperty("com.gigaspaces.system.registryPort");
                    boolean isStartedRMIRegistry = false;
                    boolean isPortOccupiedByAnotherAppl = false;
                    if (registryPortStr != null) {
                        jndiPort = Integer.parseInt(registryPortStr);
                        try {
                            LocateRegistry.createRegistry(jndiPort);
                            isStartedRMIRegistry = true;
                        }
                        catch (RemoteException re) {
                            block17: {
                                try {
                                    Registry registry = LocateRegistry.getRegistry(jndiPort);
                                    registry.list();
                                }
                                catch (RemoteException exc) {
                                    isPortOccupiedByAnotherAppl = true;
                                    if (!_logger.isLoggable(Level.INFO)) break block17;
                                    _logger.info("Failed to run RMI registry on " + jndiPort + ".Port is busy.");
                                }
                            }
                            isStartedRMIRegistry = false;
                        }
                    }
                    if (!isStartedRMIRegistry && registryPortStr == null || isPortOccupiedByAnotherAppl) {
                        while (IOUtils.isPortBusy(jndiPort, null)) {
                            jndiPort = IOUtils.getAnonymousPort();
                        }
                        LocateRegistry.createRegistry(jndiPort);
                        System.setProperty("com.gigaspaces.system.registryPort", String.valueOf(jndiPort));
                    }
                    this._rmiHostAndPort = hostName + COLON + jndiPort;
                    if (!isStartedRMIRegistry && registryPortStr == null) {
                        String jmxServiceURL = JMXUtilities.createJMXUrl((String)this._rmiHostAndPort);
                        System.setProperty("com.gigaspaces.system.jmxServiceURL", jmxServiceURL);
                        if (_logger.isLoggable(Level.CONFIG)) {
                            _logger.config("Created RMIRegistry on: < " + this._rmiHostAndPort + " >");
                        }
                    } else if (_logger.isLoggable(Level.CONFIG)) {
                        _logger.config("Using an already running RMIRegistry on: < " + this._rmiHostAndPort + " >");
                    }
                }
                catch (RemoteException ex) {
                    if (!_logger.isLoggable(Level.CONFIG)) break block18;
                    _logger.config("RMIRegistry did not start on: < " + this._rmiHostAndPort + " >. It might be already running.");
                }
            }
        }
        return this._rmiHostAndPort;
    }

    private static NonActivatableServiceDescriptor.Created createLookupServiceIfNeeded(String containerName) {
        boolean isEmbeddedReggieEnabled = Boolean.parseBoolean(JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jini_lus.start-embedded-lus", "true", true));
        if (!isEmbeddedReggieEnabled) {
            return null;
        }
        if (RegistrarFactory.isActive()) {
            _logger.info("Creation of an embedded Lookup Service was skipped - another Lookup Service is already active in this process");
            return null;
        }
        try {
            Registrar instance = RegistrarFactory.createRegistrar();
            Object proxy = ((ServiceProxyAccessor)instance).getServiceProxy();
            NonActivatableServiceDescriptor.Created result = new NonActivatableServiceDescriptor.Created((Object)instance, proxy);
            JProperties.getContainerProperties(containerName).setProperty("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.enabled", String.valueOf(true));
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Enabled the Jini Unicast Discovery on: < " + JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host", "", true) + " >  ");
            }
            return result;
        }
        catch (Throwable ex) {
            Throwable throwable;
            String error = ex.getMessage();
            if (error == null && (throwable = ex.getCause()) != null) {
                error = throwable.getMessage();
            }
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Failed to start an embedded Jini Lookup Service - " + error, ex);
            }
            return null;
        }
    }

    private static NonActivatableServiceDescriptor.Created createMahaloIfNeeded(String containerName) {
        boolean isEmbeddedMahaloEnabled = Boolean.parseBoolean(JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.embedded-services.mahalo.start-embedded-mahalo", "false", true));
        if (!isEmbeddedMahaloEnabled) {
            return null;
        }
        try {
            TxnManager instance = MahaloFactory.createMahalo();
            TransactionManager proxy = instance.getLocalProxy();
            return new NonActivatableServiceDescriptor.Created((Object)instance, (Object)proxy);
        }
        catch (Throwable ex) {
            Throwable throwable;
            String error = ex.getMessage();
            if (error == null && (throwable = ex.getCause()) != null) {
                error = throwable.getMessage();
            }
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Failed to start an embedded Mahalo Jini Transaction Manager - " + error, ex);
            }
            return null;
        }
    }

    private static String setLookupgroups(String value) {
        if (!JSpaceUtilities.isEmpty(value, true)) {
            return SystemInfo.singleton().lookup().setGroups(value);
        }
        String oldValue = SystemInfo.singleton().lookup().groups();
        if (oldValue == null) {
            SystemInfo.singleton().lookup().setGroups(SystemInfo.singleton().lookup().defaultGroups());
        }
        return oldValue;
    }

    private static String setLookupLocators(String value) {
        if (!JSpaceUtilities.isEmpty(value, true)) {
            return SystemInfo.singleton().lookup().setLocators(value);
        }
        String oldValue = SystemInfo.singleton().lookup().locators();
        if (oldValue == null) {
            SystemInfo.singleton().lookup().setLocators("");
        }
        return oldValue;
    }

    static {
        JSpaceContainerImpl.initSecurity();
    }

    private class JmxUrlData {
        private String _jmxUrl;
        private int _port;

        private JmxUrlData(String url, int port) {
            this._jmxUrl = url;
            this._port = port;
        }

        private int getPort() {
            return this._port;
        }

        private String getUrl() {
            return this._jmxUrl;
        }
    }

    private class ShutdownHook
    extends AbstractShutdownHook {
        ShutdownHook() {
            super("ShutdownHook-JSpaceContainerImpl");
        }

        @Override
        protected void onShutdown() {
            JSpaceContainerImpl.this.shutdownInternal();
        }
    }

    public static class ContainerEntry {
        private final SpaceImpl _spaceImpl;
        private final JSpaceAttributes _spaceAttr;
        private final IJSpace _nonClusteredSpaceProxy;
        private final IJSpace _clusteredSpaceProxy;

        private ContainerEntry(SpaceImpl spaceImpl, JSpaceAttributes spaceAttr) throws RemoteException {
            this._spaceImpl = spaceImpl;
            this._spaceAttr = spaceAttr;
            this._nonClusteredSpaceProxy = spaceImpl.getSingleProxy();
            this._clusteredSpaceProxy = spaceImpl.getSpaceProxy();
        }

        public SpaceImpl getSpaceImpl() {
            return this._spaceImpl;
        }

        public JSpaceAttributes getSpaceAttributes() {
            return this._spaceAttr;
        }

        public IJSpace getNonClusteredSpaceProxy() {
            return this._nonClusteredSpaceProxy;
        }

        public IJSpace getClusteredSpaceProxy() {
            return this._clusteredSpaceProxy;
        }

        public String getName() {
            return this._nonClusteredSpaceProxy.getName();
        }
    }
}

