/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.ISpaceState;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class JSpaceState
implements ISpaceState,
Serializable {
    static final long serialVersionUID = -7933691513130779751L;
    private volatile int state = 2;
    private static final Logger _logger;
    private static final Map<Object, String> fieldsMap;

    public static String convertToString(Integer state) {
        return fieldsMap.get(state);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) {
        if (newState == this.getState()) {
            return;
        }
        this.state = this.verifyTransition(newState);
    }

    public int verifyTransition(int newState) {
        int currentState = this.getState();
        boolean validTransition = false;
        switch (newState) {
            case 0: {
                if (currentState != 2) break;
                validTransition = true;
                break;
            }
            case 1: {
                if (currentState != 0) break;
                validTransition = true;
                break;
            }
            case 2: {
                if (currentState != 1 && currentState != 0) break;
                validTransition = true;
                break;
            }
            case 3: {
                validTransition = true;
                break;
            }
            case 5: {
                validTransition = true;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state [" + newState + "]");
            }
        }
        if (!validTransition) {
            throw new IllegalStateException("New state [" + newState + "] not allowed from [" + this.getState() + "]");
        }
        return newState;
    }

    public boolean isTerminated() {
        return this.state == 3;
    }

    public boolean isAborted() {
        return this.state == 3 || this.state == 5;
    }

    public boolean isStopped() {
        return this.state == 2;
    }

    static {
        block3: {
            _logger = Logger.getLogger("com.gigaspaces.space.engine");
            fieldsMap = new Hashtable<Object, String>();
            try {
                Field[] fields = JSpaceState.class.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    fieldsMap.put(fields[i].get(null), fields[i].getName().toLowerCase());
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }
}

