/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.RemoteStub;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.client.SpaceURL;
import java.nio.channels.ClosedChannelException;
import java.rmi.ConnectException;
import java.rmi.RemoteException;

@InternalApi
public class LRMIJSpaceContainer
extends RemoteStub<IJSpaceContainer>
implements IJSpaceContainer,
IJSpaceContainerAdmin {
    static final long serialVersionUID = 1L;
    private String _name;
    public static final ThreadLocal<Boolean> isEmbeddedShutdownInvocation = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public LRMIJSpaceContainer() {
    }

    public LRMIJSpaceContainer(IJSpaceContainer directObjRef, IJSpaceContainer dynamicProxy, String name) {
        super(directObjRef, dynamicProxy);
        this._name = name;
    }

    @Override
    public IJSpace getClusteredSpace(String spaceName) throws NoSuchNameException, RemoteException {
        return ((IJSpaceContainer)this.getProxy()).getClusteredSpace(spaceName);
    }

    @Override
    public String getName() throws RemoteException {
        if (this._name == null) {
            this._name = ((IJSpaceContainer)this.getProxy()).getName();
        }
        return this._name;
    }

    @Override
    public IJSpace getSpace(String spaceName) throws NoSuchNameException, RemoteException {
        return ((IJSpaceContainer)this.getProxy()).getSpace(spaceName);
    }

    @Override
    public String[] getSpaceNames() throws RemoteException {
        return ((IJSpaceContainer)this.getProxy()).getSpaceNames();
    }

    @Override
    public SpaceURL getURL() throws RemoteException {
        return ((IJSpaceContainer)this.getProxy()).getURL();
    }

    @Override
    public void ping() throws RemoteException {
        ((IJSpaceContainer)this.getProxy()).ping();
    }

    @Override
    public void shutdown() throws RemoteException {
        try {
            isEmbeddedShutdownInvocation.set(true);
            ((IJSpaceContainer)this.getProxy()).shutdown();
        }
        catch (ConnectException e) {
            if (e.getCause() instanceof ClosedChannelException) {
                return;
            }
            throw e;
        }
        finally {
            isEmbeddedShutdownInvocation.set(false);
        }
    }

    @Override
    public ContainerConfig getConfig() throws RemoteException {
        return ((IJSpaceContainerAdmin)this.getProxy()).getConfig();
    }

    @Override
    public String getRuntimeConfigReport() throws RemoteException {
        return ((IJSpaceContainerAdmin)this.getProxy()).getRuntimeConfigReport();
    }

    @Override
    public void setConfig(ContainerConfig config) throws RemoteException {
        ((IJSpaceContainerAdmin)this.getProxy()).setConfig(config);
    }
}

