/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.lease.SpaceEntryLease;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.LeaseProxy;
import com.j_spaces.core.client.EntryInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;

@InternalApi
public class LeaseInitializer {
    public static void setPreviousObject(LeaseContext<?> lease, Object previousObject) {
        if (lease instanceof SpaceEntryLease) {
            ((SpaceEntryLease)lease).setObject(previousObject);
        } else if (lease instanceof LeaseProxy) {
            ((LeaseProxy)lease).setObject(previousObject);
        } else if (lease instanceof UpdateContextLease) {
            ((UpdateContextLease)lease).setObject(previousObject);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static LeaseContext<?> createDummyLease(String uid, int version) {
        return new UIDLease(uid, version);
    }

    public static LeaseContext<?> createDummyLease(String uid, int version, Object obj) {
        return new UpdateContextLease(uid, version, obj);
    }

    public static EntryInfo getEntryInfo(LeaseContext<?> lease) {
        return new EntryInfo(lease.getUID(), 1);
    }

    public static boolean isDummyLease(LeaseContext<?> lease) {
        return lease instanceof UIDLease;
    }

    public static class UpdateContextLease
    extends UIDLease {
        private static final long serialVersionUID = 1L;
        private Object previousValue;

        public UpdateContextLease() {
        }

        private UpdateContextLease(String uid, int version, Object prevValue) {
            super(uid, version);
            this.previousValue = prevValue;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.previousValue);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.previousValue = in.readObject();
        }

        @Override
        public Object getObject() {
            return this.previousValue;
        }

        private void setObject(Object prevObj) {
            this.previousValue = prevObj;
        }
    }

    public static class UIDLease
    implements LeaseContext<Object>,
    Externalizable {
        private static final long serialVersionUID = 1L;
        private String _uid;
        private int _version;

        public UIDLease() {
        }

        private UIDLease(String uid, int version) {
            this._uid = uid;
            this._version = version;
        }

        @Override
        public String getUID() {
            return this._uid;
        }

        @Override
        public int getVersion() {
            return this._version;
        }

        @Override
        public Object getObject() {
            return null;
        }

        public long getExpiration() {
            return 0L;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this._uid);
            out.writeInt(this._version);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._uid = in.readUTF();
            this._version = in.readInt();
        }

        public void cancel() throws UnknownLeaseException, RemoteException {
            throw new UnsupportedOperationException();
        }

        public void renew(long l) {
            throw new UnsupportedOperationException();
        }

        public void setSerialFormat(int i) {
            throw new UnsupportedOperationException();
        }

        public int getSerialFormat() {
            throw new UnsupportedOperationException();
        }

        public LeaseMap createLeaseMap(long l) {
            throw new UnsupportedOperationException();
        }

        public boolean canBatch(Lease lease) {
            throw new UnsupportedOperationException();
        }
    }
}

