/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.backport.java.util.concurrent.FastConcurrentSkipListMap;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.eviction.RecentDeletesRepository;
import com.gigaspaces.internal.server.space.eviction.RecentUpdatesRepository;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.transport.TemplatePacket;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.LeaseProxy;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.XtnStatus;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.ILeasedEntryCacheInfo;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.core.cache.TerminatingFifoXtnsInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.server.processor.Processor;
import com.j_spaces.core.transaction.Prepared2PCXtnInfo;
import com.j_spaces.core.transaction.TransactionHandler;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import com.j_spaces.kernel.StoredListFactory;
import com.j_spaces.kernel.locks.ILockObject;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.space.InternalSpaceException;

@InternalApi
public class LeaseManager {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.lease");
    private static final long MIN_FORCE_EXPIRATION_INTERVAL = Long.getLong("com.gs.lease-manager.min-force-expiration-interval", 500L);
    private final Processor _coreProcessor;
    private final String _spaceName;
    private final SpaceEngine _engine;
    private final SpaceImpl _spaceImpl;
    private final SpaceTypeManager _typeManager;
    private final TransactionHandler _transactionHandler;
    private final CacheManager _cacheManager;
    private final boolean _dontReapUnderXtnLeases;
    private final FastConcurrentSkipListMap<Long, Cell> _expirationList;
    private final AtomicLong _operationID;
    private final long _clientID;
    private final boolean _slaveLeaseManagerModeConfiguredForEntries;
    private final boolean _alwaysDisableEntriesLeases;
    private final boolean _slaveLeaseManagerModeConfiguredForNotifyTemplates;
    private final long _expirationTimeInterval;
    private final long _backupSpaceLeasesDelay;
    private final int _segmentsPerExpirationCell;
    private final long _expirationTimeRecentDeletes;
    private final long _expirationTimeRecentUpdates;
    private final long _staleReplicaExpirationTime;
    private LeaseReaper _leaseReaperDaemon;
    private boolean _closed;
    private final boolean _supportsRecentExtendedUpdates;

    public LeaseManager(SpaceEngine engine, String spaceName, Processor coreProcessor) {
        this._coreProcessor = coreProcessor;
        this._spaceName = spaceName;
        this._engine = engine;
        this._spaceImpl = engine.getSpaceImpl();
        this._typeManager = engine.getTypeManager();
        this._transactionHandler = engine.getTransactionHandler();
        this._cacheManager = engine.getCacheManager();
        this._expirationList = new FastConcurrentSkipListMap();
        this._dontReapUnderXtnLeases = true;
        this._operationID = new AtomicLong();
        this._clientID = new SecureRandom().nextLong();
        SpaceConfigReader configReader = engine.getConfigReader();
        boolean slaveMode = this._engine.getClusterPolicy() != null && this._engine.getClusterPolicy().m_Replicated && this._engine.getClusterPolicy().getReplicationPolicy().isReplicateLeaseExpirations();
        this._alwaysDisableEntriesLeases = configReader.getBooleanSpaceProperty("lease_manager.disable_entries_leases", String.valueOf(false));
        this._slaveLeaseManagerModeConfiguredForEntries = slaveMode || this._alwaysDisableEntriesLeases;
        this._slaveLeaseManagerModeConfiguredForNotifyTemplates = slaveMode;
        this._expirationTimeInterval = LeaseManager.getLongValue(configReader, "lease_manager.expiration_time_interval", 10000L);
        this._backupSpaceLeasesDelay = LeaseManager.getLongValue(configReader, "lease_manager.backup_leases_expiration_delay", 300000L);
        this._segmentsPerExpirationCell = this._cacheManager.isblobStoreDataSpace() ? 1 : LeaseManager.getIntValue(configReader, "lease_manager.segments_per_expiration_cell", 2);
        this._expirationTimeRecentDeletes = LeaseManager.getLongValue(configReader, "lease_manager.expiration_time_recent_deletes", 180000L);
        this._expirationTimeRecentUpdates = LeaseManager.getLongValue(configReader, "lease_manager.expiration_time_recent_updates", 180000L);
        this._staleReplicaExpirationTime = LeaseManager.getLongValue(configReader, "lease_manager.expiration_stale_replicas", 300000L);
        this._supportsRecentExtendedUpdates = this._engine.getCacheManager().isBlobStoreCachePolicy();
        this.logConfiguration();
    }

    private static long getLongValue(SpaceConfigReader configReader, String spaceProperty, long defaultValue) {
        long result;
        block3: {
            result = defaultValue;
            try {
                result = configReader.getLongSpaceProperty(spaceProperty, String.valueOf(defaultValue));
                if (result < 0L) {
                    throw new IllegalArgumentException("Invalid argument for property: " + spaceProperty + " [" + result + "] - must be greater/eq than zero.");
                }
            }
            catch (Exception ex) {
                result = defaultValue;
                if (!_logger.isLoggable(Level.WARNING)) break block3;
                _logger.log(Level.WARNING, LeaseManager.class.getName() + " - Failed to parse " + spaceProperty + "\n using default: " + defaultValue, ex);
            }
        }
        return result;
    }

    private static int getIntValue(SpaceConfigReader configReader, String spaceProperty, int defaultValue) {
        return (int)LeaseManager.getLongValue(configReader, spaceProperty, defaultValue);
    }

    private void logConfiguration() {
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config("Lease Manager Reaper will periodically reap expired content of:\n\tEntries/templates - every " + this._expirationTimeInterval + " ms\n\tPending answers - every " + 60000L + " ms\n\tLocal transactions - every " + this._expirationTimeInterval + " ms\n\tRecovered/copied objects - every " + this._staleReplicaExpirationTime + " ms\n\tRecently deleted entries - every " + this._expirationTimeRecentDeletes + " ms\n\tRecently updated entries - every " + this._expirationTimeRecentUpdates + " ms\n\tTransactions of FIFO entries - every " + 60000L + " ms\n\t");
        }
    }

    public synchronized void init() {
        LeaseReaper leaseReaperDaemon;
        if (this._closed) {
            return;
        }
        this._leaseReaperDaemon = leaseReaperDaemon = new LeaseReaper(this.getClass().getSimpleName() + "$Reaper [" + this._spaceName + "]");
    }

    public void registerEntryLease(IEntryCacheInfo entryCacheInfo, long expiration) {
        this.register(entryCacheInfo, entryCacheInfo.getEntryHolder(this._cacheManager), expiration, 1);
    }

    public Lease registerTemplateLease(TemplateCacheInfo templateCacheInfo) {
        ITemplateHolder template = templateCacheInfo.m_TemplateHolder;
        long expiration = template.getEntryData().getExpirationTime();
        this.register(templateCacheInfo, template, expiration, 3);
        return new LeaseProxy(expiration, template.getUID(), template.getClassName(), 0, 3, this._spaceImpl);
    }

    public void reRegisterLease(ILeasedEntryCacheInfo leaseCacheInfo, IEntryHolder entry, long original_expiration, long new_expiration, int objectType) {
        boolean skip_registration = false;
        if (new_expiration == original_expiration) {
            skip_registration = true;
        }
        if (!skip_registration && leaseCacheInfo.isConnectedToLeaseManager()) {
            long expirationTime_o = original_expiration != Long.MAX_VALUE ? (original_expiration / this._expirationTimeInterval + 1L) * this._expirationTimeInterval : -1L;
            long expirationTime_n = new_expiration != Long.MAX_VALUE ? (new_expiration / this._expirationTimeInterval + 1L) * this._expirationTimeInterval : -1L;
            boolean bl = skip_registration = expirationTime_o == expirationTime_n;
        }
        if (!skip_registration) {
            this.unregister(leaseCacheInfo, original_expiration);
            this.register(leaseCacheInfo, entry, new_expiration, objectType);
        }
    }

    public OperationID createOperationIDForLeaseExpirationEvent() {
        return new OperationID(this._clientID, this._operationID.incrementAndGet());
    }

    public boolean isNoReapUnderXtnLeases() {
        return this._dontReapUnderXtnLeases;
    }

    private long getBackupSpaceLeasesDelay() {
        return this._backupSpaceLeasesDelay;
    }

    public long getEffectiveEntryLeaseTime(long time) {
        return this.isSlaveLeaseManagerForEntries() ? Long.MIN_VALUE : (this._spaceImpl.isBackup() ? time - this.getBackupSpaceLeasesDelay() : time);
    }

    public long getEffectiveEntryLeaseTimeForReaper(long time) {
        return this.isSlaveLeaseManagerForEntries() ? time : (this._spaceImpl.isBackup() ? time - this.getBackupSpaceLeasesDelay() : time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentLeaseReaperThread() {
        LeaseReaper leaseReaperDaemon = this._leaseReaperDaemon;
        if (leaseReaperDaemon == null) {
            LeaseManager leaseManager = this;
            synchronized (leaseManager) {
                leaseReaperDaemon = this._leaseReaperDaemon;
            }
        }
        return Thread.currentThread() == leaseReaperDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLeaseReaperCycle(boolean mustExecute, long timeToWait) throws InterruptedException {
        LeaseReaper leaseReaperDaemon = this._leaseReaperDaemon;
        if (leaseReaperDaemon == null) {
            LeaseManager leaseManager = this;
            synchronized (leaseManager) {
                leaseReaperDaemon = this._leaseReaperDaemon;
            }
        }
        if (leaseReaperDaemon == null) {
            return;
        }
        long currentCycle = leaseReaperDaemon.getCurrentCycle();
        if (leaseReaperDaemon.forceCycle(mustExecute)) {
            leaseReaperDaemon.waitForCycleCompletion(currentCycle, timeToWait);
        }
    }

    public void forceLeaseReaperCycle(boolean mustExecute) throws InterruptedException {
        this.forceLeaseReaperCycle(mustExecute, 0L);
    }

    public long renew(String entryUid, String className, int objectType, long duration, boolean fromReplication, boolean origin, boolean isFromGateway) throws UnknownLeaseException, InternalSpaceException {
        try {
            this.extendLeasePeriod(entryUid, className, objectType, duration, fromReplication, origin, false, null, isFromGateway);
        }
        catch (UnknownLeaseException unknownLeaseException) {
            if (this._cacheManager.isCacheExternalDB() && objectType != 5 && objectType != 3) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Failed to renew lease of an entry belonging to external-data-source.", unknownLeaseException);
                }
            }
            throw unknownLeaseException;
        }
        return duration;
    }

    public void update(String entryUid, String className, int objectType, long duration) throws UnknownLeaseException, InternalSpaceException {
        boolean fromReplication = false;
        boolean origin = true;
        boolean isFromGateway = false;
        if (duration == -1L) {
            this.cancel(entryUid, className, objectType, false, true, false);
        } else {
            this.renew(entryUid, className, objectType, duration, false, true, false);
        }
    }

    public Object[] renewAll(String[] entryUids, String[] classNames, int[] objectTypes, long[] durations) {
        Exception[] exceptions = new Exception[entryUids.length];
        long[] newDurations = new long[entryUids.length];
        for (int i = 0; i < entryUids.length; ++i) {
            try {
                newDurations[i] = this.renew(entryUids[i], classNames[i], objectTypes[i], durations[i], false, true, false);
                continue;
            }
            catch (Exception ex) {
                exceptions[i] = ex;
            }
        }
        return new Object[]{exceptions, newDurations};
    }

    public IEntryHolder cancel(String entryUid, String classname, int objectType, boolean fromReplication, boolean origin, boolean isFromGateway) throws UnknownLeaseException {
        return this.cancel(entryUid, classname, objectType, fromReplication, origin, false, null, isFromGateway);
    }

    public IEntryHolder cancel(String entryUid, String classname, int objectType, boolean fromReplication, boolean origin, boolean lease_expired, OperationID operationID, boolean isFromGateway) throws UnknownLeaseException {
        try {
            return this.extendLeasePeriod(entryUid, classname, objectType, -1L, fromReplication, origin, lease_expired, operationID, isFromGateway);
        }
        catch (UnknownLeaseException unknownLeaseException) {
            if (this._cacheManager.isCacheExternalDB()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Failed to cancel lease of an entry belonging to external-data-source.", unknownLeaseException);
                }
                return null;
            }
            throw unknownLeaseException;
        }
    }

    public Exception[] cancelAll(String[] entryUids, String[] classNames, int[] objectTypes) {
        ArrayList<Exception> exceptionsList = new ArrayList<Exception>(0);
        for (int i = 0; i < entryUids.length; ++i) {
            try {
                this.cancel(entryUids[i], classNames[i], objectTypes[i], false, true, false);
                continue;
            }
            catch (Exception ex) {
                exceptionsList.add(ex);
            }
        }
        return exceptionsList.toArray(new Exception[exceptionsList.size()]);
    }

    public final synchronized void close() {
        this._closed = true;
        if (this._leaseReaperDaemon != null) {
            this._leaseReaperDaemon.clean();
        }
    }

    public static final long toAbsoluteTime(long duration, long current) {
        if (duration == Long.MAX_VALUE || duration == -1L) {
            return Long.MAX_VALUE;
        }
        if (duration == 0L) {
            return 0L;
        }
        if ((duration += current) < 0L) {
            return Long.MAX_VALUE;
        }
        return duration;
    }

    public static final long toAbsoluteTime(long duration) {
        if (duration == Long.MAX_VALUE || duration == -1L) {
            return Long.MAX_VALUE;
        }
        if (duration == 0L) {
            return 0L;
        }
        if ((duration += SystemTime.timeMillis()) < 0L) {
            return Long.MAX_VALUE;
        }
        return duration;
    }

    public boolean isSlaveLeaseManagerForEntries() {
        return this._alwaysDisableEntriesLeases || this._slaveLeaseManagerModeConfiguredForEntries && !this._spaceImpl.isPrimary();
    }

    public boolean isSlaveLeaseManagerForNotifyTemplates() {
        return this._slaveLeaseManagerModeConfiguredForNotifyTemplates && !this._spaceImpl.isPrimary();
    }

    public boolean replicateLeaseExpirationEventsForEntries() {
        return this._slaveLeaseManagerModeConfiguredForEntries && this._spaceImpl.isPrimary();
    }

    public boolean replicateLeaseExpirationEventsForNotifyTemplates() {
        return this._slaveLeaseManagerModeConfiguredForNotifyTemplates && this._spaceImpl.isPrimary();
    }

    public boolean isSupportsRecentExtendedUpdates() {
        return this._supportsRecentExtendedUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ILeasedEntryCacheInfo leaseCacheInfo, IEntryHolder entry, long expiration, int objectType) {
        block9: {
            boolean skipCellRegistration;
            boolean bl = skipCellRegistration = expiration == Long.MAX_VALUE || this._alwaysDisableEntriesLeases && objectType == 1;
            if (!skipCellRegistration) {
                Long expirationTime = (expiration / this._expirationTimeInterval + 1L) * this._expirationTimeInterval;
                while (true) {
                    Cell cell;
                    if ((cell = this._expirationList.get(expirationTime)) == null) {
                        cell = new Cell(this._segmentsPerExpirationCell, expirationTime);
                        Cell currCell = this._expirationList.putIfAbsent(expirationTime, cell);
                        if (currCell != null) {
                            cell = currCell;
                        }
                        cell.register(leaseCacheInfo, entry, objectType);
                    } else {
                        cell.register(leaseCacheInfo, entry, objectType);
                    }
                    if (!cell.isCleaned()) break block9;
                    Cell cell2 = cell;
                    synchronized (cell2) {
                        Cell cur = this._expirationList.putIfAbsent(cell.getCellKey(), cell);
                        if (cur == cell || cur == null) {
                            break block9;
                        }
                    }
                }
            }
            leaseCacheInfo.setLeaseManagerListRefAndPosition(null, null);
        }
    }

    public void unregister(ILeasedEntryCacheInfo leaseCacheInfo, long expiration) {
        boolean unregister = leaseCacheInfo.isBlobStoreEntry() ? expiration != Long.MAX_VALUE && !this._alwaysDisableEntriesLeases : leaseCacheInfo.isConnectedToLeaseManager();
        if (unregister) {
            if (!leaseCacheInfo.isBlobStoreEntry()) {
                leaseCacheInfo.getLeaseManagerListRef().remove(leaseCacheInfo.getLeaseManagerPosition());
            } else {
                Long expirationTime = (expiration / this._expirationTimeInterval + 1L) * this._expirationTimeInterval;
                Cell cell = this._expirationList.get(expirationTime);
                if (cell != null) {
                    cell.unregisterByPos(leaseCacheInfo.getLeaseManagerPosition(), true);
                }
            }
            leaseCacheInfo.setLeaseManagerListRefAndPosition(null, null);
        }
    }

    /*
     * Exception decompiling
     */
    private final IEntryHolder extendLeasePeriod(String entryUid, String className, int objectType, long duration, boolean fromReplication, boolean origin, boolean leaseExpired, OperationID operationID, boolean isFromGatway) throws UnknownLeaseException, InternalSpaceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean waitForNoCycleOnQuiesce(long timeout) {
        return this._leaseReaperDaemon.waitForNoCycleOnQuiesce(timeout);
    }

    private static String getExtendLeasePeriodDescription(boolean leaseExpired, boolean cancelLease) {
        return cancelLease ? (leaseExpired ? "expire" : "cancel") : "renew";
    }

    static /* synthetic */ boolean access$1400(LeaseManager x0) {
        return x0._slaveLeaseManagerModeConfiguredForEntries;
    }

    static /* synthetic */ SpaceTypeManager access$1500(LeaseManager x0) {
        return x0._typeManager;
    }

    static /* synthetic */ Processor access$1600(LeaseManager x0) {
        return x0._coreProcessor;
    }

    private static final class Cell {
        private final Long _expirationTime;
        private volatile boolean _cleaned;
        private final IStoredList<Object> _entriesExpired;
        private volatile IStoredList<Object> _notifyTemplatesExpired;

        private Cell(int segmentsPerExpirationCell, Long expirationTime) {
            this._expirationTime = expirationTime;
            this._entriesExpired = segmentsPerExpirationCell == 1 ? StoredListFactory.createConcurrentList(true) : StoredListFactory.createConcurrentSegmentedList(true, segmentsPerExpirationCell, false);
        }

        private Long getCellKey() {
            return this._expirationTime;
        }

        private boolean isCleaned() {
            return this._cleaned;
        }

        private void setCleaned(boolean val) {
            this._cleaned = val;
        }

        private boolean isEmpty() {
            return this._entriesExpired.isEmpty() && (this._notifyTemplatesExpired == null || this._notifyTemplatesExpired.isEmpty());
        }

        private Iterator<IEntryHolder> mateExpriedEntriesUidsIter(SpaceEngine engine) {
            return new EntriesCellIter(this._entriesExpired, engine);
        }

        private Iterator<IEntryHolder> mateExpriedNotifyTemplatesUidsIter() {
            IStoredList<Object> notifyTemplates = this._notifyTemplatesExpired;
            return notifyTemplates != null ? new TemplatesCellIter(notifyTemplates) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void register(ILeasedEntryCacheInfo leaseCacheInfo, IEntryHolder entry, int objectType) {
            if (objectType == 1) {
                IObjectInfo<Object> pos = entry.isBlobStoreEntry() ? this._entriesExpired.add(((IBlobStoreEntryHolder)((Object)entry)).getBlobStoreResidentPart().getUID()) : this._entriesExpired.add(entry);
                leaseCacheInfo.setLeaseManagerListRefAndPosition(this._entriesExpired, pos);
            } else {
                IStoredList<Object> notifyTemplatesExpired = this._notifyTemplatesExpired;
                if (notifyTemplatesExpired == null) {
                    Cell cell = this;
                    synchronized (cell) {
                        if (this._notifyTemplatesExpired == null) {
                            this._notifyTemplatesExpired = StoredListFactory.createConcurrentList(true);
                        }
                        notifyTemplatesExpired = this._notifyTemplatesExpired;
                    }
                }
                IObjectInfo<Object> pos = notifyTemplatesExpired.add(entry);
                leaseCacheInfo.setLeaseManagerListRefAndPosition(notifyTemplatesExpired, pos);
            }
        }

        private void unregisterByPos(IObjectInfo<Object> pos, boolean isEntry) {
            if (!isEntry) {
                throw new UnsupportedOperationException();
            }
            this._entriesExpired.remove(pos);
        }

        static /* synthetic */ Iterator access$1100(Cell x0, SpaceEngine x1) {
            return x0.mateExpriedEntriesUidsIter(x1);
        }

        static /* synthetic */ Iterator access$1200(Cell x0) {
            return x0.mateExpriedNotifyTemplatesUidsIter();
        }

        private static final class TemplatesCellIter
        implements Iterator<IEntryHolder> {
            private IStoredListIterator<Object> _pos;
            private final IStoredList<Object> _templatesExp;

            private TemplatesCellIter(IStoredList<Object> templatesExpired) {
                this._templatesExp = templatesExpired;
                this._pos = this._templatesExp.establishListScan(false);
            }

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                return this._pos != null;
            }

            @Override
            public IEntryHolder next() {
                IEntryHolder sl_res = (IEntryHolder)this._pos.getSubject();
                this._pos = this._templatesExp.next(this._pos);
                return sl_res;
            }
        }

        private static final class EntriesCellIter
        implements Iterator<IEntryHolder> {
            private IStoredListIterator<Object> _pos;
            private final IStoredList<Object> _entriesExp;
            private final SpaceEngine _engine;

            private EntriesCellIter(IStoredList<Object> entriesExpired, SpaceEngine engine) {
                this._engine = engine;
                this._entriesExp = entriesExpired;
                this._pos = this._entriesExp.establishListScan(true);
            }

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                return this._pos != null;
            }

            @Override
            public IEntryHolder next() {
                IEntryHolder sl_res = null;
                Object val = this._pos.getSubject();
                sl_res = this._engine.getCacheManager().isblobStoreDataSpace() && val != null && val instanceof String ? this._engine.getCacheManager().getEntryByUidFromPureCache((String)val) : (IEntryHolder)val;
                this._pos = this._entriesExp.next(this._pos);
                return sl_res;
            }
        }
    }

    private final class LeaseReaper
    extends GSThread {
        private boolean _shouldDie;
        private long _nextExpirationTimeInterval;
        private long _lastReapedSpaceContentObjects;
        private long _lastRepeadRecentDeletes;
        private long _lastReapedRecentUpdates;
        private long _lastReapedUnusedXtn;
        private long _lastReapedMarkersRepository;
        private final Object _cycleLock;
        private long _cycleCount;
        private long _lastCycleEnded;
        private boolean _force;
        private volatile boolean _inCycle;
        private static final int DETACH_LIMIT_TO_REPORT = 1000;

        public LeaseReaper(String threadName) {
            super(threadName);
            this._nextExpirationTimeInterval = SystemTime.timeMillis();
            this._cycleLock = new Object();
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block29: {
                block21: while (true) {
                    while (!this.isInterrupted()) {
                        Object skippedReapingInQuiesceMode22;
                        try {
                            boolean skippedReapingInQuiesceMode22 = false;
                            this.fallAsleep(skippedReapingInQuiesceMode22);
                            if (this._shouldDie) break block29;
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.finest(this.getName() + " - woke up for reaping.");
                            }
                            if (this.isSpaceInQuiesce(true)) {
                                skippedReapingInQuiesceMode22 = true;
                            }
                            if (!skippedReapingInQuiesceMode22) {
                                this._inCycle = true;
                                if (this.isSpaceInQuiesce(true)) {
                                    skippedReapingInQuiesceMode22 = true;
                                }
                            }
                            if (!skippedReapingInQuiesceMode22) {
                                this.reapExpiredEntries();
                                this.reapExpiredXtns();
                                this.reapPhantomGlobalXtns();
                                this.reapStaleReplicas();
                                this.reapRecentDeletes();
                                this.reapRecentUpdates();
                                this.reapFifoXtnsEntryInfo();
                                this.reapReachedMarkers();
                                this.reapStuck2PCPreparedXtns();
                                this.reapRecentExtendedUpdates();
                            }
                            this.reapUnusedXtns();
                            this.signalEndCycle();
                            if (!this._inCycle) continue;
                            skippedReapingInQuiesceMode22 = this._cycleLock;
                        }
                        catch (Exception e) {
                            if (!_logger.isLoggable(Level.SEVERE)) continue block21;
                            _logger.log(Level.SEVERE, this.getName() + " - caught Exception", e);
                            continue block21;
                        }
                        finally {
                            if (!this._inCycle) continue;
                            Object object = this._cycleLock;
                            synchronized (object) {
                                this._inCycle = false;
                                this._cycleLock.notifyAll();
                            }
                            continue block21;
                        }
                        synchronized (skippedReapingInQuiesceMode22) {
                            this._inCycle = false;
                            this._cycleLock.notifyAll();
                            continue block21;
                        }
                    }
                    break block29;
                    break;
                }
                finally {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(this.getName() + " terminated.");
                    }
                }
            }
        }

        private boolean isSpaceInQuiesce(boolean useLogger) {
            if (LeaseManager.this._spaceImpl.getQuiesceHandler() != null && LeaseManager.this._spaceImpl.getQuiesceHandler().isOn()) {
                if (useLogger && _logger.isLoggable(Level.FINEST)) {
                    _logger.finest(this.getName() + " - is not reaping since space in quiesce mode.");
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean forceCycle(boolean mustExecute) {
            Object object = this._cycleLock;
            synchronized (object) {
                if (!mustExecute && SystemTime.timeMillis() - this._lastCycleEnded < MIN_FORCE_EXPIRATION_INTERVAL) {
                    return false;
                }
                this._force = true;
            }
            object = this;
            synchronized (object) {
                ((Object)((Object)this)).notify();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCycleCompletion(long currentCycle, long timeToWait) throws InterruptedException {
            Object object = this._cycleLock;
            synchronized (object) {
                while (this._cycleCount == currentCycle && !this._shouldDie) {
                    if (timeToWait != 0L) {
                        this._cycleLock.wait(timeToWait);
                        return;
                    }
                    this._cycleLock.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getCurrentCycle() {
            Object object = this._cycleLock;
            synchronized (object) {
                return this._cycleCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalEndCycle() {
            Object object = this._cycleLock;
            synchronized (object) {
                this._inCycle = false;
                this._force = false;
                ++this._cycleCount;
                this._lastCycleEnded = SystemTime.timeMillis();
                this._cycleLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void fallAsleep(boolean skippedReapingInQuiesceMode) {
            LeaseReaper leaseReaper = this;
            synchronized (leaseReaper) {
                try {
                    if (!this._shouldDie) {
                        this._nextExpirationTimeInterval = skippedReapingInQuiesceMode ? this._nextExpirationTimeInterval + LeaseManager.this._expirationTimeInterval / 10L : this._nextExpirationTimeInterval + LeaseManager.this._expirationTimeInterval;
                        long fixedRateDelay = this._nextExpirationTimeInterval - SystemTime.timeMillis();
                        if (fixedRateDelay <= 0L) {
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.finest("Skipped fallAsleep since fixedRateDelay=" + fixedRateDelay);
                            }
                            this._nextExpirationTimeInterval = SystemTime.timeMillis();
                            return;
                        }
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("fallAsleep - going to wait fixedRateDelay=" + fixedRateDelay);
                        }
                        ((Object)((Object)this)).wait(fixedRateDelay);
                        if (this._force) {
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.finest("lease reaper was forcibly waken up");
                            }
                            this._nextExpirationTimeInterval = SystemTime.timeMillis();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, this.getName() + " interrupted.", ie);
                    }
                    this._shouldDie = true;
                    this.signalEndCycle();
                    this.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void clean() {
            if (!this.isAlive()) {
                return;
            }
            LeaseReaper leaseReaper = this;
            synchronized (leaseReaper) {
                this._shouldDie = true;
                ((Object)((Object)this)).notify();
            }
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (LeaseManager.this._expirationList != null) {
                LeaseManager.this._expirationList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitForNoCycleOnQuiesce(long timeout) {
            if (timeout == 0L) {
                throw new RuntimeException("timeout must be supplied!");
            }
            if (!this.isSpaceInQuiesce(false)) {
                throw new RuntimeException("space not in quiesce mode!");
            }
            if (!this._inCycle) {
                return true;
            }
            Object object = this._cycleLock;
            synchronized (object) {
                if (!this._inCycle) {
                    return true;
                }
                try {
                    this._cycleLock.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return !this._inCycle;
            }
        }

        /*
         * Exception decompiling
         */
        private final void reapExpiredEntries() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 34[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void reapEmptyLeaseCells() {
            Iterator iter = LeaseManager.this._expirationList.values().iterator();
            long currentTime = LeaseManager.this.getEffectiveEntryLeaseTimeForReaper(SystemTime.timeMillis());
            int numOfCellsRemoved = 0;
            int numOfCellsSkiped = 0;
            try {
                while (iter.hasNext()) {
                    Cell cell = (Cell)iter.next();
                    long cellTime = cell.getCellKey();
                    if (currentTime <= cellTime) {
                        return;
                    }
                    if (!cell.isEmpty()) {
                        ++numOfCellsSkiped;
                        continue;
                    }
                    cell.setCleaned(true);
                    Cell cell2 = cell;
                    synchronized (cell2) {
                        if (cell.isEmpty()) {
                            iter.remove();
                            ++numOfCellsRemoved;
                        }
                    }
                }
                return;
            }
            finally {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Number of expired cells removed is " + numOfCellsRemoved + " number of cells skipped=" + numOfCellsSkiped);
                }
            }
        }

        private final void reapExpiredXtns() {
            if (LeaseManager.this._transactionHandler.getTimedXtns().isEmpty()) {
                return;
            }
            long currentTime = SystemTime.timeMillis();
            int reapCount = 0;
            Map<ServerTransaction, Long> map = LeaseManager.this._transactionHandler.getTimedXtns();
            for (Map.Entry<ServerTransaction, Long> entry : map.entrySet()) {
                Long limit = entry.getValue();
                ServerTransaction tx = entry.getKey();
                if (tx == null || limit == null || limit >= currentTime) continue;
                try {
                    XtnEntry xtnEntry = LeaseManager.this._engine.getTransaction(tx);
                    boolean unused = false;
                    if (xtnEntry == null) {
                        ((ConcurrentHashMap)LeaseManager.this._transactionHandler.getTimedXtns()).remove(tx, limit);
                        continue;
                    }
                    if (!xtnEntry.m_Active) continue;
                    if (xtnEntry.setUnUsedIfPossible(0, LeaseManager.this._engine.isCleanUnusedEmbeddedGlobalXtns())) {
                        LeaseManager.this._transactionHandler.removeUnusedTransaction(xtnEntry, true);
                        unused = true;
                    }
                    if (!unused) {
                        LeaseManager.this._engine.abortSA((TransactionManager)tx.mgr, tx, false, true, false, null);
                    }
                    ++reapCount;
                    if (unused || !_logger.isLoggable(Level.INFO)) continue;
                    _logger.info("transaction [id=" + tx.id + "] timed out, transaction aborted by space " + LeaseManager.this._engine.getSpaceName());
                }
                catch (UnknownTransactionException ute) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, this.getName() + " - transaction abort failed by space (maybe aborted by user/localTxnManager) for transaction [id=" + tx.id + "]", ute);
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, this.getName() + " -  transaction abort failed by space for transaction [id=" + tx.id + "]", ex);
                }
            }
            if (reapCount > 0 && _logger.isLoggable(Level.FINE)) {
                _logger.fine(this.getName() + " - Reaped expired transactions. [Reaped: " + reapCount + ", Alive: " + LeaseManager.this._transactionHandler.getTimedXtns().size() + "]");
            }
        }

        private final void reapPhantomGlobalXtns() {
            if (LeaseManager.this._transactionHandler.getPhantomGlobalXtns().isEmpty()) {
                return;
            }
            long currentTime = SystemTime.timeMillis();
            int reapCount = 0;
            Map<ServerTransaction, Long> map = LeaseManager.this._transactionHandler.getPhantomGlobalXtns();
            for (Map.Entry<ServerTransaction, Long> entry : map.entrySet()) {
                Long limit = entry.getValue();
                ServerTransaction tx = entry.getKey();
                if (tx == null || limit == null || limit >= currentTime) continue;
                LeaseManager.this._transactionHandler.removeFromPhantomGlobalXtns(tx);
                ++reapCount;
                if (!_logger.isLoggable(Level.INFO)) continue;
                _logger.info("Globalxtn phantom info transaction [id=" + tx.id + "] cleared " + LeaseManager.this._engine.getSpaceName());
            }
            if (reapCount > 0 && _logger.isLoggable(Level.FINE)) {
                _logger.fine(this.getName() + " - Phantom global transactions info. [Reaped: " + reapCount + ", Alive: " + LeaseManager.this._transactionHandler.getPhantomGlobalXtns().size() + "]");
            }
        }

        private final void reapStuck2PCPreparedXtns() {
            if (LeaseManager.this._engine.getClusterPolicy() != null && !LeaseManager.this._spaceImpl.isPrimary()) {
                return;
            }
            if (LeaseManager.this._transactionHandler.getPrepared2PCXtns().isEmpty()) {
                return;
            }
            long currentTime = SystemTime.timeMillis();
            int reapCount = 0;
            Map<ServerTransaction, Prepared2PCXtnInfo> map = LeaseManager.this._transactionHandler.getPrepared2PCXtns();
            for (Map.Entry<ServerTransaction, Prepared2PCXtnInfo> entry : map.entrySet()) {
                String id;
                boolean keepOn;
                Prepared2PCXtnInfo pInfo = entry.getValue();
                if (!pInfo.isExpiredPrepareTime(currentTime) || pInfo.getXtnEntry().getStatus() != XtnStatus.PREPARED || (keepOn = pInfo.extendIfPossible(LeaseManager.this._engine))) continue;
                if (_logger.isLoggable(Level.WARNING)) {
                    id = pInfo.getXtnEntry().getServerTransaction().isXid() ? " xa " : "";
                    _logger.warning(this.getName() + " - lease manager found stuck prepared xtn- going to abort , id=: " + id + pInfo.getXtnEntry().getServerTransaction().id);
                }
                try {
                    LeaseManager.this._engine.abortSA((TransactionManager)pInfo.getXtnEntry().getServerTransaction().mgr, pInfo.getXtnEntry().getServerTransaction(), false, false, false, null);
                    if (!_logger.isLoggable(Level.WARNING)) continue;
                    id = pInfo.getXtnEntry().getServerTransaction().isXid() ? " xa " : "";
                    _logger.warning(this.getName() + " - lease manager found stuck prepared xtn- aborted , id=: " + id + pInfo.getXtnEntry().getServerTransaction().id + " [Reaped: " + reapCount + " size=" + LeaseManager.this._transactionHandler.getPrepared2PCXtns().size() + "]");
                }
                catch (UnknownTransactionException unknownTransactionException) {}
            }
            if (reapCount > 0 && _logger.isLoggable(Level.WARNING)) {
                _logger.warning(this.getName() + " - stuck 2PC prepared xtns. [Reaped: " + reapCount + ", Alive: " + LeaseManager.this._transactionHandler.getPrepared2PCXtns().size() + "]");
            }
        }

        private final void reapUnusedXtns() {
            int unusedCleanTime = LeaseManager.this._transactionHandler.getUnusedXtnCleanTime();
            int reapCount = 0;
            long currentTime = SystemTime.timeMillis();
            long expirationTime = currentTime - (long)unusedCleanTime;
            if (!this._force && this._lastReapedUnusedXtn > expirationTime) {
                return;
            }
            this._lastReapedUnusedXtn = currentTime;
            Map<ServerTransaction, XtnEntry> map = LeaseManager.this._transactionHandler.getXtnTable();
            for (Map.Entry<ServerTransaction, XtnEntry> entry : map.entrySet()) {
                XtnEntry xtnEntry = entry.getValue();
                if (xtnEntry == null || !xtnEntry.setUnUsedIfPossible(unusedCleanTime, LeaseManager.this._engine.isCleanUnusedEmbeddedGlobalXtns())) continue;
                LeaseManager.this._transactionHandler.removeUnusedTransaction(xtnEntry, true);
                ++reapCount;
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("Unused transaction [id=" + xtnEntry.m_Transaction.id + "] cleaned,  space " + LeaseManager.this._engine.getSpaceName());
            }
            if (reapCount > 0 && _logger.isLoggable(Level.FINE)) {
                _logger.fine(this.getName() + " - Reaped unused transactions. [Reaped: " + reapCount + " ]");
            }
        }

        private final void reapStaleReplicas() {
            long currentTime = SystemTime.timeMillis();
            long expirationTime = currentTime - LeaseManager.this._staleReplicaExpirationTime;
            if (!this._force && this._lastReapedSpaceContentObjects >= expirationTime) {
                return;
            }
            this._lastReapedSpaceContentObjects = currentTime;
            LeaseManager.this._engine.getReplicationNode().getAdmin().clearStaleReplicas(expirationTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private final void reapRecentDeletes() {
            int reapCount;
            block21: {
                if (!LeaseManager.this._cacheManager.useRecentDeletes()) {
                    return;
                }
                reapCount = 0;
                try {
                    long currentTime = SystemTime.timeMillis();
                    long expirationTime = currentTime - LeaseManager.this._expirationTimeRecentDeletes;
                    long checkTime = currentTime - -5000L;
                    if (!this._force) {
                        if (this._lastRepeadRecentDeletes >= checkTime) return;
                    }
                    this._lastRepeadRecentDeletes = checkTime;
                    Iterator<RecentDeletesRepository.RecentDeleteInfo> itr = LeaseManager.this._cacheManager.getRecentDeletesIterator();
                    while (itr.hasNext()) {
                        IEntryHolder entry;
                        RecentDeletesRepository.RecentDeleteInfo curInfo;
                        ILockObject entryLock;
                        RecentDeletesRepository.RecentDeleteInfo rdinfo;
                        block20: {
                            rdinfo = itr.next();
                            long etime = rdinfo.getTimeBase();
                            if (etime >= expirationTime && (etime != Long.MAX_VALUE || !LeaseManager.this._cacheManager.requiresEvictionReplicationProtection())) continue;
                            entryLock = null;
                            ILockObject iLockObject = entryLock = LeaseManager.this._cacheManager.getLockManager().getLockObject(rdinfo.getUid());
                            // MONITORENTER : iLockObject
                            curInfo = LeaseManager.this._cacheManager.getRecentDeleteInfo(rdinfo.getUid());
                            if (curInfo != rdinfo) {
                                // MONITOREXIT : iLockObject
                                if (entryLock == null) continue;
                                LeaseManager.this._cacheManager.getLockManager().freeLockObject(entryLock);
                                continue;
                            }
                            entry = LeaseManager.this._cacheManager.getEntryByUidFromPureCache(rdinfo.getUid());
                            if (entry != null) break block20;
                            throw new RuntimeException("RecentDeletes reaper: entry not in memory " + rdinfo.getUid());
                        }
                        if (!entry.isDeleted()) {
                            throw new RuntimeException("RecentDeletes reaper: entry not deleted " + rdinfo.getUid());
                        }
                        if (curInfo.getTimeBase() == Long.MAX_VALUE) {
                            XtnEntry xtnEntry;
                            XtnEntry xtnEntry2 = xtnEntry = rdinfo.getXtn() != null ? LeaseManager.this._engine.getTransaction(rdinfo.getXtn()) : null;
                            if (xtnEntry != null && xtnEntry.getStatus() != XtnStatus.COMMITED && xtnEntry.getStatus() != XtnStatus.ROLLED) {
                                // MONITOREXIT : iLockObject
                                if (entryLock == null) continue;
                                LeaseManager.this._cacheManager.getLockManager().freeLockObject(entryLock);
                                continue;
                            }
                            if (LeaseManager.this._cacheManager.getEvictionReplicationsMarkersRepository().isEntryEvictable(rdinfo.getUid(), false)) {
                                LeaseManager.this._cacheManager.insertToRecentDeletes(entry, SystemTime.timeMillis(), rdinfo.getXtn());
                            }
                            // MONITOREXIT : iLockObject
                            if (entryLock == null) continue;
                            LeaseManager.this._cacheManager.getLockManager().freeLockObject(entryLock);
                            continue;
                        }
                        try {
                            itr.remove();
                            ++reapCount;
                            LeaseManager.this._cacheManager.removeEntryFromCache(entry, false, true, null, CacheManager.RecentDeleteCodes.REMOVE_DUMMY);
                            // MONITOREXIT : iLockObject
                        }
                        finally {
                            if (entryLock == null) continue;
                            LeaseManager.this._cacheManager.getLockManager().freeLockObject(entryLock);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block21;
                    _logger.log(Level.SEVERE, this.getName() + " - caught exception while reaping recent deleted entries.", ex);
                }
            }
            if (reapCount <= 0) return;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.getName() + " - Reaped content of recently deleted entries. [Reaped: " + reapCount + ", Remaining:" + LeaseManager.this._cacheManager.getNumOfRecentDeletes() + " ]");
            }
            if (!_logger.isLoggable(Level.FINEST)) return;
            if (LeaseManager.this._cacheManager.getNumOfRecentDeletes() != 0) return;
            _logger.finest(this.getName() + " - Number of entries in cache after reap all recent deletes:" + LeaseManager.this._cacheManager.getEnriesSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private final void reapRecentUpdates() {
            if (!LeaseManager.this._cacheManager.useRecentUpdatesForPinning()) {
                return;
            }
            int reapCount = 0;
            Context context = null;
            try {
                long currentTime = SystemTime.timeMillis();
                long expirationTime = currentTime - LeaseManager.this._expirationTimeRecentUpdates;
                long checkTime = currentTime - -5000L;
                if (!this._force && this._lastReapedRecentUpdates >= checkTime) {
                    if (context == null) return;
                    context = LeaseManager.this._cacheManager.freeCacheContext(context);
                    return;
                }
                this._lastReapedRecentUpdates = checkTime;
                context = LeaseManager.this._cacheManager.getCacheContext();
                Iterator<RecentUpdatesRepository.RecentUpdateInfo> itr = LeaseManager.this._cacheManager.getRecentUpdatesIterator();
                while (itr.hasNext()) {
                    IEntryHolder entry;
                    RecentUpdatesRepository.RecentUpdateInfo curInfo;
                    ILockObject entryLock;
                    RecentUpdatesRepository.RecentUpdateInfo rdinfo;
                    block24: {
                        rdinfo = itr.next();
                        long etime = rdinfo.getTimeBase();
                        if (etime >= expirationTime && (etime != Long.MAX_VALUE || !LeaseManager.this._cacheManager.requiresEvictionReplicationProtection())) continue;
                        entryLock = null;
                        ILockObject iLockObject = entryLock = LeaseManager.this._cacheManager.getLockManager().getLockObject(rdinfo.getUid());
                        // MONITORENTER : iLockObject
                        curInfo = LeaseManager.this._cacheManager.getRecentUpdateInfo(rdinfo.getUid());
                        if (curInfo != rdinfo) {
                            // MONITOREXIT : iLockObject
                            if (entryLock == null) continue;
                            LeaseManager.this._cacheManager.getLockManager().freeLockObject(entryLock);
                            continue;
                        }
                        entry = LeaseManager.this._cacheManager.getEntryByUidFromPureCache(rdinfo.getUid());
                        if (entry != null) break block24;
                        throw new RuntimeException("RecentUpdates reaper: entry not in memory " + rdinfo.getUid());
                    }
                    if (curInfo.getTimeBase() == Long.MAX_VALUE) {
                        XtnEntry xtnEntry;
                        XtnEntry xtnEntry2 = xtnEntry = rdinfo.getXtn() != null ? LeaseManager.this._engine.getTransaction(rdinfo.getXtn()) : null;
                        if (xtnEntry != null && xtnEntry.getStatus() != XtnStatus.COMMITED && xtnEntry.getStatus() != XtnStatus.ROLLED) {
                            // MONITOREXIT : iLockObject
                            if (entryLock == null) continue;
                            LeaseManager.this._cacheManager.getLockManager().freeLockObject(entryLock);
                            continue;
                        }
                        if (LeaseManager.this._cacheManager.getEvictionReplicationsMarkersRepository().isEntryEvictable(rdinfo.getUid(), false)) {
                            LeaseManager.this._cacheManager.insertToRecentUpdates(entry, SystemTime.timeMillis(), rdinfo.getXtn());
                        }
                        // MONITOREXIT : iLockObject
                        if (entryLock == null) continue;
                        LeaseManager.this._cacheManager.getLockManager().freeLockObject(entryLock);
                        continue;
                    }
                    try {
                        itr.remove();
                        ++reapCount;
                        LeaseManager.this._cacheManager.unpinIfNeeded(context, entry, null, null);
                        // MONITOREXIT : iLockObject
                    }
                    finally {
                        if (entryLock == null) continue;
                        LeaseManager.this._cacheManager.getLockManager().freeLockObject(entryLock);
                    }
                }
                if (context != null) {
                    context = LeaseManager.this._cacheManager.freeCacheContext(context);
                }
            }
            catch (Exception ex) {
                try {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, this.getName() + " - caught exception while reaping recent updated entries content.", ex);
                    }
                    if (context != null) {
                        context = LeaseManager.this._cacheManager.freeCacheContext(context);
                    }
                }
                catch (Throwable throwable) {
                    if (context == null) throw throwable;
                    context = LeaseManager.this._cacheManager.freeCacheContext(context);
                    throw throwable;
                }
            }
            if (reapCount <= 0) return;
            if (!_logger.isLoggable(Level.FINE)) return;
            _logger.fine(this.getName() + " - Reaped expired content of recently updated entries. [Reaped: " + reapCount + ", Remaining:" + LeaseManager.this._cacheManager.getNumOfRecentUpdates() + "]");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void reapFifoXtnsEntryInfo() {
            ConcurrentHashMap<TerminatingFifoXtnsInfo.FifoXtnEntryInfo, TerminatingFifoXtnsInfo.FifoXtnEntryInfo> terminatingXtnsEntries;
            long expirationTime;
            int reapCount;
            Context context;
            block17: {
                context = null;
                reapCount = 0;
                long currentTime = SystemTime.timeMillis();
                expirationTime = currentTime - 60000L;
                terminatingXtnsEntries = LeaseManager.this._cacheManager.getTerminatingXtnsEntries();
                if (!terminatingXtnsEntries.isEmpty()) break block17;
                context = LeaseManager.this._cacheManager.freeCacheContext(context);
                return;
            }
            try {
                Iterator<TerminatingFifoXtnsInfo.FifoXtnEntryInfo> itr = terminatingXtnsEntries.values().iterator();
                while (itr.hasNext()) {
                    TerminatingFifoXtnsInfo.FifoXtnEntryInfo fxe = itr.next();
                    if (fxe.getChangeTime() >= expirationTime) continue;
                    if (context == null) {
                        context = LeaseManager.this._cacheManager.getCacheContext();
                    }
                    IEntryHolder eh = null;
                    if (!LeaseManager.this._cacheManager.isEvictableCachePolicy() && (eh = LeaseManager.this._cacheManager.getEntryByUidFromPureCache(fxe.getUid())) == null) {
                        itr.remove();
                        ++reapCount;
                        continue;
                    }
                    ILockObject entryLock = null;
                    try {
                        ILockObject iLockObject = entryLock = eh != null ? LeaseManager.this._cacheManager.getLockManager().getLockObject(eh) : LeaseManager.this._cacheManager.getLockManager().getLockObject(fxe.getUid());
                        synchronized (iLockObject) {
                            if (fxe.getChangeTime() < expirationTime) {
                                itr.remove();
                                ++reapCount;
                            }
                        }
                    }
                    finally {
                        if (entryLock == null) continue;
                        LeaseManager.this._cacheManager.getLockManager().freeLockObject(entryLock);
                        entryLock = null;
                    }
                }
                context = LeaseManager.this._cacheManager.freeCacheContext(context);
            }
            catch (Exception ex) {
                try {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, this.getName() + " - caught exception while reaping transaction content for FIFO entries.", ex);
                    }
                    context = LeaseManager.this._cacheManager.freeCacheContext(context);
                }
                catch (Throwable throwable) {
                    context = LeaseManager.this._cacheManager.freeCacheContext(context);
                    throw throwable;
                }
            }
            if (reapCount > 0 && _logger.isLoggable(Level.FINE)) {
                _logger.fine(this.getName() + " - Reaped expired transaction content of FIFO entries. [Reaped: " + reapCount + ", Pending: " + LeaseManager.this._cacheManager.getTerminatingXtnsEntries().size() + "]");
            }
        }

        private final void reapReachedMarkers() {
            int reapCount;
            block6: {
                if (!LeaseManager.this._cacheManager.requiresEvictionReplicationProtection()) {
                    return;
                }
                reapCount = 0;
                try {
                    long currentTime = SystemTime.timeMillis();
                    long expirationTime = currentTime - 5000L;
                    if (!this._force && this._lastReapedMarkersRepository >= expirationTime) {
                        return;
                    }
                    this._lastReapedMarkersRepository = currentTime;
                    reapCount = LeaseManager.this._cacheManager.getEvictionReplicationsMarkersRepository().reapUnused();
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block6;
                    _logger.log(Level.SEVERE, this.getName() + " - caught exception while reaping reached markers ", ex);
                }
            }
            if (reapCount > 0 && _logger.isLoggable(Level.FINE)) {
                _logger.fine(this.getName() + " - Reaped reached markers. [Reaped: " + reapCount + ", Remaining:" + LeaseManager.this._cacheManager.getEvictionReplicationsMarkersRepository().size() + "]");
            }
            if (_logger.isLoggable(Level.FINEST) && LeaseManager.this._cacheManager.getEvictionReplicationsMarkersRepository().size() == 0) {
                _logger.finest(this.getName() + " - Number of entries in cache after reap all recent deletes:" + LeaseManager.this._cacheManager.getEnriesSize());
            }
        }

        private void reapRecentExtendedUpdates() {
            int reaped;
            block6: {
                reaped = 0;
                if (!LeaseManager.this.isSupportsRecentExtendedUpdates()) {
                    return;
                }
                try {
                    IServerTypeDesc[] subTypes;
                    TemplatePacket templatePacket = new TemplatePacket();
                    templatePacket.setFieldsValues(new Object[0]);
                    IServerTypeDesc typeDesc = LeaseManager.this._cacheManager.getTypeManager().loadServerTypeDesc(templatePacket);
                    for (IServerTypeDesc subtype : subTypes = typeDesc.getAssignableTypes()) {
                        TypeDataIndex[] indexes;
                        TypeData td = LeaseManager.this._cacheManager.getTypeData(subtype);
                        if (td == null || !td.hasIndexes()) continue;
                        for (TypeDataIndex index : indexes = td.getIndexes()) {
                            if (!index.isExtendedIndex()) continue;
                            reaped += index.getExtendedIndex().reapExpired();
                            if (index.getExtendedFGIndex() == null) continue;
                            reaped += index.getExtendedFGIndex().reapExpired();
                        }
                    }
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block6;
                    _logger.log(Level.SEVERE, this.getName() + " - caught exception while reaping reached markers ", ex);
                }
            }
            if (reaped > 0 && _logger.isLoggable(Level.FINE)) {
                _logger.fine(this.getName() + " - Reaped reapRecentExtendedUpdates. [Reaped: " + reaped + "]");
            }
        }
    }
}

