/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.LeaseProxy;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.LeaseMapException;

@InternalApi
public class LeaseMapProxy
implements LeaseMap,
Serializable {
    private static final long serialVersionUID = 3360605791400151942L;
    private final Map<Object, Long> m_Map = new HashMap<Object, Long>();
    private final IRemoteSpace m_Origin;

    LeaseMapProxy(LeaseProxy lease, long duration) {
        this.m_Map.put(lease, duration);
        this.m_Origin = lease.getSpace();
    }

    public boolean canContainKey(Object obj) {
        if (!(obj instanceof LeaseProxy)) {
            return false;
        }
        LeaseProxy l = (LeaseProxy)obj;
        return this.m_Origin.equals(l.getSpace());
    }

    public void cancelAll() throws LeaseMapException, RemoteException {
        if (this.m_Map.isEmpty()) {
            return;
        }
        int c = 0;
        int mapSize = this.m_Map.keySet().size();
        LeaseProxy[] leaseArr = new LeaseProxy[mapSize];
        String[] entryUIDs = new String[mapSize];
        String[] classes = new String[mapSize];
        int[] objectTypes = new int[mapSize];
        Iterator<Object> mapIter = this.m_Map.keySet().iterator();
        while (mapIter.hasNext()) {
            leaseArr[c] = (LeaseProxy)mapIter.next();
            entryUIDs[c] = leaseArr[c].getUID();
            classes[c] = leaseArr[c].getClassname();
            objectTypes[c] = leaseArr[c].getObjectType();
            ++c;
        }
        Exception[] exceptions = this.m_Origin.cancelAll(entryUIDs, classes, objectTypes);
        HashMap<LeaseProxy, Exception> exceptionMap = new HashMap<LeaseProxy, Exception>();
        boolean exceptionThrown = false;
        for (int i = 0; i < exceptions.length; ++i) {
            if (exceptions[i] == null) continue;
            this.m_Map.remove(leaseArr[i]);
            exceptionMap.put(leaseArr[i], exceptions[i]);
            exceptionThrown = true;
        }
        if (exceptionThrown) {
            throw new LeaseMapException("Some leases failed to cancel", exceptionMap);
        }
    }

    public void renewAll() throws LeaseMapException, RemoteException {
        if (this.m_Map.isEmpty()) {
            return;
        }
        int c = 0;
        int size = this.m_Map.size();
        LeaseProxy[] leaseArr = new LeaseProxy[size];
        String[] entryUIDs = new String[size];
        String[] classes = new String[size];
        int[] objectTypes = new int[size];
        long[] durations = new long[size];
        Iterator<Object> mapIter = this.m_Map.keySet().iterator();
        while (mapIter.hasNext()) {
            leaseArr[c] = (LeaseProxy)mapIter.next();
            durations[c] = this.m_Map.get(leaseArr[c]);
            entryUIDs[c] = leaseArr[c].getUID();
            classes[c] = leaseArr[c].getClassname();
            objectTypes[c] = leaseArr[c].getObjectType();
            ++c;
        }
        Object[] result = this.m_Origin.renewAll(entryUIDs, classes, objectTypes, durations);
        Exception[] exceptions = (Exception[])result[0];
        long[] newDurations = (long[])result[1];
        HashMap<LeaseProxy, Exception> exceptionMap = new HashMap<LeaseProxy, Exception>();
        boolean exceptionThrown = false;
        long currentTime = SystemTime.timeMillis();
        for (int i = 0; i < exceptions.length; ++i) {
            if (exceptions[i] != null) {
                this.m_Map.remove(leaseArr[i]);
                exceptionMap.put(leaseArr[i], exceptions[i]);
                exceptionThrown = true;
                continue;
            }
            leaseArr[i].setExpiration(newDurations[i] + currentTime);
        }
        if (exceptionThrown) {
            throw new LeaseMapException("Some leases failed to renew", exceptionMap);
        }
    }

    public void clear() {
        this.m_Map.clear();
    }

    public boolean containsKey(Object o) {
        return this.m_Map.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return this.m_Map.containsValue(o);
    }

    public Set entrySet() {
        return this.m_Map.entrySet();
    }

    public boolean equals(Object o) {
        if (o instanceof LeaseMap) {
            LeaseMap lm = (LeaseMap)o;
            return this.entrySet().equals(lm.entrySet());
        }
        return false;
    }

    public Object get(Object key) {
        return this.m_Map.get(key);
    }

    public int hashCode() {
        return this.m_Map.hashCode();
    }

    public boolean isEmpty() {
        return this.m_Map.isEmpty();
    }

    public Set keySet() {
        return this.m_Map.keySet();
    }

    public Object put(Object key, Object value) {
        if (!this.canContainKey(key)) {
            throw new IllegalArgumentException(key.toString());
        }
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException(value.toString());
        }
        return this.m_Map.put(key, (Long)value);
    }

    public void putAll(Map t) {
        Set set = t.entrySet();
        for (Map.Entry entry : set) {
            Object value = entry.getValue();
            if (this.canContainKey(entry.getKey()) && value instanceof Long) continue;
            throw new IllegalArgumentException(t.toString());
        }
        this.m_Map.putAll(t);
    }

    public Object remove(Object key) {
        return this.m_Map.remove(key);
    }

    public int size() {
        return this.m_Map.size();
    }

    public Collection values() {
        return this.m_Map.values();
    }
}

