/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.lease.LeaseUtils;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.LeaseMapProxy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;

@InternalApi
public class LeaseProxy
implements LeaseContext,
Externalizable {
    private static final long serialVersionUID = 1L;
    protected long _expirationTime;
    private int _serialFormat;
    private Object _previousObject;
    private String _uid;
    private int _version;
    private String _classname;
    private int _objectType;
    private boolean _partialSerialization;
    private IRemoteSpace _remoteSpace;
    private transient IRemoteSpace _embeddedSpace;

    public LeaseProxy() {
    }

    public LeaseProxy(long expirationTime, String uid, String classname, int version, int objectType) {
        this._expirationTime = expirationTime;
        this._serialFormat = 1;
        this._uid = uid;
        this._classname = classname;
        this._version = version;
        this._objectType = objectType;
    }

    public LeaseProxy(long expirationTime, String uid, String classname, int version, int objectType, SpaceImpl spaceImpl) {
        this(expirationTime, uid, classname, version, objectType);
        this._embeddedSpace = spaceImpl;
        if (spaceImpl != null && spaceImpl.getEngine() != null && (spaceImpl.getEngine().getCacheManager().isMemorySpace() || spaceImpl.getEngine().getCacheManager().isBlobStoreCachePolicy()) && objectType == 1) {
            this._partialSerialization = true;
        }
    }

    protected LeaseProxy(LeaseProxy lease) {
        this._expirationTime = lease._expirationTime;
        this._serialFormat = lease._serialFormat;
        this._partialSerialization = lease._partialSerialization;
        this._uid = lease._uid;
        this._classname = lease._classname;
        this._objectType = lease._objectType;
        this._previousObject = lease._previousObject;
    }

    public long getExpiration() {
        return this._expirationTime;
    }

    public void setExpiration(long exprTime) {
        this._expirationTime = exprTime;
    }

    public int getSerialFormat() {
        return this._serialFormat;
    }

    public void setSerialFormat(int format) {
        if (format != 1 && format != 2) {
            throw new IllegalArgumentException("Invalid serial format");
        }
        this._serialFormat = format;
    }

    public void cancel() throws UnknownLeaseException, RemoteException {
        this.getSpace().cancel(this._uid, this._classname, this._objectType);
    }

    public void renew(long duration) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        long newDuration = this.getSpace().renew(this._uid, this._classname, this._objectType, duration);
        this._expirationTime = LeaseUtils.toExpiration(newDuration);
    }

    public boolean canBatch(Lease lease) {
        if (!(lease instanceof LeaseProxy)) {
            return false;
        }
        LeaseProxy other = (LeaseProxy)lease;
        if (this._embeddedSpace == null) {
            return this._remoteSpace.equals(other._remoteSpace);
        }
        return this._embeddedSpace.equals(other._embeddedSpace);
    }

    public LeaseMap createLeaseMap(long duration) {
        return new LeaseMapProxy(this, duration);
    }

    @Override
    public String getUID() {
        return this._uid;
    }

    public void setUID(String uid) {
        this._uid = uid;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    public Object getObject() {
        return this._previousObject;
    }

    public void setObject(Object obj) {
        this._previousObject = obj;
    }

    public int getObjectType() {
        return this._objectType;
    }

    public String getClassname() {
        return this._classname;
    }

    public IRemoteSpace getSpace() {
        return this._embeddedSpace == null ? this._remoteSpace : this._embeddedSpace;
    }

    public void setRemoteSpace(IRemoteSpace remoteSpace) {
        this._remoteSpace = remoteSpace;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._remoteSpace);
        out.writeUTF(this._uid);
        out.writeInt(this._serialFormat);
        if (this._partialSerialization) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            if (this._classname != null) {
                out.writeBoolean(true);
                out.writeUTF(this._classname);
            } else {
                out.writeBoolean(false);
            }
        }
        out.writeInt(this._objectType);
        out.writeLong(this._serialFormat == 1 ? this._expirationTime - SystemTime.timeMillis() : this._expirationTime);
        out.writeObject(this._previousObject);
        out.writeInt(this._version);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._remoteSpace = (IRemoteSpace)in.readObject();
        this._uid = in.readUTF();
        this._serialFormat = in.readInt();
        this._partialSerialization = in.readBoolean();
        if (!this._partialSerialization && in.readBoolean()) {
            this._classname = in.readUTF();
        }
        this._objectType = in.readInt();
        this._expirationTime = in.readLong();
        if (this._serialFormat == 1) {
            this._expirationTime = LeaseUtils.toExpiration(this._expirationTime);
        }
        this._previousObject = in.readObject();
        this._version = in.readInt();
    }
}

