/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.StorageTypeDeserialization;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.server.storage.UserTypeEntryData;
import com.gigaspaces.internal.transport.AbstractEntryPacket;
import com.gigaspaces.internal.transport.TransportPacketType;
import java.util.Map;

@InternalApi
public class LocalCacheResponseEntryPacket
extends AbstractEntryPacket {
    private static final long serialVersionUID = 1L;
    private final Object _object;
    private final ITypeIntrospector<Object> _introspector;
    private boolean _returnOnlyUIDs;
    private String _uid;

    public LocalCacheResponseEntryPacket() {
        throw new IllegalStateException("This constructor is required for Externalizable and should not be called directly.");
    }

    public LocalCacheResponseEntryPacket(UserTypeEntryData entryData, String uid) {
        super(entryData.getEntryTypeDesc().getTypeDesc(), entryData.getEntryTypeDesc().getEntryType());
        super.setSerializeTypeDesc(false);
        this._object = entryData.getUserObject();
        this._introspector = entryData.getEntryTypeDesc().getIntrospector();
        if (this._typeDesc.getIdentifierPropertyId() == -1) {
            this._uid = uid;
        }
    }

    @Override
    public TransportPacketType getPacketType() {
        return TransportPacketType.ENTRY_PACKET;
    }

    @Override
    public String getTypeName() {
        return this._typeDesc.getTypeName();
    }

    @Override
    public Object toObject(EntryType entryType, StorageTypeDeserialization storageTypeDeserialization) {
        if (this._object != null && entryType == this._entryType) {
            return this._object;
        }
        return super.toObject(entryType, storageTypeDeserialization);
    }

    @Override
    public Object getFieldValue(int index) {
        return this._introspector.getValue(this._object, index);
    }

    @Override
    public void setFieldValue(int index, Object value) {
        this._introspector.setValue(this._object, value, index);
    }

    @Override
    public Object[] getFieldValues() {
        return this._typeDesc.getIntrospector(this._entryType).getSerializedValues(this._object);
    }

    @Override
    public void setFieldsValues(Object[] values) {
        throw new UnsupportedOperationException("Internal Error - Please contact GigaSpaces Support.");
    }

    @Override
    public String[] getMultipleUIDs() {
        return null;
    }

    @Override
    public void setMultipleUIDs(String[] uids) {
    }

    public boolean isReturnOnlyUids() {
        return this._returnOnlyUIDs;
    }

    public void setReturnOnlyUIDs(boolean returnOnlyUIDs) {
        this._returnOnlyUIDs = returnOnlyUIDs;
    }

    @Override
    public String getUID() {
        if (this._uid != null) {
            return this._uid;
        }
        return this._introspector.getUID(this._object);
    }

    @Override
    public void setUID(String uid) {
        this._introspector.setUID(this._object, uid);
    }

    @Override
    public int getVersion() {
        return this._introspector.getVersion(this._object);
    }

    @Override
    public void setVersion(int version) {
        this._introspector.setVersion(this._object, version);
    }

    @Override
    public long getTTL() {
        return this._introspector.getTimeToLive(this._object);
    }

    @Override
    public void setTTL(long ttl) {
        this._introspector.setTimeToLive(this._object, ttl);
    }

    @Override
    public boolean isFifo() {
        return false;
    }

    @Override
    public boolean isTransient() {
        return this._introspector.isTransient(this._object);
    }

    @Override
    public boolean isNoWriteLease() {
        return false;
    }

    @Override
    public ICustomQuery getCustomQuery() {
        return null;
    }

    @Override
    public void setCustomQuery(ICustomQuery customQuery) {
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this._introspector.getDynamicProperties(this._object);
    }

    @Override
    public void setDynamicProperties(Map<String, Object> properties) {
        this._introspector.setDynamicProperties(this._object, properties);
    }

    @Override
    public boolean hasFixedPropertiesArray() {
        return false;
    }
}

