/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.jms.JmsFactory;
import com.j_spaces.core.IJSpace;
import com.j_spaces.kernel.log.JProperties;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lookup.ServiceIDListener;

@InternalApi
public class LookupManager
implements ServiceIDListener,
LeaseListener {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.lookupmanager");
    private final String m_ContainerName;
    private final Hashtable<String, IJSpace> _registeredSpaces;
    private final boolean m_jndiFlag;
    private final Context m_jndiContext;
    private final boolean m_jmsFlag;
    private Closeable m_jmsLookupManager;
    private final boolean m_isInternalJmsJndi;
    private final boolean m_isExternalJmsJndi;

    public LookupManager(String containerName) throws NamingException, IOException {
        this.m_ContainerName = containerName;
        this._registeredSpaces = new Hashtable();
        this.m_jndiFlag = Boolean.parseBoolean(JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jndi.enabled", "false"));
        this.m_jmsFlag = Boolean.parseBoolean(JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jms_services.enabled", "false"));
        this.m_isInternalJmsJndi = Boolean.parseBoolean(JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jms_services.internal-jndi.internal-jndi-enabled", "false"));
        this.m_isExternalJmsJndi = Boolean.parseBoolean(JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jms_services.ext-jndi.ext-jndi-enabled", "false"));
        this.m_jndiContext = this.m_jndiFlag ? LookupManager.createInternalContext(containerName) : null;
    }

    @Override
    public void serviceIDNotify(ServiceID serviceID) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("<" + this.m_ContainerName + "> container registered with " + serviceID.toString() + " serviceID successfully.");
        }
    }

    @Override
    public void notify(LeaseRenewalEvent leaseManagerEvent) {
        if (_logger.isLoggable(Level.FINE)) {
            Throwable error = leaseManagerEvent.getException();
            _logger.fine("LeaseRenewalManager cannot renew this lease <" + leaseManagerEvent.getLease().getExpiration() + ">" + (error != null ? " - " + error.toString() : ""));
        }
    }

    public static LookupLocator[] buildLookupLocators(String lookupLocatorURLs) {
        String locatorURL = null;
        ArrayList<LookupLocator> locatorList = new ArrayList<LookupLocator>();
        if (lookupLocatorURLs != null && lookupLocatorURLs.length() > 0) {
            StringTokenizer st = new StringTokenizer(lookupLocatorURLs, ",");
            while (st.hasMoreTokens()) {
                try {
                    locatorURL = st.nextToken().trim();
                    if (locatorURL.isEmpty() || locatorURL.equals("\"\"")) continue;
                    if (!locatorURL.startsWith("jini://")) {
                        locatorURL = "jini://" + locatorURL;
                    }
                    LookupLocator lookupLocator = new LookupLocator(locatorURL);
                    locatorList.add(lookupLocator);
                }
                catch (MalformedURLException ex) {
                    if (!_logger.isLoggable(Level.WARNING)) continue;
                    _logger.log(Level.WARNING, "Unicast discovery failed for LookupService: " + locatorURL + " - " + ex.toString(), ex);
                }
            }
        }
        return locatorList.toArray(new LookupLocator[locatorList.size()]);
    }

    public void register(IJSpace spaceProxy, String containerName) {
        block6: {
            String spaceName = spaceProxy.getName();
            this._registeredSpaces.put(spaceName, spaceProxy);
            try {
                if (this.m_jmsFlag && this.m_jndiFlag) {
                    Context internalContext = this.m_jndiContext != null && this.m_isInternalJmsJndi ? this.m_jndiContext : null;
                    Context externalContext = this.m_isExternalJmsJndi ? LookupManager.createExternalContext(spaceName) : null;
                    this.m_jmsLookupManager = JmsFactory.getInstance().createLookupManager(containerName, spaceProxy, internalContext, externalContext);
                }
                if (this.m_jmsFlag && !this.m_jndiFlag && !this.m_isExternalJmsJndi && _logger.isLoggable(Level.WARNING)) {
                    _logger.warning("The JMS Service must have an enabled JNDI Lookup service. \nPlease enable Internal or External JNDI service (under <jms_services> tag) and restart the container.");
                }
            }
            catch (Exception ex) {
                String cause = "";
                if (!_logger.isLoggable(Level.WARNING)) break block6;
                if (ex instanceof NamingException) {
                    Throwable rootException = ((NamingException)ex).getRootCause();
                    if (rootException != null) {
                        cause = rootException.toString();
                    }
                    _logger.warning("\n\nDirectory Service: Failed registering space <" + spaceProxy + "> : " + cause);
                }
                _logger.log(Level.WARNING, "\n\nDirectory Service: Failed registering space <" + spaceProxy + "> : ", ex);
            }
        }
    }

    public void unregister(String spaceName) {
        block3: {
            try {
                if (this.m_jmsLookupManager != null) {
                    this.m_jmsLookupManager.close();
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.WARNING)) break block3;
                _logger.log(Level.WARNING, "\n\nDirectory Service: Failed to unregister space " + spaceName + " : " + e.toString(), e);
            }
        }
        this._registeredSpaces.remove(spaceName);
    }

    public void terminate() throws RemoteException {
        Hashtable tmpDepot = (Hashtable)this._registeredSpaces.clone();
        for (String spaceName : tmpDepot.keySet()) {
            this.unregister(spaceName);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("All spaces unregistered successfully");
        }
    }

    private static Context createInternalContext(String containerName) throws NamingException {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        env.put("java.naming.provider.url", "rmi://" + JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jndi.url", "localhost:10098"));
        return new InitialContext(env);
    }

    private static Context createExternalContext(String spaceName) {
        try {
            return new InitialContext();
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.SEVERE)) {
                if (ex instanceof NamingException) {
                    String cause = ((NamingException)ex).getRootCause().toString();
                    _logger.log(Level.SEVERE, "Failed to create InitialContext and register JMS Admin Objects on space <" + spaceName + "> using the external JNDI lookup service | " + cause, ex);
                } else {
                    _logger.log(Level.SEVERE, "Failed to create InitialContext and register JMS Admin Objects on space <" + spaceName + "> using the external JNDI lookup service | " + ex.toString(), ex);
                }
            }
            return null;
        }
    }
}

