/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.HeapDump;
import com.j_spaces.core.IProcessMemoryManager;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.MemoryShortageException;
import com.j_spaces.core.OffHeapMemoryShortageException;
import com.j_spaces.core.ProcessMemoryManager;
import com.j_spaces.core.cache.AbstractCacheManager;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.blobStore.memory_pool.AbstractMemoryPool;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@InternalApi
public class MemoryManager
implements Closeable {
    private volatile boolean _monitorOnlyWriteOps;
    private final String _spaceName;
    private final String _containerName;
    private final AbstractCacheManager _cacheManager;
    private final LeaseManager _leaseManager;
    private final boolean _enabled;
    private final boolean _restartOnFailover;
    private final float _memoryUsageHighLevel;
    private final float _memoryUsageSyncEvictionLevel;
    private final float _memoryWriteOnlyBlock;
    private final float _memoryWriteOnlyCheck;
    private final float _memoryUsageLowLevel;
    private final int _memoryRetryCount;
    private final long _layoffTimeout;
    private final int _evictionQuota;
    private final Evictor _evictor;
    private final boolean _callGC;
    private final boolean _gcBeforeShortage;
    private final boolean _forceLeaseReaper;
    private final IProcessMemoryManager _processMemoryManager;
    private final AbstractMemoryPool _offHeapStorage;
    private final Logger _logger;

    public MemoryManager(String spaceName, String containerName, AbstractCacheManager cacheManager, LeaseManager leaseManager, boolean isPrimary) {
        this._logger = Logger.getLogger("com.gigaspaces.memory-manager." + spaceName + "." + SpaceImpl.extractInstanceIdFromContainerName(containerName));
        this._spaceName = spaceName;
        this._containerName = containerName;
        this._cacheManager = cacheManager;
        this._leaseManager = leaseManager;
        this._processMemoryManager = ProcessMemoryManager.INSTANCE;
        String fullSpaceName = JSpaceUtilities.createFullSpaceName(containerName, spaceName);
        SpaceConfigReader configReader = new SpaceConfigReader(fullSpaceName);
        String monitorMemoryUsage = configReader.getSpaceProperty("engine.memory_usage.enabled", "true");
        this.startHeapDumpMBean();
        this._enabled = this.isEnabled(monitorMemoryUsage, isPrimary);
        this._restartOnFailover = monitorMemoryUsage.equalsIgnoreCase("primary-only");
        this._layoffTimeout = configReader.getLongSpaceProperty("engine.memory_usage.retry_yield_time", "50");
        this._offHeapStorage = this.initOffHeapStorage();
        if (this._enabled) {
            float syncEvictLevel;
            this._evictor = new Evictor();
            try {
                this._memoryUsageHighLevel = configReader.getFloatSpaceProperty("engine.memory_usage.high_watermark_percentage", "95");
                this._memoryWriteOnlyBlock = configReader.getFloatSpaceProperty("engine.memory_usage.write_only_block_percentage", "85");
                this._memoryWriteOnlyCheck = configReader.getFloatSpaceProperty("engine.memory_usage.write_only_check_percentage", "76");
                this._forceLeaseReaper = configReader.getBooleanSpaceProperty("engine.memory_usage.explicit-lease-reaper", "true");
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid high percentage ratio value for memory usage limit: " + ex.toString());
            }
            try {
                this._memoryUsageLowLevel = configReader.getFloatSpaceProperty("engine.memory_usage.low_watermark_percentage", "75");
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid low percentage ratio value for memory usage limit: " + ex.toString(), ex);
            }
            try {
                syncEvictLevel = configReader.getFloatSpaceProperty("engine.memory_usage.synchronous_eviction_watermark_percentage", "0");
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid sync-eviction percentage ratio value for memory usage limit: " + ex.toString(), ex);
            }
            this._memoryUsageSyncEvictionLevel = syncEvictLevel == 0.0f ? this._memoryUsageHighLevel + (100.0f - this._memoryUsageHighLevel) / 2.0f : Math.max(syncEvictLevel, this._memoryUsageHighLevel);
            try {
                this._evictionQuota = configReader.getIntSpaceProperty("engine.memory_usage.eviction_batch_size", "500");
                cacheManager.setEvictionQuota(this._evictionQuota);
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid value for eviction-quota: " + ex.toString(), ex);
            }
            try {
                this._memoryRetryCount = configReader.getIntSpaceProperty("engine.memory_usage.retry_count", "5");
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid value for Memory Retry Count: " + ex.toString(), ex);
            }
            try {
                this._callGC = configReader.getBooleanSpaceProperty("engine.memory_usage.explicit-gc", "false");
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid value for Memory explicit GC: " + ex.toString(), ex);
            }
            try {
                this._gcBeforeShortage = configReader.getBooleanSpaceProperty("engine.memory_usage.gc-before-shortage", "true");
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid value for Memory explicit GC: " + ex.toString(), ex);
            }
            if (this._memoryUsageLowLevel > this._memoryUsageHighLevel || this._memoryUsageHighLevel < this._memoryUsageLowLevel || this._memoryWriteOnlyBlock < this._memoryWriteOnlyCheck || this._memoryUsageHighLevel < this._memoryWriteOnlyBlock || this._memoryWriteOnlyCheck < this._memoryUsageLowLevel || this._memoryUsageHighLevel > 100.0f || this._memoryUsageLowLevel < 0.0f) {
                throw new RuntimeException("Invalid percentage ratio definition for Memory Management.\n\tShould obey: High Watermark Percentage >= Write only block percentage >= Write only check percentage >= Low Watermark Percentage \n\tPlease refer to the space xml file under <memory_usage> tag.\n\tExtracted parameters: (In the absence of either parameter, the default is used)\n\t\tHigh Watermark Percentage: " + this._memoryUsageHighLevel + ",\n\t\tWrite only block percentage: " + this._memoryWriteOnlyBlock + ",\n\t\tWrite only check percentage: " + this._memoryWriteOnlyCheck + ",\n\t\tLow Watermark Percentage: " + this._memoryUsageLowLevel);
            }
        } else {
            this._memoryUsageHighLevel = 100.0f;
            this._memoryWriteOnlyBlock = 100.0f;
            this._memoryWriteOnlyCheck = 100.0f;
            this._memoryUsageLowLevel = 100.0f;
            this._memoryRetryCount = 0;
            this._evictionQuota = 0;
            this._evictor = null;
            this._callGC = false;
            this._gcBeforeShortage = false;
            this._forceLeaseReaper = false;
            this._memoryUsageSyncEvictionLevel = 100.0f;
        }
        if (this._logger.isLoggable(Level.CONFIG)) {
            if (this._enabled) {
                this._logger.config("Memory manager is enabled [high_watermark=" + this._memoryUsageHighLevel + "%, low_watermark=" + this._memoryUsageLowLevel + "%, write_only_block=" + this._memoryWriteOnlyBlock + "%, write_only_check=" + this._memoryWriteOnlyCheck + "%, retry_count=" + this._memoryRetryCount + "]");
            } else if (this._restartOnFailover) {
                this._logger.config("Memory manager is disabled, but will be activated if this instance becomes primary");
            } else {
                this._logger.config("Memory manager is disabled");
            }
        }
        this.start();
    }

    private AbstractMemoryPool initOffHeapStorage() {
        if (!(this._cacheManager instanceof CacheManager)) {
            return null;
        }
        CacheManager cacheManager = (CacheManager)this._cacheManager;
        if (!cacheManager.isBlobStoreCachePolicy()) {
            return null;
        }
        if (cacheManager.hasBlobStoreOffHeapCache()) {
            return cacheManager.getBlobStoreStorageHandler().getOffHeapCache();
        }
        if (cacheManager.getBlobStoreStorageHandler().getOffHeapStore() != null) {
            return cacheManager.getBlobStoreStorageHandler().getOffHeapStore();
        }
        return null;
    }

    private synchronized void startHeapDumpMBean() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("org.xap:type=HeapDumpMBean");
            if (!mbs.isRegistered(name)) {
                HeapDump heapDump = new HeapDump();
                heapDump.setEnabled(Boolean.getBoolean("com.gs.memory.create-heap-dump-on-memory-shortage"));
                heapDump.setMaxHeaps(Integer.getInteger("com.gs.memory.max-heaps-on-memory-shortage", 1));
                heapDump.setQuietPeriod(Long.getLong("com.gs.memory.heaps-on-memory-shortage-quiet-period", 1L));
                mbs.registerMBean(heapDump, name);
                this._logger.config("Register HeapDumpMBean " + name);
            }
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "failed to start HeapDumpMBean" + e);
        }
    }

    private void createDumpIfAppropriate() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("org.xap:type=HeapDumpMBean");
            boolean created = (Boolean)mbs.invoke(name, "onMemoryShortage", null, null);
            if (created) {
                this._logger.log(Level.FINE, "Heap dump created");
            } else {
                this._logger.log(Level.FINEST, "Heap dump not created");
            }
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "failed to start HeapDumpMBean" + e);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isRestartOnFailover() {
        return this._restartOnFailover;
    }

    private boolean isEnabled(String value, boolean isPrimary) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        if (value.equalsIgnoreCase("primary-only")) {
            return isPrimary;
        }
        throw new IllegalArgumentException("Unsupported value for space-config.engine.memory_usage.enabled: " + value);
    }

    private int getEvictionBatchSize() {
        return this._evictionQuota;
    }

    private void setMonitorOnlyWriteOps(boolean val) {
        this._monitorOnlyWriteOps = val;
    }

    public void monitorMemoryUsage(boolean isWriteTypeOperation) throws MemoryShortageException {
        MemoryEvictionDecision res;
        if (isWriteTypeOperation) {
            this.monitorOffHeap();
        }
        if (this._enabled && (res = this.monitorMemoryUsageWithNoEviction_Impl(isWriteTypeOperation)) != MemoryEvictionDecision.NO_EVICTION) {
            this._evictor.evict(isWriteTypeOperation, res == MemoryEvictionDecision.SYNC_EVICTION);
        }
    }

    private void monitorOffHeap() {
        if (this._offHeapStorage == null) {
            return;
        }
        long bytesUsed = this._offHeapStorage.getUsedBytes();
        long threshold = this._offHeapStorage.getThreshold();
        int MBFactor = 0x100000;
        if ((float)bytesUsed >= (float)threshold * (this._memoryUsageHighLevel / 100.0f)) {
            String used = bytesUsed > (long)MBFactor ? bytesUsed / (long)MBFactor + " mb" : bytesUsed + " b";
            String max = threshold > (long)MBFactor ? threshold / (long)MBFactor + " mb" : threshold + " b";
            String hostId = SystemInfo.singleton().network().getHostId();
            String msg = "Off Heap Memory reached " + this._memoryUsageHighLevel + "% at: host: " + hostId + ", space " + this._spaceName + ", container " + this._containerName + ", total off heap memory: " + max + ", used off heap memory: " + used;
            throw new OffHeapMemoryShortageException(msg, this._spaceName, this._containerName, hostId, bytesUsed, threshold);
        }
    }

    public boolean monitorMemoryUsageWithNoEviction(boolean isWriteTypeOperation) {
        MemoryEvictionDecision res = this.monitorMemoryUsageWithNoEviction_Impl(isWriteTypeOperation);
        return res != MemoryEvictionDecision.NO_EVICTION;
    }

    private MemoryEvictionDecision monitorMemoryUsageWithNoEviction_Impl(boolean isWriteTypeOperation) {
        boolean monitorOnlyWriteOps;
        if (this._monitorOnlyWriteOps && !isWriteTypeOperation && !this._cacheManager.isBlobStoreCachePolicy()) {
            return MemoryEvictionDecision.NO_EVICTION;
        }
        double rate = this.getMemoryUsageRate(false, !this._cacheManager.isEvictableCachePolicy());
        boolean bl = monitorOnlyWriteOps = rate <= (double)this._memoryWriteOnlyCheck;
        if (monitorOnlyWriteOps != this._monitorOnlyWriteOps) {
            if (this._processMemoryManager.isAsyncCheckEnabled() && this._logger.isLoggable(Level.INFO)) {
                if (monitorOnlyWriteOps) {
                    this._logger.info("Current memory usage rate [" + rate + "] is below write_only_check_percentage threshold [" + this._memoryWriteOnlyCheck + "], moving to async measurement of memory usage rate");
                } else {
                    this._logger.info("Current memory usage rate [" + rate + "] is above write_only_check_percentage threshold [" + this._memoryWriteOnlyCheck + "], moving to sync measurement of memory usage rate");
                }
            }
            this._monitorOnlyWriteOps = monitorOnlyWriteOps;
        }
        if (!monitorOnlyWriteOps) {
            rate = this.getMemoryUsageRate(false, false);
        }
        if (rate < (double)this._memoryWriteOnlyBlock) {
            return MemoryEvictionDecision.NO_EVICTION;
        }
        if (rate < (double)this._memoryUsageHighLevel && !isWriteTypeOperation) {
            return MemoryEvictionDecision.NO_EVICTION;
        }
        if (this._cacheManager.isResidentEntriesCachePolicy()) {
            MemoryShortageException ex;
            if (this._gcBeforeShortage) {
                rate = this.getMemoryUsageRate(true, false);
            }
            if ((ex = this.shortageCheck(rate, isWriteTypeOperation)) != null) {
                this.createDumpIfAppropriate();
                throw ex;
            }
            return MemoryEvictionDecision.NO_EVICTION;
        }
        return rate < (double)this._memoryUsageSyncEvictionLevel ? MemoryEvictionDecision.ASYNC_EVICTION : MemoryEvictionDecision.SYNC_EVICTION;
    }

    @Override
    public void close() {
        if (this._evictor != null) {
            this._evictor.stop();
        }
    }

    private void start() {
        if (this._evictor != null && this._cacheManager.isEvictableCachePolicy()) {
            this._evictor.start();
        }
    }

    private double getMemoryUsageRate(boolean forceGC, boolean asyncCheckIfEnabled) {
        if (forceGC) {
            if (this._forceLeaseReaper && this._leaseManager != null) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("forcing lease reaper cycle");
                }
                try {
                    this._leaseManager.forceLeaseReaperCycle(false);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("explicit gc call");
            }
            this._processMemoryManager.performGC();
        }
        return this._processMemoryManager.getMemoryUsagePercentage(asyncCheckIfEnabled);
    }

    private MemoryShortageException shortageCheck(double rate, boolean writeOperation) {
        if (this.shouldBlock(rate, writeOperation)) {
            if (this._gcBeforeShortage) {
                rate = this.getMemoryUsageRate(true, false);
            }
            if (this.shouldBlock(rate, writeOperation)) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("Memory shortage in cache: " + this._spaceName);
                }
                long usage = (long)(rate * (double)this._processMemoryManager.getMaximumMemory() / 100.0);
                return new MemoryShortageException(this._spaceName, this._containerName, SystemInfo.singleton().network().getHostId(), usage, this._processMemoryManager.getMaximumMemory());
            }
        }
        return null;
    }

    private MemoryShortageException[] shortageChecks(double rate) {
        if (this.shouldBlock(rate, true) || this.shouldBlock(rate, false)) {
            if (this._gcBeforeShortage) {
                rate = this.getMemoryUsageRate(true, false);
            }
            if (this.shouldBlock(rate, true) || this.shouldBlock(rate, false)) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("Memory shortage in cache: " + this._spaceName);
                }
                long usage = (long)(rate * (double)this._processMemoryManager.getMaximumMemory() / 100.0);
                MemoryShortageException ex = new MemoryShortageException(this._spaceName, this._containerName, SystemInfo.singleton().network().getHostId(), usage, this._processMemoryManager.getMaximumMemory());
                MemoryShortageException[] res = new MemoryShortageException[2];
                if (this.shouldBlock(rate, true)) {
                    res[0] = ex;
                }
                if (this.shouldBlock(rate, false)) {
                    res[1] = ex;
                }
                return res;
            }
        }
        return null;
    }

    private boolean shouldBlock(double rate, boolean writeOperation) {
        return rate > (double)this._memoryUsageHighLevel || rate >= (double)this._memoryWriteOnlyBlock && writeOperation;
    }

    private class Evictor {
        private boolean _readTypeEvict = false;
        private boolean _writeTypeEvict = false;
        private volatile MemoryShortageException _writeTypeMemoryException = null;
        private volatile MemoryShortageException _readTypeMemoryException = null;
        private EvictorRunner _runner;
        private final Object _lock = new Object();

        private Evictor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void evict(boolean aWriteTypeOperation, boolean synchronousCall) throws MemoryShortageException {
            MemoryShortageException resultException;
            if (MemoryManager.this._logger.isLoggable(Level.FINE)) {
                MemoryManager.this._logger.fine("Call evict on operation: " + aWriteTypeOperation + " synchronous=" + synchronousCall);
            }
            if (!synchronousCall) {
                Object object = this._lock;
                synchronized (object) {
                    if (aWriteTypeOperation) {
                        this._writeTypeEvict = true;
                    } else {
                        this._readTypeEvict = true;
                    }
                    this._lock.notify();
                }
            } else {
                this._runner.doEvict();
            }
            MemoryShortageException memoryShortageException = resultException = aWriteTypeOperation ? this._writeTypeMemoryException : this._readTypeMemoryException;
            if (resultException != null) {
                MemoryManager.this.createDumpIfAppropriate();
                throw resultException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this._lock;
            synchronized (object) {
                if (this._runner != null) {
                    this._writeTypeMemoryException = null;
                    this._readTypeMemoryException = null;
                    this._readTypeEvict = false;
                    this._writeTypeEvict = false;
                    this._runner.shutdown();
                    this._runner = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this._lock;
            synchronized (object) {
                if (this._runner != null) {
                    return;
                }
                this._runner = new EvictorRunner();
                this._runner.start();
            }
        }

        private class EvictorRunner
        extends GSThread {
            private boolean _isShutdown;

            EvictorRunner() {
                super(MemoryManager.this._containerName + ":" + MemoryManager.this._spaceName + "-Evictor");
                this._isShutdown = false;
                this.setDaemon(true);
            }

            public void shutdown() {
                this._isShutdown = true;
                this.interrupt();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!this.isInterrupted()) {
                    Object object = Evictor.this._lock;
                    synchronized (object) {
                        block11: {
                            try {
                                while (!(Evictor.this._readTypeEvict || Evictor.this._writeTypeEvict || this._isShutdown)) {
                                    if (MemoryManager.this._logger.isLoggable(Level.FINEST)) {
                                        MemoryManager.this._logger.finest("Evictor waits for - call evict");
                                    }
                                    Evictor.this._lock.wait();
                                }
                                Evictor.this._readTypeEvict = false;
                                Evictor.this._writeTypeEvict = false;
                            }
                            catch (InterruptedException ie) {
                                if (MemoryManager.this._logger.isLoggable(Level.FINEST)) {
                                    MemoryManager.this._logger.log(Level.FINEST, this.getName() + " interrupted.", ie);
                                }
                                this.interrupt();
                                break;
                            }
                            catch (Exception e) {
                                if (!MemoryManager.this._logger.isLoggable(Level.WARNING)) break block11;
                                MemoryManager.this._logger.log(Level.WARNING, e.toString(), e);
                            }
                        }
                        if (this._isShutdown) {
                            return;
                        }
                    }
                    this.doEvict();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private synchronized void doEvict() throws MemoryShortageException {
                block20: {
                    double rate = MemoryManager.this.getMemoryUsageRate(MemoryManager.this._callGC, false);
                    if (MemoryManager.this._logger.isLoggable(Level.FINE)) {
                        MemoryManager.this._logger.fine("Evictor started to evict, rate=" + rate + " free-memory=" + MemoryManager.this._processMemoryManager.getFreeMemory() + " max-memory=" + MemoryManager.this._processMemoryManager.getMaximumMemory());
                    }
                    try {
                        if (!MemoryManager.this._cacheManager.isEvictableCachePolicy() || MemoryManager.this._evictionQuota <= 0) break block20;
                        for (int retryCount = 0; retryCount < MemoryManager.this._memoryRetryCount; ++retryCount) {
                            if (rate <= (double)MemoryManager.this._memoryUsageLowLevel) {
                                return;
                            }
                            if (MemoryManager.this._logger.isLoggable(Level.FINE)) {
                                MemoryManager.this._logger.fine("SpaceName: " + MemoryManager.this._spaceName + " Cache eviction started: Available memory[%]" + rate);
                            }
                            int evicted = MemoryManager.this._cacheManager.evictBatch(MemoryManager.this.getEvictionBatchSize());
                            if (MemoryManager.this._logger.isLoggable(Level.FINE)) {
                                MemoryManager.this._logger.fine("Batch evicted size=" + evicted);
                            }
                            if (evicted == 0) break;
                            rate = MemoryManager.this.getMemoryUsageRate(MemoryManager.this._callGC, false);
                            if (MemoryManager.this._logger.isLoggable(Level.FINE)) {
                                MemoryManager.this._logger.fine("rate=" + rate + " free-memory=" + MemoryManager.this._processMemoryManager.getFreeMemory() + " max-memory=" + MemoryManager.this._processMemoryManager.getMaximumMemory());
                            }
                            if (rate <= (double)MemoryManager.this._memoryUsageLowLevel) {
                                return;
                            }
                            if (MemoryManager.this._logger.isLoggable(Level.FINE)) {
                                MemoryManager.this._logger.fine("SpaceName: " + MemoryManager.this._spaceName + " Cache eviction finished: Available memory[%]" + rate + " evicted all entries.");
                            }
                            try {
                                Thread.sleep(MemoryManager.this._layoffTimeout);
                            }
                            catch (InterruptedException ie) {
                                if (MemoryManager.this._logger.isLoggable(Level.FINEST)) {
                                    MemoryManager.this._logger.log(Level.FINEST, Thread.currentThread().getName() + " interrupted.", ie);
                                }
                                Thread.currentThread().interrupt();
                                break;
                            }
                            rate = MemoryManager.this.getMemoryUsageRate(MemoryManager.this._callGC, false);
                        }
                        if (MemoryManager.this._logger.isLoggable(Level.FINE)) {
                            MemoryManager.this._logger.fine("Evictor finished to evict, rate=" + rate);
                        }
                    }
                    finally {
                        rate = MemoryManager.this.getMemoryUsageRate(false, false);
                        MemoryShortageException[] res = MemoryManager.this.shortageChecks(rate);
                        if (res == null) {
                            Evictor.this._readTypeMemoryException = null;
                            Evictor.this._writeTypeMemoryException = null;
                        } else {
                            Evictor.this._readTypeMemoryException = res[1];
                            if (res[1] != null) {
                                MemoryManager.this.setMonitorOnlyWriteOps(false);
                            }
                            Evictor.this._writeTypeMemoryException = res[0];
                        }
                    }
                }
            }
        }
    }

    private static enum MemoryEvictionDecision {
        NO_EVICTION,
        ASYNC_EVICTION,
        SYNC_EVICTION;

    }
}

