/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.client.ResourceCapacityExceededException;

public class MemoryShortageException
extends ResourceCapacityExceededException {
    private static final long serialVersionUID = 1L;
    private final String _spaceName;
    private final String _containerName;
    private final String _hostName;
    private final long _memoryUsage;
    private final long _maxMemory;

    public MemoryShortageException(String spaceName, String containerName, String hostName, long memoryUsage, long maxMemory) {
        super("Memory shortage at: host: " + hostName + ", container: " + containerName + ", space " + spaceName + ", total memory: " + maxMemory / 0x100000L + " mb, used memory: " + memoryUsage / 0x100000L + " mb");
        this._spaceName = spaceName;
        this._containerName = containerName;
        this._hostName = hostName;
        this._memoryUsage = memoryUsage;
        this._maxMemory = maxMemory;
    }

    public MemoryShortageException(String msg, String spaceName, String containerName, String hostName, long memoryUsage, long maxMemory) {
        super(msg);
        this._spaceName = spaceName;
        this._containerName = containerName;
        this._hostName = hostName;
        this._memoryUsage = memoryUsage;
        this._maxMemory = maxMemory;
    }

    public String getSpaceName() {
        return this._spaceName;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public String getHostName() {
        return this._hostName;
    }

    public long getMemoryUsage() {
        return this._memoryUsage;
    }

    public long getMaxMemory() {
        return this._maxMemory;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

