/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.FifoEntriesComparator;
import com.j_spaces.core.fifo.FifoBackgroundRequest;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

@InternalApi
public class PendingFifoSearch {
    static int INITIAL_SCAN_ACTIVE = 0;
    static int INITIAL_SCAN_NOTACTIVE = 1;
    private int _status = INITIAL_SCAN_ACTIVE;
    private TreeMap<IEntryHolder, FifoBackgroundRequest> _rejectedFifoEntries = null;
    private boolean _needNotifyTermination;
    private final boolean _memorySpace;
    private static final FifoEntriesComparator m_Comparator = new FifoEntriesComparator();

    public PendingFifoSearch(boolean memorySpace) {
        this._memorySpace = memorySpace;
    }

    public synchronized void addRejectedEntry(IEntryHolder eh, FifoBackgroundRequest red) {
        if (this._rejectedFifoEntries == null) {
            this._rejectedFifoEntries = new TreeMap(m_Comparator);
        }
        this._rejectedFifoEntries.put(eh, red);
    }

    public synchronized boolean anyRejectedEntries() {
        return this._rejectedFifoEntries != null && !this._rejectedFifoEntries.isEmpty();
    }

    public synchronized ArrayList<FifoBackgroundRequest> getRejectedEntries() {
        if (this._rejectedFifoEntries == null) {
            return null;
        }
        ArrayList<FifoBackgroundRequest> res = new ArrayList<FifoBackgroundRequest>();
        for (Map.Entry<IEntryHolder, FifoBackgroundRequest> me : this._rejectedFifoEntries.entrySet()) {
            IEntryHolder eh = me.getKey();
            if (this._memorySpace && eh.isDeleted()) continue;
            res.add(me.getValue());
        }
        return res;
    }

    public synchronized void notifyNonActiveIfNeedTo() {
        this._status = INITIAL_SCAN_NOTACTIVE;
        if (this._needNotifyTermination) {
            this.notify();
        }
    }

    public synchronized void waitForNonActiveStatus() {
        try {
            if (this._status == INITIAL_SCAN_NOTACTIVE) {
                return;
            }
            this._needNotifyTermination = true;
            this.wait(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

