/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.core.IProcessMemoryManager;

@InternalApi
public class ProcessMemoryManager
implements IProcessMemoryManager {
    private static final Runtime _runtime = Runtime.getRuntime();
    private static final long _totalMemory = _runtime.totalMemory() == _runtime.maxMemory() ? _runtime.totalMemory() : -1L;
    private static final long _maximumMemory = _runtime.maxMemory();
    private static final boolean _asyncMemorySamplerEnabled = Boolean.getBoolean("com.gs.asyncMemorySampler");
    private static final long _samplerThreadSleepDurationInMs = Long.getLong("com.gs.asyncMemorySampler.interval", 10L);
    private static volatile boolean _samplerThreadShouldRun = false;
    private static volatile long _freeMemory = _runtime.freeMemory();
    public static final IProcessMemoryManager INSTANCE = new ProcessMemoryManager();

    private ProcessMemoryManager() {
        if (_asyncMemorySamplerEnabled) {
            GSThread samplerThread = new GSThread((Runnable)new MemorySampler(), "ProcessMemoryManager");
            samplerThread.setDaemon(true);
            samplerThread.start();
        }
    }

    @Override
    public void performGC() {
        _runtime.gc();
    }

    @Override
    public double getMemoryUsagePercentage(boolean asyncCheckIfEnabled) {
        return (double)this.getMemoryUsage(asyncCheckIfEnabled) * 100.0 / (double)this.getMaximumMemory();
    }

    @Override
    public long getMemoryUsage() {
        return this.getMemoryUsage(true);
    }

    public long getMemoryUsage(boolean asyncCheckIfEnabled) {
        long totalMemory = _totalMemory == -1L ? _runtime.totalMemory() : _totalMemory;
        return totalMemory - this.getFreeMemory(asyncCheckIfEnabled);
    }

    @Override
    public long getMaximumMemory() {
        return _maximumMemory;
    }

    @Override
    public long getFreeMemory() {
        return this.getFreeMemory(true);
    }

    @Override
    public boolean isAsyncCheckEnabled() {
        return _asyncMemorySamplerEnabled;
    }

    public long getFreeMemory(boolean asyncCheckIfEnabled) {
        if (_asyncMemorySamplerEnabled && asyncCheckIfEnabled) {
            _samplerThreadShouldRun = true;
            return _freeMemory;
        }
        _freeMemory = _runtime.freeMemory();
        return _freeMemory;
    }

    static /* synthetic */ boolean access$000() {
        return _samplerThreadShouldRun;
    }

    static /* synthetic */ long access$100() {
        return _samplerThreadSleepDurationInMs;
    }

    static /* synthetic */ boolean access$002(boolean x0) {
        _samplerThreadShouldRun = x0;
        return _samplerThreadShouldRun;
    }

    static /* synthetic */ long access$202(long x0) {
        _freeMemory = x0;
        return _freeMemory;
    }

    static /* synthetic */ Runtime access$300() {
        return _runtime;
    }

    public class MemorySampler
    implements Runnable {
        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block2: while (true) {
                if (!ProcessMemoryManager.access$000()) {
                    try {
                        Thread.sleep(ProcessMemoryManager.access$100());
                    }
                    catch (InterruptedException var1_1) {}
                    continue;
                }
                while (true) {
                    if (ProcessMemoryManager.access$000()) ** break;
                    continue block2;
                    ProcessMemoryManager.access$002(false);
                    ProcessMemoryManager.access$202(ProcessMemoryManager.access$300().freeMemory());
                }
                break;
            }
        }
    }
}

