/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.Constants;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.exception.SpaceConfigurationException;
import com.j_spaces.core.filters.FiltersInfo;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.sadapter.datasource.DataAdaptorIterator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@InternalApi
public class SpaceConfigFactory {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.container");

    public static SpaceConfig createSpaceConfig(Properties schemaProps, ClusterPolicy m_ClusterPolicy, String containerName, boolean isSchema, String fullSpaceSchemaLocation) throws IOException, SAXException, ParserConfigurationException, SpaceConfigurationException {
        String clusterSpaceEnabledStr;
        String clusterConfigURL;
        String cachePolicyPropStr;
        String serilType;
        String engineMemoryUsageEnabled;
        SpaceConfig spaceConfig = new SpaceConfig(null, schemaProps, containerName, fullSpaceSchemaLocation);
        spaceConfig.setPrivate(Boolean.valueOf(schemaProps.getProperty("space-config.isPrivate", Boolean.FALSE.toString())));
        String schemaName = schemaProps.getProperty("space-config.schema", null);
        spaceConfig.setSchemaName(schemaName);
        spaceConfig.setConnectionRetries(schemaProps.getProperty("space-config.retries", "10"));
        spaceConfig.setNotifyRetries(schemaProps.getProperty("space-config.notifier-retries", "3"));
        spaceConfig.setExpirationTimeInterval(schemaProps.getProperty("space-config.lease_manager.expiration_time_interval", String.valueOf(10000L)));
        spaceConfig.setExpirationTimeRecentUpdate(schemaProps.getProperty("space-config.lease_manager.expiration_time_recent_updates", String.valueOf(180000L)));
        spaceConfig.setExpirationTimeRecentDeletes(schemaProps.getProperty("space-config.lease_manager.expiration_time_recent_deletes", String.valueOf(180000L)));
        spaceConfig.setExpirationStaleReplicas(schemaProps.getProperty("space-config.lease_manager.expiration_stale_replicas", String.valueOf(300000L)));
        String defaultEngineMemoryUsageEnabled = engineMemoryUsageEnabled = schemaProps.getProperty("space-config.engine.memory_usage.enabled", "true");
        if (JProperties.isSystemProp(engineMemoryUsageEnabled)) {
            defaultEngineMemoryUsageEnabled = "true";
        }
        engineMemoryUsageEnabled = JProperties.getPropertyFromSystem(engineMemoryUsageEnabled, defaultEngineMemoryUsageEnabled);
        spaceConfig.setEngineMemoryUsageEnabled(engineMemoryUsageEnabled);
        spaceConfig.setEngineMemoryUsageHighPercentageRatio(schemaProps.getProperty("space-config.engine.memory_usage.high_watermark_percentage", "95"));
        spaceConfig.setEngineMemoryUsageLowPercentageRatio(schemaProps.getProperty("space-config.engine.memory_usage.low_watermark_percentage", "75"));
        spaceConfig.setEngineMemoryUsageWriteOnlyBlockPercentageRatio(schemaProps.getProperty("space-config.engine.memory_usage.write_only_block_percentage", "85"));
        spaceConfig.setEngineMemoryWriteOnlyCheckPercentageRatio(schemaProps.getProperty("space-config.engine.memory_usage.write_only_check_percentage", "76"));
        spaceConfig.setEngineMemoryUsageEvictionBatchSize(schemaProps.getProperty("space-config.engine.memory_usage.eviction_batch_size", "500"));
        spaceConfig.setEngineMemoryUsageRetryCount(schemaProps.getProperty("space-config.engine.memory_usage.retry_count", "5"));
        String defaultSerilType = serilType = schemaProps.getProperty("space-config.serialization-type", Constants.Engine.ENGINE_SERIALIZATION_TYPE_DEFAULT);
        if (JProperties.isSystemProp(serilType)) {
            defaultSerilType = Constants.Engine.ENGINE_SERIALIZATION_TYPE_DEFAULT;
        }
        serilType = JProperties.getPropertyFromSystem(serilType, defaultSerilType);
        spaceConfig.setSerializationType(Integer.parseInt(serilType));
        spaceConfig.setEngineMinThreads(schemaProps.getProperty("space-config.engine.min_threads", "1"));
        spaceConfig.setEngineMaxThreads(schemaProps.getProperty("space-config.engine.max_threads", "64"));
        boolean isPersitent = Boolean.valueOf(schemaProps.getProperty("space-config.persistent.enabled", Constants.StorageAdapter.PERSISTENT_ENABLED_DEFAULT));
        spaceConfig.setPersistent(isPersitent);
        spaceConfig.setMirrorServiceEnabled(Boolean.valueOf(schemaProps.getProperty("space-config.mirror-service.enabled", "false")));
        spaceConfig.setDataSourceClass(schemaProps.getProperty("space-config.external-data-source.data-source-class", "org.openspaces.persistency.hibernate.DefaultHibernateExternalDataSource"));
        spaceConfig.setDataClass(schemaProps.getProperty("space-config.external-data-source.data-class", Constants.DataAdapter.DATA_CLASS_DEFAULT));
        spaceConfig.setQueryBuilderClass(schemaProps.getProperty("space-config.external-data-source.query-builder-class", Constants.DataAdapter.QUERY_BUILDER_PROP_DEFAULT));
        spaceConfig.setDataPropertiesFile(schemaProps.getProperty("space-config.external-data-source.init-properties-file", ""));
        spaceConfig.setUsage(schemaProps.getProperty("space-config.external-data-source.usage", "read-write"));
        spaceConfig.setSupportsInheritanceEnabled(Boolean.parseBoolean(schemaProps.getProperty("space-config.external-data-source.supports-inheritance", "true")));
        spaceConfig.setSupportsVersionEnabled(Boolean.parseBoolean(schemaProps.getProperty("space-config.external-data-source.supports-version", "false")));
        spaceConfig.setSupportsPartialUpdateEnabled(Boolean.parseBoolean(schemaProps.getProperty("space-config.external-data-source.supports-partial-update", "false")));
        spaceConfig.setSupportsRemoveByIdEnabled(Boolean.parseBoolean(schemaProps.getProperty("space-config.external-data-source.supports-remove-by-id", "false")));
        spaceConfig.setDataSourceSharedIteratorMode(Boolean.parseBoolean(schemaProps.getProperty("space-config.external-data-source.shared-iterator.enabled", "true")));
        long leaseManagerExpirationTimeRecentDeletes = Long.parseLong(spaceConfig.getExpirationTimeRecentDeletes());
        long leaseManagerExpirationTimeRecentUpdates = Long.parseLong(spaceConfig.getExpirationTimeRecentUpdates());
        String dataSourceShareIteratorTTLDefault = DataAdaptorIterator.getDataSourceShareIteratorTTLDefault(leaseManagerExpirationTimeRecentDeletes, leaseManagerExpirationTimeRecentUpdates);
        spaceConfig.setDataSourceSharedIteratorTimeToLive(Long.parseLong(schemaProps.getProperty("space-config.external-data-source.shared-iterator.time-to-live", dataSourceShareIteratorTTLDefault)));
        spaceConfig.setQPAutoCommit(Boolean.valueOf(schemaProps.getProperty("space-config.QueryProcessor.auto_commit", Constants.QueryProcessorInfo.QP_AUTO_COMMIT_DEFAULT)));
        spaceConfig.setQPParserCaseSensetivity(Boolean.valueOf(schemaProps.getProperty("space-config.QueryProcessor.parser_case_sensetivity", Constants.QueryProcessorInfo.QP_PARSER_CASE_SENSETIVITY_DEFAULT)));
        spaceConfig.setQPTraceExecTime(Boolean.valueOf(schemaProps.getProperty("space-config.QueryProcessor.trace_exec_time", Constants.QueryProcessorInfo.QP_TRACE_EXEC_TIME_DEFAULT)));
        spaceConfig.setQpTransactionTimeout(Integer.parseInt(schemaProps.getProperty("space-config.QueryProcessor.transaction_timeout", Constants.QueryProcessorInfo.QP_TRANSACTION_TIMEOUT_DEFAULT)));
        spaceConfig.setQpSpaceReadLeaseTime(Integer.parseInt(schemaProps.getProperty("space-config.QueryProcessor.space_read_lease_time", Constants.QueryProcessorInfo.QP_SPACE_READ_LEASE_TIME_DEFAULT)));
        spaceConfig.setQpSpaceWriteLeaseTime(Long.parseLong(schemaProps.getProperty("QueryProcessor.space_write_lease", Constants.QueryProcessorInfo.QP_SPACE_WRITE_LEASE_DEFAULT)));
        spaceConfig.setQpDateFormat(schemaProps.getProperty("space-config.QueryProcessor.date_format", "yyyy-MM-dd"));
        spaceConfig.setQpDateTimeFormat(schemaProps.getProperty("space-config.QueryProcessor.datetime_format", "yyyy-MM-dd HH:mm:ss"));
        spaceConfig.setQpTimeFormat(schemaProps.getProperty("space-config.QueryProcessor.time_format", "HH:mm:ss"));
        spaceConfig.setCacheManagerSize(schemaProps.getProperty("space-config.engine.cache_size", "100000"));
        String defaultCachePolicyValue = isPersitent ? String.valueOf(0) : String.valueOf(1);
        String defaultCachePolicyPropStr = cachePolicyPropStr = schemaProps.getProperty("space-config.engine.cache_policy", defaultCachePolicyValue);
        if (JProperties.isSystemProp(cachePolicyPropStr)) {
            defaultCachePolicyPropStr = defaultCachePolicyValue;
        }
        cachePolicyPropStr = JProperties.getPropertyFromSystem(cachePolicyPropStr, defaultCachePolicyPropStr);
        spaceConfig.setCachePolicy(cachePolicyPropStr);
        String defaultClusterConfigURL = clusterConfigURL = schemaProps.getProperty("space-config.cluster.config-url", "none");
        if (JProperties.isSystemProp(clusterConfigURL)) {
            defaultClusterConfigURL = "none";
        }
        clusterConfigURL = JProperties.getPropertyFromSystem(clusterConfigURL, defaultClusterConfigURL);
        spaceConfig.setClusterConfigURL(clusterConfigURL);
        String defaultClusterSpaceEnabledStr = clusterSpaceEnabledStr = schemaProps.getProperty("space-config.cluster.enabled", Boolean.FALSE.toString());
        if (JProperties.isSystemProp(clusterSpaceEnabledStr)) {
            defaultClusterSpaceEnabledStr = Boolean.FALSE.toString();
        }
        clusterSpaceEnabledStr = JProperties.getPropertyFromSystem(clusterSpaceEnabledStr, defaultClusterSpaceEnabledStr);
        spaceConfig.setClustered(Boolean.valueOf(clusterSpaceEnabledStr));
        spaceConfig.setDCacheConfigName(schemaProps.getProperty("space-config.dist-cache.config-name", "DefaultConfig"));
        spaceConfig.setDCacheProperties(JProperties.loadConfigDCache(spaceConfig.getDCacheConfigName()));
        int filterCounter = 0;
        String fnames = schemaProps.getProperty("space-config.filters.filter-names", "");
        StringTokenizer st = new StringTokenizer(fnames, ",");
        spaceConfig.setFiltersInfo(new FiltersInfo[st.countTokens()]);
        while (st.hasMoreElements()) {
            String filterName = st.nextToken().trim();
            FiltersInfo info = new FiltersInfo();
            spaceConfig.setFilterInfoAt(info, filterCounter++);
            info.filterName = filterName;
            info.enabled = Boolean.valueOf(schemaProps.getProperty("space-config.filters." + filterName + ".enabled", ""));
            info.filterClassName = schemaProps.getProperty("space-config.filters." + filterName + ".class", "");
            info.paramURL = schemaProps.getProperty("space-config.filters." + filterName + ".url", "");
            String operationsCode = schemaProps.getProperty("space-config.filters." + filterName + ".operation-code", "");
            StringTokenizer operStrToken = new StringTokenizer(operationsCode, ",");
            while (operStrToken.hasMoreTokens()) {
                int operCode = Integer.parseInt(operStrToken.nextToken().trim());
                switch (operCode) {
                    case 53: {
                        info.afterRemove = true;
                        break;
                    }
                    case 1: {
                        info.afterWrite = true;
                        break;
                    }
                    case 8: {
                        info.beforeClean = true;
                        break;
                    }
                    case 4: {
                        info.beforeNotify = true;
                        break;
                    }
                    case 2: {
                        info.beforeRead = true;
                        break;
                    }
                    case 3: {
                        info.beforeTake = true;
                        break;
                    }
                    case 0: {
                        info.beforeWrite = true;
                        break;
                    }
                    case 5: {
                        info.beforeGetAdmin = true;
                        break;
                    }
                    case 6: {
                        info.beforeAuthentication = true;
                        break;
                    }
                    case 9: {
                        info.beforeUpdate = true;
                        break;
                    }
                    case 10: {
                        info.afterUpdate = true;
                    }
                }
            }
            if (!filterName.equalsIgnoreCase("DefaultSecurityFilter")) continue;
            String schemaRef = fullSpaceSchemaLocation != null ? " [" + fullSpaceSchemaLocation + "] " : " ";
            _logger.warning("The filter [DefaultSecurityFilter] defined in the space schema file" + schemaRef + "is no longer in use since 7.0.1; Please remove it.");
        }
        spaceConfig.setJMSRmiPort(schemaProps.getProperty("space-config.jms.connections.rmi-port", ""));
        spaceConfig.setJMSTopicNames(schemaProps.getProperty("space-config.jms.administrated-destinations.topics.topic-names", ""));
        spaceConfig.setJMSQueueNames(schemaProps.getProperty("space-config.jms.administrated-destinations.queues.queue-names", ""));
        spaceConfig.setProxyConnectionMode(schemaProps.getProperty("space-config.proxy-settings.connection-monitor", "all"));
        spaceConfig.setProxyMonitorFrequency(Long.parseLong(schemaProps.getProperty("space-config.proxy-settings.ping-frequency", Constants.SpaceProxy.OldRouter.MONITOR_FREQUENCY_DEFAULT)));
        spaceConfig.setProxyDetectorFrequency(Long.parseLong(schemaProps.getProperty("space-config.proxy-settings.lookup-frequency", Constants.SpaceProxy.OldRouter.DETECTOR_FREQUENCY_DEFAULT)));
        spaceConfig.setProxyConnectionRetries(Integer.parseInt(schemaProps.getProperty("space-config.proxy-settings.connection-retries", "10")));
        spaceConfig.putAll((Map<?, ?>)schemaProps);
        return spaceConfig;
    }

    public static void performSaveAs(File selFile, String spaceName, String containerName, JSpaceAttributes spaceAttributes) {
        try {
            InputStream schemaInputStream = ResourceLoader.findSpaceSchema("default").getInputStream();
            SpaceConfigFactory.writeDOMToFile(schemaInputStream, selFile, spaceName);
            SpaceImpl.setConfig(spaceName, containerName, spaceAttributes, selFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeDOMToFile(InputStream is, File selFile, String spaceName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(is);
        Element root = doc.getDocumentElement();
        SpaceConfigFactory.writeToFile(selFile, root);
    }

    public static void writeDOMToFile(InputStream is, File selFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(is);
        Element root = doc.getDocumentElement();
        SpaceConfigFactory.writeToFile(selFile, root);
    }

    private static void writeToFile(File selFile, Element root) throws IOException {
        FileOutputStream fos = new FileOutputStream(selFile);
        PrintStream ps = new PrintStream(fos);
        JSpaceUtilities.domWriter(root, ps, "");
        fos.flush();
        ps.flush();
        ps.close();
        fos.close();
    }

    public static String createGenericDBName(String containerName, String spaceName) {
        String genericPersistPropertiesFolder = "GenericPersistProperties";
        StringBuilder strBuffer = new StringBuilder(SystemInfo.singleton().getXapHome());
        strBuffer.append(File.separator);
        strBuffer.append("GenericPersistProperties");
        strBuffer.append(File.separator);
        strBuffer.append(containerName);
        strBuffer.append('_');
        strBuffer.append(spaceName);
        strBuffer.append(File.separator);
        strBuffer.append(containerName);
        strBuffer.append('_');
        strBuffer.append(spaceName);
        strBuffer.append("DB.dbs");
        return strBuffer.toString();
    }
}

