/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.admin.quiesce.QuiesceToken;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.security.service.SecurityContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SpaceContext
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private SecurityContext securityContext;
    private boolean fromGateway;
    private QuiesceToken quiesceToken;
    private static final short FLAG_SECURITY = 1;
    private static final short FLAG_FROM_GATEWAY = 2;
    private static final short FLAG_QUIESCE_TOKEN = 4;

    public SpaceContext() {
    }

    public SpaceContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public SpaceContext(boolean fromGateway) {
        this.fromGateway = fromGateway;
    }

    public SpaceContext createCopy(SecurityContext newSecurityContext) {
        SpaceContext newContext = new SpaceContext(this.fromGateway);
        newContext.securityContext = newSecurityContext;
        return newContext;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public boolean isFromGateway() {
        return this.fromGateway;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
            this.writeExternalV10_1_0(out);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
            this.writeExternalV9_7_0(out);
        } else {
            this.writeExternalV8_0_3(out);
        }
    }

    private void writeExternalV10_1_0(ObjectOutput out) throws IOException {
        short flags = this.buildFlags();
        out.writeShort(flags);
        if (this.securityContext != null) {
            IOUtils.writeObject(out, this.securityContext);
        }
        if (this.quiesceToken != null) {
            IOUtils.writeObject(out, this.quiesceToken);
        }
    }

    private void writeExternalV9_7_0(ObjectOutput out) throws IOException {
        short flags = this.buildFlags();
        out.writeShort(flags);
        if (this.securityContext != null) {
            IOUtils.writeObject(out, this.securityContext);
        }
    }

    private void writeExternalV8_0_3(ObjectOutput out) throws IOException {
        if (this.securityContext != null) {
            out.writeBoolean(true);
            out.writeObject(this.securityContext);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.fromGateway);
        if (this.fromGateway) {
            out.writeBoolean(true);
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this.securityContext != null) {
            flags = (short)(flags | 1);
        }
        if (this.fromGateway) {
            flags = (short)(flags | 2);
        }
        if (this.quiesceToken != null) {
            flags = (short)(flags | 4);
        }
        return flags;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
            this.readExternalV10_1_0(in);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
            this.readExternalV9_7_0(in);
        } else {
            this.readExternalV8_0_3(in);
        }
    }

    private void readExternalV10_1_0(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        boolean bl = this.fromGateway = (flags & 2) != 0;
        if ((flags & 1) != 0) {
            this.securityContext = (SecurityContext)IOUtils.readObject(in);
        }
        if ((flags & 4) != 0) {
            this.quiesceToken = (QuiesceToken)IOUtils.readObject(in);
        }
    }

    private void readExternalV9_7_0(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        boolean bl = this.fromGateway = (flags & 2) != 0;
        if ((flags & 1) != 0) {
            this.securityContext = (SecurityContext)IOUtils.readObject(in);
        }
    }

    private void readExternalV8_0_3(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.securityContext = (SecurityContext)in.readObject();
        }
        this.fromGateway = in.readBoolean();
        if (this.fromGateway) {
            in.readBoolean();
        }
    }

    public QuiesceToken getQuiesceToken() {
        return this.quiesceToken;
    }

    public void setQuiesceToken(QuiesceToken quiesceToken) {
        this.quiesceToken = quiesceToken;
    }
}

