/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.SpaceCopyStatus;
import com.j_spaces.core.client.SpaceURL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.jini.core.event.EventRegistration;

@InternalApi
public class SpaceCopyStatusImpl
implements SpaceCopyStatus {
    private static final long serialVersionUID = 1L;
    public static final short RECOVERY_TYPE = 1;
    public static final short COPY_TYPE = 2;
    private short _operationType = (short)2;
    private int _totalCopyObj;
    private String _sourceMember;
    private final String _targetMember;
    private SpaceURL _sourceMemberUrl;
    private Exception _causeEx;
    private int _totalDummyObj;
    private AtomicInteger counter = new AtomicInteger();
    private final HashMap<String, Integer> _writeEntries;
    private final HashMap<String, Integer> _notifyTempl;
    private transient HashSet<EventRegistration> _notifyTemplRegistration;
    private final HashMap<String, String> _duplicateUID;
    public static final String NULL_TEMPLATE = "NULL_NOTIFY_TEMPLATE";

    public SpaceCopyStatusImpl(short operationType, String targetMember) {
        this._operationType = operationType;
        this._targetMember = targetMember;
        this._writeEntries = new HashMap();
        this._notifyTempl = new HashMap();
        this._duplicateUID = new HashMap();
        this._notifyTemplRegistration = new HashSet();
    }

    @Override
    public int getTotalDummyObj() {
        return this._totalDummyObj;
    }

    @Override
    public void setTotalDummyObj(int totalDummyObj) {
        this._totalDummyObj = totalDummyObj;
    }

    @Override
    public void incrementTotalDummyObjects() {
        ++this._totalDummyObj;
    }

    @Override
    public int incrementCounter() {
        return this.counter.incrementAndGet();
    }

    @Override
    public int getTotalCopyObj() {
        return this._totalCopyObj;
    }

    @Override
    public String getSourceMemberName() {
        return this._sourceMember;
    }

    @Override
    public String getTargetMemberName() {
        return this._targetMember;
    }

    @Override
    public SpaceURL getSourceMemberURL() {
        return this._sourceMemberUrl;
    }

    @Override
    public Exception getCauseException() {
        return this._causeEx;
    }

    public void setCauseException(Exception causeEx) {
        this._causeEx = causeEx;
    }

    @Override
    public int getTotalBlockedEntriesByFilter() {
        return this._totalDummyObj;
    }

    @Override
    public Map<String, Integer> getTotalCopiedEntries() {
        return this._writeEntries;
    }

    @Override
    public Map<String, Integer> getTotalCopiedNotifyTemplates() {
        return this._notifyTempl;
    }

    @Override
    public Map<String, String> getTotalDuplicateEntries() {
        return this._duplicateUID;
    }

    public void setOperationType(short operationType) {
        this._operationType = operationType;
    }

    @Override
    public HashMap<String, Integer> getWriteEntries() {
        return this._writeEntries;
    }

    @Override
    public HashMap<String, String> getDuplicateUID() {
        return this._duplicateUID;
    }

    @Override
    public HashSet<EventRegistration> getNotifyTemplRegistration() {
        return this._notifyTemplRegistration;
    }

    public void setSourceMember(String sourceMember, SpaceURL sourceMemberUrl) {
        this._sourceMember = sourceMember;
        this._sourceMemberUrl = sourceMemberUrl;
    }

    public void addWriteEntry(String entryName) {
        this.increaseCount(entryName, this._writeEntries);
    }

    public void setWriteCount(String className, int count) {
        this._writeEntries.put(className, count);
        this._totalCopyObj += count;
    }

    public void addNotifyTemplate(String templateName) {
        templateName = templateName == null ? NULL_TEMPLATE : templateName;
        this.increaseCount(templateName, this._notifyTempl);
    }

    public void setNotifyTemplateCount(String className, int count) {
        this._notifyTempl.put(className, count);
        this._totalCopyObj += count;
    }

    public void addNotifyTemplate(String templateName, EventRegistration eventRegistration) {
        this.addNotifyTemplate(templateName);
        this._notifyTemplRegistration.add(eventRegistration);
    }

    public void addDuplicateUID(String className, String UID) {
        this._duplicateUID.put(UID, className);
    }

    private void increaseCount(String className, HashMap<String, Integer> mapType) {
        int total = 0;
        Integer count = mapType.get(className);
        if (count != null) {
            total = count;
        }
        mapType.put(className, ++total);
        ++this._totalCopyObj;
    }

    public String toString() {
        if (this._causeEx != null) {
            return (this._operationType == 2 ? "Copy" : "Recovery") + " operation failed: " + this._causeEx.toString();
        }
        StringBuilder sb = new StringBuilder();
        String operation = this._operationType == 2 ? "Copied" : "Recovered";
        sb.append(operation + " from " + this._sourceMember + " [" + this._sourceMemberUrl + "] to " + this._targetMember);
        sb.append(" [total-objects=").append(this._totalCopyObj);
        this.appendEntriesDesc(sb, this._writeEntries);
        this.appendNotifyTemplatesDesc(sb, this._notifyTempl);
        this.appendDuplicatesDesc(sb, this._duplicateUID);
        if (this._totalDummyObj != 0) {
            sb.append(",discarded-by-replication-input-filter=" + this._totalDummyObj);
        }
        sb.append("]");
        return sb.toString();
    }

    private void appendEntriesDesc(StringBuilder sb, Map<String, Integer> copiedEntries) {
        if (copiedEntries.size() != 0) {
            sb.append(",entries={");
            int total = 0;
            for (Map.Entry<String, Integer> entry : copiedEntries.entrySet()) {
                int count = entry.getValue();
                sb.append(entry.getKey() + "=" + count + ",");
                total += count;
            }
            sb.append("TOTAL=" + total + "}");
        }
    }

    private void appendNotifyTemplatesDesc(StringBuilder sb, Map<String, Integer> copiedNotifyTemplates) {
        if (copiedNotifyTemplates.size() != 0) {
            sb.append(",notify-templates={");
            int total = 0;
            for (Map.Entry<String, Integer> entry : copiedNotifyTemplates.entrySet()) {
                int count = entry.getValue();
                sb.append(entry.getKey() + "=" + count + ",");
                total += count;
            }
            sb.append("TOTAL=" + total + "}");
        }
    }

    private void appendDuplicatesDesc(StringBuilder sb, Map<String, String> duplicateEntries) {
        if (duplicateEntries.size() != 0) {
            sb.append(",duplicates=" + duplicateEntries.size());
            sb.append(" {");
            for (Map.Entry<String, String> entry : duplicateEntries.entrySet()) {
                String uid = entry.getKey();
                String className = entry.getValue();
                sb.append(uid + "/" + className + ",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("}");
        }
    }
}

