/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.AbstractQueryPacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class UidQueryPacket
extends AbstractQueryPacket {
    private static final long serialVersionUID = 1L;
    private String _uid;
    private String[] _uids;
    private boolean _isReturnOnlyUids;
    private int _version;
    private Object _routing;
    private String _typeName;
    private AbstractProjectionTemplate _projectionTemplate;
    private static final byte HAS_UID = 1;
    private static final byte HAS_UIDS = 2;
    private static final byte HAS_VERSION = 4;
    private static final byte RETURN_ONLY_UIDS = 8;
    private static final byte HAS_ROUTING = 16;
    private static final byte HAS_TYPE_NAME = 32;
    private static final byte HAS_PROJECTION = 64;

    public UidQueryPacket() {
    }

    public UidQueryPacket(ITypeDesc typeDesc, String uid, Object routing, int version, QueryResultTypeInternal resultType, boolean returnOnlyUids, AbstractProjectionTemplate projectionTemplate) {
        super(typeDesc, resultType);
        this._typeName = typeDesc != null ? typeDesc.getTypeName() : null;
        this._uid = uid;
        this._version = version;
        this._isReturnOnlyUids = returnOnlyUids;
        this._routing = routing;
        this._projectionTemplate = projectionTemplate;
    }

    public UidQueryPacket(String uid, Object routing, int version, QueryResultTypeInternal resultType) {
        this(null, uid, routing, version, resultType, false, null);
    }

    public UidQueryPacket(String[] uids, int version, QueryResultTypeInternal resultType, boolean returnOnlyUids) {
        super(null, resultType);
        this._uids = uids;
        this._version = version;
        this._isReturnOnlyUids = returnOnlyUids;
        this._routing = null;
        this._projectionTemplate = null;
    }

    @Override
    public String getUID() {
        return this._uid;
    }

    @Override
    public void setUID(String uid) {
        this._uid = uid;
    }

    @Override
    public String[] getMultipleUIDs() {
        return this._uids;
    }

    @Override
    public void setMultipleUIDs(String[] uids) {
        this._uids = uids;
    }

    @Override
    public boolean isReturnOnlyUids() {
        return this._isReturnOnlyUids;
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public boolean isTransient() {
        return this._typeDesc == null || this._typeDesc.getIdPropertyName() == null || super.isTransient();
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(int version) {
        this._version = version;
    }

    @Override
    public Object getRoutingFieldValue() {
        return this._routing;
    }

    public void setRouting(Object routing) {
        this._routing = routing;
    }

    @Override
    public boolean isIdQuery() {
        return this._typeDesc != null;
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.deserialize(in);
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        this.serialize(out, version);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.serialize(out, PlatformLogicalVersion.getLogicalVersion());
    }

    private final void serialize(ObjectOutput out, PlatformLogicalVersion logicalVersion) throws IOException {
        byte flags = this.buildFlags(logicalVersion);
        out.writeByte(flags);
        if (this._uid != null) {
            IOUtils.writeString(out, this._uid);
        }
        if (this._uids != null) {
            IOUtils.writeStringArray(out, this._uids);
        }
        if (this._version != 0) {
            out.writeInt(this._version);
        }
        if (this._routing != null) {
            IOUtils.writeObject(out, this._routing);
        }
        if ((flags & 0x20) != 0) {
            IOUtils.writeRepetitiveString(out, this._typeName);
        }
        if ((flags & 0x40) != 0) {
            IOUtils.writeObject(out, this._projectionTemplate);
        }
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.deserialize(in);
    }

    private final void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        boolean bl = this._isReturnOnlyUids = (flags & 8) != 0;
        if ((flags & 1) != 0) {
            this._uid = IOUtils.readString(in);
        }
        if ((flags & 2) != 0) {
            this._uids = IOUtils.readStringArray(in);
        }
        if ((flags & 4) != 0) {
            this._version = in.readInt();
        }
        if ((flags & 0x10) != 0) {
            this._routing = IOUtils.readObject(in);
        }
        if ((flags & 0x20) != 0) {
            this._typeName = IOUtils.readRepetitiveString(in);
        }
        if ((flags & 0x40) != 0) {
            this._projectionTemplate = (AbstractProjectionTemplate)IOUtils.readObject(in);
        }
    }

    private byte buildFlags(PlatformLogicalVersion version) {
        byte flags = 0;
        if (this._uid != null) {
            flags = (byte)(flags | 1);
        }
        if (this._uids != null) {
            flags = (byte)(flags | 2);
        }
        if (this._version != 0) {
            flags = (byte)(flags | 4);
        }
        if (this._isReturnOnlyUids) {
            flags = (byte)(flags | 8);
        }
        if (this._routing != null) {
            flags = (byte)(flags | 0x10);
        }
        if (this._typeName != null && version.greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            flags = (byte)(flags | 0x20);
        }
        if (this._projectionTemplate != null && version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            flags = (byte)(flags | 0x40);
        }
        return flags;
    }

    @Override
    public void setProjectionTemplate(AbstractProjectionTemplate projectionTemplate) {
        this._projectionTemplate = projectionTemplate;
    }

    @Override
    public AbstractProjectionTemplate getProjectionTemplate() {
        return this._projectionTemplate;
    }
}

