/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.XtnInfo;
import com.j_spaces.core.XtnStatus;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.XtnData;
import com.j_spaces.core.client.LocalTransactionManager;
import com.j_spaces.core.fifo.FifoBackgroundRequest;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class XtnEntry
extends XtnInfo {
    private final Object _joinLock;
    public final transient XtnData _xtnData = new XtnData(this);
    private final transient FifoBackgroundRequest.AllowFifoNotificationsForNonFifoType _allowFifoNotificationsForNonFifoType;
    private final transient boolean _createdOnNonBackup;

    public XtnEntry(ServerTransaction xtn, boolean isBackup) {
        super(xtn);
        this._joinLock = !(xtn.mgr instanceof LocalTransactionManager) ? new Object() : null;
        this._allowFifoNotificationsForNonFifoType = new FifoBackgroundRequest.AllowFifoNotificationsForNonFifoType();
        this._createdOnNonBackup = !isBackup;
    }

    public Object getJoinLock() {
        return this._joinLock;
    }

    public boolean isActive() {
        return this.getStatus() == XtnStatus.UNINITIALIZED || this.getStatus() == XtnStatus.BEGUN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XtnStatus checkAndGetState_Granular() {
        XtnStatus status = this.getStatus();
        if (status == XtnStatus.UNINITIALIZED) {
            Object object = this.getJoinLock();
            synchronized (object) {
                status = this.getStatus();
            }
        }
        return status;
    }

    public XtnData getXtnData() {
        return this._xtnData;
    }

    public boolean anyFifoEntriesUnderXtn() {
        return this.getXtnData().anyFifoEntries();
    }

    public int getNumOfChangesUnderTransaction(CacheManager cacheManager) {
        int numOfChangesUnderTransaction = 0;
        IStoredList<IEntryCacheInfo> locked = this._xtnData.getLockedEntries();
        if (locked != null && !locked.isEmpty()) {
            IStoredListIterator slh = locked.establishListScan(false);
            while (slh != null) {
                IEntryHolder entryHolder;
                IEntryCacheInfo pEntry = (IEntryCacheInfo)slh.getSubject();
                if (pEntry != null && !(entryHolder = pEntry.getEntryHolder(cacheManager)).isDeleted() && entryHolder.getWriteLockOwner() == this && entryHolder.getWriteLockOperation() != 2 && entryHolder.getWriteLockOperation() != 3) {
                    ++numOfChangesUnderTransaction;
                }
                slh = this._xtnData.getLockedEntries().next(slh);
            }
        }
        return numOfChangesUnderTransaction;
    }

    public FifoBackgroundRequest.AllowFifoNotificationsForNonFifoType getAllowFifoNotificationsForNonFifoEntries() {
        return this._allowFifoNotificationsForNonFifoType;
    }

    public boolean createdOnNonBackup() {
        return this._createdOnNonBackup;
    }
}

