/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.ReentrantSimpleLock;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.XtnGatewayInfo;
import com.j_spaces.core.XtnStatus;
import com.j_spaces.core.client.LocalTransactionManager;
import java.util.Set;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class XtnInfo
extends ReentrantSimpleLock {
    public final ServerTransaction m_Transaction;
    private volatile XtnStatus _status;
    public final boolean m_Readonly;
    public boolean m_Active;
    public boolean m_AlreadyPrepared;
    public long m_CommitRollbackTimeStamp;
    public boolean m_SingleParticipant;
    public boolean m_AnyUpdates;
    public final long m_startTime;
    private boolean _isFromReplication;
    private XtnGatewayInfo _gatewayInfo = null;
    private int _usage;
    private long _lastUsageTime;
    private boolean _operatedUpon;
    private boolean _onlyEmbeddedJoins;
    private boolean _disableUnusedXtnCleanupInServer;

    public XtnInfo(ServerTransaction xtn) {
        this.m_Transaction = xtn;
        this.setStatus(XtnStatus.UNINITIALIZED);
        this.m_Readonly = true;
        this.m_Active = true;
        this.m_startTime = SystemTime.timeMillis();
        this._usage = 1;
        this._lastUsageTime = this.m_startTime;
        this._onlyEmbeddedJoins = true;
    }

    public ServerTransaction getServerTransaction() {
        return this.m_Transaction;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public boolean isFromReplication() {
        return this._isFromReplication;
    }

    public void setFromReplication(boolean isFromReplication) {
        this._isFromReplication = isFromReplication;
    }

    public void setStatus(XtnStatus m_Status) {
        this._status = m_Status;
    }

    public XtnStatus getStatus() {
        return this._status;
    }

    public boolean isUsed() {
        return this._usage > 0;
    }

    public synchronized boolean addUsedIfPossible() {
        if (this._status == XtnStatus.UNUSED) {
            return false;
        }
        ++this._usage;
        return true;
    }

    public void decrementUsed() {
        this.decrementUsed(false);
    }

    public synchronized void decrementUsed(boolean disableUnusedXtnCleanupInServer) {
        this._lastUsageTime = SystemTime.timeMillis();
        if (this._usage > 0) {
            --this._usage;
        }
        if (disableUnusedXtnCleanupInServer) {
            this._disableUnusedXtnCleanupInServer = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUnUsedIfPossible(int unusedCleanTime, boolean includeGlobalXtns) {
        if (!this.isCandidateForUnusedXtnRemoval(includeGlobalXtns)) {
            return false;
        }
        if (this._status == XtnStatus.UNUSED) {
            return true;
        }
        XtnInfo xtnInfo = this;
        synchronized (xtnInfo) {
            if (this.isOperatedUpon() || this.isUsed() || this._status != XtnStatus.BEGUN || !this.isOnlyEmbeddedJoins() || this._disableUnusedXtnCleanupInServer) {
                return false;
            }
            if (this._lastUsageTime + (long)unusedCleanTime >= SystemTime.timeMillis()) {
                return false;
            }
            this._status = XtnStatus.UNUSED;
            return true;
        }
    }

    public boolean isOperatedUpon() {
        return this._operatedUpon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOperatedUpon() {
        if (this.isOperatedUpon()) {
            return;
        }
        XtnInfo xtnInfo = this;
        synchronized (xtnInfo) {
            this._operatedUpon = true;
        }
    }

    public long getLastUsageTime() {
        return this._lastUsageTime;
    }

    private boolean isCandidateForUnusedXtnRemoval(boolean includeGlobalXtns) {
        return includeGlobalXtns || this.m_Transaction.mgr instanceof LocalTransactionManager;
    }

    public synchronized boolean isOnlyEmbeddedJoins() {
        return this._onlyEmbeddedJoins;
    }

    public synchronized boolean setOnlyEmbeddedJoins(boolean val) {
        boolean old = this._onlyEmbeddedJoins;
        this._onlyEmbeddedJoins = val;
        return old;
    }

    public boolean isFromGateway() {
        return this._gatewayInfo != null;
    }

    public void setFromGateway() {
        if (this._gatewayInfo == null) {
            this._gatewayInfo = XtnGatewayInfo.EMPTY_GATEWAY_INDICATOR;
        }
    }

    public void setGatewayOverrideVersion(String uid) {
        if (this._gatewayInfo == null || this._gatewayInfo == XtnGatewayInfo.EMPTY_GATEWAY_INDICATOR) {
            this._gatewayInfo = new XtnGatewayInfo();
        }
        this._gatewayInfo.setOverrideVersion(uid);
    }

    public Set<String> getOverrideVersionUids() {
        if (this._gatewayInfo != null) {
            return this._gatewayInfo.getOverrideVersionUids();
        }
        return null;
    }
}

