/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.admin;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.server.space.suspend.SuspendInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class RuntimeHolder
implements Externalizable {
    static final long serialVersionUID = -6308647788360370371L;
    private SpaceMode spaceMode;
    private Object[] replicationStatus = null;
    private Integer spaceState = null;
    private SuspendInfo suspendInfo;

    public RuntimeHolder() {
    }

    public RuntimeHolder(SpaceMode spaceMode, Object[] replicationStatus, int spaceState, SuspendInfo suspendInfo) {
        this.spaceMode = spaceMode;
        this.replicationStatus = replicationStatus;
        this.spaceState = spaceState;
        this.suspendInfo = suspendInfo;
    }

    public SpaceMode getSpaceMode() {
        return this.spaceMode;
    }

    public Object[] getReplicationStatus() {
        return this.replicationStatus;
    }

    public Integer getSpaceState() {
        return this.spaceState;
    }

    public SuspendInfo getSuspendInfo() {
        return this.suspendInfo;
    }

    public void setSuspendInfo(SuspendInfo suspendInfo) {
        this.suspendInfo = suspendInfo;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.spaceMode);
        if (this.replicationStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.replicationStatus);
        }
        if (this.spaceState == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.spaceState);
        }
        PlatformLogicalVersion version = PlatformLogicalVersion.getLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v14_0_0)) {
            if (this.suspendInfo == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeObject(this.suspendInfo);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion version;
        this.spaceMode = (SpaceMode)((Object)in.readObject());
        if (in.readBoolean()) {
            this.replicationStatus = (Object[])in.readObject();
        }
        if (in.readBoolean()) {
            this.spaceState = in.readInt();
        }
        if ((version = PlatformLogicalVersion.getLogicalVersion()).greaterOrEquals(PlatformLogicalVersion.v14_0_0) && in.readBoolean()) {
            this.suspendInfo = (SuspendInfo)in.readObject();
        }
    }
}

