/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.admin;

import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.UnmarshalException;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SpaceConfig
extends JSpaceAttributes {
    private String _spaceName;
    private String _containerName;
    private String _fullSpaceName;
    private String _schemaPath = "";
    private final ConcurrentMap extraProperties = new ConcurrentHashMap();
    private static final long serialVersionUID = 1L;
    private static final int SERIAL_VERSION = 1;

    public SpaceConfig() {
    }

    public SpaceConfig(String spaceName, String containerName) {
        this._spaceName = spaceName;
        this._containerName = containerName;
        this._fullSpaceName = JSpaceUtilities.createFullSpaceName(this._containerName, this._spaceName);
    }

    public SpaceConfig(String spaceName, Properties prop, String containerName, String schemaPath) {
        super(prop);
        this._spaceName = spaceName;
        this._containerName = containerName;
        this._schemaPath = schemaPath;
        this._fullSpaceName = JSpaceUtilities.createFullSpaceName(this._containerName, this._spaceName);
    }

    @Override
    public SpaceConfig clone() {
        return (SpaceConfig)super.clone();
    }

    public String getSpaceName() {
        return this._spaceName;
    }

    public void setSpaceName(String spaceName) {
        this._spaceName = spaceName;
    }

    public String getFullSpaceName() {
        return this._fullSpaceName;
    }

    public String getSchemaPath() {
        return this._schemaPath;
    }

    public void setSchemaPath(String schemaName) {
        this._schemaPath = schemaName;
    }

    @Override
    public String getProperty(String key) {
        return super.getProperty(this.prepareProperty(key));
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return super.getProperty(this.prepareProperty(key), defaultValue);
    }

    @Override
    public Object setProperty(String key, String value) {
        return super.setProperty(this.prepareProperty(key), value);
    }

    private String prepareProperty(String key) {
        if (!key.startsWith("space-config.")) {
            return key;
        }
        return this._fullSpaceName + '.' + key;
    }

    public String getPropertyFromSuper(String key) {
        return super.getProperty(key);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t ============================================================\n");
        sb.append("\n\t Space configuration for space \"" + this._fullSpaceName + "\" \n");
        sb.append("\n\t ============================================================\n");
        sb.append("\n\t DCache configuration \n\t ");
        sb.append(this.getDCacheProperties());
        sb.append('\n');
        sb.append("\n\t Cluster Info -\t");
        sb.append(this.getClusterInfo());
        sb.append('\n');
        sb.append("\n\t Filters configuration -\t");
        sb.append(Arrays.toString(this.getFiltersInfo()));
        sb.append('\n');
        sb.append("\n\t Custom properties -\t ");
        StringUtils.appendProperties(sb, this.getCustomProperties());
        sb.append('\n');
        sb.append("\n---------------------------------------------------------------------------------------- \n");
        sb.append("Space configuration elements for space < ");
        sb.append(this._fullSpaceName);
        sb.append(" >");
        sb.append("\n---------------------------------------------------------------------------------------- \n\n");
        StringUtils.appendProperties(sb, this);
        return sb.toString();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        String preparedKey = this.prepareProperty(key.toString());
        return super.getProperty(preparedKey) != null;
    }

    public String getContainerName() {
        return this._containerName;
    }

    private byte buildFlags() {
        byte flags = 0;
        if (this._spaceName != null) {
            flags = (byte)(flags | 1);
        }
        if (this._containerName != null) {
            flags = (byte)(flags | 2);
        }
        if (this._fullSpaceName != null) {
            flags = (byte)(flags | 4);
        }
        if (this._schemaPath != null) {
            flags = (byte)(flags | 8);
        }
        return flags;
    }

    public ConcurrentMap getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int version = in.readInt();
        if (version != 1) {
            throw new UnmarshalException("Class [" + this.getClass().getName() + "] received version [" + version + "] does not match local version [" + 1 + "]. Please make sure you are using the same product version on both ends.");
        }
        byte flags = in.readByte();
        if (flags == 0) {
            return;
        }
        if ((flags & 1) != 0) {
            this._spaceName = (String)in.readObject();
        }
        if ((flags & 2) != 0) {
            this._containerName = (String)in.readObject();
        }
        if ((flags & 4) != 0) {
            this._fullSpaceName = (String)in.readObject();
        }
        if ((flags & 8) != 0) {
            this._schemaPath = (String)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(1);
        byte flags = this.buildFlags();
        out.writeByte(flags);
        if (flags == 0) {
            return;
        }
        if (this._spaceName != null) {
            out.writeObject(this._spaceName);
        }
        if (this._containerName != null) {
            out.writeObject(this._containerName);
        }
        if (this._fullSpaceName != null) {
            out.writeObject(this._fullSpaceName);
        }
        if (this._schemaPath != null) {
            out.writeObject(this._schemaPath);
        }
    }

    private static interface BitMap {
        public static final byte _SPACENAME = 1;
        public static final byte _CONTAINERNAME = 2;
        public static final byte _FULLSPACENAME = 4;
        public static final byte _SCHEMAPATH = 8;
    }
}

