/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.admin;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class SpaceRuntimeInfo
implements Externalizable {
    private static final long serialVersionUID = -5586653306007649053L;
    public List<String> m_ClassNames;
    public List<Integer> m_NumOFEntries;
    public List<Integer> m_NumOFTemplates;

    public SpaceRuntimeInfo() {
    }

    public SpaceRuntimeInfo(List<String> classNames, List<Integer> numOfEntries, List<Integer> numOFTemplates) {
        this.m_ClassNames = classNames;
        this.m_NumOFEntries = numOfEntries;
        this.m_NumOFTemplates = numOFTemplates;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.m_ClassNames.size());
        for (String name : this.m_ClassNames) {
            out.writeUTF(name);
        }
        for (Integer num : this.m_NumOFEntries) {
            out.writeInt(num);
        }
        for (Integer num : this.m_NumOFTemplates) {
            out.writeInt(num);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int size = in.readInt();
        this.m_ClassNames = new ArrayList<String>(size);
        this.m_NumOFEntries = new ArrayList<Integer>(size);
        this.m_NumOFTemplates = new ArrayList<Integer>(size);
        for (i = 0; i < size; ++i) {
            this.m_ClassNames.add(in.readUTF());
        }
        for (i = 0; i < size; ++i) {
            this.m_NumOFEntries.add(in.readInt());
        }
        for (i = 0; i < size; ++i) {
            this.m_NumOFTemplates.add(in.readInt());
        }
    }

    public SpaceRuntimeInfo appendSpaceRuntimeInfo(SpaceRuntimeInfo spaceRuntimeInfo) {
        if (spaceRuntimeInfo == null) {
            return this;
        }
        List<String> classesNamesList = spaceRuntimeInfo.m_ClassNames;
        int listSize = classesNamesList.size();
        for (int i = 0; i < listSize; ++i) {
            String className = classesNamesList.get(i);
            int index = this.m_ClassNames.indexOf(className);
            if (index >= 0) {
                int newNumEntriesValue = this.m_NumOFEntries.get(index) + spaceRuntimeInfo.m_NumOFEntries.get(i);
                this.m_NumOFEntries.set(index, newNumEntriesValue);
                int newNumTemplatesValue = this.m_NumOFTemplates.get(index) + spaceRuntimeInfo.m_NumOFTemplates.get(i);
                this.m_NumOFTemplates.set(index, newNumTemplatesValue);
                continue;
            }
            this.m_ClassNames.add(className);
            this.m_NumOFEntries.add(spaceRuntimeInfo.m_NumOFEntries.get(i));
            this.m_NumOFTemplates.add(spaceRuntimeInfo.m_NumOFTemplates.get(i));
        }
        return this;
    }
}

