/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ShadowEntryHolder;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.MultiValueIndexBackref;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.kernel.IObjectInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AbstractMultiValueIndexHandler<K> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    final TypeDataIndex<K> _typeDataIndex;

    public AbstractMultiValueIndexHandler(TypeDataIndex<K> typeDataIndex) {
        this._typeDataIndex = typeDataIndex;
    }

    public void insertEntryIndexedField(IEntryCacheInfo pEntry, K fieldValue, TypeData pType, ArrayList<IObjectInfo<IEntryCacheInfo>> insertBackRefs) {
        if (fieldValue == null) {
            this._typeDataIndex.insertEntryIndexedField_impl(pEntry, fieldValue, pType, insertBackRefs);
            return;
        }
        int size = this.multiValueSize(fieldValue);
        MultiValueIndexBackref mvbref = pEntry.indexesBackRefsKept() ? new MultiValueIndexBackref(this.numOfMultiValueBackrefs(size)) : null;
        HashSet<K> redundantValsFilter = new HashSet<K>(size);
        Iterator<K> iter = this.multiValueIterator(fieldValue);
        int numIndexesInserted = 0;
        while (iter.hasNext()) {
            K val = iter.next();
            if (val == null || !redundantValsFilter.add(val)) continue;
            try {
                this._typeDataIndex.insertEntryIndexedField_impl(pEntry, val, pType, mvbref != null ? mvbref.getBackrefs() : null);
                ++numIndexesInserted;
            }
            catch (RuntimeException ex) {
                try {
                    this.removePartiallyInsertedCollectionAfterInsertFailure(pEntry, fieldValue, mvbref, numIndexesInserted);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
        }
        if (pEntry.indexesBackRefsKept()) {
            this.addMultiValueBackref(insertBackRefs, mvbref);
        }
    }

    private void removePartiallyInsertedCollectionAfterInsertFailure(IEntryCacheInfo pEntry, K fieldValue, MultiValueIndexBackref mvbref, int numIndexesInserted) {
        if (numIndexesInserted == 0) {
            return;
        }
        int numRemoved = 0;
        Iterator<K> iter = this.multiValueIterator(fieldValue);
        HashSet<K> redundantValsFilter = new HashSet<K>(this.multiValueSize(fieldValue));
        int mvRefPos = 0;
        while (iter.hasNext() && numRemoved < numIndexesInserted) {
            K val = iter.next();
            if (val == null) continue;
            if (redundantValsFilter.add(val)) {
                mvRefPos = this._typeDataIndex.removeEntryIndexedField_impl(pEntry.getEntryHolder(this._typeDataIndex.getCacheManager()), pEntry.indexesBackRefsKept() ? mvbref.getBackrefs() : null, val, mvRefPos, true, pEntry);
            }
            ++numRemoved;
        }
    }

    public int removeEntryIndexedField(IEntryHolder eh, ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs, K fieldValue, int refpos, boolean removeIndexedValue, IEntryCacheInfo pEntry) {
        if (!removeIndexedValue || fieldValue == null) {
            return this._typeDataIndex.removeEntryIndexedField_impl(eh, deletedBackRefs, fieldValue, refpos, removeIndexedValue, pEntry);
        }
        MultiValueIndexBackref mvbref = deletedBackRefs != null ? (MultiValueIndexBackref)deletedBackRefs.get(refpos) : null;
        Iterator<K> iter = this.multiValueIterator(fieldValue);
        HashSet<K> redundantValsFilter = new HashSet<K>(this.multiValueSize(fieldValue));
        int mvRefPos = 0;
        while (iter.hasNext()) {
            K val = iter.next();
            if (val == null || !redundantValsFilter.add(val)) continue;
            mvRefPos = this._typeDataIndex.removeEntryIndexedField_impl(eh, mvbref != null ? mvbref.getBackrefs() : null, val, mvRefPos, removeIndexedValue, pEntry);
        }
        if (deletedBackRefs != null) {
            deletedBackRefs.set(refpos++, null);
            if (this._typeDataIndex.isExtendedIndex()) {
                deletedBackRefs.set(refpos++, null);
            }
        }
        return refpos;
    }

    public int updateMultiValueIndex(TypeData pType, IEntryHolder eh, IEntryCacheInfo pEntry, K original, K updated, ArrayList<IObjectInfo<IEntryCacheInfo>> originalBackRefs, int refpos, TypeDataIndex.UpdateIndexModes updateMode) {
        if ((updateMode == TypeDataIndex.UpdateIndexModes.INSERT_NONEQUALS || updateMode == TypeDataIndex.UpdateIndexModes.REPLACE_NONEQUALS) && original == updated) {
            return this._typeDataIndex.moveValueBackrefsOnUpdate(pEntry, original, originalBackRefs, pEntry.getBackRefs(), refpos, true);
        }
        if (original == null || updated == null) {
            if (updateMode == TypeDataIndex.UpdateIndexModes.INSERT_NONEQUALS || updateMode == TypeDataIndex.UpdateIndexModes.REPLACE_NONEQUALS) {
                this.insertEntryIndexedField(pEntry, updated, pType, pEntry.getBackRefs());
            }
            if (updateMode == TypeDataIndex.UpdateIndexModes.REMOVE_NONEQUALS || updateMode == TypeDataIndex.UpdateIndexModes.REPLACE_NONEQUALS) {
                return this._typeDataIndex.removeEntryIndexedField(eh, originalBackRefs, original, refpos, true, pEntry);
            }
            return refpos + this._typeDataIndex.numOfEntryIndexBackRefs(original);
        }
        if (updateMode == TypeDataIndex.UpdateIndexModes.REMOVE_NONEQUALS) {
            return this.removeOriginalIndexValuesOnUpdateEnd(pType, eh, pEntry, original, updated, originalBackRefs, refpos);
        }
        int size_u = this.multiValueSize(updated);
        MultiValueIndexBackref mvbref_u = pEntry.indexesBackRefsKept() ? new MultiValueIndexBackref(this.numOfMultiValueBackrefs(size_u)) : null;
        MultiValueIndexBackref mvbref_o = pEntry.indexesBackRefsKept() ? (MultiValueIndexBackref)originalBackRefs.get(refpos) : null;
        HashMap<K, Integer> originalHM = this.buildMultiValueHashMapFromObject(original);
        HashSet<K> redundantValsFilter = new HashSet<K>(size_u);
        int numInserted = 0;
        Iterator<K> iter_u = this.multiValueIterator(updated);
        try {
            while (iter_u.hasNext()) {
                K val = iter_u.next();
                if (val == null || !redundantValsFilter.add(val)) continue;
                Integer orgpos = originalHM.remove(val);
                if (orgpos == null) {
                    int pos = pEntry.indexesBackRefsKept() ? mvbref_u.getBackrefs().size() : -1;
                    this._typeDataIndex.insertEntryIndexedField_impl(pEntry, val, pType, pEntry.indexesBackRefsKept() ? mvbref_u.getBackrefs() : null);
                    ++numInserted;
                    continue;
                }
                if (!pEntry.indexesBackRefsKept()) continue;
                this._typeDataIndex.moveValueBackrefsOnUpdate(pEntry, val, mvbref_o.getBackrefs(), mvbref_u.getBackrefs(), orgpos, false);
            }
        }
        catch (RuntimeException ex) {
            try {
                this.removePartiallyInsertedCollectionAfterUpdateFailure(pEntry, original, updated, mvbref_u, numInserted);
            }
            catch (Exception orgpos) {
                // empty catch block
            }
            throw ex;
        }
        if (updateMode == TypeDataIndex.UpdateIndexModes.REPLACE_NONEQUALS && originalHM.size() > 0) {
            for (Map.Entry<K, Integer> entry : originalHM.entrySet()) {
                this._typeDataIndex.removeEntryIndexedField_impl(eh, pEntry.indexesBackRefsKept() ? mvbref_o.getBackrefs() : null, entry.getKey(), entry.getValue(), true, pEntry);
            }
        }
        if (pEntry.indexesBackRefsKept()) {
            this.addMultiValueBackref(pEntry.getBackRefs(), mvbref_u);
        }
        return refpos + this._typeDataIndex.numOfEntryIndexBackRefs(original);
    }

    private void removePartiallyInsertedCollectionAfterUpdateFailure(IEntryCacheInfo pEntry, K original, K updated, MultiValueIndexBackref mvbref_u, int numInserted) {
        K val;
        HashSet<K> oldVals;
        if (numInserted == 0) {
            return;
        }
        Iterator<K> iter_u = this.multiValueIterator(updated);
        HashSet<K> redundantValsFilter = new HashSet<K>(this.multiValueSize(updated));
        int mvRefPos = 0;
        HashSet<K> hashSet = oldVals = original != null ? new HashSet<K>() : null;
        if (oldVals != null) {
            Iterator<K> iter_o = this.multiValueIterator(original);
            while (iter_o.hasNext()) {
                val = iter_o.next();
                if (val == null) continue;
                oldVals.add(val);
            }
        }
        int numRemoved = 0;
        while (iter_u.hasNext() && numRemoved < numInserted) {
            val = iter_u.next();
            if (val == null || !redundantValsFilter.add(val)) continue;
            if (oldVals == null || !oldVals.contains(val)) {
                mvRefPos = this._typeDataIndex.removeEntryIndexedField_impl(pEntry.getEntryHolder(this._typeDataIndex.getCacheManager()), pEntry.indexesBackRefsKept() ? mvbref_u.getBackrefs() : null, val, mvRefPos, true, pEntry);
                ++numRemoved;
                continue;
            }
            mvRefPos += this._typeDataIndex.numOfEntryIndexBackRefs(val);
        }
    }

    private int removeOriginalIndexValuesOnUpdateEnd(TypeData pType, IEntryHolder eh, IEntryCacheInfo pEntry, K original, K updated, ArrayList<IObjectInfo<IEntryCacheInfo>> originalBackRefs, int refpos) {
        HashSet<K> updatedVals;
        MultiValueIndexBackref mvbref_o = null;
        if (pEntry.indexesBackRefsKept() && (mvbref_o = (MultiValueIndexBackref)originalBackRefs.get(refpos)).getBackrefs().isEmpty()) {
            return refpos + this._typeDataIndex.numOfEntryIndexBackRefs(original);
        }
        Iterator<K> iter_o = this.multiValueIterator(original);
        HashSet<K> redundantValsFilter = new HashSet<K>(this.multiValueSize(original));
        int mvRefPos = 0;
        HashSet<K> hashSet = updatedVals = updated != null ? new HashSet<K>() : null;
        if (updatedVals != null) {
            Iterator<K> iter_u = this.multiValueIterator(updated);
            while (iter_u.hasNext()) {
                K val = iter_u.next();
                if (val == null) continue;
                updatedVals.add(val);
            }
        }
        while (iter_o.hasNext() && (mvbref_o == null || mvRefPos < mvbref_o.getBackrefs().size())) {
            K val = iter_o.next();
            if (val == null || !redundantValsFilter.add(val)) continue;
            if (updatedVals == null || !updatedVals.contains(val)) {
                mvRefPos = this._typeDataIndex.removeEntryIndexedField_impl(pEntry.getEntryHolder(this._typeDataIndex.getCacheManager()), pEntry.indexesBackRefsKept() ? mvbref_o.getBackrefs() : null, val, mvRefPos, true, pEntry);
                continue;
            }
            mvRefPos += this._typeDataIndex.numOfEntryIndexBackRefs(val);
        }
        return refpos + this._typeDataIndex.numOfEntryIndexBackRefs(original);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateMultiValueIndexUndexXtn(TypeData pType, IEntryHolder eh, IEntryCacheInfo pEntry, K previous, K updated, ArrayList<IObjectInfo<IEntryCacheInfo>> previousBackRefs, int refpos) {
        RuntimeException ex_thrown = null;
        try {
            IObjectInfo<IEntryCacheInfo> backref_prev;
            ShadowEntryHolder shadowEh = pEntry.getEntryHolder(this._typeDataIndex.getCacheManager()).getShadow();
            IEntryData shadowEntryData = shadowEh.getEntryData();
            IObjectInfo<IEntryCacheInfo> iObjectInfo = backref_prev = pEntry.indexesBackRefsKept() ? previousBackRefs.get(refpos) : null;
            IObjectInfo<IEntryCacheInfo> backref_shadow = pEntry.indexesBackRefsKept() ? (previousBackRefs == shadowEh.getBackRefs() ? backref_prev : shadowEh.getBackRefs().get(shadowEh.getBackrefIndexPos()[this._typeDataIndex.getPos()])) : null;
            boolean doubleUpdate = shadowEh.getNumOfUpdates() > 1;
            Object shadowFieldValue = this._typeDataIndex.getIndexValue(shadowEntryData);
            MultiValueIndexBackref mvbref_u = null;
            if (previous == updated) {
                int n = this._typeDataIndex.moveValueBackrefsOnUpdate(pEntry, previous, previousBackRefs, pEntry.getBackRefs(), refpos, false);
                return n;
            }
            if (shadowFieldValue == null && updated == null) {
                this._typeDataIndex.moveValueBackrefsOnUpdate(pEntry, shadowFieldValue, shadowEh.getBackRefs(), pEntry.getBackRefs(), pEntry.indexesBackRefsKept() ? shadowEh.getBackrefIndexPos()[this._typeDataIndex.getPos()] : -1, false);
                int n = this._typeDataIndex.removeEntryIndexedField(eh, previousBackRefs, previous, refpos, true, pEntry);
                return n;
            }
            if (updated == null) {
                this.insertEntryIndexedField(pEntry, updated, pType, pEntry.getBackRefs());
            } else {
                int size_u = this.multiValueSize(updated);
                if (pEntry.indexesBackRefsKept()) {
                    mvbref_u = new MultiValueIndexBackref(this.numOfMultiValueBackrefs(size_u));
                }
            }
            MultiValueIndexBackref mvbref_prev = null;
            HashMap<K, Integer> previousHM = null;
            MultiValueIndexBackref mvbref_shadow = null;
            HashMap<K, Integer> shadowHM = null;
            if (shadowFieldValue != null) {
                mvbref_shadow = (MultiValueIndexBackref)backref_shadow;
                shadowHM = this.buildMultiValueHashMapFromObject(shadowFieldValue);
            }
            if (doubleUpdate && previous != null) {
                mvbref_prev = (MultiValueIndexBackref)backref_prev;
                previousHM = this.buildMultiValueHashMapFromObject(previous);
            }
            if (updated != null) {
                Iterator<K> iter_u = this.multiValueIterator(updated);
                HashSet<K> redundantValsFilter = new HashSet<K>(this.multiValueSize(updated));
                while (iter_u.hasNext()) {
                    Integer previouspos;
                    K val = iter_u.next();
                    if (val == null || !redundantValsFilter.add(val)) continue;
                    Integer shadowpos = shadowHM != null ? shadowHM.remove(val) : null;
                    Integer n = previouspos = previousHM != null ? previousHM.remove(val) : null;
                    if (shadowpos == null && previouspos == null) {
                        int cursize = pEntry.indexesBackRefsKept() ? mvbref_u.getBackrefs().size() : -1;
                        try {
                            this._typeDataIndex.insertEntryIndexedField_impl(pEntry, val, pType, mvbref_u != null ? mvbref_u.getBackrefs() : null);
                        }
                        catch (RuntimeException ex) {
                            if (ex_thrown == null) {
                                ex_thrown = ex;
                            }
                            if (!pEntry.indexesBackRefsKept()) continue;
                            if (mvbref_u.getBackrefs().size() == cursize) {
                                mvbref_u.getBackrefs().add(TypeDataIndex._DummyOI);
                            }
                            if (!this._typeDataIndex.isExtendedIndex() || val == null || mvbref_u.getBackrefs().size() != cursize + 1) continue;
                            mvbref_u.getBackrefs().add(TypeDataIndex._DummyOI);
                        }
                        continue;
                    }
                    if (shadowpos != null) {
                        this._typeDataIndex.moveValueBackrefsOnUpdate(pEntry, val, mvbref_shadow != null ? mvbref_shadow.getBackrefs() : null, mvbref_u != null ? mvbref_u.getBackrefs() : null, shadowpos, false);
                        continue;
                    }
                    this._typeDataIndex.moveValueBackrefsOnUpdate(pEntry, val, mvbref_prev != null ? mvbref_prev.getBackrefs() : null, mvbref_u != null ? mvbref_u.getBackrefs() : null, previouspos, false);
                }
            }
            if (doubleUpdate) {
                if (previousHM != null && previousHM.size() > 0) {
                    for (Map.Entry<K, Integer> entry : previousHM.entrySet()) {
                        if (shadowHM != null && shadowHM.containsKey(entry.getKey())) continue;
                        this._typeDataIndex.removeEntryIndexedField_impl(eh, mvbref_prev != null ? mvbref_prev.getBackrefs() : null, entry.getKey(), entry.getValue(), true, pEntry);
                    }
                }
                if (previous == null) {
                    this._typeDataIndex.removeEntryIndexedField(eh, previousBackRefs, previous, refpos, true, pEntry);
                }
            }
            if (updated != null && pEntry.indexesBackRefsKept()) {
                this.addMultiValueBackref(pEntry.getBackRefs(), mvbref_u);
            }
            int n = refpos + this._typeDataIndex.numOfEntryIndexBackRefs(previous);
            return n;
        }
        finally {
            if (ex_thrown != null) {
                throw ex_thrown;
            }
        }
    }

    private HashMap<K, Integer> buildMultiValueHashMapFromObject(Object mvo) {
        HashMap<K, Integer> hm = new HashMap<K, Integer>(this.multiValueSize(mvo));
        Iterator<K> iter_p = this.multiValueIterator(mvo);
        int orefpos = 0;
        while (iter_p.hasNext()) {
            K val = iter_p.next();
            if (val == null || hm.get(val) != null) continue;
            hm.put(val, orefpos);
            orefpos += this._typeDataIndex.numOfEntryIndexBackRefs(val);
        }
        return hm;
    }

    int consolidateMultiValueIndexOnXtnEnd(IEntryHolder eh, IEntryCacheInfo pEntry, K keptValue, K deletedVlaue, ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs, int refpos, boolean onError) {
        if (deletedVlaue == keptValue) {
            return refpos + this._typeDataIndex.numOfEntryIndexBackRefs(deletedVlaue);
        }
        if (deletedVlaue == null || keptValue == null) {
            return this.removeEntryIndexedField(eh, deletedBackRefs, deletedVlaue, refpos, true, pEntry);
        }
        if (this.multiValueSize(keptValue) == 0) {
            return this.removeEntryIndexedField(eh, deletedBackRefs, deletedVlaue, refpos, true, pEntry);
        }
        HashMap<K, Integer> keptHM = this.buildMultiValueHashMapFromObject(keptValue);
        Iterator<K> iter_d = this.multiValueIterator(deletedVlaue);
        int orefpos = 0;
        MultiValueIndexBackref mvbref_del = pEntry.indexesBackRefsKept() ? (MultiValueIndexBackref)deletedBackRefs.get(refpos) : null;
        HashSet<K> redundantValsFilter = new HashSet<K>(this.multiValueSize(deletedVlaue));
        while (iter_d.hasNext()) {
            K val = iter_d.next();
            if (val == null || !redundantValsFilter.add(val)) continue;
            if (keptHM.remove(val) != null) {
                orefpos += this._typeDataIndex.numOfEntryIndexBackRefs(val);
                continue;
            }
            if (onError) {
                try {
                    orefpos = this._typeDataIndex.removeEntryIndexedField_impl(eh, mvbref_del != null ? mvbref_del.getBackrefs() : null, val, orefpos, true, pEntry);
                }
                catch (Exception exception) {}
                continue;
            }
            orefpos = this._typeDataIndex.removeEntryIndexedField_impl(eh, mvbref_del != null ? mvbref_del.getBackrefs() : null, val, orefpos, true, pEntry);
        }
        return refpos + this._typeDataIndex.numOfEntryIndexBackRefs(deletedVlaue);
    }

    private void addMultiValueBackref(ArrayList<IObjectInfo<IEntryCacheInfo>> backRefs, MultiValueIndexBackref mvbref) {
        backRefs.add(mvbref);
        if (this._typeDataIndex.isExtendedIndex()) {
            backRefs.add(mvbref);
        }
    }

    private int numOfMultiValueBackrefs(int size) {
        return size * (this._typeDataIndex.isExtendedIndex() ? 2 : 1);
    }

    protected abstract int multiValueSize(Object var1);

    protected abstract Iterator<K> multiValueIterator(Object var1);
}

