/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.cache.AbstractMultiValueIndexHandler;
import com.j_spaces.core.cache.TypeDataIndex;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

@InternalApi
public class ArrayIndexHandler<K>
extends AbstractMultiValueIndexHandler<K> {
    public ArrayIndexHandler(TypeDataIndex<K> typeDataIndex) {
        super(typeDataIndex);
    }

    @Override
    protected int multiValueSize(Object mvo) {
        return Array.getLength(mvo);
    }

    @Override
    protected Iterator<K> multiValueIterator(Object mvo) {
        return new ArrayIterator(mvo);
    }

    private static class ArrayIterator<K>
    implements Iterator<K> {
        private final Object _mva;
        private boolean _calledHasNext;
        private int _pos = -1;
        int _len;

        ArrayIterator(Object mva) {
            this._mva = mva;
            this._len = Array.getLength(this._mva);
        }

        @Override
        public boolean hasNext() {
            this._calledHasNext = true;
            int i = this._pos + 1;
            while (i < this._len) {
                if (Array.get(this._mva, i) != null) {
                    return true;
                }
                this._pos = i++;
            }
            return false;
        }

        @Override
        public K next() {
            if (!this._calledHasNext) {
                throw new UnsupportedOperationException();
            }
            this._calledHasNext = false;
            if (this._pos < this._len - 1) {
                return (K)Array.get(this._mva, ++this._pos);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

