/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.collections.WeakHashSet;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.exception.ClosedResourceException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;

@InternalApi
public class CacheContextFactory {
    private final String _fullSpaceName;
    private final Set<Context> _createdContexts;
    private volatile boolean _isClosed;
    private final ThreadLocal<Context> _context = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            Context context = new Context();
            CacheContextFactory.this._createdContexts.add(context);
            return context;
        }
    };

    public CacheContextFactory(CacheManager cacheManager, String fullSpaceName) {
        this._fullSpaceName = fullSpaceName;
        this._createdContexts = Collections.synchronizedSet(new WeakHashSet());
    }

    public Context getCacheContext() {
        if (this._isClosed) {
            throw new ClosedResourceException("Space [" + this._fullSpaceName + "] is not available. Internal resources are being closed.");
        }
        Context context = this._context.get();
        if (context.isLocalActive()) {
            context = new Context();
        }
        context.setActive(true);
        context.setOwningThreadName(Thread.currentThread().getName());
        return context;
    }

    public Context viewCacheContext() {
        if (this._isClosed) {
            return null;
        }
        Context context = this._context.get();
        return context.isLocalActive() ? context : null;
    }

    public void freeCacheContext(Context ctx) {
        ctx.clean();
        ctx.setActive(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllContexts() {
        long closeMaxWait = Long.getLong("com.gs.cache_context_close_max_wait", -1L);
        long startTime = System.currentTimeMillis();
        long endTime = closeMaxWait * 1000L + startTime;
        this._isClosed = true;
        Set<Context> set = this._createdContexts;
        synchronized (set) {
            for (Context context : this._createdContexts) {
                while (context.isActive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (0L >= closeMaxWait || 0L >= System.currentTimeMillis() - endTime) continue;
                    CacheManager.getLogger().log(Level.WARNING, this._fullSpaceName + ": not all cache context closed, forced exit, owning thread is " + context.getOwningThreadName());
                    return;
                }
            }
        }
    }
}

