/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.client.protective.ProtectiveMode;
import com.gigaspaces.client.protective.ProtectiveModeException;
import com.gigaspaces.internal.client.cache.CustomInfo;
import com.gigaspaces.internal.cluster.node.IReplicationNode;
import com.gigaspaces.internal.cluster.node.IReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.ioImpl.DirectPersistencyBlobStoreIO;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.notification.NotificationReplicationChannelDataFilter;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.explainplan.ExplainPlanContext;
import com.gigaspaces.internal.query.explainplan.ExplainPlanUtil;
import com.gigaspaces.internal.query.explainplan.IndexChoiceNode;
import com.gigaspaces.internal.query.explainplan.IndexInfo;
import com.gigaspaces.internal.query.explainplan.QueryOperator;
import com.gigaspaces.internal.query.explainplan.SingleExplainPlan;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.ChangeInternalException;
import com.gigaspaces.internal.server.space.LocalCacheRegistrations;
import com.gigaspaces.internal.server.space.MatchResult;
import com.gigaspaces.internal.server.space.MatchTarget;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.SpaceInstanceConfig;
import com.gigaspaces.internal.server.space.TemplateExpirationManager;
import com.gigaspaces.internal.server.space.TemplatesManager;
import com.gigaspaces.internal.server.space.eviction.AllInCacheSpaceEvictionStrategy;
import com.gigaspaces.internal.server.space.eviction.ConcurrentLruSpaceEvictionStrategy;
import com.gigaspaces.internal.server.space.eviction.DefaultTimeBasedSpaceEvictionStrategy;
import com.gigaspaces.internal.server.space.eviction.EvictionReplicationsMarkersRepository;
import com.gigaspaces.internal.server.space.eviction.IEvictionReplicationsMarkersRepository;
import com.gigaspaces.internal.server.space.eviction.RecentDeletesRepository;
import com.gigaspaces.internal.server.space.eviction.RecentUpdatesRepository;
import com.gigaspaces.internal.server.space.eviction.TimeBasedSpaceEvictionStrategy;
import com.gigaspaces.internal.server.space.metadata.IServerTypeDescListener;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.space.metadata.TypeDataFactory;
import com.gigaspaces.internal.server.space.operations.WriteEntryResult;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyRecoveryException;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.IStorageConsistency;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.StorageConsistencyModes;
import com.gigaspaces.internal.server.storage.EntryHolderFactory;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.server.storage.ReplicationEntryHolder;
import com.gigaspaces.internal.server.storage.ShadowEntryHolder;
import com.gigaspaces.internal.server.storage.TemplateHolder;
import com.gigaspaces.internal.server.storage.TemplateHolderFactory;
import com.gigaspaces.internal.sync.hybrid.SyncHybridStorageAdapter;
import com.gigaspaces.internal.transport.TemplatePacket;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.economy.EconomyConcurrentHashMap;
import com.gigaspaces.internal.utils.collections.economy.HashEntryHandlerSpaceEntry;
import com.gigaspaces.management.space.LocalCacheDetails;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.index.CompoundIndex;
import com.gigaspaces.metadata.index.ISpaceCompoundIndexSegment;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.query.extension.QueryExtensionProvider;
import com.gigaspaces.query.extension.QueryExtensionRuntimeInfo;
import com.gigaspaces.query.extension.impl.QueryExtensionRuntimeInfoImpl;
import com.gigaspaces.server.blobstore.BlobStoreConfig;
import com.gigaspaces.server.blobstore.BlobStoreStatistics;
import com.gigaspaces.server.blobstore.BlobStoreStatisticsImpl;
import com.gigaspaces.server.blobstore.BlobStoreStorageHandler;
import com.gigaspaces.server.blobstore.BlobStoreStorageStatistics;
import com.gigaspaces.server.eviction.EvictableServerEntry;
import com.gigaspaces.server.eviction.SpaceEvictionManager;
import com.gigaspaces.server.eviction.SpaceEvictionStrategy;
import com.gigaspaces.server.eviction.SpaceEvictionStrategyConfig;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.CreateException;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.XtnStatus;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.admin.TemplateInfo;
import com.j_spaces.core.cache.AbstractCacheManager;
import com.j_spaces.core.cache.CacheContextFactory;
import com.j_spaces.core.cache.CacheOperationReason;
import com.j_spaces.core.cache.CountInfo;
import com.j_spaces.core.cache.EntriesIter;
import com.j_spaces.core.cache.EntryCacheInfoFactory;
import com.j_spaces.core.cache.EvictableEntryCacheInfo;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.ILeasedEntryCacheInfo;
import com.j_spaces.core.cache.InitialLoadInfo;
import com.j_spaces.core.cache.NullIteratorException;
import com.j_spaces.core.cache.PTypeMap;
import com.j_spaces.core.cache.PersistentGC;
import com.j_spaces.core.cache.QueryExtensionIndexManagerWrapper;
import com.j_spaces.core.cache.QueryExtensionIndexRemoveMode;
import com.j_spaces.core.cache.ScanListSAIterator;
import com.j_spaces.core.cache.SpaceServerEntryImpl;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.core.cache.TerminatingFifoXtnsInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.UnderXtnEntriesIter;
import com.j_spaces.core.cache.UnderXtnTemplatesIter;
import com.j_spaces.core.cache.XtnData;
import com.j_spaces.core.cache.blobStore.BlobStoreCacheHandler;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.BlobStoreExtendedStorageHandler;
import com.j_spaces.core.cache.blobStore.BlobStoreInternalCacheFilter;
import com.j_spaces.core.cache.blobStore.BlobStoreMemoryMonitor;
import com.j_spaces.core.cache.blobStore.BlobStoreMemoryMonitorWrapper;
import com.j_spaces.core.cache.blobStore.BlobStoreOperationsWrapper;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.BlobStoreReplicaConsumeHelper;
import com.j_spaces.core.cache.blobStore.BlobStoreReplicationBulkConsumeHelper;
import com.j_spaces.core.cache.blobStore.IBlobStoreCacheHandler;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.IBlobStoreRefCacheInfo;
import com.j_spaces.core.cache.blobStore.memory_pool.AbstractMemoryPool;
import com.j_spaces.core.cache.blobStore.memory_pool.OffHeapMemoryPool;
import com.j_spaces.core.cache.blobStore.optimizations.BlobStoreOperationOptimizations;
import com.j_spaces.core.cache.blobStore.recovery.BlobStoreRecoveryHelper;
import com.j_spaces.core.cache.blobStore.recovery.BlobStoreRecoveryHelperWrapper;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreFifoInitialLoader;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreStorageAdapter;
import com.j_spaces.core.cache.blobStore.sadapter.IBlobStoreStorageAdapter;
import com.j_spaces.core.cache.blobStore.storage.BlobStoreHashMock;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.cache.fifoGroup.FifoGroupCacheImpl;
import com.j_spaces.core.client.DuplicateIndexValueException;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.INotifyDelegatorFilter;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.ReadModifiers;
import com.j_spaces.core.client.SequenceNumberException;
import com.j_spaces.core.client.TemplateMatchCodes;
import com.j_spaces.core.client.UpdateModifiers;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.exception.internal.EngineInternalSpaceException;
import com.j_spaces.core.fifo.DefaultFifoBackgroundDispatcher;
import com.j_spaces.core.fifo.FifoBackgroundDispatcher;
import com.j_spaces.core.fifo.FifoBackgroundRequest;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.IStorageAdapter;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.core.server.processor.RemoveWaitingForInfoSABusPacket;
import com.j_spaces.jdbc.SQLFunctions;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.StoredListFactory;
import com.j_spaces.kernel.list.ConcurrentSegmentedStoredList;
import com.j_spaces.kernel.list.IObjectsList;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.list.MultiIntersectedStoredList;
import com.j_spaces.kernel.list.ScanSingleListIterator;
import com.j_spaces.kernel.list.ScanUidsIterator;
import com.j_spaces.kernel.locks.AllInCacheLockManager;
import com.j_spaces.kernel.locks.BasicEvictableLockManager;
import com.j_spaces.kernel.locks.BlobStoreLockManager;
import com.j_spaces.kernel.locks.IBasicLockManager;
import com.j_spaces.kernel.locks.ILockObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.space.InternalSpaceException;

@InternalApi
public class CacheManager
extends AbstractCacheManager
implements SpaceEvictionManager {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    private static final boolean _USE_UIDS_ECONOMY_HASH_MAP_FOR_BLOBSTORE_ = true;
    public final TerminatingFifoXtnsInfo _terminatingXtnsInfo;
    private final AtomicInteger _cacheSize;
    private final ConcurrentMap<String, IEntryCacheInfo> _entries;
    private final SpaceEngine _engine;
    private final ClusterPolicy _clusterPolicy;
    private final SpaceTypeManager _typeManager;
    private final LocalCacheRegistrations _localCacheRegistrations;
    private final PTypeMap _typeDataMap;
    private final TypeDataFactory _typeDataFactory;
    private final CacheContextFactory _cacheContextFactory;
    private final IStorageAdapter _storageAdapter;
    private final SQLFunctions sqlFunctions;
    private LeaseManager _leaseManager;
    private PersistentGC _persistentGC;
    private final boolean _readOnlySA;
    private final IReplicationNode _replicationNode;
    private final TemplatesManager _templatesManager;
    private final TemplateExpirationManager _templateExpirationManager;
    private final boolean _isMemorySA;
    private final boolean _isCacheExternalDB;
    private final boolean _isCentralDB;
    private final boolean _isClusteredExternalDBEnabled;
    private final boolean _isVersionedExternalDB;
    private boolean _syncReplicationUsed;
    private int _minExtendedIndexActivationSize;
    private IBasicLockManager<IEntryHolder> _lockManager;
    private final AtomicInteger _actualCacheSize;
    private final boolean _isTimeBasedEvictionStrategy;
    private final IEntryCacheInfo _entryAlreadyInSpaceIndication = EntryCacheInfoFactory.createEntryCacheInfo(null);
    private SpaceEvictionStrategy _evictionStrategy;
    private final RecentDeletesRepository _recentDeletesRespository;
    private final RecentUpdatesRepository _recentUpdatesRespository;
    private final long _recoveryLogInterval = Long.getLong("com.gs.cacheManager.logRecoveryInterval", 10000L);
    private final boolean _logRecoveryProcess = Boolean.parseBoolean(System.getProperty("com.gs.cacheManager.logRecovery", "true"));
    private boolean _partialUpdateReplication;
    private final FifoBackgroundDispatcher _fifoBackgroundDispatcher;
    private final FifoGroupCacheImpl _fifoGroupCacheImpl;
    private final IEvictionReplicationsMarkersRepository _evictionReplicationsMarkersRepository;
    private volatile boolean _emptyAfterInitialLoadStage;
    private final boolean _directPersistencyEmbeddedtHandlerUsed;
    private BlobStoreExtendedStorageHandler _blobStoreStorageHandler;
    private BlobStoreMemoryMonitor _blobStoreMemoryMonitor;
    private IBlobStoreCacheHandler _blobStoreInternalCache;
    private final boolean _persistentBlobStore;
    private final boolean _useBlobStoreBulks;
    private final boolean _optimizedBlobStoreClear;
    private final IStorageConsistency _blobStoreRecoveryHelper;
    private final boolean _enableSyncListForBlobStore;
    private final boolean _useBlobStorePrefetch;
    private final boolean _useBlobStoreReplicationBackupBulk;
    private final Map<String, QueryExtensionIndexManagerWrapper> queryExtensionManagers;
    private boolean _blobStoreForQa;
    private final boolean _forceSpaceIdIndexIfEqual;
    public static final int MIN_SIZE_TO_PERFORM_EXPLICIT_PROPERTIES_INDEX_SCAN_ = 5;
    public static final int MIN_SIZE_TO_CONSIDER_COMPOUND_INDICES = 5;

    public CacheManager(SpaceConfigReader configReader, ClusterPolicy clusterPolicy, SpaceTypeManager typeManager, IReplicationNode replicationNode, IStorageAdapter sa, SpaceEngine engine, Properties customProperties) throws CreateException {
        this._engine = engine;
        this._clusterPolicy = clusterPolicy;
        this._typeManager = typeManager;
        this._replicationNode = replicationNode;
        this._localCacheRegistrations = new LocalCacheRegistrations();
        this._typeDataMap = new PTypeMap();
        this._typeDataFactory = new TypeDataFactory(engine.getConfigReader(), this);
        this.m_CacheSize = configReader.getIntSpaceProperty("engine.cache_size", "100000");
        boolean persistentBlobStore = Boolean.parseBoolean(customProperties.getProperty("space-config.engine.blobstore_persistent", "false"));
        int numNotifyFifoThreads = engine.getConfigReader().getIntSpaceProperty("engine.fifo_notify_threads", "0");
        numNotifyFifoThreads = numNotifyFifoThreads != 0 ? numNotifyFifoThreads : Runtime.getRuntime().availableProcessors();
        int numNonNotifyFifoThreads = engine.getConfigReader().getIntSpaceProperty("engine.fifo_regular_threads", "4");
        numNonNotifyFifoThreads = numNonNotifyFifoThreads != 0 ? numNonNotifyFifoThreads : Runtime.getRuntime().availableProcessors();
        this._fifoBackgroundDispatcher = new DefaultFifoBackgroundDispatcher(numNotifyFifoThreads, numNonNotifyFifoThreads, this, this._engine);
        boolean isCacheExternalDB = sa.supportsExternalDB();
        boolean isMemorySA = !isCacheExternalDB;
        this.setCachePolicy(configReader.getIntSpaceProperty("engine.cache_policy", String.valueOf(1)));
        this._emptyAfterInitialLoadStage = true;
        String oh = System.getProperty("com.gs.OffHeapData");
        if (!this._blobStoreForQa) {
            boolean bl = this._blobStoreForQa = oh == null || this._engine.isLocalCache() ? false : Boolean.parseBoolean(oh);
        }
        if (this._blobStoreForQa && !this.isSyncHybrid()) {
            persistentBlobStore = true;
        }
        if (this._blobStoreForQa && this.isEvictableCachePolicy()) {
            this._blobStoreForQa = false;
        }
        if (this._blobStoreForQa && this._engine.isLocalCache()) {
            this._blobStoreForQa = false;
        }
        if (this._blobStoreForQa) {
            this.setCachePolicy(3);
        }
        if (this._blobStoreForQa && !isMemorySA && !sa.isReadOnly() && !this.isSyncHybrid()) {
            this._blobStoreForQa = false;
            this.setCachePolicy(1);
        }
        Boolean forceSpaceIdIndexIfEqualDefault = !this.isBlobStoreCachePolicy();
        this._forceSpaceIdIndexIfEqual = engine.getConfigReader().getBooleanSpaceProperty("engine.cache.force-space-id-index-if-equal", forceSpaceIdIndexIfEqualDefault.toString());
        if (this._forceSpaceIdIndexIfEqual != forceSpaceIdIndexIfEqualDefault) {
            _logger.info("engine.cache.force-space-id-index-if-equal was set to " + this._forceSpaceIdIndexIfEqual);
        }
        if (this.isBlobStoreCachePolicy()) {
            this._useBlobStoreBulks = Boolean.parseBoolean(System.getProperty("space-config.engine.blobstore_use_bulks", this.isSyncHybrid() ? "false" : "true"));
            _logger.info("useBlobStoreBulks=" + this._useBlobStoreBulks);
            this._optimizedBlobStoreClear = Boolean.parseBoolean(System.getProperty("engine.blobstore_use_clear_optimization", "true"));
            this._enableSyncListForBlobStore = Boolean.parseBoolean(System.getProperty("com.gs.replication.blobstore.use_sync_list", "true"));
            this._useBlobStorePrefetch = this._useBlobStoreBulks && Boolean.parseBoolean(System.getProperty("space-config.engine.blobstore_prefetch", "false"));
            _logger.info("useBlobStorePrefetch=" + this._useBlobStorePrefetch);
            this._useBlobStoreReplicationBackupBulk = this._useBlobStoreBulks && this._engine.isReplicatedPersistentBlobstore() && Boolean.parseBoolean(System.getProperty("com.gs.replication.blobstore.use_backup_bulks", "true"));
            _logger.info("useBlobStoreReplicationBackupBulk=" + this._useBlobStoreReplicationBackupBulk);
        } else {
            this._useBlobStoreBulks = false;
            this._optimizedBlobStoreClear = false;
            this._enableSyncListForBlobStore = false;
            this._useBlobStorePrefetch = false;
            this._useBlobStoreReplicationBackupBulk = false;
        }
        if (this.getCachePolicy() < 0 || this.getCachePolicy() > 3) {
            throw new RuntimeException("invalid cache policy value specified");
        }
        if (this.isBlobStoreCachePolicy() && this._engine.isLocalCache()) {
            throw new RuntimeException("blob-store cache policy not supported in local-cache");
        }
        if (this.isBlobStoreCachePolicy() && !isMemorySA && !sa.isReadOnly() && !this.isSyncHybrid()) {
            throw new RuntimeException("blob-store cache policy not supported with direct EDS");
        }
        this._persistentBlobStore = persistentBlobStore;
        if (this.isBlobStoreCachePolicy()) {
            IStorageAdapter curSa = this.isSyncHybrid() ? new SyncHybridStorageAdapter(this, sa, new BlobStoreStorageAdapter(this._engine, this._persistentBlobStore)) : (isMemorySA ? new BlobStoreStorageAdapter(this._engine, this._persistentBlobStore) : new BlobStoreStorageAdapter(this._engine, this._persistentBlobStore, sa));
            this._storageAdapter = curSa;
            this._isMemorySA = false;
            this._isCacheExternalDB = false;
        } else {
            this._storageAdapter = sa;
            this._isMemorySA = isMemorySA;
            this._isCacheExternalDB = isCacheExternalDB;
        }
        this._actualCacheSize = new AtomicInteger(0);
        this._isTimeBasedEvictionStrategy = this._evictionStrategy instanceof TimeBasedSpaceEvictionStrategy;
        this._evictionReplicationsMarkersRepository = !isMemorySA && this.isEvictableCachePolicy() && this._engine.hasMirror() ? new EvictionReplicationsMarkersRepository() : null;
        this._recentDeletesRespository = this.useRecentDeletes() ? new RecentDeletesRepository() : null;
        RecentUpdatesRepository recentUpdatesRepository = this._recentUpdatesRespository = this.useRecentUpdatesForPinning() ? new RecentUpdatesRepository() : null;
        if (engine.getClusterPolicy() != null) {
            this._isClusteredExternalDBEnabled = engine.isClusteredExternalDBEnabled(this.getStorageAdapter());
            this._isCentralDB = this._storageAdapter.supportsExternalDB() && engine.getClusterPolicy().m_CacheLoaderConfig.centralDataSource;
        } else {
            this._isClusteredExternalDBEnabled = false;
            this._isCentralDB = false;
        }
        this._terminatingXtnsInfo = new TerminatingFifoXtnsInfo();
        this._cacheSize = new AtomicInteger(0);
        int numOfCHMSegents = Integer.getInteger("com.gs.cacheManager.hashmapSegments", 64);
        this._entries = this._typeDataFactory.useEconomyHashMap() || this.isBlobStoreCachePolicy() ? new EconomyConcurrentHashMap(16, 0.75f, numOfCHMSegents, new HashEntryHandlerSpaceEntry(-1)) : new ConcurrentHashMap(16, 0.75f, numOfCHMSegents);
        this._cacheContextFactory = new CacheContextFactory(this, engine.getFullSpaceName());
        this._templatesManager = new TemplatesManager(this, numNotifyFifoThreads, numNonNotifyFifoThreads);
        this._templateExpirationManager = new TemplateExpirationManager(this);
        this._fifoGroupCacheImpl = new FifoGroupCacheImpl(this, _logger);
        this._isVersionedExternalDB = this._engine.getSpaceImpl().getJspaceAttr().isSupportsVersionEnabled();
        this._readOnlySA = this._storageAdapter.isReadOnly();
        if (this.isBlobStoreCachePolicy()) {
            BlobStoreStorageHandler driver = this.createBlobStoreHandlerNewInterface(configReader, customProperties);
            this._blobStoreStorageHandler = new BlobStoreOperationsWrapper(this, driver);
            this._blobStoreRecoveryHelper = new BlobStoreRecoveryHelperWrapper(_logger, this._engine.getFullSpaceName(), driver, this._engine.getNumberOfPartitions(), this._engine.getClusterInfo().getNumberOfBackups());
            this.setOffHeapProperties(customProperties);
        } else {
            this._blobStoreStorageHandler = null;
            this._blobStoreRecoveryHelper = null;
        }
        this._directPersistencyEmbeddedtHandlerUsed = engine.getReplicationNode() != null && engine.getReplicationNode().getDirectPesistencySyncHandler() != null && engine.getReplicationNode().getDirectPesistencySyncHandler().isEmbeddedListUsed();
        Object userFunctions = customProperties.get("user-sql-function");
        this.sqlFunctions = new SQLFunctions((Map)userFunctions);
        this.queryExtensionManagers = this.initQueryExtensionManagers(customProperties);
    }

    private void setOffHeapProperties(Properties customProperties) {
        if (customProperties.getProperty("blobstore.off-heap.update_threshold") != null && !this.hasBlobStoreOffHeapCache() && !this.hasBlobStoreOffHeapStore()) {
            _logger.warning("blobstore.off-heap.update_threshold is set but no off heap memory is used");
        } else {
            long minimalDiffToAllocate = StringUtils.parseStringAsBytes(customProperties.getProperty("blobstore.off-heap.update_threshold", "50B"));
            if (this._blobStoreStorageHandler.getOffHeapStore() != null && this._blobStoreStorageHandler.getOffHeapStore() instanceof OffHeapMemoryPool) {
                ((OffHeapMemoryPool)this._blobStoreStorageHandler.getOffHeapStore()).setMinimalDiffToAllocate((int)minimalDiffToAllocate);
            }
            if (this._blobStoreStorageHandler.getOffHeapCache() != null) {
                this._blobStoreStorageHandler.getOffHeapCache().setMinimalDiffToAllocate((int)minimalDiffToAllocate);
            }
        }
    }

    public boolean isSyncHybrid() {
        return this._engine.getConfigReader().getBooleanSpaceProperty("blobstore.enable_unsafe_sync_endpoint", "false");
    }

    private Map<String, QueryExtensionIndexManagerWrapper> initQueryExtensionManagers(Properties customProperties) {
        HashMap<String, QueryExtensionIndexManagerWrapper> queryExtensions = new HashMap<String, QueryExtensionIndexManagerWrapper>();
        QueryExtensionRuntimeInfoImpl info = new QueryExtensionRuntimeInfoImpl(this.getEngine().getSpaceImpl().getNodeName(), this.getEngine().getSpaceImpl().getDeployPath());
        SpaceInstanceConfig spaceInstanceConfig = (SpaceInstanceConfig)customProperties.get("space-config");
        if (spaceInstanceConfig != null && spaceInstanceConfig.getQueryExtensionProviders() != null) {
            for (QueryExtensionProvider provider : spaceInstanceConfig.getQueryExtensionProviders()) {
                queryExtensions.put(provider.getNamespace(), new QueryExtensionIndexManagerWrapper(provider, info));
            }
        }
        this.addPredefinedIfAbsent(queryExtensions, info, "spatial", "org.openspaces.spatial.spi.LuceneSpatialQueryExtensionProvider");
        this.addPredefinedIfAbsent(queryExtensions, info, "text", "org.openspaces.textsearch.LuceneTextSearchQueryExtensionProvider");
        return queryExtensions;
    }

    private void addPredefinedIfAbsent(Map<String, QueryExtensionIndexManagerWrapper> queryExtensions, QueryExtensionRuntimeInfo info, String namespace, String providerClassName) {
        block3: {
            if (!queryExtensions.containsKey(namespace)) {
                try {
                    Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(providerClassName);
                    QueryExtensionProvider provider = (QueryExtensionProvider)providerClass.newInstance();
                    queryExtensions.put(namespace, new QueryExtensionIndexManagerWrapper(provider, info));
                }
                catch (Throwable e) {
                    if (!_logger.isLoggable(Level.FINE)) break block3;
                    _logger.log(Level.FINE, "Failed to load predefined query extension " + namespace + " - " + e);
                }
            }
        }
    }

    public static Logger getLogger() {
        return _logger;
    }

    public void setLeaseManager(LeaseManager leaseManager) {
        this._leaseManager = leaseManager;
    }

    public void init(Properties properties) throws SAException, CreateException {
        this._storageAdapter.initialize();
        this._typeManager.registerTypeDescListener(new TypeDescListener());
        SpaceConfigReader configReader = this._engine.getConfigReader();
        this._evictionStrategy = this.createEvictionStrategy(configReader, properties);
        this._lockManager = this.isBlobStoreCachePolicy() ? new BlobStoreLockManager<IEntryHolder>() : (this.isAllInCachePolicy() ? new AllInCacheLockManager() : new BasicEvictableLockManager(configReader));
        this._minExtendedIndexActivationSize = configReader.getIntSpaceProperty("engine.extended-match.min_ext_index_activation_size", "1");
        if (this._minExtendedIndexActivationSize < 0) {
            throw new RuntimeException("invalid min_ext_index_activation_size value specified");
        }
        this._syncReplicationUsed = this._engine.isSyncReplicationEnabled();
        this._partialUpdateReplication = configReader.getBooleanSpaceProperty("engine.partial_update_replication", "true");
    }

    public boolean isTimeBasedEvictionStrategy() {
        return this._isTimeBasedEvictionStrategy;
    }

    public boolean requiresEvictionReplicationProtection() {
        return this._evictionReplicationsMarkersRepository != null;
    }

    public IEvictionReplicationsMarkersRepository getEvictionReplicationsMarkersRepository() {
        return this._evictionReplicationsMarkersRepository;
    }

    public void initCache(boolean loadDataFromDB, Properties properties) throws SAException {
        BlobStoreInternalCacheFilter blobStoreInternalCacheFilter = null;
        if (this.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper() != null && this.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper().isPerInstancePersistency()) {
            if (this._engine.getSpaceImpl().isPrimary()) {
                if (this.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper().isInconsistentStorage()) {
                    _logger.severe("space " + this.getEngine().getFullSpaceName() + " selected to be primary but storage in inconsistent");
                    DirectPersistencyRecoveryException e = new DirectPersistencyRecoveryException("space " + this.getEngine().getFullSpaceName() + " selected to be primary but storage in inconsistent");
                    throw e;
                }
            } else if (this.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper().isMeLastPrimary()) {
                _logger.severe("space " + this.getEngine().getFullSpaceName() + " selected to be backup but last time was primary");
                DirectPersistencyRecoveryException e = new DirectPersistencyRecoveryException("space " + this.getEngine().getFullSpaceName() + " selected to be backup last time was primary");
                throw e;
            }
        }
        SpaceEvictionStrategyConfig config = new SpaceEvictionStrategyConfig(this.getMaxCacheSize());
        this._evictionStrategy.initialize(this, config);
        if (this.isBlobStoreCachePolicy()) {
            boolean inconsistentBackup;
            loadDataFromDB = true;
            boolean warmStart = this._persistentBlobStore;
            boolean bl = inconsistentBackup = this._persistentBlobStore && this.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper() != null && !this._engine.getSpaceImpl().isPrimary() && this.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper().isInconsistentStorage();
            if (warmStart && inconsistentBackup && _logger.isLoggable(Level.INFO)) {
                _logger.info(this.getEngine().getFullSpaceName() + " blob-store backup space inconsistent-storage indicator, forced cold start on");
            }
            warmStart &= !inconsistentBackup;
            if (!this._engine.getSpaceImpl().isPrimary() && this._engine.getReplicationNode() != null) {
                warmStart &= this._engine.getReplicationNode().getDirectPesistencySyncHandler() != null;
            }
            MetricRegistrator blobstoreMetricRegistrar = this._engine.getMetricRegistrator().extend("blobstore");
            properties.put("blobstoreMetricRegistrar", blobstoreMetricRegistrar);
            this._blobStoreInternalCache = new BlobStoreCacheHandler(properties);
            BlobStoreConfig blobStoreConfig = new BlobStoreConfig(this._engine.getFullSpaceName(), this._engine.getNumberOfPartitions(), this._engine.getClusterInfo().getNumberOfBackups(), warmStart, blobstoreMetricRegistrar);
            this._blobStoreStorageHandler.initialize(blobStoreConfig);
            List blobStoreCacheFilterQueries = (List)properties.get("space-config.engine.blobstore_cache_filter_queries");
            if (blobStoreCacheFilterQueries != null) {
                try {
                    blobStoreInternalCacheFilter = new BlobStoreInternalCacheFilter(this._engine, blobStoreCacheFilterQueries);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create blobstore cache filter", e);
                }
            }
            this._blobStoreInternalCache.setBlobStoreInternalCacheFilter(blobStoreInternalCacheFilter);
            Properties blobstoreProperties = new Properties();
            blobstoreProperties.setProperty("space-config.engine.blobstore_cache_size", properties.getProperty("space-config.engine.blobstore_cache_size"));
            blobstoreProperties.setProperty("space-config.engine.blobstore_persistent", String.valueOf(warmStart));
            Properties implProperties = this._blobStoreStorageHandler.getProperties();
            if (implProperties != null) {
                implProperties.remove(BlobStoreMemoryMonitor.MEMORY_MONITOR_PROPERTY_NAME);
                implProperties.remove(BlobStoreRecoveryHelper.BLOB_STORE_RECOVERY_HELPER_PROPERTY_NAME);
                blobstoreProperties.putAll((Map<?, ?>)implProperties);
            }
            this.getEngine().getSpaceImpl().getConfig().setBlobStoreProperties(blobstoreProperties);
            this._blobStoreMemoryMonitor = new BlobStoreMemoryMonitorWrapper(this._blobStoreStorageHandler.getProperties() != null ? (BlobStoreMemoryMonitor)this._blobStoreStorageHandler.getProperties().get(BlobStoreMemoryMonitor.MEMORY_MONITOR_PROPERTY_NAME) : null, this, this._engine.getFullSpaceName(), properties);
            if (this.getEngine().getReplicationNode() != null) {
                this.getEngine().getReplicationNode().setBlobStoreReplicaConsumeHelper(new BlobStoreReplicaConsumeHelper(this.getEngine()));
                if (this.useBlobStoreReplicationBackupBulks()) {
                    this.getEngine().getReplicationNode().setBlobStoreReplicationBulkConsumeHelper(new BlobStoreReplicationBulkConsumeHelper(this.getEngine()));
                }
            }
        }
        if (this.isBlobStoreCachePolicy() && this._replicationNode.getDirectPesistencySyncHandler() != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[" + this.getEngine().getFullSpaceName() + "] initializingIoHandler DirectPersistencyBlobStoreIO in DirectPersistencySyncHandler");
            }
            this._replicationNode.getDirectPesistencySyncHandler().afterInitializedBlobStoreIO(new DirectPersistencyBlobStoreIO(this, _logger, this._replicationNode.getDirectPesistencySyncHandler().getCurrentGenerationId()));
        }
        if (loadDataFromDB) {
            Context context = null;
            try {
                context = this.getCacheContext();
                this.loadDataFromDB(context, this._engine.getConfigReader());
                this._emptyAfterInitialLoadStage = this._entries.isEmpty();
            }
            catch (Exception ex1) {
                if (this.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper() != null) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.warning("[" + this.getEngine().getFullSpaceName() + "] setting storage state to Inconsistent due to failure during initial load");
                    }
                    this.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper().setStorageState(StorageConsistencyModes.Inconsistent);
                }
                throw ex1 instanceof SAException ? (SAException)ex1 : new SAException(ex1);
            }
            finally {
                this.freeCacheContext(context);
            }
        }
        if (this.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper() != null && this._engine.getSpaceImpl().isPrimary()) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("[" + this.getEngine().getFullSpaceName() + "] setting storage state of primary to Consistent after initial load");
            }
            this.getEngine().getSpaceImpl().getDirectPersistencyRecoveryHelper().setStorageState(StorageConsistencyModes.Consistent);
        }
        if (this.isBlobStoreCachePolicy() && this._replicationNode.getDirectPesistencySyncHandler() != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[" + this.getEngine().getFullSpaceName() + "] initializing DirectPersistencyBlobStoreIO in DirectPersistencySyncHandler");
            }
            if (this.isDirectPersistencyEmbeddedtHandlerUsed()) {
                this._replicationNode.getDirectPesistencySyncHandler().getEmbeddedSyncHandler().getInitialLoadHandler().onInitialLoadEnd();
            }
            this._replicationNode.getDirectPesistencySyncHandler().initialize();
        }
        this._persistentGC = new PersistentGC(this, this._engine.getConfigReader());
        this._persistentGC.start();
    }

    public boolean isCacheExternalDB() {
        return this._isCacheExternalDB;
    }

    public SpaceEngine getEngine() {
        return this._engine;
    }

    public SpaceTypeManager getTypeManager() {
        return this._typeManager;
    }

    public LeaseManager getLeaseManager() {
        return this._leaseManager;
    }

    public boolean isblobStoreDataSpace() {
        return this.isBlobStoreCachePolicy();
    }

    public BlobStoreExtendedStorageHandler getBlobStoreStorageHandler() {
        return this._blobStoreStorageHandler;
    }

    public BlobStoreMemoryMonitor getBlobStoreMemoryMonitor() {
        return this._blobStoreMemoryMonitor;
    }

    public IStorageConsistency getBlobStoreRecoveryHelper() {
        return this._blobStoreRecoveryHelper;
    }

    public boolean useBlobStoreBulks() {
        return this._useBlobStoreBulks;
    }

    public boolean useBlobStoreReplicationBackupBulks() {
        return this._useBlobStoreReplicationBackupBulk;
    }

    public boolean useBlobStorePreFetch() {
        return this._useBlobStorePrefetch;
    }

    public boolean isPersistentBlobStore() {
        return this._persistentBlobStore;
    }

    public boolean optimizedBlobStoreClear() {
        return this._optimizedBlobStoreClear;
    }

    public boolean needReReadAfterEntryLock() {
        return this.isEvictableCachePolicy() || this.isblobStoreDataSpace();
    }

    public boolean mayNeedEntriesUnpinning() {
        return this.isEvictableCachePolicy() || this.isblobStoreDataSpace();
    }

    public boolean isClusteredExternalDBEnabled() {
        return this._isClusteredExternalDBEnabled;
    }

    public boolean isCentralDB() {
        return this._isCentralDB;
    }

    public boolean isVersionedExternalDB() {
        return this._isVersionedExternalDB;
    }

    public boolean isEmptyAfterInitialLoadStage() {
        return this._emptyAfterInitialLoadStage;
    }

    public boolean isDirectPersistencyEmbeddedtHandlerUsed() {
        return this._directPersistencyEmbeddedtHandlerUsed;
    }

    public IBasicLockManager<IEntryHolder> getLockManager() {
        return this._lockManager;
    }

    private void touch(EvictableServerEntry entry, boolean isUpdate) {
        if (!this.isMemorySpace() && ((EvictableEntryCacheInfo)entry).isTransient()) {
            return;
        }
        if (this._evictionStrategy.requiresConcurrencyProtection()) {
            if (((EvictableEntryCacheInfo)entry).permitCallingEvictionStrategy()) {
                try {
                    if (isUpdate) {
                        this._evictionStrategy.onUpdate(entry);
                    }
                    this._evictionStrategy.onRead(entry);
                }
                finally {
                    ((EvictableEntryCacheInfo)entry).afterCallingEvictionStrategy();
                }
            }
        } else if (isUpdate) {
            this._evictionStrategy.onUpdate(entry);
        } else {
            this._evictionStrategy.onRead(entry);
        }
    }

    public void touchByEntry(Context context, IEntryHolder entry, boolean modifyOp, ITemplateHolder template, CacheOperationReason cacheOperationReason) {
        if (entry.isBlobStoreEntry()) {
            if (template.getXidOriginatedTransaction() != null && cacheOperationReason != CacheOperationReason.ON_READ) {
                return;
            }
            ((IBlobStoreEntryHolder)((Object)entry)).insertOrTouchInternalCache(context, this, cacheOperationReason);
        } else {
            IEntryCacheInfo pe = this.getPEntryByUid(entry.getUID());
            if (pe != null && pe.getEntryHolder(this) == entry) {
                this.touch(pe, modifyOp);
            }
        }
    }

    private SpaceEvictionStrategy createEvictionStrategy(SpaceConfigReader configReader, Properties properties) throws CreateException {
        if (this.isAllInCachePolicy() || this.isBlobStoreCachePolicy()) {
            return new AllInCacheSpaceEvictionStrategy();
        }
        if (this.getCachePolicy() == 0) {
            int touchThreashold = configReader.getIntSpaceProperty("engine.lruTouchThreshold", "50");
            return new ConcurrentLruSpaceEvictionStrategy(touchThreashold, this.getMaxCacheSize());
        }
        SpaceEvictionStrategy injEvictionStrategy = (SpaceEvictionStrategy)properties.get("engine.eviction_strategy_instance");
        if (injEvictionStrategy != null) {
            return injEvictionStrategy;
        }
        String evictor = configReader.getSpaceProperty("engine.eviction_strategy", "");
        if (evictor == null || evictor.length() == 0) {
            throw new RuntimeException("invalid eviction strategy value specified " + evictor);
        }
        if (evictor.equalsIgnoreCase(DefaultTimeBasedSpaceEvictionStrategy.class.getName())) {
            return new DefaultTimeBasedSpaceEvictionStrategy(configReader);
        }
        try {
            Class evClass = ClassLoaderHelper.loadClass(evictor);
            Object newInstance = evClass.newInstance();
            return (SpaceEvictionStrategy)newInstance;
        }
        catch (Exception e) {
            throw new CreateException("Failed to load eviction strategy class", e);
        }
    }

    private BlobStoreStorageHandler createBlobStoreHandlerNewInterface(SpaceConfigReader configReader, Properties properties) throws CreateException {
        BlobStoreStorageHandler res = null;
        try {
            if (!this.isBlobStoreCachePolicy()) {
                BlobStoreStorageHandler blobStoreStorageHandler = null;
                return blobStoreStorageHandler;
            }
            res = (BlobStoreStorageHandler)properties.get("engine.blobstore_storage_handler_instance");
            if (res != null) {
                BlobStoreStorageHandler blobStoreStorageHandler = res;
                return blobStoreStorageHandler;
            }
            String oh = (String)properties.get("engine.blobstore_storage_handler");
            if (this._blobStoreForQa && (oh == null || oh.length() == 0)) {
                oh = BlobStoreHashMock.class.getName();
            }
            if (oh == null || oh.length() == 0) {
                throw new RuntimeException("invalid blob-store storage handler value specified " + oh);
            }
            if (oh.indexOf("BlobStoreStorageHashMock") != -1) {
                BlobStoreStorageHandler blobStoreStorageHandler = res = new BlobStoreHashMock();
                return blobStoreStorageHandler;
            }
            Class ohClass = ClassLoaderHelper.loadClass(oh);
            Object newInstance = ohClass.newInstance();
            BlobStoreStorageHandler blobStoreStorageHandler = res = (BlobStoreStorageHandler)newInstance;
            return blobStoreStorageHandler;
        }
        finally {
            if (res != null && _logger.isLoggable(Level.INFO)) {
                _logger.info("created blob-store handler class=" + res.getClass().getName() + " persistentBlobStore=" + this._persistentBlobStore);
            }
        }
    }

    public IBlobStoreCacheHandler getBlobStoreInternalCache() {
        return this._blobStoreInternalCache;
    }

    public boolean hasBlobStoreOffHeapCache() {
        return this._blobStoreStorageHandler.getOffHeapCache() != null;
    }

    public boolean hasBlobStoreOffHeapStore() {
        return this._blobStoreStorageHandler.getOffHeapStore() != null;
    }

    public String getConfigInfo() {
        return "policy=" + this.getPolicy() + ", persistency-mode=" + this.getPersistencyMode();
    }

    private String getPolicy() {
        if (this.isAllInCachePolicy()) {
            return "all-in-cache";
        }
        if (this.getCachePolicy() == 0) {
            return "lru(cache-size=" + this.m_CacheSize + ")";
        }
        if (this.isPluggedEvictionPolicy()) {
            return "custom(cache-size=" + this.m_CacheSize + ")";
        }
        return "blob-store";
    }

    private String getPersistencyMode() {
        if (this._isMemorySA) {
            return "memory";
        }
        if (this.isBlobStoreCachePolicy()) {
            return "blob-store";
        }
        if (this.isCacheExternalDB()) {
            return "external";
        }
        return "jdbc";
    }

    private void loadDataFromDB(Context context, SpaceConfigReader configReader) throws SAException {
        InitialLoadInfo initialLoadInfo = new InitialLoadInfo(_logger, this._logRecoveryProcess, this._recoveryLogInterval);
        if (this.isBlobStoreCachePolicy()) {
            initialLoadInfo.setBlobStoreFifoInitialLoader(new BlobStoreFifoInitialLoader());
        }
        context.setInitialLoadInfo(initialLoadInfo);
        if (this.isResidentEntriesCachePolicy()) {
            this.residentEntriesInitialLoad(context, configReader, initialLoadInfo);
            if (this.isBlobStoreCachePolicy() && this._persistentBlobStore && this._engine.getSpaceImpl().isPrimary() && this._entries.isEmpty()) {
                if (((IBlobStoreStorageAdapter)((Object)this._storageAdapter)).hasAnotherInitialLoadSource() && _logger.isLoggable(Level.INFO)) {
                    _logger.info("persistent blob store is empty, trying the mirror initial load source");
                }
                this.residentEntriesInitialLoad(context, configReader, initialLoadInfo);
            }
        }
        if (this.isEvictableCachePolicy()) {
            this.evictableEntriesInitialLoad(context, configReader, initialLoadInfo);
        }
        if (_logger.isLoggable(Level.INFO)) {
            String formattedErrors = this.format(initialLoadInfo.getInitialLoadErrors());
            _logger.info("Data source recovery:\n \tEntries found in data source: " + initialLoadInfo.getFoundInDatabase() + ".\n\tEntries inserted to space: " + initialLoadInfo.getInsertedToCache() + ".\n\tEntries ignored: " + (initialLoadInfo.getFoundInDatabase() - initialLoadInfo.getInsertedToCache()) + ".\n" + formattedErrors + "\tTotal Time: " + JSpaceUtilities.formatMillis(SystemTime.timeMillis() - initialLoadInfo.getRecoveryStartTime()) + ".");
        }
        if (this.getBlobStoreInternalCache() != null && this.getBlobStoreInternalCache().getBlobStoreInternalCacheFilter() != null && _logger.isLoggable(Level.INFO)) {
            _logger.info("BlobStore internal cache recovery:\n \tblob-store-queries: " + this.getBlobStoreInternalCache().getBlobStoreInternalCacheFilter().getSqlQueries() + ".\n\tEntries inserted to blobstore cache: " + this.getBlobStoreInternalCache().getBlobStoreInternalCacheFilter().getInsertedToBlobStoreInternalCacheOnInitialLoad() + ".\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void residentEntriesInitialLoad(Context context, SpaceConfigReader configReader, InitialLoadInfo initialLoadInfo) throws SAException {
        boolean isFifo = true;
        ITemplateHolder th = TemplateHolderFactory.createEmptyTemplateHolder(this._engine, this._engine.generateUid(), Long.MAX_VALUE, isFifo);
        ISAdapterIterator entriesIterSA = null;
        try {
            IEntryHolder eh;
            context.setInInitialLoad(true);
            entriesIterSA = this._storageAdapter.initialLoad(context, th);
            if (entriesIterSA != null) {
                HashSet<String> typesIn;
                IServerTypeDesc serverTypeDesc = null;
                HashSet<String> hashSet = typesIn = this._persistentBlobStore ? new HashSet<String>() : null;
                while ((eh = (IEntryHolder)entriesIterSA.next()) != null) {
                    initialLoadInfo.incrementFoundInDatabase();
                    if (this._engine.isPartitionedSpace() && !eh.isBlobStoreEntry()) {
                        if (serverTypeDesc == null || !serverTypeDesc.getTypeName().equals(eh.getClassName())) {
                            serverTypeDesc = this._typeManager.getServerTypeDesc(eh.getClassName());
                        }
                        if (eh.getRoutingValue() == null) {
                            initialLoadInfo.getInitialLoadErrors().add("Object without routing  -  [" + eh.getClassName() + ":" + eh.getUID() + "]");
                            continue;
                        }
                        if (!this._engine.isEntryFromPartition(eh)) continue;
                    }
                    if (this._entries.containsKey(eh.getUID())) {
                        initialLoadInfo.getInitialLoadErrors().add("Object with duplicate uid -  [" + eh.getClassName() + ":" + eh.getUID() + "]");
                        continue;
                    }
                    boolean entryFromBlobStore = false;
                    if (this.isBlobStoreCachePolicy()) {
                        if (eh.isBlobStoreEntry()) {
                            entryFromBlobStore = true;
                            if (eh.getServerTypeDesc().isFifoSupported() || eh.getServerTypeDesc().getTypeDesc().getFifoGroupingPropertyPath() != null) {
                                if (initialLoadInfo.getCurTypeData() == null || initialLoadInfo.getCurDesc() != eh.getServerTypeDesc()) {
                                    initialLoadInfo.setCurTypeData(this._typeDataMap.get(eh.getServerTypeDesc()));
                                    initialLoadInfo.setCurDesc(eh.getServerTypeDesc());
                                }
                                if (this.isDirectPersistencyEmbeddedtHandlerUsed() && !this._replicationNode.getDirectPesistencySyncHandler().getEmbeddedSyncHandler().getInitialLoadHandler().onLoadingEntry(eh)) continue;
                                initialLoadInfo.getBlobStoreFifoInitialLoader().add(eh, initialLoadInfo.getCurTypeData());
                                continue;
                            }
                        } else {
                            eh = new BlobStoreEntryHolder(eh);
                            EntryCacheInfoFactory.createBlobStoreEntryCacheInfo(eh);
                        }
                    }
                    boolean insertBlobStoreEntryToCache = true;
                    if (eh.isBlobStoreEntry() && this.isDirectPersistencyEmbeddedtHandlerUsed()) {
                        insertBlobStoreEntryToCache = this._replicationNode.getDirectPesistencySyncHandler().getEmbeddedSyncHandler().getInitialLoadHandler().onLoadingEntry(eh);
                    }
                    if (!insertBlobStoreEntryToCache) continue;
                    this.safeInsertEntryToCache(context, eh, false, null, false, entryFromBlobStore ? InitialLoadOrigin.FROM_BLOBSTORE : InitialLoadOrigin.FROM_NON_BLOBSTORE);
                    if (this.isBlobStoreCachePolicy()) {
                        if (!entryFromBlobStore) {
                            ((IBlobStoreEntryHolder)((Object)eh)).setDirty(this);
                        }
                        ((IBlobStoreEntryHolder)((Object)eh)).getBlobStoreResidentPart().unLoadFullEntryIfPossible(this, context);
                        if (!entryFromBlobStore && typesIn != null) {
                            this.insertMetadataTypeToBlobstoreIfNeeded(eh, typesIn);
                        }
                    }
                    initialLoadInfo.incrementInsertedToCache();
                    initialLoadInfo.setLastLoggedTime(this.logInsertionIfNeeded(initialLoadInfo.getRecoveryStartTime(), initialLoadInfo.getLastLoggedTime(), initialLoadInfo.getInsertedToCache()));
                }
            }
            if (this.isBlobStoreCachePolicy() && !initialLoadInfo.getBlobStoreFifoInitialLoader().isEmpty()) {
                BlobStoreFifoInitialLoader blobStoreFifoInitialLoader = initialLoadInfo.getBlobStoreFifoInitialLoader();
                boolean avoidInsertToBlobStoreInternalCache = true;
                while (blobStoreFifoInitialLoader.hasNext()) {
                    eh = blobStoreFifoInitialLoader.next();
                    this.safeInsertEntryToCache(context, eh, false, null, false, InitialLoadOrigin.FROM_BLOBSTORE);
                    ((IBlobStoreEntryHolder)((Object)eh)).getBlobStoreResidentPart().unLoadFullEntryIfPossible(this, context);
                    initialLoadInfo.incrementInsertedToCache();
                    initialLoadInfo.setLastLoggedTime(this.logInsertionIfNeeded(initialLoadInfo.getRecoveryStartTime(), initialLoadInfo.getLastLoggedTime(), initialLoadInfo.getInsertedToCache()));
                }
            }
        }
        finally {
            context.setInInitialLoad(false);
            if (entriesIterSA != null) {
                entriesIterSA.close();
            }
        }
    }

    private void insertMetadataTypeToBlobstoreIfNeeded(IEntryHolder eh, Set<String> typesIn) {
        if (!eh.getServerTypeDesc().getTypeDesc().isBlobstoreEnabled() || typesIn.contains(eh.getServerTypeDesc().getTypeDesc().getTypeName())) {
            return;
        }
        ITypeDesc typeDescriptor = eh.getServerTypeDesc().getTypeDesc();
        String[] superClassesNames = typeDescriptor.getRestrictSuperClassesNames();
        if (superClassesNames != null) {
            for (String superClassName : superClassesNames) {
                if (this._typeManager.getServerTypeDesc(superClassName) == null) {
                    throw new IllegalArgumentException("Missing super class type descriptor [" + superClassName + "] for type [" + typeDescriptor.getTypeName() + "]");
                }
                if (!typesIn.add(superClassName)) continue;
                this._storageAdapter.introduceDataType(this._typeManager.getServerTypeDesc(superClassName).getTypeDesc());
            }
        }
        typesIn.add(eh.getServerTypeDesc().getTypeDesc().getTypeName());
        this._storageAdapter.introduceDataType(eh.getServerTypeDesc().getTypeDesc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictableEntriesInitialLoad(Context context, SpaceConfigReader configReader, InitialLoadInfo initialLoadInfo) throws SAException {
        block19: {
            int initial_lru_load = 0;
            int initial_lru_load_p = configReader.getIntSpaceProperty("engine.initial_load", "50");
            if (initial_lru_load_p > 0 && initial_lru_load_p <= 100) {
                initial_lru_load = this.m_CacheSize * initial_lru_load_p / 100;
            }
            int need_load = initial_lru_load - this._cacheSize.get();
            IServerTypeDesc templateType = null;
            String initial_load_class = null;
            if (need_load > 0) {
                initial_load_class = configReader.getSpaceProperty("engine.initial_load_class", "_");
                if ("_".equals(initial_load_class)) {
                    initial_load_class = null;
                } else {
                    templateType = this._typeManager.getServerTypeDesc(initial_load_class);
                    if (templateType == null) {
                        need_load = 0;
                    }
                }
            }
            if (need_load > 0) {
                ITemplateHolder th = null;
                if (initial_load_class == null) {
                    th = TemplateHolderFactory.createEmptyTemplateHolder(this._engine, this._engine.generateUid(), Long.MAX_VALUE, false);
                    templateType = this._typeManager.getServerTypeDesc(IServerTypeDesc.ROOT_TYPE_NAME);
                } else {
                    TemplatePacket ep = new TemplatePacket(templateType.getTypeDesc());
                    th = TemplateHolderFactory.createTemplateHolder(templateType, ep, this._engine.generateUid(), Long.MAX_VALUE);
                }
                ISAdapterIterator entriesIterSA = null;
                try {
                    IEntryHolder eh;
                    context.setInInitialLoad(true);
                    entriesIterSA = this._storageAdapter.initialLoad(context, th);
                    if (entriesIterSA == null) break block19;
                    IServerTypeDesc serverTypeDesc = null;
                    while ((eh = (IEntryHolder)entriesIterSA.next()) != null) {
                        initialLoadInfo.incrementFoundInDatabase();
                        if (this._engine.isPartitionedSpace()) {
                            if (serverTypeDesc == null || !serverTypeDesc.getTypeName().equals(eh.getClassName())) {
                                serverTypeDesc = this._typeManager.getServerTypeDesc(eh.getClassName());
                            }
                            if (eh.getRoutingValue() == null) {
                                initialLoadInfo.getInitialLoadErrors().add("Object without routing -  [" + eh.getClassName() + ":" + eh.getUID() + "]");
                                continue;
                            }
                            if (!this._engine.isEntryFromPartition(eh)) continue;
                        }
                        if (this._entries.containsKey(eh.getUID())) {
                            initialLoadInfo.getInitialLoadErrors().add("Object with duplicate uid -  [" + eh.getClassName() + ":" + eh.getUID() + "]");
                            continue;
                        }
                        if (this._engine.getMemoryManager().isEnabled() && this._engine.getMemoryManager().monitorMemoryUsageWithNoEviction(true)) {
                            break;
                        }
                        this.safeInsertEntryToCache(context, eh, false, null, false, InitialLoadOrigin.FROM_NON_BLOBSTORE);
                        initialLoadInfo.incrementInsertedToCache();
                        initialLoadInfo.setLastLoggedTime(this.logInsertionIfNeeded(initialLoadInfo.getRecoveryStartTime(), initialLoadInfo.getLastLoggedTime(), initialLoadInfo.getInsertedToCache()));
                        if (--need_load <= 0) break;
                    }
                }
                finally {
                    context.setInInitialLoad(false);
                    if (entriesIterSA != null) {
                        entriesIterSA.close();
                    }
                }
            }
        }
    }

    private String format(LinkedList<String> initialLoadErrors) {
        if (initialLoadErrors.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\t[\n");
        for (String error : initialLoadErrors) {
            sb.append("\t\t" + error + "\n");
        }
        sb.append("\t]\n");
        return sb.toString();
    }

    private long logInsertionIfNeeded(long startLogTime, long lastLogTime, int fetchedEntries) {
        long curTime;
        if (this._logRecoveryProcess && _logger.isLoggable(Level.INFO) && (curTime = SystemTime.timeMillis()) - lastLogTime > this._recoveryLogInterval) {
            _logger.info("Entries loaded so far: " + fetchedEntries + " [" + JSpaceUtilities.formatMillis(curTime - startLogTime) + "]");
            return curTime;
        }
        return lastLogTime;
    }

    public void shutDown() {
        block17: {
            block16: {
                if (this.isBlobStoreCachePolicy() && this.getBlobStoreStorageHandler() != null && (this.hasBlobStoreOffHeapCache() || this.hasBlobStoreOffHeapStore())) {
                    this.freeOffHeapCache();
                }
                if (this._fifoBackgroundDispatcher != null) {
                    this._fifoBackgroundDispatcher.close();
                }
                if (this._templateExpirationManager != null) {
                    this._templateExpirationManager.shutDown();
                }
                try {
                    this._persistentGC.shutdown();
                }
                catch (Exception ex) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, ex.toString(), ex);
                    }
                }
                finally {
                    this._persistentGC = null;
                }
                try {
                    this._cacheContextFactory.closeAllContexts();
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.FINE)) break block16;
                    _logger.log(Level.FINE, ex.toString(), ex);
                }
            }
            try {
                this._storageAdapter.shutDown();
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block17;
                _logger.log(Level.FINE, ex.toString(), ex);
            }
        }
        if (this._evictionStrategy != null) {
            this._evictionStrategy.close();
        }
        if (this._replicationNode != null && this._replicationNode.getDirectPesistencySyncHandler() != null) {
            this._replicationNode.getDirectPesistencySyncHandler().close();
        }
    }

    public boolean useRecentDeletes() {
        return this.isEvictableCachePolicy() && !this._isMemorySA && (!this._readOnlySA || this._engine.hasMirror());
    }

    public void insertToRecentDeletes(IEntryHolder entry, long duration, ServerTransaction committingXtn) {
        this._recentDeletesRespository.insertToRecentDeletes(entry, duration, committingXtn);
    }

    public boolean removeFromRecentDeletes(IEntryHolder entry) {
        return this._recentDeletesRespository.removeFromRecentDeletes(entry);
    }

    public Iterator<RecentDeletesRepository.RecentDeleteInfo> getRecentDeletesIterator() {
        return this._recentDeletesRespository.getRecentDeletesIterator();
    }

    public RecentDeletesRepository.RecentDeleteInfo getRecentDeleteInfo(String uid) {
        return this._recentDeletesRespository.getRecentDeleteInfo(uid);
    }

    public int getNumOfRecentDeletes() {
        return this._recentDeletesRespository.size();
    }

    public boolean useRecentUpdatesForPinning() {
        return this.isEvictableCachePolicy() && !this._isMemorySA && (!this._readOnlySA || this._engine.hasMirror());
    }

    public void insertToRecentUpdates(IEntryHolder entry, long duration, ServerTransaction committingXtn) {
        this._recentUpdatesRespository.insertToRecentUpdates(entry, duration, committingXtn);
    }

    public void insertToRecentUpdatesIfNeeded(IEntryHolder entry, long duration, ServerTransaction committingXtn) {
        if (this.useRecentUpdatesForPinning()) {
            this.insertToRecentUpdates(entry, duration, committingXtn);
        }
    }

    private boolean removeFromRecentUpdates(IEntryHolder entry) {
        return this._recentUpdatesRespository.removeFromRecentUpdates(entry);
    }

    public boolean removeFromRecentUpdatesIfNeeded(IEntryHolder entry) {
        return this.useRecentUpdatesForPinning() ? this._recentUpdatesRespository.removeFromRecentUpdates(entry) : false;
    }

    public Iterator<RecentUpdatesRepository.RecentUpdateInfo> getRecentUpdatesIterator() {
        return this._recentUpdatesRespository.getRecentUpdatesIterator();
    }

    public RecentUpdatesRepository.RecentUpdateInfo getRecentUpdateInfo(String uid) {
        return this._recentUpdatesRespository.getRecentUpdateInfo(uid);
    }

    public int getNumOfRecentUpdates() {
        return this._recentUpdatesRespository.size();
    }

    public boolean isEntryInRecentUpdates(IEntryHolder entry) {
        return this.getRecentUpdateInfo(entry.getUID()) != null;
    }

    public boolean isDummyEntry(IEntryHolder eh) {
        if (!this.useRecentDeletes() || !eh.isDeleted()) {
            return false;
        }
        IEntryCacheInfo pEntry = this.getPEntryByUid(eh.getUID());
        return pEntry != null && pEntry.isRecentDelete();
    }

    @Override
    public int evictBatch(int evictionQuota) {
        return this._evictionStrategy.evict(evictionQuota);
    }

    public void insertEntry(Context context, IEntryHolder entryHolder, boolean shouldReplicate, boolean origin, boolean suppliedUid) throws SAException, EntryAlreadyInSpaceException {
        this.validateEntryCanBeWrittenToCache(entryHolder);
        TypeData typeData = this._typeDataMap.get(entryHolder.getServerTypeDesc());
        if (entryHolder.getXidOriginatedTransaction() != null) {
            entryHolder.setMaybeUnderXtn(true);
            entryHolder.setWriteLockOwnerAndOperation(entryHolder.getXidOriginated(), 1, false);
        }
        if (entryHolder.getXidOriginated() != null) {
            entryHolder.getXidOriginated().setOperatedUpon();
        }
        IEntryCacheInfo pE = null;
        pE = this.insertEntryToCache(context, entryHolder, true, typeData, true, InitialLoadOrigin.NON);
        if (pE == this._entryAlreadyInSpaceIndication) {
            throw new EntryAlreadyInSpaceException(entryHolder.getUID(), entryHolder.getClassName());
        }
        if (entryHolder.getXidOriginatedTransaction() == null) {
            try {
                if (entryHolder.isBlobStoreEntry() && this.isDirectPersistencyEmbeddedtHandlerUsed() && context.isActiveBlobStoreBulk()) {
                    context.setForBulkInsert(entryHolder);
                }
                this._storageAdapter.insertEntry(context, entryHolder, origin, shouldReplicate);
                if (shouldReplicate && !context.isDelayedReplicationForbulkOpUsed()) {
                    this.handleInsertEntryReplication(context, entryHolder);
                }
            }
            catch (SAException ex) {
                if (!entryHolder.isDeleted()) {
                    this.removeEntryFromCache(entryHolder);
                }
                context.resetRecentFifoObject();
                throw ex;
            }
        }
    }

    public void handleInsertEntryReplication(Context context, IEntryHolder entryHolder) throws SAException {
        this.handleInsertEntryReplication(context, entryHolder, 0);
    }

    public void handleInsertEntryReplication(Context context, IEntryHolder entryHolder, int blobstoreBulkId) throws SAException {
        IReplicationOutContext replCtx = this.getReplicationContext(context);
        this.updateReplicationContext(replCtx, context);
        this.attachBlobstoreReplicationBulkIdIfNeeded(replCtx, blobstoreBulkId);
        if (this.requiresEvictionReplicationProtection()) {
            replCtx.askForMarker(this.getEvictionPolicyReplicationMembersGroupName());
        }
        this._replicationNode.outWriteEntry(replCtx, entryHolder);
        if (this.requiresEvictionReplicationProtection()) {
            IMarker marker = replCtx.getRequestedMarker();
            this.getEvictionReplicationsMarkersRepository().insert(entryHolder.getUID(), marker, false);
        }
    }

    private void attachBlobstoreReplicationBulkIdIfNeeded(IReplicationOutContext outContext, int blobstoreBulkId) {
        boolean attachBlobstoreBulkId = this.useBlobStoreReplicationBackupBulks() && this._engine.getSpaceImpl().isPrimary();
        outContext.setBlobstoreReplicationBulkId(attachBlobstoreBulkId ? blobstoreBulkId : 0);
    }

    public String getEvictionPolicyReplicationMembersGroupName() {
        return "persistency";
    }

    public IEntryHolder updateEntry(Context context, IEntryHolder entry, ITemplateHolder template, boolean shouldReplicate, boolean origin) throws SAException {
        IEntryCacheInfo pEntry = null;
        IEntryHolder new_eh = null;
        IEntryData originalData = entry.getEntryData();
        try {
            if (entry.isBlobStoreEntry()) {
                pEntry = ((IBlobStoreEntryHolder)((Object)entry)).getBlobStoreResidentPart();
                context.setBlobStoreOriginalEntryInfo(originalData, ((IBlobStoreEntryHolder)((Object)entry)).getBlobStoreVersion());
            } else if (this.isAllInCachePolicy()) {
                pEntry = this.getPEntryByUid(entry.getUID());
            }
            IEntryData newEntryData = template.getUpdatedEntry().getEntryData();
            pEntry = this.updateEntryInCache(context, pEntry, pEntry != null ? pEntry.getEntryHolder(this) : entry, newEntryData, newEntryData.getExpirationTime(), template.getOperationModifiers());
            new_eh = pEntry.getEntryHolder(this);
            if (entry.isBlobStoreEntry() && this.isDirectPersistencyEmbeddedtHandlerUsed() && context.isActiveBlobStoreBulk()) {
                context.setForBulkUpdate(new_eh, originalData, template.getMutators());
            }
            this._storageAdapter.updateEntry(context, new_eh, shouldReplicate, origin, context.getPartialUpdatedValuesIndicators());
            if (shouldReplicate && !context.isDelayedReplicationForbulkOpUsed()) {
                this.handleUpdateEntryReplication(context, new_eh, originalData, template.getMutators());
            }
        }
        catch (Exception ex) {
            if (ex instanceof DuplicateIndexValueException) {
                throw (RuntimeException)ex;
            }
            try {
                if (entry.getEntryData().getVersion() == template.getUpdatedEntry().getEntryData().getVersion()) {
                    if (this.isEvictableCachePolicy()) {
                        this.removeEntryFromCache(entry);
                    } else {
                        this.updateEntryInCache(context, null, entry, originalData, template.getUpdatedEntry().getEntryData().getExpirationTime(), template.getOperationModifiers());
                    }
                }
            }
            catch (Exception ex_) {
                ex = ex instanceof SAException ? new SAException("Original exception=" + ex + " while trying to revert caught: " + ex_, ex) : new RuntimeException("Original exception=" + ex + " while trying to revert caught: " + ex_, ex);
            }
            if (ex instanceof SAException) {
                throw (SAException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        return new_eh;
    }

    public void handleUpdateEntryReplication(Context context, IEntryHolder new_eh, IEntryData originalData, Collection<SpaceEntryMutator> mutators) {
        this.handleUpdateEntryReplication(context, new_eh, originalData, mutators, 0);
    }

    public void handleUpdateEntryReplication(Context context, IEntryHolder new_eh, IEntryData originalData, Collection<SpaceEntryMutator> mutators, int blobstoreBulkId) {
        boolean isChange = mutators != null;
        IReplicationOutContext replCtx = this.getReplicationContext(context);
        this.attachBlobstoreReplicationBulkIdIfNeeded(replCtx, blobstoreBulkId);
        if (isChange) {
            this.updateReplicationContextForChangeEntry(replCtx, originalData, context, mutators);
        } else {
            this.updateReplicationContextForUpdateEntry(replCtx, originalData, context, context.getPartialUpdatedValuesIndicators());
        }
        if (this.requiresEvictionReplicationProtection()) {
            replCtx.askForMarker(this.getEvictionPolicyReplicationMembersGroupName());
        }
        if (isChange) {
            this._replicationNode.outChangeEntry(replCtx, new_eh);
        } else {
            this._replicationNode.outUpdateEntry(replCtx, new_eh);
        }
        if (this.requiresEvictionReplicationProtection()) {
            IMarker marker = replCtx.getRequestedMarker();
            this.getEvictionReplicationsMarkersRepository().insert(new_eh.getUID(), marker, false);
        }
    }

    public IEntryHolder makeChangeOpEntry(Context context, ITemplateHolder template, IEntryHolder currentEntry) {
        context.setChangeResultsForCurrentEntry(null);
        ITransactionalEntryData edata = (ITransactionalEntryData)currentEntry.getEntryData();
        int versionID = this._engine.isLocalCache() || context.isFromReplication() ? template.getEntryData().getVersion() : Math.max(template.getEntryData().getVersion() + 1, 2);
        ITransactionalEntryData udata = template.getChangeExpiration() != 0L ? edata.createShallowClonedCopyWithSuppliedVersionAndExpiration(versionID, template.getChangeExpiration()) : edata.createShallowClonedCopyWithSuppliedVersion(versionID);
        ArrayList<Object> results = null;
        try {
            int i = 0;
            for (SpaceEntryMutator mutator : template.getMutators()) {
                Object result = mutator.change(udata);
                if (!Modifiers.contains(template.getOperationModifiers(), 0x2000000)) continue;
                if (result != null && results == null) {
                    results = new ArrayList<Object>(template.getMutators().size());
                    if (i > 0) {
                        for (int j = 0; j < i; ++j) {
                            results.add(null);
                        }
                    }
                }
                if (results != null) {
                    results.add(result);
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            throw new ChangeInternalException(e);
        }
        context.setChangeResultsForCurrentEntry(results);
        return EntryHolderFactory.createEntryHolder(currentEntry.getServerTypeDesc(), udata, currentEntry.getUID(), currentEntry.isTransient());
    }

    public void insertTemplate(Context context, ITemplateHolder templateHolder, boolean shouldReplicate) {
        CustomInfo customInfo;
        TemplateCacheInfo oldValue;
        NotifyTemplateHolder notifyTemplateHolder = templateHolder.isNotifyTemplate() ? (NotifyTemplateHolder)templateHolder : null;
        TemplateCacheInfo pTemplate = null;
        if (templateHolder.isNotifyTemplate() && (oldValue = this._templatesManager.putIfAbsent(pTemplate = new TemplateCacheInfo(templateHolder))) != null) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("notify template already in space, uid=" + oldValue.m_TemplateHolder.getUID() + " , in class: " + oldValue.m_TemplateHolder.getClassName());
            }
            return;
        }
        templateHolder.setInCache();
        if (!templateHolder.isExplicitInsertionToExpirationManager()) {
            this._templateExpirationManager.addTemplate(templateHolder);
        }
        if (templateHolder.isNotifyTemplate() && templateHolder.getXidOriginatedTransaction() == null && shouldReplicate) {
            IReplicationOutContext replCtx = this.getReplicationContext(context);
            this.updateReplicationContext(replCtx, context);
            this._replicationNode.outInsertNotifyTemplate(replCtx, notifyTemplateHolder);
        }
        if (templateHolder.getXidOriginated() != null && templateHolder.isNotifyTemplate()) {
            templateHolder.getXidOriginated().setOperatedUpon();
        }
        if (pTemplate == null) {
            pTemplate = new TemplateCacheInfo(templateHolder);
            this._templatesManager.put(pTemplate);
        }
        this.insertTemplateToCache(context, pTemplate);
        if (!context.isSyncReplFromMultipleOperation() && shouldReplicate) {
            this._engine.performReplication(context);
        }
        if (notifyTemplateHolder != null && (customInfo = notifyTemplateHolder.getNotifyInfo().getCustomInfo()) != null && customInfo.isLocalCacheCustomInfo()) {
            this._localCacheRegistrations.add(notifyTemplateHolder);
        }
    }

    public IEntryHolder getEntry(Context context, IEntryHolder entryHolder, boolean tryInsertToCache, boolean lockedEntry, boolean useOnlyCache) throws SAException {
        if (entryHolder.isBlobStoreEntry()) {
            context.setBlobStoreOpParams(((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart(), entryHolder, tryInsertToCache && lockedEntry);
            return this._storageAdapter.getEntry(context, entryHolder.getUID(), entryHolder.getClassName(), entryHolder);
        }
        IEntryHolder entry = null;
        IEntryCacheInfo pEntry = null;
        pEntry = this.getPEntryByUid(entryHolder.getUID());
        if (pEntry != null) {
            if (lockedEntry ? pEntry.isDeleted() : pEntry.isRecentDelete()) {
                return null;
            }
            if (!this._isMemorySA && useOnlyCache && !lockedEntry && this.isEvictableCachePolicy() && !this.isResidentCacheEntry(pEntry)) {
                return null;
            }
            if (lockedEntry && tryInsertToCache) {
                if (this.isEvictableCachePolicy()) {
                    if (!pEntry.setPinned(true, !this.isMemorySpace())) {
                        pEntry = null;
                    }
                } else if (pEntry.isBlobStoreEntry()) {
                    context.setBlobStoreOpParams(pEntry, null, true);
                    return this._storageAdapter.getEntry(context, entryHolder.getUID(), entryHolder.getClassName(), entryHolder);
                }
            }
            if (pEntry != null) {
                return pEntry.getEntryHolder(this);
            }
        }
        if (!this.isEvictableCachePolicy() || this._isMemorySA) {
            return null;
        }
        if (useOnlyCache) {
            return null;
        }
        if (entryHolder.isTransient()) {
            return null;
        }
        entry = !lockedEntry && context.getPrefetchedNonBlobStoreEntries() != null ? context.getPrefetchedNonBlobStoreEntries().get(entryHolder.getUID()) : this._storageAdapter.getEntry(context, entryHolder.getUID(), entryHolder.getClassName(), entryHolder);
        if (entry == null) {
            return null;
        }
        if (tryInsertToCache && (pEntry = this.safeInsertEntryToCache(context, entry, false, null, lockedEntry, InitialLoadOrigin.NON)) == null) {
            return null;
        }
        return pEntry != null ? pEntry.getEntryHolder(this) : entry;
    }

    public IEntryHolder getEntry(Context context, IEntryHolder entryHolder, boolean tryInsertToCache, boolean lockedEntry) throws SAException {
        return this.getEntry(context, entryHolder, tryInsertToCache, lockedEntry, false);
    }

    public IEntryHolder getEntry(Context context, String uid, String inputClassName, IEntryHolder template, boolean tryInsertToCache, boolean lockedEntry, boolean useOnlyCache) throws SAException {
        IEntryCacheInfo pEntry = this.getPEntryByUid(uid);
        if (pEntry != null) {
            if (lockedEntry ? pEntry.isDeleted() : pEntry.isRecentDelete()) {
                return null;
            }
            if (!this._isMemorySA && useOnlyCache && !lockedEntry && this.isEvictableCachePolicy() && !this.isResidentCacheEntry(pEntry)) {
                return null;
            }
            if (lockedEntry && tryInsertToCache) {
                if (this.isEvictableCachePolicy()) {
                    if (!pEntry.setPinned(true, !this.isMemorySpace())) {
                        pEntry = null;
                    }
                } else if (pEntry.isBlobStoreEntry()) {
                    context.setBlobStoreOpParams(pEntry, null, true);
                    return this._storageAdapter.getEntry(context, uid, inputClassName, template);
                }
            }
            if (pEntry != null) {
                if (pEntry.isBlobStoreEntry()) {
                    boolean indexesPartOnly = template instanceof ITemplateHolder && BlobStoreOperationOptimizations.isConsiderOptimizedForBlobstore(this._engine, context, (ITemplateHolder)template, pEntry);
                    IEntryHolder latestEntryVersion = ((IBlobStoreRefCacheInfo)((Object)pEntry)).getLatestEntryVersion(this, false, null, null, indexesPartOnly);
                    return latestEntryVersion;
                }
                return pEntry.getEntryHolder(this);
            }
        }
        if (!this.isEvictableCachePolicy() || this._isMemorySA) {
            return null;
        }
        if (useOnlyCache) {
            return null;
        }
        if (template != null && template.isTransient()) {
            return null;
        }
        IEntryHolder entry = !lockedEntry && context.getPrefetchedNonBlobStoreEntries() != null ? context.getPrefetchedNonBlobStoreEntries().get(uid) : this._storageAdapter.getEntry(context, uid, inputClassName, template);
        if (entry == null) {
            return null;
        }
        if (tryInsertToCache && (pEntry = this.safeInsertEntryToCache(context, entry, false, null, lockedEntry, InitialLoadOrigin.NON)) == null) {
            return null;
        }
        return pEntry != null ? pEntry.getEntryHolder(this) : entry;
    }

    public List<TemplateInfo> getTemplatesInfo(String className) {
        IServerTypeDesc serverTypeDesc = this._typeManager.getServerTypeDesc(className);
        TypeData typeData = this._typeDataMap.get(serverTypeDesc);
        ArrayList<TemplateInfo> templatesList = new ArrayList<TemplateInfo>(0);
        if (typeData != null) {
            typeData.fillTemplatesInfo(templatesList);
        }
        this.loadDurableNotificationTemplatesInfo(serverTypeDesc, templatesList);
        return templatesList;
    }

    private void loadDurableNotificationTemplatesInfo(IServerTypeDesc typeDesc, List<TemplateInfo> templatesList) {
        String groupName = this.getEngine().generateGroupName();
        if (!StringUtils.hasText(groupName)) {
            return;
        }
        DynamicSourceGroupConfigHolder groupConfig = this.getEngine().getReplicationNode().getAdmin().getSourceGroupConfigHolder(groupName);
        Map<String, IReplicationChannelDataFilter> filters = groupConfig.getConfig().getFilters();
        for (IReplicationChannelDataFilter filter : filters.values()) {
            NotificationReplicationChannelDataFilter notifyFilter;
            if (!(filter instanceof NotificationReplicationChannelDataFilter) || !(notifyFilter = (NotificationReplicationChannelDataFilter)filter).isTemplateOfType(typeDesc.getTypeName())) continue;
            templatesList.add(notifyFilter.createTemplateInfo());
        }
    }

    public ITemplateHolder getTemplate(String uid) {
        return this._templatesManager.getTemplate(uid);
    }

    public IScanListIterator<IEntryCacheInfo> getMatchingMemoryEntriesForScanning(Context context, IServerTypeDesc currServerTypeDesc, ITemplateHolder template, IServerTypeDesc serverTypeDesc) {
        int numOfFields = template.getClassName() != null ? serverTypeDesc.getTypeDesc().getNumOfFixedProperties() : 0;
        TypeData typeData = this._typeDataMap.get(currServerTypeDesc);
        if (this.isBlobStoreCachePolicy() && typeData != null && !typeData.isBlobStoreClass()) {
            context.setDisableBlobStorePreFetching(true);
        }
        if (template.getExtendedMatchCodes() == null) {
            return typeData == null ? null : this.getScannableEntriesMinIndex(context, typeData, numOfFields, template);
        }
        return typeData == null ? null : this.getScannableEntriesMinIndexExtended(context, typeData, numOfFields, template);
    }

    public int removeEntry(Context context, IEntryHolder entryHolder, IEntryCacheInfo pEntry, boolean shouldReplicate, boolean origin, SpaceEngine.EntryRemoveReasonCodes removeReason, boolean disableSAcall) throws SAException {
        RecentDeleteCodes recentDeleteUsage;
        boolean is_writing_xtn = entryHolder.getXidOriginatedTransaction() != null;
        XtnEntry xtnEntry = null;
        boolean updated_recent_deletes = false;
        if (entryHolder.hasShadow()) {
            TypeData typeData = this._typeDataMap.get(entryHolder.getServerTypeDesc());
            if (pEntry == null) {
                pEntry = this.getPEntryByUid(entryHolder.getUID());
            }
            this.consolidateWithShadowEntry(typeData, pEntry, false, false);
        }
        boolean leaseExpiration = removeReason == SpaceEngine.EntryRemoveReasonCodes.LEASE_CANCEL || removeReason == SpaceEngine.EntryRemoveReasonCodes.LEASE_EXPIRED;
        try {
            if (is_writing_xtn) {
                xtnEntry = entryHolder.getXidOriginated();
                boolean bl = is_writing_xtn = xtnEntry != null;
            }
            if (!is_writing_xtn) {
                if (!(!this.useRecentDeletes() || entryHolder.isTransient() || leaseExpiration && this.isCacheExternalDB())) {
                    this.insertToRecentDeletes(entryHolder, this.requiresEvictionReplicationProtection() ? Long.MAX_VALUE : 0L, context.getCommittingXtn());
                    updated_recent_deletes = true;
                }
                if (!disableSAcall) {
                    if (entryHolder.isBlobStoreEntry() && this.isDirectPersistencyEmbeddedtHandlerUsed() && context.isActiveBlobStoreBulk()) {
                        context.setForBulkRemove(entryHolder, removeReason);
                    }
                    this._storageAdapter.removeEntry(context, entryHolder, origin, leaseExpiration, shouldReplicate);
                    if (shouldReplicate && !context.isDelayedReplicationForbulkOpUsed()) {
                        this.handleRemoveEntryReplication(context, entryHolder, removeReason);
                    }
                }
            } else if (xtnEntry.m_AlreadyPrepared) {
                if (!(!this.useRecentDeletes() || entryHolder.isTransient() || leaseExpiration && this.isCacheExternalDB())) {
                    this.insertToRecentDeletes(entryHolder, this.requiresEvictionReplicationProtection() ? Long.MAX_VALUE : 0L, context.getCommittingXtn());
                    updated_recent_deletes = true;
                }
                boolean actualUpdateRedoLog = shouldReplicate;
                if (!xtnEntry.m_SingleParticipant && xtnEntry.getStatus() != XtnStatus.COMMITED && xtnEntry.getStatus() != XtnStatus.COMMITING) {
                    actualUpdateRedoLog = false;
                }
                if (!disableSAcall) {
                    if (entryHolder.isBlobStoreEntry() && this.isDirectPersistencyEmbeddedtHandlerUsed() && context.isActiveBlobStoreBulk()) {
                        context.setForBulkRemove(entryHolder, removeReason);
                    }
                    this._storageAdapter.removeEntry(context, entryHolder, origin, leaseExpiration, actualUpdateRedoLog);
                    if (actualUpdateRedoLog && !context.isDelayedReplicationForbulkOpUsed()) {
                        this.handleRemoveEntryReplication(context, entryHolder, removeReason);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (updated_recent_deletes) {
                this.removeFromRecentDeletes(entryHolder);
            }
            if (ex instanceof SAException) {
                throw (SAException)ex;
            }
            throw new RuntimeException(ex);
        }
        RecentDeleteCodes recentDeleteCodes = recentDeleteUsage = updated_recent_deletes ? RecentDeleteCodes.INSERT_DUMMY : RecentDeleteCodes.NONE;
        if (!entryHolder.isBlobStoreEntry() || context.getBlobStoreBulkInfo() == null || ((IBlobStoreEntryHolder)((Object)entryHolder)).getBulkInfo() == null && !context.getBlobStoreBulkInfo().wasEntryRemovedInChunk(entryHolder.getUID())) {
            this.removeEntryFromCache(entryHolder, false, true, pEntry, recentDeleteUsage);
        }
        if (!context.isSyncReplFromMultipleOperation() && !context.isDisableSyncReplication() && shouldReplicate) {
            return this._engine.performReplication(context);
        }
        return 0;
    }

    public void handleRemoveEntryReplication(Context context, IEntryHolder entryHolder, SpaceEngine.EntryRemoveReasonCodes removeReason) {
        this.handleRemoveEntryReplication(context, entryHolder, removeReason, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoveEntryReplication(Context context, IEntryHolder entryHolder, SpaceEngine.EntryRemoveReasonCodes removeReason, int blobstoreBulkId) {
        IMarker marker = null;
        try {
            IReplicationOutContext replContext = this.getReplicationContext(context);
            this.attachBlobstoreReplicationBulkIdIfNeeded(replContext, blobstoreBulkId);
            this.updateReplicationContext(replContext, context);
            if (removeReason == SpaceEngine.EntryRemoveReasonCodes.LEASE_CANCEL) {
                this._replicationNode.outCancelEntryLease(replContext, entryHolder);
            } else if (removeReason == SpaceEngine.EntryRemoveReasonCodes.LEASE_EXPIRED) {
                this._replicationNode.outEntryLeaseExpired(replContext, entryHolder);
            } else {
                if (this.requiresEvictionReplicationProtection()) {
                    replContext.askForMarker(this.getEvictionPolicyReplicationMembersGroupName());
                }
                this._replicationNode.outRemoveEntry(replContext, entryHolder);
                if (this.requiresEvictionReplicationProtection()) {
                    marker = replContext.getRequestedMarker();
                }
            }
            if (this.requiresEvictionReplicationProtection() && marker != null) {
                this.getEvictionReplicationsMarkersRepository().insert(entryHolder.getUID(), marker, false);
            }
        }
        catch (Throwable throwable) {
            if (this.requiresEvictionReplicationProtection() && marker != null) {
                this.getEvictionReplicationsMarkersRepository().insert(entryHolder.getUID(), marker, false);
            }
            throw throwable;
        }
    }

    public void removeTemplate(Context context, ITemplateHolder template, boolean fromReplication, boolean origin, boolean dontReplicate) {
        this.removeTemplate(context, template, fromReplication, origin, dontReplicate, SpaceEngine.TemplateRemoveReasonCodes.OPERATED_OR_TIMEDOUT);
    }

    public void removeTemplate(Context context, ITemplateHolder template, boolean fromReplication, boolean origin, boolean dontReplicate, SpaceEngine.TemplateRemoveReasonCodes removeReason) {
        template.setDeleted(true);
        if (template.isHasWaitingFor()) {
            RemoveWaitingForInfoSABusPacket packet = new RemoveWaitingForInfoSABusPacket(context.getOperationID(), null, template);
            this._engine.getProcessorWG().enqueueBlocked(packet);
        }
        boolean updateRedoLog = false;
        if (!dontReplicate) {
            if (template.isNotifyTemplate()) {
                boolean replicate = ((NotifyTemplateHolder)template).isReplicateNotify();
                updateRedoLog = this._engine.isReplicated() && !fromReplication && replicate;
            } else {
                updateRedoLog = false;
            }
        }
        if (template.isInExpirationManager()) {
            this._templateExpirationManager.removeTemplate(template);
        }
        this.removeTemplate(context, template, updateRedoLog, origin, removeReason);
    }

    private void removeTemplate(Context context, ITemplateHolder template, boolean updateRedoLog, boolean origin, SpaceEngine.TemplateRemoveReasonCodes removeReason) {
        boolean pureTransient;
        boolean bl = pureTransient = template.isTransient() && !updateRedoLog && origin;
        if (template.isNotifyTemplate() && template.getXidOriginatedTransaction() == null && !pureTransient && (!this._isMemorySA || this._clusterPolicy != null) && updateRedoLog) {
            NotifyTemplateHolder notifyTemplateHolder = (NotifyTemplateHolder)template;
            IReplicationOutContext replCtx = this.getReplicationContext(context);
            this.updateReplicationContext(replCtx, context);
            if (removeReason == SpaceEngine.TemplateRemoveReasonCodes.LEASE_CANCEL) {
                this._replicationNode.outRemoveNotifyTemplate(replCtx, notifyTemplateHolder);
            } else {
                this._replicationNode.outNotifyTemplateLeaseExpired(replCtx, notifyTemplateHolder);
            }
        }
        this.removeTemplateFromCache(template);
        if (template.isNotifyTemplate()) {
            CustomInfo customInfo;
            NotifyTemplateHolder notifyTemplate = (NotifyTemplateHolder)template;
            INotifyDelegatorFilter filter = notifyTemplate.getFilter();
            if (filter != null) {
                try {
                    filter.close();
                }
                catch (Throwable e) {
                    _logger.log(Level.FINE, "closing user filter caused an exception", e);
                }
            }
            if (notifyTemplate.getNotifyInfo().getCustomInfo() != null && (customInfo = notifyTemplate.getNotifyInfo().getCustomInfo()) != null && customInfo.isLocalCacheCustomInfo()) {
                this._localCacheRegistrations.remove(notifyTemplate);
            }
        }
        if (!context.isSyncReplFromMultipleOperation() && updateRedoLog) {
            this._engine.performReplication(context);
        }
    }

    public FifoBackgroundDispatcher getFifoBackgroundDispatcher() {
        return this._fifoBackgroundDispatcher;
    }

    public void makeWaitForInfo(Context context, IEntryHolder entryHolder, ITemplateHolder templateHolder) throws SAException {
        entryHolder.addTemplateWaitingForEntry(templateHolder);
        templateHolder.addEntryWaitingForTemplate(entryHolder);
    }

    public void removeWaitingForInfo(Context context, IEntryHolder entryHolder, ITemplateHolder templateHolder, boolean unpinIfPossible) {
        entryHolder.removeTemplateWaitingForEntry(templateHolder);
        if (!entryHolder.isHasWaitingFor() && !entryHolder.isMaybeUnderXtn()) {
            entryHolder.resetEntryXtnInfo();
        }
        templateHolder.removeEntryWaitingForTemplate(entryHolder);
        if (unpinIfPossible) {
            this.unpinIfNeeded(context, entryHolder, null, null);
        }
    }

    public IEntryHolder associateEntryWithXtn(Context context, IEntryHolder entryHolder, ITemplateHolder template, XtnEntry xtnEntry, IEntryHolder new_content) throws SAException {
        XtnData pXtn = xtnEntry.getXtnData();
        xtnEntry.setOperatedUpon();
        TypeData typeData = this._typeDataMap.get(entryHolder.getServerTypeDesc());
        IEntryCacheInfo pEntry = this.getPEntryByUid(entryHolder.getUID());
        if (!pEntry.isPinned()) {
            throw new RuntimeException("associateEntryWithXtn: internal error- entry uid =" + pEntry.getUID() + " not pinned");
        }
        if (!pXtn.isLockedEntry(pEntry)) {
            this.lockEntry(pXtn, pEntry, context.getOperationID());
        } else {
            this.updateLock(pXtn, pEntry, context.getOperationID(), template.getTemplateOperation());
        }
        switch (template.getTemplateOperation()) {
            case 2: 
            case 3: {
                if (pEntry.getEntryHolder(this).getWriteLockTransaction() != null && pEntry.getEntryHolder(this).getWriteLockTransaction().equals((Object)xtnEntry.m_Transaction)) break;
                if (ReadModifiers.isExclusiveReadLock(template.getOperationModifiers())) {
                    pEntry.getEntryHolder(this).clearReadLockOwners();
                    pEntry.getEntryHolder(this).setWriteLockOwnerAndOperation(xtnEntry, template.getTemplateOperation());
                    break;
                }
                pEntry.getEntryHolder(this).addReadLockOwner(pXtn.getXtnEntry());
                break;
            }
            case 4: 
            case 5: {
                boolean restoreShadowValues = false;
                if (pEntry.getEntryHolder(this).getWriteLockTransaction() != null && pEntry.getEntryHolder(this).hasShadow() && pEntry.getEntryHolder(this).getWriteLockOperation() == 7 && pEntry.getEntryHolder(this).getWriteLockTransaction().equals((Object)xtnEntry.m_Transaction)) {
                    restoreShadowValues = true;
                }
                pEntry.getEntryHolder(this).clearReadLockOwners();
                pEntry.getEntryHolder(this).setWriteLockOwnerAndOperation(xtnEntry, template.getTemplateOperation());
                if (restoreShadowValues) {
                    this.consolidateWithShadowEntry(typeData, pEntry, true, false);
                    pXtn.removeRewrittenEntryIndication(pEntry.getUID());
                }
                pXtn.addToTakenEntriesIfNotInside(pEntry);
                break;
            }
            case 7: {
                pEntry.getEntryHolder(this).clearReadLockOwners();
                boolean newShadow = true;
                if (pEntry.getEntryHolder(this).getWriteLockOperation() == 1 && pEntry.getEntryHolder(this).getWriteLockTransaction() != null && pEntry.getEntryHolder(this).getWriteLockTransaction().equals((Object)xtnEntry.m_Transaction)) {
                    newShadow = false;
                }
                if (pEntry.getEntryHolder(this).getWriteLockOperation() == 7 && pEntry.getEntryHolder(this).getWriteLockTransaction() != null && pEntry.getEntryHolder(this).getWriteLockTransaction().equals((Object)xtnEntry.m_Transaction) && pEntry.getEntryHolder(this).hasShadow()) {
                    newShadow = false;
                }
                if ((pEntry.getEntryHolder(this).getWriteLockOperation() == 4 || pEntry.getEntryHolder(this).getWriteLockOperation() == 5) && pEntry.getEntryHolder(this).getWriteLockTransaction() != null && pEntry.getEntryHolder(this).getWriteLockTransaction().equals((Object)xtnEntry.m_Transaction)) {
                    pXtn.signalRewrittenEntry(pEntry.getUID());
                    pXtn.removeTakenEntry(pEntry);
                }
                if (newShadow) {
                    if (this.getTypeData(pEntry.getEntryHolder(this).getServerTypeDesc()).hasFifoGroupingIndex()) {
                        pXtn.addToEntriesForFifoGroupScan(pEntry.getEntryHolder(this));
                    }
                    ShadowEntryHolder shadowEh = this.createShadowEntry(pEntry, typeData);
                    pEntry.getEntryHolder(this).setWriteLockOwnerOperationAndShadow(xtnEntry, template.getTemplateOperation(), shadowEh);
                }
                pEntry.getEntryHolder(this).setMaybeUnderXtn(true);
                IEntryData new_content_data = new_content.getEntryData();
                pEntry = this.updateEntryInCache(context, pEntry, pEntry.getEntryHolder(this), new_content_data, new_content_data.getExpirationTime(), template.getOperationModifiers());
                if (template.isChange()) {
                    pXtn.setInPlaceUpdatedEntry(pEntry.getEntryHolder(this), template.getMutators());
                    break;
                }
                pXtn.setUpdatedEntry(pEntry.getEntryHolder(this), context.getPartialUpdatedValuesIndicators());
            }
        }
        pEntry.getEntryHolder(this).setMaybeUnderXtn(true);
        return pEntry.getEntryHolder(this);
    }

    private ShadowEntryHolder createShadowEntry(IEntryCacheInfo pmaster, TypeData pType) {
        IEntryHolder master = pmaster.getEntryHolder(this);
        int[] backrefIndexPos = pType.createIndexBackreferenceArray(pmaster, master.getEntryData());
        return !master.isBlobStoreEntry() ? EntryHolderFactory.createShadowEntryHolder(master, pmaster.getBackRefs(), backrefIndexPos, pmaster.getLeaseManagerListRef(), pmaster.getLeaseManagerPosition()) : EntryHolderFactory.createShadowEntryHolder(master, pmaster.getBackRefs(), backrefIndexPos, null, pmaster.getLeaseManagerPosition());
    }

    public IEntryCacheInfo getPEntryByUid(String uid) {
        IEntryCacheInfo pEntry = (IEntryCacheInfo)this._entries.get(uid);
        if (pEntry != null && this.isEvictableCachePolicy() && pEntry.isRemovingOrRemoved()) {
            return null;
        }
        return pEntry;
    }

    public IEntryHolder getEntryByUidFromPureCache(String uid) {
        IEntryCacheInfo pEntry = this.getPEntryByUid(uid);
        return pEntry != null ? pEntry.getEntryHolder(this) : null;
    }

    public boolean isEntryInPureCache(String uid) {
        return this._entries.containsKey(uid);
    }

    public void disconnectEntryFromXtn(Context context, IEntryHolder entryHolder, XtnEntry xtnEntry, boolean xtnEnd) throws SAException {
        IEntryCacheInfo pEntry = this.getPEntryByUid(entryHolder.getUID());
        if (pEntry == null) {
            return;
        }
        XtnData pXtn = xtnEntry.getXtnData();
        if (!xtnEnd) {
            this.removeLockedEntry(pXtn, pEntry);
        }
        if (pEntry.getEntryHolder(this).getWriteLockTransaction() == null || !pEntry.getEntryHolder(this).getWriteLockTransaction().equals((Object)pXtn.getXtn())) {
            pEntry.getEntryHolder(this).removeReadLockOwner(pXtn.getXtnEntry());
        }
        if (pEntry.getEntryHolder(this).getWriteLockTransaction() != null && pEntry.getEntryHolder(this).getWriteLockTransaction().equals((Object)pXtn.getXtn())) {
            pEntry.getEntryHolder(this).resetWriteLockOwner();
        }
        if (xtnEntry == pEntry.getEntryHolder(this).getXidOriginated()) {
            pEntry.getEntryHolder(this).resetXidOriginated();
        }
        pEntry.getEntryHolder(this).setMaybeUnderXtn(pEntry.getEntryHolder(this).anyReadLockXtn() || pEntry.getEntryHolder(this).getWriteLockTransaction() != null);
        if (!pEntry.getEntryHolder(this).isMaybeUnderXtn() && !pEntry.getEntryHolder(this).isHasWaitingFor()) {
            pEntry.getEntryHolder(this).resetEntryXtnInfo();
            if (pEntry.isPinned() && xtnEnd) {
                this.unpinIfNeeded(context, pEntry.getEntryHolder(this), null, pEntry);
            }
        }
    }

    public void prepare(Context context, XtnEntry xtnEntry, boolean supportsTwoPhaseReplication, boolean handleReplication, boolean handleSA) throws SAException {
        boolean needsToBeReplicated;
        if ((this._isMemorySA || this._storageAdapter.isReadOnly()) && !handleReplication) {
            return;
        }
        boolean singleParticipant = xtnEntry.m_SingleParticipant;
        boolean replicationIsRelevant = this._engine.isReplicated() && !xtnEntry.isFromReplication();
        boolean bl = needsToBeReplicated = replicationIsRelevant && (singleParticipant || supportsTwoPhaseReplication && !this.replicateOnePhaseCommit());
        if (!needsToBeReplicated && this._isMemorySA) {
            return;
        }
        context.setFromGateway(xtnEntry.isFromGateway());
        ServerTransaction xtn = xtnEntry.m_Transaction;
        XtnData pXtn = xtnEntry.getXtnData();
        ArrayList<IEntryHolder> pLocked = this.createLockedEntriesList(xtnEntry, pXtn);
        if (this.requiresEvictionReplicationProtection()) {
            xtnEntry.getXtnData().setEntriesForReplicationIn2PCommit(pLocked);
        }
        if (pLocked == null || pLocked.size() == 0) {
            return;
        }
        if (handleSA && !this._isMemorySA) {
            this._storageAdapter.prepare(context, xtn, pLocked, singleParticipant, pXtn.getUpdatedEntries(), needsToBeReplicated);
        }
        if (!handleReplication) {
            return;
        }
        if (needsToBeReplicated) {
            OperationID[] opIDs = this.createOperationIdsArray(pXtn, pLocked);
            boolean[] updateRedoLog = this.createUpdateRedologArray(pLocked);
            IReplicationOutContext replContext = this.getReplicationContext(context);
            this.updateReplicationContextForTransaction(replContext, context, updateRedoLog, pXtn.getUpdatedEntries(), opIDs, xtnEntry);
            if (singleParticipant) {
                if (this.requiresEvictionReplicationProtection()) {
                    replContext.askForMarker(this.getEvictionPolicyReplicationMembersGroupName());
                }
                this._replicationNode.outTransaction(replContext, xtn, pLocked);
                if (this.requiresEvictionReplicationProtection()) {
                    IMarker marker = replContext.getRequestedMarker();
                    this.insertTransactionMarkerToRepository(marker, pLocked, xtnEntry.m_Transaction);
                }
            } else {
                this._replicationNode.outTransactionPrepare(replContext, xtn, pLocked);
            }
            if (this._syncReplicationUsed && singleParticipant && this._clusterPolicy.m_ReplicationPolicy.m_SyncReplPolicy.isHoldTxnLockUntilSyncReplication() && !context.isSyncReplFromMultipleOperation()) {
                this._engine.performReplication(context);
            }
        }
    }

    private boolean replicateOnePhaseCommit() {
        return this._engine.getClusterPolicy().getReplicationPolicy().isReplicateOnePhaseCommit();
    }

    private boolean[] createUpdateRedologArray(ArrayList<IEntryHolder> pLocked) {
        Map<String, IServerTypeDesc> typeTable = this._typeManager.getSafeTypeTable();
        boolean[] updateRedoLog = new boolean[pLocked.size()];
        for (int i = 0; i < pLocked.size(); ++i) {
            IEntryHolder entryHolder = pLocked.get(i);
            if (!this._engine.isReplicated() || entryHolder.getWriteLockTransaction() == null) continue;
            if (this._clusterPolicy.m_ReplicationPolicy.isFullReplication()) {
                updateRedoLog[i] = true;
                continue;
            }
            IServerTypeDesc serverTypeDesc = typeTable.get(entryHolder.getClassName());
            updateRedoLog[i] = serverTypeDesc.getTypeDesc().isReplicable();
        }
        return updateRedoLog;
    }

    private OperationID[] createOperationIdsArray(XtnData pXtn, ArrayList<IEntryHolder> pLocked) {
        OperationID[] opIDs = new OperationID[pLocked.size()];
        for (int i = 0; i < pLocked.size(); ++i) {
            opIDs[i] = pXtn.getOperationID(pLocked.get(i).getUID());
        }
        return opIDs;
    }

    private ArrayList<IEntryHolder> createLockedEntriesList(XtnEntry xtnEntry, XtnData pXtn) {
        ArrayList<ReplicationEntryHolder> pLocked = null;
        IStoredList<IEntryCacheInfo> lockedEntries = pXtn.getLockedEntries();
        if (lockedEntries != null && !lockedEntries.isEmpty()) {
            pLocked = new ArrayList<ReplicationEntryHolder>();
            IStoredListIterator slh = lockedEntries.establishListScan(false);
            while (slh != null) {
                IEntryHolder entryHolder;
                IEntryCacheInfo pEntry = (IEntryCacheInfo)slh.getSubject();
                if (pEntry != null && !(entryHolder = pEntry.getEntryHolder(this)).isDeleted() && entryHolder.getWriteLockOwner() == xtnEntry && entryHolder.getWriteLockOperation() != 2 && entryHolder.getWriteLockOperation() != 3) {
                    pLocked.add(new ReplicationEntryHolder(pEntry.getEntryHolder(this), xtnEntry));
                }
                slh = pXtn.getLockedEntries().next(slh);
            }
        }
        return pLocked;
    }

    public void prePrepare(XtnEntry xtnEntry) {
        XtnData pXtn = xtnEntry.getXtnData();
        IStoredList<IEntryCacheInfo> locked = pXtn.getLockedEntries();
        if (locked != null && !locked.isEmpty()) {
            IStoredListIterator slh = locked.establishListScan(false);
            while (slh != null) {
                IEntryHolder eh;
                IEntryCacheInfo pEntry = (IEntryCacheInfo)slh.getSubject();
                if (!(pEntry == null || (eh = pEntry.getEntryHolder(this)).isDeleted() || eh.isExpired() && !this._leaseManager.isNoReapUnderXtnLeases() && !this._leaseManager.isSlaveLeaseManagerForEntries() || eh.getWriteLockOwner() != xtnEntry || eh.getWriteLockOperation() == 2 || eh.getWriteLockOperation() == 3 || eh.getWriteLockOperation() != 1 && eh.getWriteLockOperation() != 7 && eh.getWriteLockOperation() != 4 && eh.getWriteLockOperation() != 5)) {
                    IEntryCacheInfo pe;
                    if (eh.getWriteLockOperation() == 7 && pXtn.isReWrittenEntry(eh.getUID())) {
                        pe = EntryCacheInfoFactory.createEntryCacheInfo(eh.getShadow().createCopy());
                        pe.getEntryHolder(this).setWriteLockOperation(4, false);
                        pe.getEntryHolder(this).setUID(eh.getUID());
                        pXtn.getNeedNotifyEntries(true).add(pe);
                        pe = EntryCacheInfoFactory.createEntryCacheInfo(eh.createCopy());
                        pe.getEntryHolder(this).setWriteLockOperation(1, false);
                        pXtn.getNeedNotifyEntries(true).add(pe);
                    } else if (eh.getWriteLockOperation() == 7 && (this._templatesManager.anyNotifyUnmatchedTemplates() || this._templatesManager.anyNotifyMatchedTemplates() || this._templatesManager.anyNotifyRematchedTemplates())) {
                        pe = EntryCacheInfoFactory.createEntryCacheInfo(eh.createCopy());
                        IEntryHolder shadowEh = eh.getShadow().createCopy();
                        pe.getEntryHolder(this).setWriteLockOwnerOperationAndShadow(xtnEntry, eh.getWriteLockOperation(), shadowEh);
                        pXtn.getNeedNotifyEntries(true).add(pe);
                    } else {
                        pe = EntryCacheInfoFactory.createEntryCacheInfo(eh.createCopy());
                        pe.getEntryHolder(this).setWriteLockOperation(eh.getWriteLockOperation(), false);
                        pXtn.getNeedNotifyEntries(true).add(pe);
                    }
                }
                slh = pXtn.getLockedEntries().next(slh);
            }
        }
    }

    public void handleUnderXtnUpdate(Context context, ServerTransaction xtn, IEntryHolder eh, boolean isCommitting, XtnData pXtn) {
        IEntryCacheInfo pEntry = this.getPEntryByUid(eh.getUID());
        if (pEntry == null) {
            throw new RuntimeException("handleUnderXtnUpdate:internal error-Entry is null UID=" + eh.getUID());
        }
        if (isCommitting) {
            this.insertToRecentUpdatesIfNeeded(eh, this.requiresEvictionReplicationProtection() ? Long.MAX_VALUE : 0L, context.getCommittingXtn());
        }
        TypeData typeData = this._typeDataMap.get(eh.getServerTypeDesc());
        this.consolidateWithShadowEntry(typeData, pEntry, !isCommitting, false);
    }

    public void preCommit(Context context, XtnEntry xtnEntry, boolean supportsTwoPhaseReplication) {
        boolean needsToBeReplicated;
        boolean bl = needsToBeReplicated = this._engine.isReplicated() && !xtnEntry.isFromReplication() && (this.replicateOnePhaseCommit() || !supportsTwoPhaseReplication);
        if (xtnEntry.m_SingleParticipant || !needsToBeReplicated) {
            return;
        }
        ServerTransaction xtn = xtnEntry.m_Transaction;
        XtnData pXtn = xtnEntry.getXtnData();
        ArrayList<IEntryHolder> pLocked = this.createLockedEntriesList(xtnEntry, pXtn);
        if (pLocked == null || pLocked.size() == 0) {
            return;
        }
        OperationID[] opIDs = this.createOperationIdsArray(pXtn, pLocked);
        boolean[] updateRedoLog = this.createUpdateRedologArray(pLocked);
        IReplicationOutContext replContext = this.getReplicationContext(context);
        this.updateReplicationContextForTransaction(replContext, context, updateRedoLog, pXtn.getUpdatedEntries(), opIDs, xtnEntry);
        if (this.requiresEvictionReplicationProtection()) {
            replContext.askForMarker(this.getEvictionPolicyReplicationMembersGroupName());
        }
        this._replicationNode.outTransaction(replContext, xtn, pLocked);
        if (this.requiresEvictionReplicationProtection()) {
            IMarker marker = replContext.getRequestedMarker();
            this.insertTransactionMarkerToRepository(marker, pLocked, xtnEntry.m_Transaction);
        }
        if (this._syncReplicationUsed && this._clusterPolicy.m_ReplicationPolicy.m_SyncReplPolicy.isHoldTxnLockUntilSyncReplication() && !context.isSyncReplFromMultipleOperation()) {
            this._engine.performReplication(context);
        }
    }

    private void insertTransactionMarkerToRepository(IMarker marker, List<IEntryHolder> pLocked, ServerTransaction transaction) {
        if (pLocked == null) {
            return;
        }
        for (IEntryHolder entryHolder : pLocked) {
            int op;
            if (entryHolder == null || entryHolder.getWriteLockTransaction() == null || !entryHolder.getWriteLockTransaction().equals((Object)transaction) || (op = entryHolder.getWriteLockOperation()) != 1 && op != 7 && op != 4 && op != 5) continue;
            this.getEvictionReplicationsMarkersRepository().insert(entryHolder.getUID(), marker, false);
        }
    }

    public void commit(Context context, XtnEntry xtnEntry, boolean singleParticipant, boolean anyUpdates, boolean supportsTwoPhaseReplication) throws SAException {
        boolean needsToBeReplicated;
        boolean call_sa;
        ServerTransaction xtn = xtnEntry.m_Transaction;
        boolean bl = call_sa = !singleParticipant || !this._engine.isTransactionalSA();
        if (call_sa && !this._isMemorySA) {
            this._storageAdapter.commit(xtn, anyUpdates);
        }
        boolean bl2 = needsToBeReplicated = this._engine.isReplicated() && !xtnEntry.isFromReplication();
        if (xtnEntry.m_SingleParticipant || !needsToBeReplicated) {
            return;
        }
        context.setFromGateway(xtnEntry.isFromGateway());
        if (!this.replicateOnePhaseCommit() && supportsTwoPhaseReplication) {
            int numOfChangesUnderTransaction = xtnEntry.getNumOfChangesUnderTransaction(this);
            if (numOfChangesUnderTransaction == 0) {
                return;
            }
            IReplicationOutContext replContext = this.getReplicationContext(context);
            this.updateReplicationContext(replContext, context);
            if (this.requiresEvictionReplicationProtection()) {
                replContext.askForMarker(this.getEvictionPolicyReplicationMembersGroupName());
            }
            this._replicationNode.outTransactionCommit(replContext, xtn);
            if (this.requiresEvictionReplicationProtection()) {
                IMarker marker = replContext.getRequestedMarker();
                this.insertTransactionMarkerToRepository(marker, xtnEntry.getXtnData().getEntriesForReplicationIn2PCommit(), xtnEntry.m_Transaction);
            }
            if (this._syncReplicationUsed && this._clusterPolicy.m_ReplicationPolicy.m_SyncReplPolicy.isHoldTxnLockUntilSyncReplication() && !context.isSyncReplFromMultipleOperation()) {
                this._engine.performReplication(context);
            }
        }
    }

    public void rollback(Context context, XtnEntry xtnEntry, boolean alreadyPrepared, boolean anyUpdates, boolean supportsTwoPhaseReplication) throws SAException {
        boolean useRedoLog;
        ServerTransaction xtn = xtnEntry.m_Transaction;
        if (alreadyPrepared && !this._isMemorySA) {
            this._storageAdapter.rollback(xtn, anyUpdates);
        }
        boolean bl = useRedoLog = this._engine.isReplicated() && !xtnEntry.isFromReplication();
        if (xtnEntry.m_SingleParticipant || !supportsTwoPhaseReplication || !alreadyPrepared || !useRedoLog) {
            return;
        }
        int numOfChangesUnderTransaction = xtnEntry.getNumOfChangesUnderTransaction(this);
        if (numOfChangesUnderTransaction == 0) {
            return;
        }
        IReplicationOutContext replContext = this.getReplicationContext(context);
        this.updateReplicationContext(replContext, context);
        this._replicationNode.outTransactionAbort(replContext, xtn);
        this._engine.performReplication(context);
    }

    public void extendLeasePeriod(Context context, long time, long original_time, String uid, String classname, int objectType, boolean shouldReplicate, boolean origin) {
        IObjectInfo<IEntryCacheInfo> leaseCacheInfo = null;
        IEntryHolder leasedObject = null;
        switch (objectType) {
            case 1: {
                IEntryHolder eh;
                IEntryCacheInfo pEntry;
                leaseCacheInfo = pEntry = this.getPEntryByUid(uid);
                leasedObject = eh = pEntry.getEntryHolder(this);
                if (shouldReplicate) {
                    IReplicationOutContext replContext = this.getReplicationContext(context);
                    this.updateReplicationContext(replContext, context);
                    this._replicationNode.outExtendEntryLeasePeriod(replContext, eh);
                }
                pEntry.getEntryHolder(this).setExpirationTime(time);
                break;
            }
            default: {
                TemplateCacheInfo pTemplate = this._templatesManager.get(uid);
                leaseCacheInfo = pTemplate;
                if (pTemplate.m_TemplateHolder.isNotifyTemplate() && pTemplate.m_TemplateHolder.getXidOriginatedTransaction() == null && shouldReplicate) {
                    IReplicationOutContext replContext = this.getReplicationContext(context);
                    this.updateReplicationContext(replContext, context);
                    this._replicationNode.outExtendNotifyTemplateLeasePeriod(replContext, (NotifyTemplateHolder)pTemplate.m_TemplateHolder);
                }
                leasedObject = pTemplate.m_TemplateHolder;
                pTemplate.m_TemplateHolder.setExpirationTime(time);
            }
        }
        this._leaseManager.reRegisterLease((ILeasedEntryCacheInfo)((Object)leaseCacheInfo), leasedObject, original_time, time, objectType);
    }

    public Object findTemplatesByIndex(Context context, IServerTypeDesc typeDesc, IEntryHolder entry, MatchTarget matchTarget) {
        TypeData typeData = this._typeDataMap.get(typeDesc);
        if (typeData == null) {
            return null;
        }
        return this.findTemplatesByIndex(context, typeData, entry, matchTarget);
    }

    public IEntryHolder getEntryFromCacheHolder(IEntryCacheInfo pt) {
        return pt.getEntryHolder(this);
    }

    public IEntryCacheInfo getEntryCacheInfo(IEntryHolder eh) {
        return this.getPEntryByUid(eh.getUID());
    }

    public TemplateCacheInfo getTemplateCacheInfo(ITemplateHolder th) {
        return this._templatesManager.get(th.getUID());
    }

    public ISAdapterIterator<IEntryHolder> makeEntriesIter(Context context, ITemplateHolder template, IServerTypeDesc serverTypeDesc, long SCNFilter, long leaseFilter, boolean memoryOnly, boolean transientOnly) throws SAException {
        return new EntriesIter(context, template, serverTypeDesc, this, SCNFilter, leaseFilter, memoryOnly, transientOnly);
    }

    public ISAdapterIterator<IEntryHolder> makeEntriesIter(Context context, ITemplateHolder template, IServerTypeDesc serverTypeDesc, long SCNFilter, long leaseFilter, boolean memoryOnly) throws SAException {
        return new EntriesIter(context, template, serverTypeDesc, this, SCNFilter, leaseFilter, memoryOnly, false);
    }

    public IScanListIterator makeScanableEntriesIter(Context context, ITemplateHolder template, IServerTypeDesc serverTypeDesc, long SCNFilter, long leaseFilter, boolean memoryOnly) throws SAException {
        EntriesIter ei = new EntriesIter(context, template, serverTypeDesc, this, SCNFilter, leaseFilter, memoryOnly, false);
        return new ScanListSAIterator(ei);
    }

    public ISAdapterIterator<ITemplateHolder> makeUnderXtnTemplatesIter(Context context, XtnEntry xtnEntry) throws SAException {
        try {
            return new UnderXtnTemplatesIter(context, xtnEntry, MatchTarget.READ_TAKE_UPDATE, this);
        }
        catch (NullIteratorException ex) {
            return null;
        }
    }

    public ISAdapterIterator makeUnderXtnEntriesIter(Context context, XtnEntry xtnEntry, int selectType) throws SAException {
        try {
            return new UnderXtnEntriesIter(context, xtnEntry, selectType, this, false);
        }
        catch (NullIteratorException ex) {
            return null;
        }
    }

    public ISAdapterIterator makeUnderXtnEntriesIter(Context context, XtnEntry xtnEntry, int selectType, boolean returnPentries) throws SAException {
        XtnData pXtn = xtnEntry.getXtnData();
        IStoredList<IEntryCacheInfo> entries = pXtn.getUnderXtnEntries(selectType);
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        try {
            return new UnderXtnEntriesIter(context, xtnEntry, selectType, this, returnPentries);
        }
        catch (NullIteratorException ex) {
            return null;
        }
    }

    public int count(Context context, ITemplateHolder template, XtnEntry xtnFilter) throws SAException {
        EntriesIter iter;
        boolean memoryOnly = this.isCacheExternalDB() || this._isMemorySA || this.isResidentEntriesCachePolicy() || template.isMemoryOnlySearch();
        boolean slaveLeaseManager = this._leaseManager.isSlaveLeaseManagerForEntries();
        if (xtnFilter != null && !xtnFilter.m_Active) {
            throw new SAException("Transaction " + xtnFilter + " is not active");
        }
        IServerTypeDesc serverTypeDesc = this._typeManager.getServerTypeDesc(template.getClassName());
        if (this.isblobStoreDataSpace()) {
            context.setBlobStoreTryNonPersistentOp(true);
            context.setOptimizedBlobStoreReadEnabled(template.isOptimizedForBlobStoreOp(this));
        }
        if ((iter = (EntriesIter)this.makeEntriesIter(context, template, serverTypeDesc, 0L, SystemTime.timeMillis(), memoryOnly)) == null) {
            return 0;
        }
        iter.setNotRefreshCache();
        CountInfo countInfo = new CountInfo();
        HashSet<String> processedResults = new HashSet<String>();
        while (true) {
            boolean useShadow;
            IEntryHolder eh = null;
            Object res = iter.nextObject();
            if (res == null) break;
            if (iter.isBringCacheInfoOnly()) {
                IEntryCacheInfo pEntry = iter.getCurrentEntryCacheInfo();
                if (pEntry.isDeleted()) continue;
                if (!pEntry.isBlobStoreEntry()) {
                    eh = pEntry.getEntryHolder(this);
                    if (eh == null) {
                        continue;
                    }
                } else {
                    eh = iter.getCurrentEntryHolder();
                    if (eh == null) {
                        if (!processedResults.add(pEntry.getUID())) continue;
                        countInfo.incSaCount();
                        continue;
                    }
                }
            } else {
                eh = iter.getCurrentEntryHolder();
            }
            if (eh.isDeleted()) continue;
            XtnStatus writelockXtnsSatus = XtnStatus.UNUSED;
            if (!memoryOnly && context.getLastMatchResult() == MatchResult.NONE) {
                this._engine.getTemplateScanner().match(context, eh, template);
                if (context.getLastMatchResult() == MatchResult.NONE) continue;
            }
            ITransactionalEntryData entryData = context.getLastRawMatchSnapshot();
            XtnEntry writeLock = null;
            writeLock = entryData.getWriteLockOwner();
            if (writeLock != null) {
                writelockXtnsSatus = writeLock.getStatus();
            }
            boolean useMaster = context.getLastMatchResult() == MatchResult.MASTER_AND_SHADOW || context.getLastMatchResult() == MatchResult.MASTER;
            boolean bl = useShadow = context.getLastMatchResult() == MatchResult.MASTER_AND_SHADOW || context.getLastMatchResult() == MatchResult.SHADOW;
            if (!processedResults.add(eh.getUID())) continue;
            if (useMaster) {
                this.count_entry(context, countInfo, template, entryData, xtnFilter, writeLock, memoryOnly, false, writelockXtnsSatus, slaveLeaseManager);
            }
            if (!useShadow) continue;
            this.count_entry(context, countInfo, template, entryData, xtnFilter, writeLock, memoryOnly, true, writelockXtnsSatus, slaveLeaseManager);
        }
        iter.close();
        return countInfo.getSaCount();
    }

    private void count_entry(Context context, CountInfo countInfo, ITemplateHolder template, ITransactionalEntryData ehData, XtnEntry xtnFilter, XtnEntry xtnWriteLock, boolean memoryOnly, boolean original_shadow, XtnStatus writelockXtnsSatus, boolean slaveLeaseManager) {
        int writeLockOperation;
        int n = writeLockOperation = xtnWriteLock != null ? ehData.getWriteLockOperation() : 0;
        if (ehData.isExpired() && !slaveLeaseManager) {
            return;
        }
        if (xtnWriteLock == null && !original_shadow) {
            countInfo.incSaCount();
            return;
        }
        if (xtnFilter != null && xtnFilter == xtnWriteLock) {
            if (writeLockOperation != 4 && writeLockOperation != 5 && !original_shadow) {
                countInfo.incSaCount();
            }
            if (!memoryOnly) {
                switch (writeLockOperation) {
                    case 1: {
                        countInfo.incAddedToPersistCount();
                        break;
                    }
                    case 4: 
                    case 5: {
                        countInfo.incSubFromPersistCount();
                        break;
                    }
                    case 7: {
                        if (original_shadow) {
                            countInfo.incSubFromPersistCount();
                            break;
                        }
                        countInfo.incAddedToPersistCount();
                    }
                }
            }
            return;
        }
        XtnStatus xtnEntryStatus = xtnWriteLock != null ? writelockXtnsSatus : XtnStatus.UNUSED;
        boolean useDirtyRead = this._engine.indicateDirtyRead(template);
        boolean useReadCommitted = template.isReadCommittedRequested();
        if (original_shadow) {
            if (!useReadCommitted) {
                if (!memoryOnly) {
                    countInfo.incSubFromPersistCount();
                }
            } else {
                countInfo.incSaCount();
            }
            return;
        }
        if (writeLockOperation == 1) {
            if (xtnEntryStatus == XtnStatus.COMMITED || xtnEntryStatus == XtnStatus.COMMITING || xtnEntryStatus == XtnStatus.PREPARED && xtnWriteLock.m_SingleParticipant) {
                countInfo.incSaCount();
                return;
            }
            if (useDirtyRead) {
                countInfo.incSaCount();
                if (!memoryOnly) {
                    countInfo.incAddedToPersistCount();
                }
            }
            return;
        }
        if (writeLockOperation == 4 || writeLockOperation == 5) {
            if (xtnEntryStatus == XtnStatus.ROLLED || xtnEntryStatus == XtnStatus.ROLLING) {
                countInfo.incSaCount();
                return;
            }
            if (useDirtyRead || useReadCommitted) {
                countInfo.incSaCount();
            } else if (!memoryOnly) {
                countInfo.incSubFromPersistCount();
            }
            return;
        }
        if (writeLockOperation == 7) {
            if (useReadCommitted) {
                if (ehData.getOtherUpdateUnderXtnEntry() == null) {
                    countInfo.incSaCount();
                }
                return;
            }
            if (xtnEntryStatus == XtnStatus.COMMITED || xtnEntryStatus == XtnStatus.COMMITING || xtnEntryStatus == XtnStatus.PREPARED && xtnWriteLock.m_SingleParticipant) {
                countInfo.incSaCount();
                return;
            }
            if ((xtnEntryStatus == XtnStatus.ROLLED || xtnEntryStatus == XtnStatus.ROLLING) && ehData.getOtherUpdateUnderXtnEntry() == null) {
                countInfo.incSaCount();
                return;
            }
            if (useDirtyRead) {
                countInfo.incSaCount();
            }
            if (memoryOnly) {
                return;
            }
            if (useDirtyRead) {
                countInfo.incAddedToPersistCount();
            }
            return;
        }
        if (writeLockOperation == 2 || writeLockOperation == 3) {
            if (!xtnWriteLock.m_Active) {
                countInfo.incSaCount();
                return;
            }
            if (useDirtyRead || useReadCommitted) {
                countInfo.incSaCount();
            } else if (!memoryOnly) {
                countInfo.incSubFromPersistCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropClass(IServerTypeDesc typeDesc) {
        TypeData typeData = this._typeDataMap.get(typeDesc);
        if (typeData != null) {
            Context context = null;
            try {
                context = this.getCacheContext();
                this.clearEntries(typeData, context);
                this.clearTemplates(typeDesc.getTypeName());
                this._typeDataMap.remove(typeDesc);
            }
            catch (SAException ex) {
                JSpaceUtilities.throwEngineInternalSpaceException(ex.getMessage(), ex);
            }
            finally {
                this.freeCacheContext(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void clearEntries(TypeData typeData, Context context) throws SAException {
        while (true) {
            block34: {
                block33: {
                    if ((oi = typeData.getEntries().getHead()) == null) {
                        return;
                    }
                    pEntry = oi.getSubject();
                    if (pEntry == null) {
                        typeData.getEntries().remove(oi);
                        continue;
                    }
                    entry = pEntry.getEntryHolder(this);
                    if (entry.isDeleted()) continue;
                    entryLock = null;
                    templateLock = null;
                    var8_8 = entryLock = this.getLockManager().getLockObject(pEntry.getEntryHolder(this));
                    // MONITORENTER : var8_8
                    original = entry;
                    entry = this.getEntry(context, entry, true, true, true);
                    if (entry == null) {
                        // MONITOREXIT : var8_8
                        if (entryLock != null) {
                            this.getLockManager().freeLockObject(entryLock);
                        }
                        entryLock = null;
                        continue;
                    }
                    if (!this.isblobStoreDataSpace()) break block33;
                    ** if (entry.isSameEntryInstance((IEntryHolder)original)) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        // MONITOREXIT : var8_8
                        if (entryLock != null) {
                            this.getLockManager().freeLockObject(entryLock);
                        }
                        entryLock = null;
                        continue;
                    }
lbl-1000:
                    // 1 sources

                    {
                        break block34;
                    }
                }
                if (entryLock.isLockSubject() && entry != pEntry.getEntryHolder(this)) {
                    // MONITOREXIT : var8_8
                    if (entryLock != null) {
                        this.getLockManager().freeLockObject(entryLock);
                    }
                    entryLock = null;
                    continue;
                }
            }
            try {
                block35: {
                    pEntry = this.getEntryCacheInfo(entry);
                    try {
                        if (pEntry.getEntryHolder(this).getWriteLockOwner() != null) {
                            this.disconnectEntryFromXtn(context, entry, entry.getWriteLockOwner(), false);
                        }
                        if ((readLockOwner = entry.getReadLockOwners()) != null) {
                            while (readLockOwner.size() > 0) {
                                xtn = readLockOwner.iterator().next();
                                this.disconnectEntryFromXtn(context, entry, xtn, false);
                            }
                        }
                    }
                    catch (SAException ex) {
                        if (!CacheManager._logger.isLoggable(Level.FINE)) break block35;
                        CacheManager._logger.log(Level.FINE, ex.toString(), ex);
                    }
                }
                if (entry.hasShadow()) {
                    this.consolidateWithShadowEntry(typeData, pEntry, false, false);
                }
                entry.setDeleted(true);
                this.removeEntryFromCache(entry);
                waitingForTemplates = entry.getCopyOfTemplatesWaitingForEntry();
                if (waitingForTemplates != null) {
                    for (ITemplateHolder template : waitingForTemplates) {
                        templateLock = this.getLockManager().getLockObject(template, false);
                        try {
                            var13_14 = templateLock;
                            // MONITORENTER : var13_14
                            template.removeEntryWaitingForTemplate(entry);
                            // MONITOREXIT : var13_14
                        }
                        finally {
                            if (templateLock != null) {
                                this.getLockManager().freeLockObject(templateLock);
                            }
                            templateLock = null;
                        }
                    }
                }
                // MONITOREXIT : var8_8
                continue;
            }
            catch (Throwable var17_16) {
                throw var17_16;
            }
            finally {
                if (entryLock != null) {
                    this.getLockManager().freeLockObject(entryLock);
                }
                entryLock = null;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTemplates(String className) {
        ILockObject templateLock = null;
        Enumeration<String> keys = this._templatesManager.getAllTemplatesKeys();
        while (keys.hasMoreElements()) {
            TemplateCacheInfo pt = this._templatesManager.get(keys.nextElement());
            ITemplateHolder th = pt.m_TemplateHolder;
            if (th.getClassName() == null || !th.getClassName().equals(className)) continue;
            templateLock = this.getLockManager().getLockObject(th, false);
            try {
                ILockObject iLockObject = templateLock;
                synchronized (iLockObject) {
                    block9: {
                        if (!th.isDeleted()) break block9;
                        continue;
                    }
                    th.setDeleted(true);
                    this.removeTemplateFromCache(th);
                }
            }
            finally {
                if (templateLock == null) continue;
                this.getLockManager().freeLockObject(templateLock);
            }
        }
    }

    public TypeDataFactory getTypeDataFactory() {
        return this._typeDataFactory;
    }

    public TypeData getTypeData(IServerTypeDesc typeDesc) {
        return this._typeDataMap.get(typeDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void reindexTypeEntries(TypeData updatedTypeData, boolean indexAddition) {
        if (!indexAddition) {
            throw new RuntimeException("dropindex not supported");
        }
        IStoredList<IEntryCacheInfo> entriesList = updatedTypeData.getEntries();
        IStoredListIterator pos = null;
        Context context = this.getCacheContext();
        try {
            pos = entriesList.establishListScan(true);
            while (pos != null) {
                block28: {
                    IEntryHolder entry;
                    IEntryCacheInfo pEntry = (IEntryCacheInfo)pos.getSubject();
                    if (!(pEntry == null || this.isEvictableCachePolicy() && pEntry.isRemoving() || (entry = pEntry.getEntryHolder(this)).isDeleted() || pEntry.isRecentDelete())) {
                        block27: {
                            boolean needUnpin;
                            block26: {
                                ILockObject entryLock = this.getLockManager().getLockObject(entry);
                                needUnpin = false;
                                ILockObject iLockObject = entryLock;
                                // MONITORENTER : iLockObject
                                try {
                                    if (entry.isDeleted()) {
                                    }
                                    if (!this.isEvictableCachePolicy()) break block26;
                                    if (pEntry.setPinned(true, true)) {
                                        needUnpin = true;
                                        break block27;
                                    }
                                    if (entryLock != null) {
                                        this.getLockManager().freeLockObject(entryLock);
                                    }
                                    break block28;
                                }
                                catch (SAException ex) {
                                    if (!_logger.isLoggable(Level.SEVERE)) throw new RuntimeException("Reindex problem: " + ex);
                                    _logger.log(Level.SEVERE, "Reindex entry problem uid=" + entry.getUID(), ex);
                                    throw new RuntimeException("Reindex problem: " + ex);
                                }
                                finally {
                                    if (needUnpin) {
                                        this.unpinIfNeeded(context, entry, null, null);
                                    }
                                }
                            }
                            if (entry.isBlobStoreEntry()) {
                                entry = this.getEntry(context, entry, true, true);
                                needUnpin = true;
                            }
                        }
                        TypeDataIndex.reindexEntry(this, pEntry, updatedTypeData);
                        // MONITOREXIT : iLockObject
                    }
                }
                pos = entriesList.next(pos);
            }
            return;
        }
        finally {
            entriesList.freeSLHolder(pos);
            this.freeCacheContext(context);
        }
    }

    public IEntryCacheInfo safeInsertEntryToCache(Context context, IEntryHolder entryHolder, boolean newEntry, TypeData pType, boolean pin, InitialLoadOrigin fromInitialLoad) {
        this._engine.getMemoryManager().monitorMemoryUsage(true);
        return this.insertEntryToCache(context, entryHolder, newEntry, pType, pin, fromInitialLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IEntryCacheInfo insertEntryToCache(Context context, IEntryHolder entryHolder, boolean newEntry, TypeData typeData, boolean pin, InitialLoadOrigin fromInitialLoad) {
        if (typeData == null) {
            typeData = this._typeDataMap.get(entryHolder.getServerTypeDesc());
        }
        BlobStoreRefEntryCacheInfo pEntry = !entryHolder.isBlobStoreEntry() ? EntryCacheInfoFactory.createEntryCacheInfo(entryHolder, typeData.numberOfBackRefs(), pin, this.getEngine()) : ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart();
        context.setWriteResult(null);
        try {
            boolean fifo_notification_for_nonfifo;
            if (newEntry) {
                entryHolder.setunStable(true);
            }
            boolean consider_fifo = (newEntry || fromInitialLoad == InitialLoadOrigin.FROM_NON_BLOBSTORE) && typeData.isFifoSupport();
            boolean bl = fifo_notification_for_nonfifo = newEntry && !typeData.isFifoSupport() && context.getNotifyNewEntry() != null && this._templatesManager.anyNotifyFifoForNonFifoTypePerOperation(entryHolder.getServerTypeDesc(), 1);
            if (fromInitialLoad == InitialLoadOrigin.NON && (consider_fifo || fifo_notification_for_nonfifo)) {
                boolean nofify_fifo;
                boolean bl2 = nofify_fifo = fifo_notification_for_nonfifo || this._templatesManager.anyNotifyFifoWriteTemplates() && context.getNotifyNewEntry() != null;
                if (nofify_fifo) {
                    context.setRecentFifoObject(new FifoBackgroundRequest(context.getOperationID(), true, !fifo_notification_for_nonfifo, entryHolder, null, context.isFromReplication(), 1, entryHolder.getXidOriginatedTransaction(), context.getNotifyNewEntry()));
                } else {
                    context.setRecentFifoObject(new FifoBackgroundRequest(context.getOperationID(), false, true, entryHolder, null, context.isFromReplication(), 1, entryHolder.getXidOriginatedTransaction(), null));
                }
            }
            if (consider_fifo || entryHolder.isBlobStoreEntry() && newEntry && typeData.getFifoGroupingIndex() != null) {
                typeData.setFifoOrderFieldsForEntry(entryHolder);
            }
            IEntryCacheInfo iEntryCacheInfo = this.internalInsertEntryToCache(context, entryHolder, newEntry, typeData, pEntry, pin);
            return iEntryCacheInfo;
        }
        finally {
            if (newEntry) {
                entryHolder.setunStable(false);
            }
        }
    }

    public boolean forceSpaceIdIndexIfEqual() {
        return this._forceSpaceIdIndexIfEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeOffHeapCache() {
        AbstractMemoryPool memoryPool;
        AbstractMemoryPool abstractMemoryPool = memoryPool = this.hasBlobStoreOffHeapCache() ? this.getBlobStoreStorageHandler().getOffHeapCache() : this.getBlobStoreStorageHandler().getOffHeapStore();
        if (memoryPool != null && memoryPool.getUsedBytes() == 0L) {
            return;
        }
        Context context = null;
        try {
            long count;
            context = this.getCacheContext();
            if (memoryPool.isOffHeap()) {
                for (IServerTypeDesc serverTypeDesc : this.getTypeManager().getSafeTypeTable().values()) {
                    IScanListIterator<IEntryCacheInfo> entriesIter;
                    if (serverTypeDesc.isRootType() || serverTypeDesc.getTypeDesc().isInactive() || !serverTypeDesc.getTypeDesc().isBlobstoreEnabled() || (entriesIter = this.getTypeData(serverTypeDesc).scanTypeEntries()) == null) continue;
                    try {
                        while (entriesIter.hasNext()) {
                            IEntryCacheInfo entry = entriesIter.next();
                            if (entry == null || !entry.isBlobStoreEntry()) continue;
                            ((IBlobStoreRefCacheInfo)((Object)entry)).freeOffHeap(this, memoryPool);
                        }
                        entriesIter.releaseScan();
                    }
                    catch (SAException ex) {
                        _logger.log(Level.WARNING, "caught exception while cleaning offheap entries during shutdown", ex);
                    }
                }
            } else if (memoryPool.isPmem()) {
                memoryPool.close();
            }
            if (_logger.isLoggable(Level.WARNING) && memoryPool != null && (count = memoryPool.getUsedBytes()) != 0L) {
                _logger.log(Level.WARNING, "offheap used bytes still consumes " + count + " bytes");
            }
        }
        finally {
            if (context != null) {
                this.freeCacheContext(context);
            }
        }
    }

    public BlobStoreStatistics getBlobStoreStatistics() {
        BlobStoreStorageStatistics snapshot;
        if (!this.isBlobStoreCachePolicy()) {
            return null;
        }
        BlobStoreStatisticsImpl result = new BlobStoreStatisticsImpl();
        result.setCacheSize(this._blobStoreInternalCache.getCacheSize());
        result.setCacheHitCount(this._blobStoreInternalCache.getHitCount());
        result.setCacheMissCount(this._blobStoreInternalCache.getMissCount());
        result.setHotDataCacheMissCount(this._blobStoreInternalCache.getHotDataCacheMiss());
        if (this._blobStoreStorageHandler.getOffHeapCache() != null) {
            result.setOffHeapCacheUsedBytes(this._blobStoreStorageHandler.getOffHeapCache().getUsedBytes());
        }
        if ((snapshot = this._blobStoreStorageHandler.getStorageStatistics()) != null) {
            result.setStorageStatistics(new ArrayList<BlobStoreStorageStatistics>(1));
            result.getStorageStatistics().add(snapshot);
        }
        return result;
    }

    private void validateEntryCanBeWrittenToCache(IEntryHolder entryHolder) {
        ITypeDesc typeDescriptor = entryHolder.getServerTypeDesc().getTypeDesc();
        if (!entryHolder.isTransient() && typeDescriptor.isFifoSupported() && this.isEvictableCachePolicy() && (this.isCacheExternalDB() || this.isClusteredExternalDBEnabled())) {
            throw new SpaceMetadataException("Fifo class [" + typeDescriptor.getTypeName() + "] is not supported by space with LRU cache and external data source.");
        }
    }

    /*
     * Exception decompiling
     */
    IEntryCacheInfo internalInsertEntryToCache(Context context, IEntryHolder entryHolder, boolean newEntry, TypeData typeData, IEntryCacheInfo pEntry, boolean pin) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void insertEntryReferences(Context context, IEntryCacheInfo pEntry, TypeData pType, boolean applySequenceNumber) {
        context.clearNumOfIndexesInserted();
        IEntryData entryData = pEntry.getEntryHolder(this).getEntryData();
        if (pType.getFifoGroupingIndex() != null) {
            pEntry.setMainListBackRef(((ConcurrentSegmentedStoredList)pType.getEntries()).add(pEntry, pType.getFifoGroupingIndex().getIndexValue(entryData)));
        } else {
            pEntry.setMainListBackRef(pType.getEntries().add(pEntry));
        }
        int sequenceNumPlaceHolderPos = 0;
        if (pType.hasIndexes()) {
            int indexBuildNumber = 0;
            TypeDataIndex[] indexes = pType.getIndexes();
            for (TypeDataIndex index : indexes) {
                if (pType.disableIdIndexForEntries(index)) continue;
                if (applySequenceNumber && index == pType.getSequenceNumberIndex()) {
                    if (pEntry.getBackRefs() != null) {
                        pEntry.getBackRefs().add(TypeDataIndex._DummyOI);
                        sequenceNumPlaceHolderPos = pEntry.getBackRefs().size() - 1;
                        if (index.isExtendedIndex()) {
                            pEntry.getBackRefs().add(TypeDataIndex._DummyOI);
                        }
                    } else {
                        sequenceNumPlaceHolderPos = -1;
                    }
                } else {
                    index.insertEntryIndexedField(pEntry, index.getIndexValue(entryData), pType);
                }
                if (pType.supportsDynamicIndexing() && index.getIndexCreationNumber() > indexBuildNumber) {
                    indexBuildNumber = index.getIndexCreationNumber();
                }
                context.incrementNumOfIndexesInserted();
            }
            if (pType.supportsDynamicIndexing() && indexBuildNumber > 0 && indexBuildNumber > pEntry.getLatestIndexCreationNumber()) {
                pEntry.setLatestIndexCreationNumber(indexBuildNumber);
            }
            for (QueryExtensionIndexManagerWrapper queryExtensionIndexManager : pType.getForeignQueriesHandlers()) {
                queryExtensionIndexManager.insertEntry(new SpaceServerEntryImpl(pEntry, this), false);
            }
        }
        if (applySequenceNumber) {
            pEntry.getEntryHolder(this).getEntryData().setFixedPropertyValue(pEntry.getEntryHolder(this).getServerTypeDesc().getTypeDesc().getSequenceNumberFixedPropertyID(), pType.getSequenceNumberGenerator().getNext());
        } else if (pType.hasSequenceNumber() && !this._engine.isLocalCache()) {
            pType.getSequenceNumberGenerator().updateIfGreater((Long)pEntry.getEntryHolder(this).getEntryData().getFixedPropertyValue(pEntry.getEntryHolder(this).getServerTypeDesc().getTypeDesc().getSequenceNumberFixedPropertyID()));
        }
        if (sequenceNumPlaceHolderPos != 0) {
            TypeDataIndex<?> index = pType.getSequenceNumberIndex();
            index.insertEntryIndexedField(pEntry, index.getIndexValue(pEntry.getEntryHolder(this).getEntryData()), pType);
            if (sequenceNumPlaceHolderPos > 0) {
                int curpos = index.isExtendedIndex() ? pEntry.getBackRefs().size() - 2 : pEntry.getBackRefs().size() - 1;
                pEntry.getBackRefs().set(sequenceNumPlaceHolderPos, pEntry.getBackRefs().remove(curpos));
                if (index.isExtendedIndex()) {
                    pEntry.getBackRefs().set(sequenceNumPlaceHolderPos + 1, pEntry.getBackRefs().remove(curpos));
                }
            }
        }
    }

    private void insertTemplateToCache(Context context, TemplateCacheInfo pTemplate) {
        boolean extendedMatch;
        ITemplateHolder template = pTemplate.m_TemplateHolder;
        TypeData typeData = this._typeDataMap.get(template.getServerTypeDesc());
        if (template.isNotifyTemplate()) {
            typeData.incM_NumRegularNotifyTemplatesStored();
        }
        if (template.isFifoGroupPoll()) {
            this._fifoGroupCacheImpl.incrementNumOfTemplates();
        }
        boolean anyIndexes = typeData.hasInitialIndexes();
        boolean bl = extendedMatch = template.getExtendedMatchCodes() != null;
        if (template.getUidToOperateBy() != null) {
            this.insertTemplateByUid(pTemplate, typeData);
        } else if (!anyIndexes) {
            this.insertNonIndexedTemplate(pTemplate, typeData, extendedMatch);
        } else {
            TypeDataIndex.insertIndexedTemplate(pTemplate, typeData, extendedMatch);
        }
        if (template.isNotifyTemplate()) {
            context.setNotifyLease(this._leaseManager.registerTemplateLease(pTemplate));
        }
        if (template.getXidOriginated() != null) {
            XtnData pXtn = template.getXidOriginated().getXtnData();
            if (template.isNotifyTemplate()) {
                pXtn.getNTemplates(true).add(pTemplate);
            } else {
                pXtn.getRTTemplates(true).add(pTemplate);
            }
        }
    }

    private void insertTemplateByUid(TemplateCacheInfo pTemplate, TypeData typeData) {
        ITemplateHolder template = pTemplate.m_TemplateHolder;
        IObjectInfo<TemplateCacheInfo> oi = null;
        pTemplate.initBackRefs(1);
        ConcurrentHashMap<String, IStoredList<TemplateCacheInfo>> uidTemplates = template.isNotifyTemplate() ? typeData.getNotifyUidTemplates() : typeData.getReadTakeUidTemplates();
        IStoredList<TemplateCacheInfo> templates = uidTemplates.get(template.getUidToOperateBy());
        while (true) {
            if (templates != null) {
                oi = templates.add(pTemplate);
                if (oi != null) break;
                uidTemplates.remove(template.getUidToOperateBy(), templates);
                templates = null;
            }
            if (templates != null) continue;
            templates = StoredListFactory.createConcurrentList(true);
            oi = templates.add(pTemplate);
            templates = uidTemplates.putIfAbsent(template.getUidToOperateBy(), templates);
            if (templates == null) break;
        }
        pTemplate.m_BackRefs.add(oi);
    }

    private void insertNonIndexedTemplate(TemplateCacheInfo pTemplate, TypeData typeData, boolean extendedMatch) {
        pTemplate.initBackRefs(1);
        if (pTemplate.m_TemplateHolder.isNotifyTemplate()) {
            IObjectInfo<TemplateCacheInfo> oi = !extendedMatch ? typeData.getNotifyTemplates().add(pTemplate) : typeData.getNotifyExtendedTemplates().add(pTemplate);
            pTemplate.m_BackRefs.add(oi);
        } else {
            IObjectInfo<TemplateCacheInfo> oi = !extendedMatch ? typeData.getReadTakeTemplates().add(pTemplate) : typeData.getReadTakeExtendedTemplates().add(pTemplate);
            pTemplate.m_BackRefs.add(oi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEntryCacheInfo updateEntryInCache(Context context, IEntryCacheInfo pEntry, IEntryHolder entryHolder, IEntryData newEntryData, long newExpirationTime, int modifiers) {
        TypeData typeData = this._typeDataMap.get(entryHolder.getServerTypeDesc());
        boolean partial_update = UpdateModifiers.isPartialUpdate(modifiers);
        if (pEntry == null) {
            pEntry = this.getPEntryByUid(entryHolder.getUID());
        }
        if (!pEntry.isPinned()) {
            throw new RuntimeException("updateEntryInCache: internal error- entry uid =" + pEntry.getUID() + " not pinned");
        }
        try {
            pEntry.getEntryHolder(this).setunStable(true);
            IEntryData originalEntryData = entryHolder.getEntryData();
            context.setPartialUpdatedValuesIndicators(null);
            if (partial_update) {
                int numOfFields = originalEntryData.getNumOfFixedProperties();
                boolean[] partialUpdatedValuesIndicators = new boolean[numOfFields];
                boolean anyPartial = false;
                for (int i = 0; i < numOfFields; ++i) {
                    if (newEntryData.getFixedPropertyValue(i) != null) continue;
                    newEntryData.setFixedPropertyValue(i, originalEntryData.getFixedPropertyValue(i));
                    partialUpdatedValuesIndicators[i] = true;
                    anyPartial = this._partialUpdateReplication;
                }
                if (newEntryData.getDynamicProperties() == null) {
                    newEntryData.setDynamicProperties(originalEntryData.getDynamicProperties());
                }
                if (anyPartial) {
                    context.setPartialUpdatedValuesIndicators(partialUpdatedValuesIndicators);
                }
            }
            if (entryHolder.getServerTypeDesc().getTypeDesc().hasSequenceNumber() && !this._engine.isLocalCache()) {
                int snPos = entryHolder.getServerTypeDesc().getTypeDesc().getSequenceNumberFixedPropertyID();
                Object newVal = newEntryData.getFixedPropertyValue(snPos);
                Object originalVal = originalEntryData.getFixedPropertyValue(snPos);
                if (newVal == null) {
                    newEntryData.setFixedPropertyValue(snPos, originalVal);
                }
                if (newVal != null && !TypeData.objectsEquality(originalVal, newVal)) {
                    throw new SequenceNumberException(entryHolder.getUID(), entryHolder.getClassName(), " sequence number altered in update/change op was=" + originalVal + " new=" + newVal);
                }
            }
            typeData.prepareForUpdatingIndexValues(this, pEntry, newEntryData);
            long original_expiration = 0L;
            if (context.isReRegisterLeaseOnUpdate()) {
                original_expiration = pEntry.getEntryHolder(this).getEntryData().getExpirationTime();
            }
            entryHolder.updateEntryData(newEntryData, newExpirationTime);
            typeData.updateEntryReferences(this, entryHolder, pEntry, originalEntryData);
            if (context.isReRegisterLeaseOnUpdate()) {
                if (!pEntry.getEntryHolder(this).hasShadow()) {
                    this._leaseManager.reRegisterLease(pEntry, pEntry.getEntryHolder(this), original_expiration, newExpirationTime, 1);
                } else {
                    pEntry.getEntryHolder(this).getShadow().incrementNumOfLeaseUpdates();
                    if (pEntry.getEntryHolder(this).getShadow().getNumOfLeaseUpdates() > 1) {
                        this._leaseManager.unregister(pEntry, original_expiration);
                    }
                    this._leaseManager.registerEntryLease(pEntry, newExpirationTime);
                }
                context.setWriteResult(new WriteEntryResult(pEntry.getUID(), newEntryData.getVersion(), newExpirationTime));
            }
            if (!pEntry.getEntryHolder(this).isBlobStoreEntry()) {
                pEntry.getEntryHolder(this).setDeleted(false);
            }
            IEntryCacheInfo iEntryCacheInfo = pEntry;
            return iEntryCacheInfo;
        }
        finally {
            pEntry.getEntryHolder(this).setunStable(false);
        }
    }

    public boolean removeEntryFromCache(IEntryHolder entryHolder) {
        return this.removeEntryFromCache(entryHolder, false, true, null, RecentDeleteCodes.NONE);
    }

    public boolean removeEntryFromCache(IEntryHolder entryHolder, boolean initiatedByEvictionStrategy, boolean locked, IEntryCacheInfo pEntry, RecentDeleteCodes recentDeleteUsage) {
        boolean inserted;
        boolean recentDeleteEntry = false;
        if (!locked) {
            if (!locked && pEntry == null) {
                throw new RuntimeException("removeEntryFromCache: invalid usage, unlocked && pEntry is null");
            }
            recentDeleteEntry = pEntry.isRecentDelete();
            if (recentDeleteUsage == RecentDeleteCodes.REMOVE_DUMMY && !recentDeleteEntry) {
                return false;
            }
            if (!initiatedByEvictionStrategy && !pEntry.setRemoving(false)) {
                return false;
            }
        } else if (this.isEvictableCachePolicy() || entryHolder.isBlobStoreEntry()) {
            if (pEntry == null) {
                IEntryCacheInfo iEntryCacheInfo = pEntry = entryHolder.isBlobStoreEntry() ? ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart() : this.getPEntryByUid(entryHolder.getUID());
            }
            if (pEntry == null) {
                throw new RuntimeException("removeEntryFromCache: locked && pEntry not found uid=" + entryHolder.getUID());
            }
            recentDeleteEntry = pEntry.isRecentDelete();
            if (recentDeleteUsage != RecentDeleteCodes.INSERT_DUMMY) {
                pEntry.setRemoving(true);
            }
        }
        if (recentDeleteUsage == RecentDeleteCodes.REMOVE_DUMMY) {
            if (pEntry == null || !recentDeleteEntry) {
                return false;
            }
        } else if (pEntry != null && this.isEvictableCachePolicy()) {
            this.removeFromEvictionStrategy(pEntry);
        }
        if (recentDeleteUsage == RecentDeleteCodes.INSERT_DUMMY) {
            if (pEntry == null) {
                pEntry = this.getPEntryByUid(entryHolder.getUID());
            }
            if (pEntry != null) {
                IEntryHolder dummyEh = entryHolder.createDummy();
                EvictableEntryCacheInfo dummyPe = new EvictableEntryCacheInfo(dummyEh, 0, false);
                dummyPe.setRecentDelete();
                this._entries.replace(entryHolder.getUID(), pEntry, dummyPe);
            }
        } else if (pEntry == null) {
            pEntry = (IEntryCacheInfo)this._entries.remove(entryHolder.getUID());
        } else {
            this._entries.remove(entryHolder.getUID(), pEntry);
        }
        if (pEntry == null && locked) {
            throw new RuntimeException("removeEntryFromCache: locked && pEntry not found");
        }
        if (recentDeleteUsage == RecentDeleteCodes.REMOVE_DUMMY) {
            return true;
        }
        boolean bl = inserted = !this.isEvictableCachePolicy() || pEntry != null && pEntry.wasInserted();
        if (!inserted) {
            return true;
        }
        TypeData typeData = this._typeDataMap.get(entryHolder.getServerTypeDesc());
        this.removeEntryReferences(pEntry, typeData, -1);
        this._leaseManager.unregister(pEntry, entryHolder.getEntryData().getExpirationTime());
        if (this.isEvictableCachePolicy()) {
            this._cacheSize.decrementAndGet();
        }
        XtnData pXtn = null;
        if (pEntry.getEntryHolder(this).getXidOriginatedTransaction() != null && (pXtn = pEntry.getEntryHolder(this).getXidOriginated().getXtnData()) != null) {
            pXtn.removeFromNewEntries(pEntry);
        }
        if (pEntry.getEntryHolder(this).getWriteLockTransaction() != null) {
            if (pEntry.getEntryHolder(this).getXidOriginatedTransaction() == null || !pEntry.getEntryHolder(this).getXidOriginatedTransaction().equals((Object)pEntry.getEntryHolder(this).getWriteLockTransaction())) {
                pXtn = pEntry.getEntryHolder(this).getWriteLockOwner().getXtnData();
            }
            if (pXtn != null) {
                this.removeLockedEntry(pXtn, pEntry);
                pXtn.removeTakenEntry(pEntry);
            }
        }
        if (this.isEvictableCachePolicy()) {
            pEntry.setRemoved();
        }
        return true;
    }

    public SQLFunctions getSqlFunctions() {
        return this.sqlFunctions;
    }

    public void removeEntryReferences(IEntryCacheInfo pEntry, TypeData pType, int numOfIndexesInsertedOnError) {
        boolean onError = numOfIndexesInsertedOnError > 0;
        int refpos = 1;
        pType.getEntries().remove(pEntry.getMainListBackRef());
        int numIndexesProcessed = 0;
        if (pType.hasIndexes()) {
            IEntryData entryData = pEntry.getEntryHolder(this).getEntryData();
            TypeDataIndex[] indexes = pType.getIndexes();
            for (TypeDataIndex index : indexes) {
                if (index.disableIndexUsageForOperation(pType, pEntry.getLatestIndexCreationNumber())) continue;
                if (onError && (pEntry.getBackRefs() != null ? refpos > pEntry.getBackRefs().size() - 1 : numIndexesProcessed == numOfIndexesInsertedOnError)) break;
                refpos = index.removeEntryIndexedField_main(pEntry.getEntryHolder(this), pEntry.getBackRefs(), index.getIndexValue(entryData), refpos, true, pEntry);
                ++numIndexesProcessed;
            }
            for (QueryExtensionIndexManagerWrapper queryExtensionIndexManager : pType.getForeignQueriesHandlers()) {
                queryExtensionIndexManager.removeEntry(new SpaceServerEntryImpl(pEntry, this), QueryExtensionIndexRemoveMode.NO_XTN, pEntry.getVersion());
            }
        }
        if (pEntry.getBackRefs() != null) {
            pEntry.getBackRefs().clear();
        }
    }

    private void removeTemplateFromCache(ITemplateHolder template) {
        XtnData pXtn;
        TypeDataIndex[] indexes;
        TemplateCacheInfo pTemplate = this._templatesManager.remove(template.getUID());
        if (pTemplate == null) {
            return;
        }
        boolean extendedMatch = pTemplate.m_TemplateHolder.getExtendedMatchCodes() != null;
        IObjectInfo<TemplateCacheInfo> oi = null;
        int refpos = 0;
        TypeData typeData = this._typeDataMap.get(template.getServerTypeDesc());
        boolean anyIndexes = false;
        for (TypeDataIndex index : indexes = typeData.getIndexes()) {
            if (index.getIndexCreationNumber() > pTemplate.getLatestIndexCreationNumber() || index.isCompound()) continue;
            anyIndexes = true;
            break;
        }
        if (template.getUidToOperateBy() == null) {
            refpos = !anyIndexes ? this.removeNonIndexedTemplate(pTemplate, extendedMatch, typeData) : TypeDataIndex.removeIndexedTemplate(pTemplate, extendedMatch, oi, refpos, typeData);
        } else {
            oi = pTemplate.m_BackRefs.get(0);
            IStoredList<TemplateCacheInfo> templates = pTemplate.m_TemplateHolder.isNotifyTemplate() ? typeData.getNotifyUidTemplates().get(pTemplate.m_TemplateHolder.getUidToOperateBy()) : typeData.getReadTakeUidTemplates().get(pTemplate.m_TemplateHolder.getUidToOperateBy());
            templates.remove(oi);
        }
        if (template.isNotifyTemplate()) {
            typeData.decM_NumRegularNotifyTemplatesStored();
        }
        pTemplate.m_BackRefs.clear();
        this._leaseManager.unregister(pTemplate, pTemplate.m_TemplateHolder.getExpirationTime());
        if (pTemplate.m_TemplateHolder.getXidOriginated() != null && (pXtn = pTemplate.m_TemplateHolder.getXidOriginated().getXtnData()) != null) {
            if (pTemplate.m_TemplateHolder.isNotifyTemplate()) {
                pXtn.getNTemplates().removeByObject(pTemplate);
            } else {
                pXtn.getRTTemplates().removeByObject(pTemplate);
            }
        }
        if (template.isFifoGroupPoll()) {
            this._fifoGroupCacheImpl.decrementNumOfTemplates();
        }
    }

    private int removeNonIndexedTemplate(TemplateCacheInfo pTemplate, boolean extendedMatch, TypeData typeData) {
        IObjectInfo<TemplateCacheInfo> oi = pTemplate.m_BackRefs.get(0);
        if (pTemplate.m_TemplateHolder.isNotifyTemplate()) {
            if (!extendedMatch) {
                typeData.getNotifyTemplates().remove(oi);
            } else {
                typeData.getNotifyExtendedTemplates().remove(oi);
            }
        } else if (!extendedMatch) {
            typeData.getReadTakeTemplates().remove(oi);
        } else {
            typeData.getReadTakeExtendedTemplates().remove(oi);
        }
        int refpos = 1;
        return refpos;
    }

    public IEntryCacheInfo getEntryByUniqueId(IServerTypeDesc currServerTypeDesc, Object templateValue, ITemplateHolder template) {
        TypeData typeData = this._typeDataMap.get(currServerTypeDesc);
        if (template.isFifoSearch() && !typeData.isFifoSupport()) {
            return null;
        }
        if (!typeData.hasIndexes()) {
            return null;
        }
        int latestIndexToConsider = typeData.getLastIndexCreationNumber();
        TypeDataIndex primaryKey = typeData.getIdField();
        if (primaryKey != null && latestIndexToConsider >= primaryKey.getIndexCreationNumber()) {
            if (typeData.disableIdIndexForEntries(primaryKey)) {
                return this.getPEntryByUid(typeData.generateUid(templateValue));
            }
            IStoredList res = (IStoredList)primaryKey.getUniqueEntriesStore().get(templateValue);
            if (res != null && !res.isMultiObjectCollection()) {
                return (IEntryCacheInfo)res.getObjectFromHead();
            }
        }
        return null;
    }

    public IEntryCacheInfo[] getEntriesByUniqueIds(IServerTypeDesc currServerTypeDesc, Object[] ids, ITemplateHolder template) {
        IEntryCacheInfo[] res = new IEntryCacheInfo[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            res[i] = this.getEntryByUniqueId(currServerTypeDesc, ids[i], template);
        }
        return res;
    }

    public IStoredList<IEntryCacheInfo> getEntriesMinIndex(Context context, TypeData typeData, int numOfFields, ITemplateHolder template) {
        Object templateValue;
        if (template.isFifoSearch() && !typeData.isFifoSupport()) {
            return null;
        }
        if (numOfFields == 0 || !typeData.hasIndexes()) {
            return typeData.getEntries();
        }
        int latestIndexToConsider = typeData.getLastIndexCreationNumber();
        TypeDataIndex primaryKey = typeData.getIdField();
        if (primaryKey != null && primaryKey.getPos() < numOfFields && latestIndexToConsider >= primaryKey.getIndexCreationNumber() && (templateValue = primaryKey.getIndexValueForTemplate(template.getEntryData())) != null) {
            if (typeData.disableIdIndexForEntries(primaryKey)) {
                return this.getPEntryByUid(typeData.generateUid(templateValue));
            }
            return (IStoredList)primaryKey.getUniqueEntriesStore().get(templateValue);
        }
        context.setIndexUsed(false);
        IStoredList<IEntryCacheInfo> shortestPotentialMatchList = typeData.getEntries();
        context.setIntersectionEnablment(typeData.isBlobStoreClass() && !template.isFifoGroupPoll());
        shortestPotentialMatchList = CacheManager.findShortestPotentialMatchList(context, typeData, template, shortestPotentialMatchList, numOfFields, latestIndexToConsider);
        shortestPotentialMatchList = CacheManager.findShortestPotentialMatchListCustom(context, typeData, template, shortestPotentialMatchList, latestIndexToConsider);
        if (ProtectiveMode.isQueryWithoutIndexProtectionEnabled() && !context.isIndexUsed()) {
            throw new ProtectiveModeException("Cannot perform operation: The request references only unindexed fields!\n(you can disable this protection, though it is not recommended, by setting the following system property: com.gs.protectiveMode.queryWithoutIndex=false)");
        }
        return shortestPotentialMatchList;
    }

    private IScanListIterator<IEntryCacheInfo> getScannableEntriesMinIndex(Context context, TypeData typeData, int numOfFields, ITemplateHolder template) {
        if (context.isBlobStoreTryNonPersistentOp()) {
            context.setBlobStoreUsePureIndexesAccess(this.isRelevantUsePureIndexesAccess(context, typeData, template));
        }
        if (template.isFifoGroupPoll()) {
            return this._fifoGroupCacheImpl.getScannableEntriesMinIndex(context, typeData, numOfFields, template);
        }
        IStoredList<IEntryCacheInfo> res = this.getEntriesMinIndex(context, typeData, numOfFields, template);
        if (res != null && context.isIndicesIntersectionEnabled() && context.getChosenIntersectedList(false) != null) {
            return context.getChosenIntersectedList(true);
        }
        if (res != null && !res.isMultiObjectCollection()) {
            return res.getObjectFromHead();
        }
        return res != null ? new ScanSingleListIterator<IEntryCacheInfo>(res, template.isFifoTemplate() || context.isInMemoryRecovery() && (typeData.getFifoGroupingIndex() != null || typeData.isFifoSupport())) : null;
    }

    private boolean isRelevantUsePureIndexesAccess(Context context, TypeData typeData, ITemplateHolder template) {
        if (!typeData.isBlobStoreClass() || !typeData.hasIndexes() || template.isFifoGroupPoll() || template.getXidOriginated() != null) {
            return false;
        }
        if (template.isSqlQuery()) {
            return template.isAllValuesIndexSqlQuery();
        }
        if (template.getEntryData() == null || template.getEntryData().getFixedPropertiesValues() == null) {
            return false;
        }
        boolean allNulls = true;
        for (int i = 0; i < template.getEntryData().getFixedPropertiesValues().length; ++i) {
            if (template.getEntryData().getFixedPropertiesValues()[i] == null) continue;
            allNulls = false;
            if (typeData.getIndexesRelatedFixedProperties()[i]) continue;
            return false;
        }
        return !allNulls;
    }

    private static IStoredList<IEntryCacheInfo> findShortestPotentialMatchList(Context context, TypeData typeData, ITemplateHolder template, IStoredList<IEntryCacheInfo> shortestPotentialMatchList, int numOfFields, int latestIndexToConsider) {
        TypeDataIndex[] indexes;
        IStoredList<IEntryCacheInfo> shortestPotentialMatchListCompound;
        if (shortestPotentialMatchList == null) {
            return shortestPotentialMatchList;
        }
        IStoredList<IEntryCacheInfo> compound_selection = null;
        int shortestPotentialMatchListSize = shortestPotentialMatchList.size();
        HashSet<String> usedInSegments = null;
        MultiIntersectedStoredList<IEntryCacheInfo> intersectedList = context.getChosenIntersectedList(false);
        if (typeData.anyNonFGCompoundIndex() && !template.isFifoGroupPoll() && template.getCustomQuery() == null && (shortestPotentialMatchListCompound = CacheManager.findShortestPotentialMatchListCompound(context, typeData, template, shortestPotentialMatchList, numOfFields, latestIndexToConsider, usedInSegments = new HashSet<String>())) != shortestPotentialMatchList) {
            compound_selection = shortestPotentialMatchList = shortestPotentialMatchListCompound;
            if (shortestPotentialMatchList == null) {
                return shortestPotentialMatchList;
            }
            shortestPotentialMatchListSize = shortestPotentialMatchList.size();
            if (context.isIndicesIntersectionEnabled()) {
                intersectedList = CacheManager.addToIntersectedList(context, intersectedList, shortestPotentialMatchListCompound, template.isFifoTemplate(), true, typeData);
            }
            if (!(shortestPotentialMatchListSize != 0 && context.isIndicesIntersectionEnabled() || shortestPotentialMatchListSize >= 5)) {
                if (_logger.isLoggable(Level.FINEST)) {
                    CacheManager.logSearchCompoundSelection(typeData, shortestPotentialMatchList, compound_selection, null);
                }
                return shortestPotentialMatchList;
            }
        }
        for (TypeDataIndex index : indexes = typeData.getIndexes()) {
            int potentialMatchListSize;
            Object templateValue;
            if (index.getPos() >= numOfFields) break;
            if (index.disableIndexUsageForOperation(typeData, latestIndexToConsider) || usedInSegments != null && usedInSegments.contains(index.getIndexDefinition().getName()) || (templateValue = index.getIndexValueForTemplate(template.getEntryData())) == null) continue;
            context.setIndexUsed(true);
            IStoredList<IEntryCacheInfo> potentialMatchList = index.getIndexEntries(templateValue);
            int n = potentialMatchListSize = potentialMatchList == null ? 0 : potentialMatchList.size();
            if (potentialMatchListSize == 0) {
                return null;
            }
            if (shortestPotentialMatchListSize == 1 && !context.isIndicesIntersectionEnabled()) continue;
            if (context.isIndicesIntersectionEnabled()) {
                intersectedList = CacheManager.addToIntersectedList(context, intersectedList, potentialMatchList, template.isFifoTemplate(), potentialMatchListSize <= shortestPotentialMatchListSize, typeData);
            }
            if (potentialMatchListSize <= shortestPotentialMatchListSize) {
                shortestPotentialMatchListSize = potentialMatchListSize;
                shortestPotentialMatchList = potentialMatchList;
                if (template.isFifoGroupPoll()) {
                    context.setFifoGroupIndexUsedInFifoGroupScan(shortestPotentialMatchList, index);
                }
            }
            if (!shortestPotentialMatchList.isMultiObjectCollection() && !context.isIndicesIntersectionEnabled()) break;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            CacheManager.logSearchCompoundSelection(typeData, shortestPotentialMatchList, compound_selection, null);
        }
        if (context.isIndicesIntersectionEnabled()) {
            intersectedList = CacheManager.addToIntersectedList(context, intersectedList, shortestPotentialMatchList, template.isFifoTemplate(), true, typeData);
        }
        return shortestPotentialMatchList;
    }

    private static IStoredList<IEntryCacheInfo> findShortestPotentialMatchListCompound(Context context, TypeData typeData, ITemplateHolder template, IStoredList<IEntryCacheInfo> shortestPotentialMatchList, int numOfFields, int latestIndexToConsider, Set<String> usedInSegments) {
        if (shortestPotentialMatchList == null) {
            return shortestPotentialMatchList;
        }
        int shortestPotentialMatchListSize = shortestPotentialMatchList.size();
        if (shortestPotentialMatchListSize == 1 && !context.isIndicesIntersectionEnabled()) {
            return shortestPotentialMatchList;
        }
        List<TypeDataIndex> indexes = typeData.getCompoundIndexes();
        block0: for (TypeDataIndex index : indexes) {
            int potentialMatchListSize;
            if (index.disableIndexUsageForOperation(typeData, latestIndexToConsider)) {
                if (!context.isBlobStoreUsePureIndexesAccess()) continue;
                context.setBlobStoreUsePureIndexesAccess(false);
                continue;
            }
            Object templateValue = index.getIndexValueForTemplate(template.getEntryData());
            if (templateValue == null) {
                if (!context.isBlobStoreUsePureIndexesAccess()) continue;
                CompoundIndex ci = (CompoundIndex)index.getIndexDefinition();
                for (ISpaceCompoundIndexSegment seg : ci.getCompoundIndexSegments()) {
                    if (seg.getSegmentValue(template.getEntryData()) == null || typeData.getIndex(seg.getName()) != null) continue;
                    context.setBlobStoreUsePureIndexesAccess(false);
                    continue block0;
                }
                continue;
            }
            IStoredList<IEntryCacheInfo> potentialMatchList = index.getIndexEntries(templateValue);
            int n = potentialMatchListSize = potentialMatchList == null ? 0 : potentialMatchList.size();
            if (potentialMatchListSize == 0) {
                return null;
            }
            if (context.isIndicesIntersectionEnabled()) {
                CacheManager.addToIntersectedList(context, context.getChosenIntersectedList(false), potentialMatchList, template.isFifoTemplate(), potentialMatchListSize <= shortestPotentialMatchListSize, typeData);
            }
            CompoundIndex ci = (CompoundIndex)index.getIndexDefinition();
            for (ISpaceCompoundIndexSegment seg : ci.getCompoundIndexSegments()) {
                usedInSegments.add(seg.getName());
            }
            if (potentialMatchListSize <= shortestPotentialMatchListSize) {
                shortestPotentialMatchListSize = potentialMatchListSize;
                shortestPotentialMatchList = potentialMatchList;
            }
            if (shortestPotentialMatchList.isMultiObjectCollection() && shortestPotentialMatchListSize != 1) continue;
            break;
        }
        return shortestPotentialMatchList;
    }

    private static IStoredList<IEntryCacheInfo> findShortestPotentialMatchListCustom(Context context, TypeData typeData, ITemplateHolder template, IStoredList<IEntryCacheInfo> shortestPotentialMatchList, int latestIndexToConsider) {
        if (shortestPotentialMatchList == null) {
            return shortestPotentialMatchList;
        }
        ICustomQuery customQuery = template.getCustomQuery();
        if (customQuery == null) {
            return shortestPotentialMatchList;
        }
        List<IQueryIndexScanner> customIndexes = customQuery.getCustomIndexes();
        if (customIndexes == null || customIndexes.isEmpty()) {
            return shortestPotentialMatchList;
        }
        MultiIntersectedStoredList<IEntryCacheInfo> intersectedList = context.getChosenIntersectedList(false);
        for (IQueryIndexScanner queryIndex : customIndexes) {
            int potentialMatchListSize;
            IObjectsList result = queryIndex.getIndexedEntriesByType(context, typeData, template, latestIndexToConsider);
            if (result == IQueryIndexScanner.RESULT_IGNORE_INDEX) {
                context.setBlobStoreUsePureIndexesAccess(false);
                continue;
            }
            context.setIndexUsed(true);
            if (result == IQueryIndexScanner.RESULT_NO_MATCH) {
                return null;
            }
            IStoredList potentialMatchList = (IStoredList)result;
            int n = potentialMatchListSize = potentialMatchList == null ? 0 : potentialMatchList.size();
            if (potentialMatchListSize == 0) {
                return null;
            }
            if (context.isIndicesIntersectionEnabled()) {
                intersectedList = CacheManager.addToIntersectedList(context, intersectedList, potentialMatchList, template.isFifoTemplate(), potentialMatchListSize <= shortestPotentialMatchList.size(), typeData);
            }
            if (potentialMatchListSize <= shortestPotentialMatchList.size()) {
                shortestPotentialMatchList = potentialMatchList;
            }
            if (shortestPotentialMatchList.isMultiObjectCollection() || context.isIndicesIntersectionEnabled()) continue;
            break;
        }
        if (context.isIndicesIntersectionEnabled()) {
            intersectedList = CacheManager.addToIntersectedList(context, intersectedList, shortestPotentialMatchList, template.isFifoTemplate(), true, typeData);
        }
        return shortestPotentialMatchList;
    }

    public Object getEntriesMinIndexExtended(Context context, TypeData entryType, int numOfFields, ITemplateHolder template) {
        Object templateValue;
        if (template instanceof TemplateHolder && ((TemplateHolder)template).getExplainPlan() != null) {
            SingleExplainPlan singleExplainPlan = ((TemplateHolder)template).getExplainPlan();
            singleExplainPlan.setPartitionId(Integer.toString(this.getEngine().getPartitionIdOneBased()));
            ExplainPlanContext explainPlanContext = new ExplainPlanContext();
            explainPlanContext.setSingleExplainPlan(singleExplainPlan);
            context.setExplainPlanContext(explainPlanContext);
        }
        if (template.isFifoSearch() && !entryType.isFifoSupport()) {
            return null;
        }
        if (!entryType.hasIndexes() && (template.getCustomQuery() == null || template.getCustomQuery().getCustomIndexes() == null || template.getCustomQuery().getCustomIndexes().isEmpty())) {
            return entryType.getEntries();
        }
        int latestIndexToConsider = entryType.getLastIndexCreationNumber();
        TypeDataIndex primaryKey = entryType.getIdField();
        if (primaryKey != null && primaryKey.getPos() < numOfFields && latestIndexToConsider >= primaryKey.getIndexCreationNumber() && template.getExtendedMatchCodes()[primaryKey.getPos()] == 0 && (templateValue = primaryKey.getIndexValueForTemplate(template.getEntryData())) != null) {
            context.setBlobStoreUsePureIndexesAccess(false);
            IEntryCacheInfo pEntryByUid = entryType.disableIdIndexForEntries(primaryKey) ? this.getPEntryByUid(entryType.generateUid(templateValue)) : (IEntryCacheInfo)primaryKey.getUniqueEntriesStore().get(templateValue);
            if (context.getExplainPlanContext() != null) {
                context.getExplainPlanContext().setMatch(new IndexChoiceNode("MATCH"));
                context.getExplainPlanContext().getSingleExplainPlan().addScanIndexChoiceNode(entryType.getClassName(), context.getExplainPlanContext().getMatch());
                int indexSize = pEntryByUid == null ? 0 : pEntryByUid.size();
                IndexInfo indexInfo = new IndexInfo(entryType.getProperty(primaryKey.getPos()).getName(), indexSize, primaryKey.getIndexType(), templateValue, QueryOperator.EQ);
                context.getExplainPlanContext().getMatch().addOption(indexInfo);
                context.getExplainPlanContext().getMatch().setChosen(indexInfo);
            }
            return pEntryByUid;
        }
        IObjectsList compound_selection = null;
        String compound_name = null;
        IStoredList<IEntryCacheInfo> resultSL = null;
        IScanListIterator<IEntryCacheInfo> resultOIS = null;
        ScanUidsIterator uidsIter = null;
        boolean ignoreOrderedIndexes = entryType.getEntries().size() < this._minExtendedIndexActivationSize && !context.isBlobStoreUsePureIndexesAccess();
        context.setIntersectionEnablment(entryType.isBlobStoreClass() && !template.isFifoGroupPoll());
        MultiIntersectedStoredList<IEntryCacheInfo> intersectedList = null;
        int uidsSize = Integer.MAX_VALUE;
        ICustomQuery customQuery = template.getCustomQuery();
        boolean indexUsed = false;
        if (customQuery != null && customQuery.getCustomIndexes() != null) {
            for (IQueryIndexScanner index : customQuery.getCustomIndexes()) {
                TypeDataIndex<?> idx;
                IObjectsList result = index.getIndexedEntriesByType(context, entryType, template, latestIndexToConsider);
                if (result == IQueryIndexScanner.RESULT_IGNORE_INDEX) {
                    context.setBlobStoreUsePureIndexesAccess(false);
                    continue;
                }
                indexUsed = true;
                if (_logger.isLoggable(Level.FINEST) && (idx = entryType.getIndex(index.getIndexName())) != null && idx.isCompound()) {
                    compound_selection = result;
                    compound_name = index.getIndexName();
                }
                if (result == IQueryIndexScanner.RESULT_NO_MATCH) {
                    return null;
                }
                if (result != null && result.isIterator()) {
                    if (uidsIter != null) continue;
                    resultOIS = (IScanListIterator<IEntryCacheInfo>)result;
                    if (index.isUidsScanner()) {
                        uidsIter = (ScanUidsIterator)resultOIS;
                        uidsSize = uidsIter.size();
                    }
                    if (context.isIndicesIntersectionEnabled()) {
                        intersectedList = CacheManager.addToIntersectedList(context, intersectedList, resultOIS, template.isFifoTemplate(), false, entryType);
                    }
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.log(Level.FINEST, "EXTENDED-INDEX '" + index.getIndexName() + "' has been used for type [" + entryType.getClassName() + "]");
                    continue;
                }
                IStoredList entriesVector = (IStoredList)result;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "BASIC-INDEX '" + index.getIndexName() + "' has been used for type [" + entryType.getClassName() + "]");
                }
                if (entriesVector == null) {
                    return null;
                }
                if (context.isIndicesIntersectionEnabled()) {
                    intersectedList = CacheManager.addToIntersectedList(context, intersectedList, entriesVector, template.isFifoTemplate(), false, entryType);
                }
                if (resultSL != null && resultSL.size() <= entriesVector.size()) continue;
                resultSL = entriesVector;
            }
        }
        if (resultSL == null || resultSL.size() > 5 && uidsSize > 5 || entryType.isBlobStoreClass() && resultSL != null && resultSL.size() > 0) {
            TypeDataIndex index;
            int pos;
            TypeDataIndex[] indexes;
            TypeDataIndex[] typeDataIndexArray = indexes = entryType.getIndexes();
            int n = typeDataIndexArray.length;
            block8: for (int i = 0; i < n && (pos = (index = typeDataIndexArray[i]).getPos()) < numOfFields; ++i) {
                if (latestIndexToConsider < index.getIndexCreationNumber()) continue;
                short extendedMatchCode = template.getExtendedMatchCodes()[pos];
                Object templateValue2 = index.getIndexValueForTemplate(template.getEntryData());
                if (template.isFifoTemplate() && !TemplateMatchCodes.supportFifoOrder(extendedMatchCode)) continue;
                IStoredList<IEntryCacheInfo> entriesVector = null;
                switch (extendedMatchCode) {
                    case 7: 
                    case 8: {
                        continue block8;
                    }
                    case 6: {
                        entriesVector = index.getNullEntries();
                        if (context.isIndicesIntersectionEnabled()) {
                            intersectedList = CacheManager.addToIntersectedList(context, intersectedList, entriesVector, template.isFifoTemplate(), false, entryType);
                        }
                        if (resultSL != null && resultSL.size() <= entriesVector.size()) continue block8;
                        if (context.getExplainPlanContext() != null) {
                            if (context.getExplainPlanContext().getMatch() == null) {
                                context.getExplainPlanContext().setMatch(new IndexChoiceNode("MATCH"));
                                context.getExplainPlanContext().getSingleExplainPlan().addScanIndexChoiceNode(entryType.getClassName(), context.getExplainPlanContext().getMatch());
                            }
                            int indexSize = entriesVector == null ? 0 : entriesVector.size();
                            IndexInfo indexInfo = new IndexInfo(entryType.getProperty(pos).getName(), indexSize, index.getIndexType(), templateValue2, QueryOperator.IS_NULL);
                            context.getExplainPlanContext().getMatch().addOption(indexInfo);
                            context.getExplainPlanContext().getMatch().setChosen(indexInfo);
                        }
                        resultSL = entriesVector;
                        continue block8;
                    }
                    case 1: {
                        if (templateValue2 == null || (entriesVector = (IStoredList<IEntryCacheInfo>)index.getNonUniqueEntriesStore().get(templateValue2)) == null || entriesVector.size() != entryType.getEntries().size()) continue block8;
                        return null;
                    }
                    case 0: {
                        if (templateValue2 == null) continue block8;
                        indexUsed = true;
                        entriesVector = index.getIndexEntries(templateValue2);
                        if (entriesVector == null) {
                            return null;
                        }
                        if (context.isIndicesIntersectionEnabled()) {
                            intersectedList = CacheManager.addToIntersectedList(context, intersectedList, entriesVector, template.isFifoTemplate(), false, entryType);
                        }
                        if (resultSL == null || resultSL.size() > entriesVector.size()) {
                            this.handleExplainPlanMatchCodes(true, context, entryType, index, pos, templateValue2, entriesVector);
                            resultSL = entriesVector;
                            continue block8;
                        }
                        this.handleExplainPlanMatchCodes(false, context, entryType, index, pos, templateValue2, entriesVector);
                        continue block8;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (templateValue2 == null || ignoreOrderedIndexes) continue block8;
                        if (index.getExtendedIndexForScanning() == null) {
                            if (!context.isBlobStoreUsePureIndexesAccess()) continue block8;
                            context.setBlobStoreUsePureIndexesAccess(false);
                            continue block8;
                        }
                        indexUsed = true;
                        if (resultOIS != null && !entryType.isBlobStoreClass()) continue block8;
                        Object rangeValue = template.getRangeValue(pos);
                        boolean isInclusive = rangeValue == null ? false : template.getRangeInclusion(pos);
                        IScanListIterator<IEntryCacheInfo> originalOIS = resultOIS;
                        resultOIS = index.getExtendedIndexForScanning().establishScan(templateValue2, extendedMatchCode, rangeValue, isInclusive);
                        resultSL = entriesVector;
                        if (resultOIS == null) {
                            return null;
                        }
                        if (context.getExplainPlanContext() != null) {
                            if (context.getExplainPlanContext().getMatch() == null) {
                                context.getExplainPlanContext().setMatch(new IndexChoiceNode("MATCH"));
                                context.getExplainPlanContext().getSingleExplainPlan().addScanIndexChoiceNode(entryType.getClassName(), context.getExplainPlanContext().getMatch());
                            }
                            int indexSize = entriesVector == null ? 0 : entriesVector.size();
                            IndexInfo indexInfo = new IndexInfo(entryType.getProperty(pos).getName(), indexSize, index.getIndexType(), templateValue2, ExplainPlanUtil.getQueryOperator(extendedMatchCode));
                            context.getExplainPlanContext().getMatch().addOption(indexInfo);
                            context.getExplainPlanContext().getMatch().setChosen(indexInfo);
                        }
                        if (context.isIndicesIntersectionEnabled()) {
                            intersectedList = CacheManager.addToIntersectedList(context, intersectedList, resultOIS, template.isFifoTemplate(), false, entryType);
                        }
                        if (uidsSize == Integer.MAX_VALUE) continue block8;
                        resultOIS = originalOIS;
                    }
                }
            }
            if (ProtectiveMode.isQueryWithoutIndexProtectionEnabled() && !indexUsed && !ignoreOrderedIndexes) {
                throw new ProtectiveModeException("Cannot perform operation: The request references only unindexed fields!\n(you can disable this protection, though it is not recommended, by setting the following system property: com.gs.protectiveMode.queryWithoutIndex=false)");
            }
        }
        if (resultSL == null) {
            if (resultOIS == null) {
                context.setBlobStoreUsePureIndexesAccess(false);
                return entryType.getEntries();
            }
            if (_logger.isLoggable(Level.FINEST)) {
                CacheManager.logSearchCompoundSelection(entryType, resultOIS, compound_selection, compound_name);
            }
            if (context.isIndicesIntersectionEnabled()) {
                intersectedList = CacheManager.addToIntersectedList(context, intersectedList, resultOIS, template.isFifoTemplate(), true, entryType);
            }
            return resultOIS;
        }
        if (resultOIS == null || resultSL.size() < entryType.getEntries().size() && (uidsSize == Integer.MAX_VALUE || resultSL.size() <= uidsSize)) {
            if (_logger.isLoggable(Level.FINEST)) {
                CacheManager.logSearchCompoundSelection(entryType, resultSL, compound_selection, compound_name);
            }
            if (context.isIndicesIntersectionEnabled()) {
                intersectedList = CacheManager.addToIntersectedList(context, intersectedList, resultOIS, template.isFifoTemplate(), false, entryType);
                intersectedList = CacheManager.addToIntersectedList(context, intersectedList, resultSL, template.isFifoTemplate(), true, entryType);
            }
            return resultSL;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            CacheManager.logSearchCompoundSelection(entryType, resultOIS, compound_selection, compound_name);
        }
        if (context.isIndicesIntersectionEnabled()) {
            intersectedList = CacheManager.addToIntersectedList(context, intersectedList, resultSL, template.isFifoTemplate(), false, entryType);
            intersectedList = CacheManager.addToIntersectedList(context, intersectedList, resultOIS, template.isFifoTemplate(), true, entryType);
        }
        return resultOIS;
    }

    private void handleExplainPlanMatchCodes(boolean chosen, Context context, TypeData entryType, TypeDataIndex<Object> index, int pos, Object templateValue, IStoredList<IEntryCacheInfo> entriesVector) {
        if (context.getExplainPlanContext() != null) {
            if (context.getExplainPlanContext().getMatch() == null) {
                context.getExplainPlanContext().setMatch(new IndexChoiceNode("MATCH"));
                context.getExplainPlanContext().getSingleExplainPlan().addScanIndexChoiceNode(entryType.getClassName(), context.getExplainPlanContext().getMatch());
            }
            int indexSize = entriesVector == null ? 0 : entriesVector.size();
            IndexInfo indexInfo = new IndexInfo(entryType.getProperty(pos).getName(), indexSize, index.getIndexType(), templateValue, QueryOperator.EQ);
            context.getExplainPlanContext().getMatch().addOption(indexInfo);
            if (chosen) {
                context.getExplainPlanContext().getMatch().setChosen(indexInfo);
            }
        }
    }

    private static MultiIntersectedStoredList<IEntryCacheInfo> addToIntersectedList(Context context, MultiIntersectedStoredList<IEntryCacheInfo> intersectedList, IObjectsList list, boolean fifoScan, boolean shortest, TypeData typeData) {
        if (list != null && list != typeData.getEntries()) {
            if (intersectedList == null) {
                intersectedList = new MultiIntersectedStoredList(context, list, fifoScan, typeData.getEntries(), !context.isBlobStoreUsePureIndexesAccess());
                context.setChosenIntersectedList(intersectedList);
            } else {
                intersectedList.add(list, shortest);
            }
        }
        return intersectedList;
    }

    private static void logSearchCompoundSelection(TypeData type, Object res, Object compound_selection, String compound_name) {
        if (!_logger.isLoggable(Level.FINEST) || res == null || res != compound_selection) {
            return;
        }
        if (compound_name == null) {
            compound_name = " ";
        }
        _logger.log(Level.FINEST, "COMPOUND-INDEX '" + compound_name + "' has been selected for type [" + type.getClassName() + "]");
    }

    IScanListIterator<IEntryCacheInfo> getScannableEntriesMinIndexExtended(Context context, TypeData entryType, int numOfFields, ITemplateHolder template) {
        if (context.isBlobStoreTryNonPersistentOp()) {
            context.setBlobStoreUsePureIndexesAccess(this.isRelevantUsePureIndexesAccess(context, entryType, template));
        }
        if (template.isFifoGroupPoll()) {
            return this._fifoGroupCacheImpl.getScannableEntriesMinIndexExtended(context, entryType, numOfFields, template);
        }
        Object chosen = this.getEntriesMinIndexExtended(context, entryType, numOfFields, template);
        if (chosen != null && context.isIndicesIntersectionEnabled() && context.getChosenIntersectedList(false) != null) {
            return context.getChosenIntersectedList(true);
        }
        if (chosen != null && chosen instanceof IEntryCacheInfo) {
            return (IEntryCacheInfo)chosen;
        }
        return chosen instanceof IStoredList ? new ScanSingleListIterator((IStoredList)chosen, template.isFifoTemplate()) : (IScanListIterator)chosen;
    }

    public IEntryHolder getEntryByIdFromPureCache(Object id, IServerTypeDesc typeDesc) {
        TypeData typeData = this._typeDataMap.get(typeDesc);
        if (typeData == null) {
            return null;
        }
        TypeDataIndex idPropertyIndex = typeData.getIdField();
        if (idPropertyIndex == null || typeData.getLastIndexCreationNumber() < idPropertyIndex.getIndexCreationNumber()) {
            throw new EngineInternalSpaceException("No index defined for entry.");
        }
        if (typeData.disableIdIndexForEntries(idPropertyIndex)) {
            return this.getEntryByUidFromPureCache(typeData.generateUid(id));
        }
        IEntryCacheInfo pe = (IEntryCacheInfo)idPropertyIndex.getUniqueEntriesStore().get(id);
        if (pe == null) {
            return null;
        }
        return pe.getEntryHolder(this);
    }

    private Object findTemplatesByIndex(Context context, TypeData templateType, IEntryHolder entry, MatchTarget matchTarget) {
        IStoredList<TemplateCacheInfo> result = null;
        Object min_array = null;
        boolean need_search = true;
        if (matchTarget == MatchTarget.NOTIFY && templateType.getM_NumRegularNotifyTemplatesStored() == 0) {
            need_search = false;
        }
        IEntryData entryData = entry.getEntryData();
        if (!templateType.hasIndexes()) {
            if (need_search) {
                result = templateType.getTemplates(matchTarget);
            }
            result = this.getTemplatesWaitingForUid(templateType, matchTarget, result, entry);
            if (need_search) {
                result = this.getTemplatesExtendedSearch(templateType, matchTarget, result);
            }
            return result;
        }
        int minIndexSize = 0;
        IStoredList<TemplateCacheInfo> templVector = null;
        IStoredList<TemplateCacheInfo> nullTemplVector = null;
        int latestIndexToConsider = 0;
        if (need_search) {
            TypeDataIndex[] indexes;
            boolean anyIndex = false;
            for (TypeDataIndex index : indexes = templateType.getIndexes()) {
                int size;
                if (index.getIndexCreationNumber() > latestIndexToConsider || index.isCompound()) continue;
                anyIndex = true;
                IStoredList<TemplateCacheInfo> templatesVector = null;
                IStoredList<TemplateCacheInfo> nullTemplatesVector = null;
                IStoredList<TemplateCacheInfo>[] t_vec = null;
                Object entryValue = index.getIndexValue(entryData);
                if (index.isMultiValuePerEntryIndex() && entryValue != null) {
                    ConcurrentSegmentedStoredList<TemplateCacheInfo> multiValueTemplates = new ConcurrentSegmentedStoredList<TemplateCacheInfo>(true, 1, true);
                    nullTemplatesVector = matchTarget == MatchTarget.READ_TAKE ? index._RTNullTemplates : index._NNullTemplates;
                    for (Object value : (Collection)entryValue) {
                        IStoredListIterator it;
                        if (matchTarget == MatchTarget.READ_TAKE) {
                            if (value == null || (t_vec = index._RTTemplates.get(value)) == null || t_vec[0].isEmpty()) continue;
                            templatesVector = t_vec[0];
                            it = templatesVector.establishListScan(false);
                            while (it != null) {
                                multiValueTemplates.add((TemplateCacheInfo)it.getSubject());
                                it = templatesVector.next(it);
                            }
                            continue;
                        }
                        if (value == null || (t_vec = index._NTemplates.get(value)) == null || t_vec[0].isEmpty()) continue;
                        templatesVector = t_vec[0];
                        it = templatesVector.establishListScan(false);
                        while (it != null) {
                            TemplateCacheInfo subject = (TemplateCacheInfo)it.getSubject();
                            if (subject != null) {
                                multiValueTemplates.add(subject);
                            }
                            it = templatesVector.next(it);
                        }
                    }
                    t_vec = new IStoredList[]{multiValueTemplates, nullTemplatesVector};
                    if (!multiValueTemplates.isEmpty()) {
                        templatesVector = multiValueTemplates;
                    }
                } else if (matchTarget == MatchTarget.READ_TAKE) {
                    if (entryValue != null && (t_vec = index._RTTemplates.get(entryValue)) != null && !t_vec[0].isEmpty()) {
                        templatesVector = t_vec[0];
                    }
                    nullTemplatesVector = index._RTNullTemplates;
                } else {
                    if (entryValue != null && (t_vec = index._NTemplates.get(entryValue)) != null && !t_vec[0].isEmpty()) {
                        templatesVector = t_vec[0];
                    }
                    nullTemplatesVector = index._NNullTemplates;
                }
                int n = size = templatesVector == null ? nullTemplatesVector.size() : templatesVector.size() + nullTemplatesVector.size();
                if (nullTemplVector == null) {
                    minIndexSize = size;
                    templVector = templatesVector;
                    nullTemplVector = nullTemplatesVector;
                    if (templatesVector != null) {
                        min_array = t_vec;
                    }
                } else if (size < minIndexSize) {
                    minIndexSize = size;
                    templVector = templatesVector;
                    nullTemplVector = nullTemplatesVector;
                    min_array = templatesVector != null ? t_vec : null;
                }
                if (size == 0) break;
            }
            result = min_array;
            if (anyIndex) {
                if (templVector == null) {
                    result = nullTemplVector;
                }
            } else {
                result = templateType.getTemplates(matchTarget);
            }
        }
        result = this.getTemplatesWaitingForUid(templateType, matchTarget, result, entry);
        if (need_search) {
            result = templateType.anyInitialExtendedIndex() ? TypeDataIndex.getTemplatesExtendedIndexSearch(templateType, matchTarget, entry, result) : this.getTemplatesExtendedSearch(templateType, matchTarget, result);
        }
        return result;
    }

    private Object getTemplatesExtendedSearch(TypeData templateType, MatchTarget matchTarget, Object tempResult) {
        IStoredList[] resSls;
        IStoredList<TemplateCacheInfo> sl = templateType.getExtendedTemplates(matchTarget);
        if (sl.isEmpty()) {
            return tempResult;
        }
        if (tempResult == null) {
            return sl;
        }
        if (tempResult instanceof IStoredList) {
            IStoredList orgRes = (IStoredList)tempResult;
            if (orgRes.isEmpty()) {
                return sl;
            }
            resSls = new IStoredList[]{orgRes, sl};
        } else {
            IStoredList[] sls = (IStoredList[])tempResult;
            int dim = sls.length;
            resSls = new IStoredList[dim + 1];
            for (int i = 0; i < dim; ++i) {
                resSls[i] = sls[i];
            }
            resSls[dim] = sl;
        }
        return resSls;
    }

    private Object getTemplatesWaitingForUid(TypeData templateType, MatchTarget matchTarget, Object tempResult, IEntryHolder entry) {
        IStoredList[] resSls;
        IStoredList<TemplateCacheInfo> sl = templateType.getUidTemplates(matchTarget, entry.getUID());
        if (sl == null || sl.isEmpty()) {
            return tempResult;
        }
        if (tempResult == null) {
            return sl;
        }
        if (tempResult instanceof IStoredList) {
            IStoredList orgRes = (IStoredList)tempResult;
            if (orgRes.isEmpty()) {
                return sl;
            }
            resSls = new IStoredList[]{orgRes, sl};
        } else {
            IStoredList[] sls = (IStoredList[])tempResult;
            int dim = sls.length;
            resSls = new IStoredList[dim + 1];
            for (int i = 0; i < dim; ++i) {
                resSls[i] = sls[i];
            }
            resSls[dim] = sl;
        }
        return resSls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryEvict(EvictableServerEntry entry) {
        boolean bl;
        EvictableEntryCacheInfo pev = (EvictableEntryCacheInfo)entry;
        IEntryHolder eh = pev.getEntryHolder();
        if (pev.isPinned()) {
            return false;
        }
        if (!this.requiresEvictionReplicationProtection()) {
            return this.grantEvictionPermissionAndRemove_Impl(pev);
        }
        Object lockObject = this.getEvictionReplicationsMarkersRepository().getLockObject(eh.getUID());
        try {
            Object object = lockObject;
            synchronized (object) {
                if (!this.getEvictionReplicationsMarkersRepository().isEntryEvictable(eh.getUID(), true)) {
                    boolean bl2 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl13 : MonitorExitStatement: MONITOREXIT : var5_5
                    this.getEvictionReplicationsMarkersRepository().releaseLockObject(lockObject);
                    return bl2;
                }
                bl = this.grantEvictionPermissionAndRemove_Impl(pev);
            }
        }
        catch (Throwable throwable) {
            this.getEvictionReplicationsMarkersRepository().releaseLockObject(lockObject);
            throw throwable;
        }
        this.getEvictionReplicationsMarkersRepository().releaseLockObject(lockObject);
        return bl;
    }

    private boolean grantEvictionPermissionAndRemove_Impl(EvictableEntryCacheInfo pev) {
        IEntryHolder eh = pev.getEntryHolder();
        if (!pev.setRemoving(false)) {
            return false;
        }
        this.removeEntryFromCache(eh, true, false, pev, RecentDeleteCodes.NONE);
        return true;
    }

    public boolean unpinIfNeeded(Context context, IEntryHolder entry, ITemplateHolder template, IEntryCacheInfo pEntry) {
        if (!this.isEvictableCachePolicy() && !entry.isBlobStoreEntry()) {
            return false;
        }
        if (template != null && template.isTakeOperation() && entry.isDeleted()) {
            return false;
        }
        if (this.useRecentUpdatesForPinning() && this.isEntryInRecentUpdates(entry)) {
            return false;
        }
        if (pEntry == null) {
            IEntryCacheInfo iEntryCacheInfo = pEntry = entry.isBlobStoreEntry() ? ((IBlobStoreEntryHolder)((Object)entry)).getBlobStoreResidentPart() : this.getEntryCacheInfo(entry);
        }
        if (pEntry == null || !pEntry.isPinned()) {
            return false;
        }
        if (this.useRecentDeletes() && pEntry.isRecentDelete()) {
            return false;
        }
        if (entry.isBlobStoreEntry() && ((IBlobStoreRefCacheInfo)((Object)pEntry)).isInBulk()) {
            return false;
        }
        if (pEntry.getEntryHolder(this).isMaybeUnderXtn() || pEntry.getEntryHolder(this).isHasWaitingFor()) {
            return false;
        }
        if (this.isEvictableCachePolicy()) {
            pEntry.setPinned(false);
        } else {
            ((IBlobStoreRefCacheInfo)((Object)pEntry)).unLoadFullEntryIfPossible(this, context);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initiatedCacheEviction(IEntryHolder entry) {
        boolean bl;
        IEntryCacheInfo pEntry = null;
        if (this.useRecentUpdatesForPinning() && this.isEntryInRecentUpdates(entry)) {
            return false;
        }
        pEntry = this.getEntryCacheInfo(entry);
        if (pEntry == null || !pEntry.isPinned()) {
            return false;
        }
        if (this.useRecentDeletes() && pEntry.isRecentDelete()) {
            return false;
        }
        if (pEntry.getEntryHolder(this).isMaybeUnderXtn() || pEntry.getEntryHolder(this).isHasWaitingFor()) {
            return false;
        }
        if (!this.requiresEvictionReplicationProtection()) {
            return this.initiatedCacheEviction_Impl(pEntry);
        }
        Object lockObject = this.getEvictionReplicationsMarkersRepository().getLockObject(entry.getUID());
        try {
            Object object = lockObject;
            synchronized (object) {
                if (!this.getEvictionReplicationsMarkersRepository().isEntryEvictable(entry.getUID(), true)) {
                    boolean bl2 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl19 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.getEvictionReplicationsMarkersRepository().releaseLockObject(lockObject);
                    return bl2;
                }
                bl = this.initiatedCacheEviction_Impl(pEntry);
            }
        }
        catch (Throwable throwable) {
            this.getEvictionReplicationsMarkersRepository().releaseLockObject(lockObject);
            throw throwable;
        }
        this.getEvictionReplicationsMarkersRepository().releaseLockObject(lockObject);
        return bl;
    }

    private boolean initiatedCacheEviction_Impl(IEntryCacheInfo pEntry) {
        pEntry.setRemoving(true);
        this.removeEntryFromCache(pEntry.getEntryHolder(this), false, true, pEntry, RecentDeleteCodes.NONE);
        return true;
    }

    public boolean initiatedEviction(Context context, IEntryHolder entry, boolean shouldReplicate) throws SAException {
        boolean res = this.initiatedCacheEviction(entry);
        if (res && shouldReplicate) {
            IReplicationOutContext replContext = this.getReplicationContext(context);
            this.updateReplicationContext(replContext, context);
            this._replicationNode.outEvictEntry(replContext, entry);
            if (!context.isSyncReplFromMultipleOperation() && !context.isDisableSyncReplication()) {
                this._engine.performReplication(context);
            }
        }
        return res;
    }

    public boolean isMemorySpace() {
        return this._isMemorySA;
    }

    public boolean isResidentCacheEntry(EvictableServerEntry entry) {
        return true;
    }

    public IReplicationOutContext getReplicationContext(Context context) {
        if (context == null) {
            return null;
        }
        IReplicationOutContext replicationContext = context.getReplicationContext();
        if (replicationContext == null) {
            replicationContext = this._replicationNode.createContext();
            context.setReplicationContext(replicationContext);
        }
        return replicationContext;
    }

    void consolidateWithShadowEntry(TypeData pType, IEntryCacheInfo pmaster, boolean restoreOriginalValues, boolean onError) {
        IEntryData keptEntryData;
        ArrayList<IObjectInfo<IEntryCacheInfo>> deleteBackrefs;
        IEntryData deleteEntryData;
        ShadowEntryHolder shadowEh = pmaster.getEntryHolder(this).getShadow();
        int numIndexsesUpdated = 0;
        if (restoreOriginalValues) {
            deleteEntryData = pmaster.getEntryHolder(this).getEntryData();
            if (shadowEh.getNumOfLeaseUpdates() > 0) {
                this._leaseManager.unregister(pmaster, deleteEntryData.getExpirationTime());
                pmaster.setLeaseManagerListRefAndPosition(shadowEh.getLeaseManagerListRef(), shadowEh.getLeaseManagerPosition());
            }
            pType.prepareForUpdatingIndexValues(this, pmaster, shadowEh.getEntryData());
            deleteBackrefs = pmaster.getBackRefs();
            keptEntryData = shadowEh.getEntryData();
            pmaster.setBackRefs(shadowEh.getBackRefs());
            pmaster.getEntryHolder(this).restoreUpdateXtnRollback(shadowEh.getEntryData());
        } else {
            if (shadowEh.getNumOfLeaseUpdates() > 0) {
                this._leaseManager.unregister(shadowEh, shadowEh.getEntryData().getExpirationTime());
            }
            deleteBackrefs = shadowEh.getBackRefs();
            IEntryHolder keptEh = pmaster.getEntryHolder(this);
            keptEntryData = keptEh.getEntryData();
            deleteEntryData = shadowEh.getEntryData();
            keptEh.setOtherUpdateUnderXtnEntry(null);
        }
        int refpos = 1;
        if (pType.hasIndexes()) {
            TypeDataIndex[] indexes = pType.getIndexes();
            for (TypeDataIndex index : indexes) {
                boolean useOnError;
                if (index.disableIndexUsageForOperation(pType, pmaster.getLatestIndexCreationNumber())) continue;
                Object deleteValue = index.getIndexValue(deleteEntryData);
                boolean bl = useOnError = onError && shadowEh.getNumOfIndexesUpdated() < ++numIndexsesUpdated;
                if (useOnError) {
                    try {
                        refpos = index.consolidateIndexValueOnXtnEnd(pmaster.getEntryHolder(this), pmaster, index.getIndexValue(keptEntryData), deleteValue, deleteBackrefs, refpos, true);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                refpos = index.consolidateIndexValueOnXtnEnd(pmaster.getEntryHolder(this), pmaster, index.getIndexValue(keptEntryData), deleteValue, deleteBackrefs, refpos, false);
            }
            for (QueryExtensionIndexManagerWrapper queryExtensionIndexManager : pType.getForeignQueriesHandlers()) {
                try {
                    queryExtensionIndexManager.removeEntry(new SpaceServerEntryImpl(pmaster, this), restoreOriginalValues ? QueryExtensionIndexRemoveMode.ON_XTN_UPDATED_ROLLBACK : QueryExtensionIndexRemoveMode.ON_XTN_UPDATED_COMMIT, deleteEntryData.getVersion());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Remove entry to foreign index failed", ex);
                }
            }
        }
        shadowEh.setDeleted(true);
    }

    public boolean isFromFifoClass(IServerTypeDesc typeDesc) {
        TypeData type = this._typeDataMap.get(typeDesc);
        return type != null ? type.isFifoSupport() : false;
    }

    public TemplatesManager getTemplatesManager() {
        return this._templatesManager;
    }

    public int getNumberOfLockedObjectsUnderTxn(XtnEntry xtnEntry) {
        return xtnEntry.getXtnData().getUnderXtnEntries(2) != null ? xtnEntry.getXtnData().getUnderXtnEntries(2).size() : 0;
    }

    public int getMinExtendedIndexActivationSize() {
        return this._minExtendedIndexActivationSize;
    }

    public int getEnriesSize() {
        if (this._entries == null) {
            return 0;
        }
        return this._entries.size();
    }

    public long getLatestTTransactionTerminationNum() {
        return this._terminatingXtnsInfo.getLatestTTransactionTerminationNum();
    }

    public void setLatestTransactionTerminationNum(long xtnTerminationNum) {
        this._terminatingXtnsInfo.setLatestTransactionTerminationNum(xtnTerminationNum);
    }

    public void setFifoXtnNumber(XtnEntry xtnEntry, long fifoXtnNumber) {
        xtnEntry.getXtnData().setFifoXtnNumber(fifoXtnNumber);
    }

    public long getFifoXtnNumber(XtnEntry xtnEntry) {
        return xtnEntry.getXtnData().getFifoXtnNumber();
    }

    public void updateFifoXtnInfoForEntry(IEntryHolder eh, long xtnNumber, boolean writeLock, boolean entryWritingXtn) {
        this._terminatingXtnsInfo.updateFifoXtnInfoForEntry(eh, xtnNumber, writeLock, entryWritingXtn);
    }

    public void setFifoCreationXtnInfoForEntry(IEntryHolder eh, long xtnNumber) {
        this._terminatingXtnsInfo.setFifoCreationXtnInfoForEntry(eh, xtnNumber);
    }

    public TerminatingFifoXtnsInfo.FifoXtnEntryInfo getFifoEntryXtnInfo(IEntryHolder eh) {
        return this._terminatingXtnsInfo.getFifoEntryXtnInfo(eh);
    }

    public void removeFifoXtnInfoForEntry(IEntryHolder eh) {
        this._terminatingXtnsInfo.removeFifoXtnInfoForEntry(eh);
    }

    public ConcurrentHashMap<TerminatingFifoXtnsInfo.FifoXtnEntryInfo, TerminatingFifoXtnsInfo.FifoXtnEntryInfo> getTerminatingXtnsEntries() {
        return this._terminatingXtnsInfo.getTerminatingXtnsEntries();
    }

    public void lockEntry(XtnData xtn, IEntryCacheInfo pEntry, OperationID operationID) {
        boolean fifo = this.isFromFifoClass(pEntry.getEntryHolder(this).getServerTypeDesc());
        xtn.addLockedEntry(pEntry, operationID, fifo);
    }

    public void updateLock(XtnData xtn, IEntryCacheInfo pEntry, OperationID operationID, int templateOperation) {
        boolean isReadOperation = templateOperation == 2 || templateOperation == 3;
        boolean fifo = this.isFromFifoClass(pEntry.getEntryHolder(this).getServerTypeDesc());
        xtn.updateLock(pEntry, operationID, isReadOperation, fifo);
    }

    public void removeLockedEntry(XtnData xtn, IEntryCacheInfo pEntry) {
        IStoredList<IEntryCacheInfo> locked = xtn.getLockedEntries();
        if (locked != null && locked.removeByObject(pEntry) && this.isFromFifoClass(pEntry.getEntryHolder(this).getServerTypeDesc())) {
            IStoredList<IEntryCacheInfo> flocked = xtn.getLockedFifoEntries();
            flocked.removeByObject(pEntry);
        }
    }

    public IStorageAdapter getStorageAdapter() {
        return this._storageAdapter;
    }

    public FifoGroupCacheImpl getFifoGroupCacheImpl() {
        return this._fifoGroupCacheImpl;
    }

    private void updateReplicationContextForUpdateEntry(IReplicationOutContext replicationContext, IEntryData originalData, Context context, boolean[] partialUpdatedValuesIndicators) {
        ReplicationOutContext typedContext = (ReplicationOutContext)replicationContext;
        typedContext.setOperationID(context.getOperationID());
        if (!this._engine.getConflictingOperationPolicy().isOverride()) {
            typedContext.setPartialUpdatedValuesIndicators(partialUpdatedValuesIndicators);
        }
        typedContext.setFromGateway(context.isFromGateway());
        typedContext.setPreviousUpdatedEntryData(originalData);
    }

    private void updateReplicationContextForChangeEntry(IReplicationOutContext replicationContext, IEntryData originalData, Context context, Collection<SpaceEntryMutator> mutators) {
        ReplicationOutContext typedContext = (ReplicationOutContext)replicationContext;
        typedContext.setOperationID(context.getOperationID());
        typedContext.setFromGateway(context.isFromGateway());
        typedContext.setPreviousUpdatedEntryData(originalData);
        typedContext.setSpaceEntryMutators(mutators);
    }

    private void updateReplicationContext(IReplicationOutContext replicationContext, Context context) {
        ReplicationOutContext typedContext = (ReplicationOutContext)replicationContext;
        typedContext.setOperationID(context.getOperationID());
        typedContext.setFromGateway(context.isFromGateway());
    }

    private void updateReplicationContextForTransaction(IReplicationOutContext replicationContext, Context context, boolean[] updateRedoLogs, Map<String, Object> partialUpdatesAndInPlaceUpdatesInfo, OperationID[] opIDs, XtnEntry xtnEntry) {
        ReplicationOutContext typedContext = (ReplicationOutContext)replicationContext;
        typedContext.setOperationID(context.getOperationID());
        typedContext.setShouldReplicate(updateRedoLogs);
        typedContext.setPartialUpdatesInfo(partialUpdatesAndInPlaceUpdatesInfo);
        typedContext.setOperationIDs(opIDs);
        typedContext.setFromGateway(context.isFromGateway());
        typedContext.setOverrideVersionUids(xtnEntry.getOverrideVersionUids());
    }

    public Context getCacheContext() {
        return this._cacheContextFactory.getCacheContext();
    }

    public Context freeCacheContext(Context context) {
        if (context != null) {
            if (context.isActiveBlobStoreBulk() && context.getBlobStoreBulkInfo().getException() == null) {
                throw new RuntimeException("active BlobStore bulk in terminated context!!");
            }
            this._cacheContextFactory.freeCacheContext(context);
        }
        return null;
    }

    public Context viewCacheContext() {
        return this._cacheContextFactory.viewCacheContext();
    }

    public void startTemplateExpirationManager() {
        this._templateExpirationManager.start();
    }

    public TemplateExpirationManager getTemplateExpirationManager() {
        return this._templateExpirationManager;
    }

    public boolean testAndSetFGCacheForEntry(Context context, IEntryHolder entry, ITemplateHolder template, boolean testOnly, IServerTypeDesc tte) {
        Object val = this.getTypeData(tte).getFifoGroupingIndex().getIndexValue(entry.getEntryData());
        return this._fifoGroupCacheImpl.testAndSetFGCacheForEntry(context, entry, template, val, testOnly);
    }

    public void handleFifoGroupsCacheOnXtnEnd(Context context, XtnEntry xtnEntry) {
        this._fifoGroupCacheImpl.handleFifoGroupsCacheOnXtnEnd(context, xtnEntry);
    }

    public void addToEvictionStrategy(EvictableServerEntry entry, boolean isNew) {
        int numToEvict;
        boolean actualInsert;
        int maxCacheSize = this.getMaxCacheSize();
        boolean bl = actualInsert = this.isMemorySpace() || !((EvictableEntryCacheInfo)entry).isTransient();
        if (maxCacheSize != Integer.MAX_VALUE && maxCacheSize != 0 && (numToEvict = this._actualCacheSize.incrementAndGet() - maxCacheSize) > 0) {
            this._evictionStrategy.evict(numToEvict);
        }
        if (actualInsert) {
            if (isNew) {
                this._evictionStrategy.onInsert(entry);
            } else {
                this._evictionStrategy.onLoad(entry);
            }
        }
        ((EvictableEntryCacheInfo)entry).setInEvictionStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromEvictionStrategy(EvictableServerEntry entry) {
        if (!((EvictableEntryCacheInfo)entry).isInEvictionStrategy()) {
            return;
        }
        boolean actualRemove = this.isMemorySpace() || !((EvictableEntryCacheInfo)entry).isTransient();
        try {
            if (actualRemove) {
                if (this._evictionStrategy.requiresConcurrencyProtection()) {
                    ((EvictableEntryCacheInfo)entry).verifyBeforeEntryRemoval();
                }
                this._evictionStrategy.onRemove(entry);
            }
        }
        finally {
            ((EvictableEntryCacheInfo)entry).setRemovedFromEvictionStrategy(this._evictionStrategy.requiresConcurrencyProtection());
            int maxCacheSize = this.getMaxCacheSize();
            if (maxCacheSize != Integer.MAX_VALUE && maxCacheSize != 0) {
                this._actualCacheSize.decrementAndGet();
            }
        }
    }

    public Map<String, LocalCacheDetails> getLocalCaches() {
        return this._localCacheRegistrations.get();
    }

    public static Logger getCacheLogger() {
        return _logger;
    }

    public int getNumberOfEntries() {
        return this.getNumberOfEntries(this._typeManager.getServerTypeDesc(IServerTypeDesc.ROOT_TYPE_NAME), true);
    }

    public int getNumberOfEntries(String typeName, boolean includeSubtypes) {
        return this.getNumberOfEntries(this._typeManager.getServerTypeDesc(typeName), includeSubtypes);
    }

    private int getNumberOfEntries(IServerTypeDesc serverTypeDesc, boolean includeSubtypes) {
        if (serverTypeDesc == null || serverTypeDesc.isInactive()) {
            return -1;
        }
        int result = 0;
        if (includeSubtypes) {
            for (IServerTypeDesc subType : serverTypeDesc.getAssignableTypes()) {
                if (subType.isInactive()) continue;
                TypeData typeData = this._typeDataMap.get(subType);
                result += typeData == null ? 0 : typeData.getEntries().size();
            }
        } else {
            TypeData typeData = this._typeDataMap.get(serverTypeDesc);
            result += typeData == null ? 0 : typeData.getEntries().size();
        }
        return result;
    }

    public int getNumberOfNotifyTemplates() {
        return this.getNumberOfNotifyTemplates(this._typeManager.getServerTypeDesc(IServerTypeDesc.ROOT_TYPE_NAME), true);
    }

    public int getNumberOfNotifyTemplates(String typeName, boolean includeSubtypes) {
        return this.getNumberOfNotifyTemplates(this._typeManager.getServerTypeDesc(typeName), includeSubtypes);
    }

    private int getNumberOfNotifyTemplates(IServerTypeDesc serverTypeDesc, boolean includeSubtypes) {
        if (serverTypeDesc == null || serverTypeDesc.isInactive()) {
            return -1;
        }
        int result = 0;
        if (includeSubtypes) {
            for (IServerTypeDesc subType : serverTypeDesc.getAssignableTypes()) {
                if (subType.isInactive()) continue;
                TypeData typeData = this._typeDataMap.get(subType);
                result += typeData == null ? 0 : typeData.getTotalNotifyTemplates();
            }
        } else {
            TypeData typeData = this._typeDataMap.get(serverTypeDesc);
            result += typeData == null ? 0 : typeData.getTotalNotifyTemplates();
        }
        return result;
    }

    public SpaceRuntimeInfo getRuntimeInfo(String typeName) {
        Map<String, Integer> entriesInfo;
        boolean memoryOnlyIter;
        IServerTypeDesc serverTypeDesc = this._typeManager.getServerTypeDesc(typeName);
        if (serverTypeDesc == null) {
            throw new IllegalArgumentException("Runtime info couldn't be extracted. Unknown class [" + typeName + "] for space [" + this._engine.getFullSpaceName() + "]");
        }
        boolean bl = memoryOnlyIter = this.isCacheExternalDB() || this.isResidentEntriesCachePolicy();
        if (memoryOnlyIter && !this.useRecentDeletes()) {
            entriesInfo = null;
        } else {
            boolean loadPersistent = !this.isMemorySpace() && !this.isResidentEntriesCachePolicy() && !memoryOnlyIter;
            entriesInfo = this.countEntries(serverTypeDesc, loadPersistent);
        }
        return this.getRuntimeInfo(serverTypeDesc, entriesInfo);
    }

    private SpaceRuntimeInfo getRuntimeInfo(IServerTypeDesc serverTypeDesc, Map<String, Integer> entriesInfo) {
        IServerTypeDesc[] subTypes = serverTypeDesc.getAssignableTypes();
        ArrayList<String> classes = new ArrayList<String>(subTypes.length);
        ArrayList<Integer> entries = new ArrayList<Integer>(subTypes.length);
        ArrayList<Integer> templates = new ArrayList<Integer>(subTypes.length);
        for (IServerTypeDesc subType : subTypes) {
            if (subType.isInactive()) continue;
            classes.add(subType.getTypeName());
            if (entriesInfo == null) {
                entries.add(this.getNumberOfEntries(subType, false));
            } else {
                Integer count = entriesInfo.get(subType.getTypeName());
                entries.add(count != null ? count : 0);
            }
            templates.add(this.getNumberOfNotifyTemplates(subType, false));
        }
        return new SpaceRuntimeInfo(classes, entries, templates);
    }

    private void countPersistentEntries(Map<String, Integer> classCountMap, ITemplateHolder template, IServerTypeDesc[] subTypes) {
        Context context = null;
        try {
            context = this.getCacheContext();
            for (IServerTypeDesc subtype : subTypes) {
                if (subtype.isInactive()) continue;
                int count = this._storageAdapter.count(template, new String[]{subtype.getTypeName()});
                classCountMap.put(subtype.getTypeName(), count);
            }
        }
        catch (SAException ex) {
            throw new InternalSpaceException(ex.getMessage(), ex);
        }
        finally {
            this.freeCacheContext(context);
        }
    }

    private Map<String, Integer> countEntries(IServerTypeDesc serverTypeDesc, boolean loadPersistent) {
        ITemplateHolder template = TemplateHolderFactory.createEmptyTemplateHolder(this._engine, this._engine.createUIDFromCounter(), LeaseManager.toAbsoluteTime(0L), false);
        IServerTypeDesc[] subTypes = serverTypeDesc.getAssignableTypes();
        HashMap<String, Integer> entriesInfo = new HashMap<String, Integer>(subTypes.length);
        for (IServerTypeDesc subType : subTypes) {
            if (!subType.isActive()) continue;
            entriesInfo.put(subType.getTypeName(), 0);
        }
        if (loadPersistent) {
            this.countPersistentEntries(entriesInfo, template, subTypes);
        }
        Context context = null;
        ISAdapterIterator<IEntryHolder> entriesIter = null;
        try {
            context = this.getCacheContext();
            entriesIter = this.makeEntriesIter(context, template, serverTypeDesc, 0L, SystemTime.timeMillis(), true);
            String curClass = null;
            int currCount = 0;
            if (entriesIter != null) {
                IEntryHolder entryHolder;
                while ((entryHolder = entriesIter.next()) != null) {
                    if (loadPersistent && !entryHolder.isTransient() || this.isDummyEntry(entryHolder)) continue;
                    if (entryHolder.getClassName().equals(curClass)) {
                        ++currCount;
                        continue;
                    }
                    if (curClass != null) {
                        entriesInfo.put(curClass, currCount);
                    }
                    curClass = entryHolder.getClassName();
                    Integer classCount = (Integer)entriesInfo.get(entryHolder.getClassName());
                    if (classCount == null) {
                        currCount = 1;
                        continue;
                    }
                    currCount = classCount + 1;
                }
            }
            if (curClass != null) {
                entriesInfo.put(curClass, currCount);
            }
        }
        catch (SAException e) {
            throw new InternalSpaceException(e.toString(), e);
        }
        finally {
            try {
                if (entriesIter != null) {
                    entriesIter.close();
                }
            }
            catch (SAException ex) {
                this.freeCacheContext(context);
                context = null;
                throw new InternalSpaceException(ex.toString(), ex);
            }
            if (context != null) {
                this.freeCacheContext(context);
            }
        }
        return entriesInfo;
    }

    public QueryExtensionIndexManagerWrapper getQueryExtensionManager(String namespace) {
        return this.queryExtensionManagers.get(namespace);
    }

    public void closeQueryExtensionManagers() {
        for (QueryExtensionIndexManagerWrapper manager : this.queryExtensionManagers.values()) {
            try {
                manager.close();
            }
            catch (Throwable e) {
                if (!_logger.isLoggable(Level.WARNING)) continue;
                _logger.warning("failure closing query extention manager " + manager.toString());
            }
        }
        this.queryExtensionManagers.clear();
    }

    private class TypeDescListener
    implements IServerTypeDescListener {
        private TypeDescListener() {
        }

        @Override
        public void onTypeAdded(IServerTypeDesc typeDesc) {
            if (typeDesc.isActive()) {
                this.CreateTypeDataIfAbsent(typeDesc);
            }
        }

        @Override
        public void onTypeActivated(IServerTypeDesc typeDesc) {
            this.CreateTypeDataIfAbsent(typeDesc);
        }

        @Override
        public void onTypeDeactivated(IServerTypeDesc typeDesc) {
            this.unregisterTypeMetrics(typeDesc.getTypeName());
            CacheManager.this.dropClass(typeDesc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTypeIndexAdded(IServerTypeDesc typeDesc) {
            TypeData oldTypeData = CacheManager.this._typeDataMap.get(typeDesc);
            oldTypeData.typeLock();
            try {
                TypeData newTypeData = this.replaceTypeData(typeDesc, TypeData.TypeDataRecreationReasons.DYNAMIC_INDEX_CREATION);
                oldTypeData.setTypeDataReplaced();
                if (newTypeData.getLastIndexPendingCreationNumber() == 0) {
                    return;
                }
                CacheManager.this.reindexTypeEntries(newTypeData, true);
                TypeData typeData = this.replaceTypeData(typeDesc, TypeData.TypeDataRecreationReasons.DYNAMIC_INDEX_CREATION_COMPLETION);
            }
            finally {
                oldTypeData.typeUnLock();
            }
        }

        private void CreateTypeDataIfAbsent(IServerTypeDesc serverTypeDesc) {
            TypeData typeData = CacheManager.this._typeDataMap.get(serverTypeDesc);
            if (typeData == null) {
                typeData = CacheManager.this._typeDataFactory.createTypeData(serverTypeDesc);
                CacheManager.this._typeDataMap.put(serverTypeDesc, typeData);
                if (!CacheManager.this._engine.isLocalCache()) {
                    this.registerTypeMetrics(serverTypeDesc);
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Created new TypeData for type " + serverTypeDesc.getTypeName() + " [typeId=" + serverTypeDesc.getTypeId() + "]");
                }
            }
        }

        private void registerTypeMetrics(IServerTypeDesc serverTypeDesc) {
            short typeDescCode = serverTypeDesc.getServerTypeDescCode();
            final String typeName = serverTypeDesc.getTypeName();
            String metricTypeName = typeName.equals(IServerTypeDesc.ROOT_TYPE_NAME) ? "total" : typeName;
            MetricRegistrator registrator = CacheManager.this._engine.getMetricRegistrator();
            registrator.register(registrator.toPath("data", "entries", metricTypeName), new Gauge<Integer>(){

                @Override
                public Integer getValue() throws Exception {
                    return CacheManager.this.getNumberOfEntries(typeName, true);
                }
            });
            registrator.register(registrator.toPath("data", "notify-templates", metricTypeName), new Gauge<Integer>(){

                @Override
                public Integer getValue() throws Exception {
                    return CacheManager.this.getNumberOfNotifyTemplates(typeName, true);
                }
            });
            if (!typeName.equals(IServerTypeDesc.ROOT_TYPE_NAME) && CacheManager.this.isBlobStoreCachePolicy()) {
                if (CacheManager.this.getBlobStoreStorageHandler().getOffHeapCache() != null) {
                    CacheManager.this.getBlobStoreStorageHandler().getOffHeapCache().register(typeName, typeDescCode);
                }
                if (CacheManager.this.getBlobStoreStorageHandler().getOffHeapStore() != null) {
                    CacheManager.this.getBlobStoreStorageHandler().getOffHeapStore().register(typeName, typeDescCode);
                }
            }
        }

        private void unregisterTypeMetrics(String typeName) {
            String metricTypeName = typeName.equals(IServerTypeDesc.ROOT_TYPE_NAME) ? "total" : typeName;
            MetricRegistrator registrator = CacheManager.this._engine.getMetricRegistrator();
            registrator.unregisterByPrefix(registrator.toPath("data", "entries", metricTypeName));
            registrator.unregisterByPrefix(registrator.toPath("data", "notify-templates", metricTypeName));
            if (!typeName.equals(IServerTypeDesc.ROOT_TYPE_NAME) && CacheManager.this.isBlobStoreCachePolicy()) {
                short typeDescCode = CacheManager.this._typeManager.getServerTypeDesc(typeName).getServerTypeDescCode();
                if (CacheManager.this.getBlobStoreStorageHandler().getOffHeapCache() != null) {
                    CacheManager.this.getBlobStoreStorageHandler().getOffHeapCache().unregister(typeName, typeDescCode);
                }
                if (CacheManager.this.getBlobStoreStorageHandler().getOffHeapStore() != null) {
                    CacheManager.this.getBlobStoreStorageHandler().getOffHeapStore().unregister(typeName, typeDescCode);
                }
            }
        }

        private TypeData replaceTypeData(IServerTypeDesc serverTypeDesc, TypeData.TypeDataRecreationReasons reason) {
            TypeData oldTypeData = CacheManager.this._typeDataMap.get(serverTypeDesc);
            TypeData newTypeData = CacheManager.this._typeDataFactory.createTypeDataOnDynamicIndexCreation(serverTypeDesc, oldTypeData, reason);
            CacheManager.this._typeDataMap.put(serverTypeDesc, newTypeData);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "replaced TypeData for type [" + serverTypeDesc.getTypeName() + "], typeId: " + serverTypeDesc.getTypeId() + ", isInactive: " + serverTypeDesc.isInactive() + " reason: " + (Object)((Object)reason));
            }
            return newTypeData;
        }
    }

    public static enum RecentDeleteCodes {
        NONE,
        INSERT_DUMMY,
        REMOVE_DUMMY;

    }

    public static enum InitialLoadOrigin {
        NON,
        FROM_NON_BLOBSTORE,
        FROM_BLOBSTORE;

    }
}

