/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.CompoundIndexSegmentTypeData;
import com.j_spaces.core.cache.CustomTypeDataIndex;
import com.j_spaces.core.cache.ICompoundIndexValueHolder;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.fifoGroup.FifoGroupsCompoundIndexExtention;
import com.j_spaces.kernel.IObjectInfo;
import java.security.InvalidParameterException;

@InternalApi
public class CompoundCustomTypeDataIndex<K>
extends CustomTypeDataIndex<K> {
    private final TypeDataIndex[] _segmentsFromIndexes;
    private final CompoundIndexSegmentTypeData[] _segments;
    private final int _maxFixedPropertiesSegmentsPos;
    private final boolean _considerValueClone;
    private boolean _valueTypeFinallySet;
    public static ICompoundIndexValueHolder.LowEdge _lowEdge = new ICompoundIndexValueHolder.LowEdge();
    public static ICompoundIndexValueHolder.HighEdge _highEdge = new ICompoundIndexValueHolder.HighEdge();

    public CompoundCustomTypeDataIndex(CacheManager cacheManager, ISpaceIndex index, CompoundIndexSegmentTypeData[] segments, int indexCreationNumber, int indexPosition, ISpaceIndex.FifoGroupsIndexTypes fifoGroupsIndexType) {
        super(cacheManager, index, indexPosition, indexCreationNumber, fifoGroupsIndexType);
        if (segments.length == 1) {
            throw new InvalidParameterException();
        }
        this._segments = segments;
        boolean considerClone = false;
        for (CompoundIndexSegmentTypeData segment : segments) {
            if (!segment.isConsiderValueClone()) continue;
            considerClone = true;
            break;
        }
        this._considerValueClone = considerClone;
        TypeDataIndex[] segmentsFromIndexes = new TypeDataIndex[this._segments.length];
        for (CompoundIndexSegmentTypeData segment : segments) {
            if (segment.getOriginatingIndex() == null) {
                segmentsFromIndexes = null;
                break;
            }
            segmentsFromIndexes[segment.getSegmentPoition() - 1] = segment.getOriginatingIndex();
        }
        this._segmentsFromIndexes = segmentsFromIndexes;
        int maxFixedPropertiesSegmentsPos = -1;
        for (CompoundIndexSegmentTypeData segment : segments) {
            if (segment.getFixedPropertyPos() == -1) {
                maxFixedPropertiesSegmentsPos = -1;
                break;
            }
            if (segment.getFixedPropertyPos() <= maxFixedPropertiesSegmentsPos) continue;
            maxFixedPropertiesSegmentsPos = segment.getFixedPropertyPos();
        }
        this._valueTypeFinallySet = this._segmentsFromIndexes != null;
        this._maxFixedPropertiesSegmentsPos = maxFixedPropertiesSegmentsPos;
        if (fifoGroupsIndexType == ISpaceIndex.FifoGroupsIndexTypes.COMPOUND) {
            this._fifoGroupsIndexExtention = new FifoGroupsCompoundIndexExtention(cacheManager, this);
        }
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public int getMaxFixedPropertiesSegmentPos() {
        return this._maxFixedPropertiesSegmentsPos;
    }

    private int getNumSegments() {
        return this._segments.length;
    }

    @Override
    public TypeDataIndex[] getSegmentsOriginatingIndexes() {
        return this._segmentsFromIndexes;
    }

    @Override
    public Object getIndexValue(ServerEntry entry) {
        return this.getIndexDefinition().getIndexValue(entry);
    }

    @Override
    public Object getIndexValueForTemplate(ServerEntry entry) {
        return this.getIndexValue(entry);
    }

    @Override
    public Object getCompoundIndexValueForTemplate(ServerEntry entry) {
        return this.getIndexValue(entry);
    }

    @Override
    protected void insertBasicIndexTemplate(TemplateCacheInfo pTemplate, boolean isNullIndex) {
    }

    @Override
    protected int removeBasicIndexTemplate(TemplateCacheInfo pTemplate, IObjectInfo<TemplateCacheInfo> oi, int refpos) {
        return refpos;
    }

    @Override
    protected boolean isConsiderValueClone() {
        return this._considerValueClone;
    }

    @Override
    public CompoundIndexSegmentTypeData[] getCompoundIndexSegments() {
        return this._segments;
    }

    @Override
    K cloneIndexValue(K fieldValue, IEntryHolder entryHolder) {
        if (!this.isConsiderValueClone() || fieldValue == null) {
            return fieldValue;
        }
        ICompoundIndexValueHolder vh = (ICompoundIndexValueHolder)fieldValue;
        for (int i = 0; i < vh.getNumSegments(); ++i) {
            Object val = this._segments[i].cloneIndexValue(vh.getValueBySegment(i + 1), entryHolder);
            if (val == vh.getValueBySegment(i + 1)) continue;
            vh.setValueForSegment(val, i + 1);
        }
        return fieldValue;
    }

    @Override
    void updateValueType(Object fieldValue) {
        if (this._valueTypeFinallySet) {
            return;
        }
        ICompoundIndexValueHolder h = (ICompoundIndexValueHolder)fieldValue;
        boolean finalTypes = true;
        for (int i = 0; i < this._segments.length; ++i) {
            if (this._segments[i].updateValueType(h.getValueBySegment(i + 1))) continue;
            finalTypes = false;
        }
        if (finalTypes) {
            this._valueTypeFinallySet = true;
        }
    }
}

