/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.metadata.index.ISpaceCompoundIndexSegment;
import com.j_spaces.core.cache.DefaultValueCloner;
import com.j_spaces.core.cache.IValueCloner;
import com.j_spaces.core.cache.TypeDataIndex;
import java.util.Map;

@InternalApi
public class CompoundIndexSegmentTypeData {
    private final ISpaceCompoundIndexSegment _segment;
    private final TypeDataIndex _originatingIndex;
    private final ThreadLocal<IValueCloner> _valueCloner;
    private final boolean _considerValueClone;
    private final boolean _cloneableIndexValue;
    private final boolean _valueTypeKnown;
    private Class<?> _valueType;
    private boolean _valueTypeFinallySet;
    private final int _segmentPosition;
    private final int _fixedPropertyPosition;

    public CompoundIndexSegmentTypeData(ISpaceCompoundIndexSegment segment, Map<String, TypeDataIndex<?>> indexTable, IServerTypeDesc serverTypeDesc) {
        this._segment = segment;
        TypeDataIndex<?> originatingIndex = indexTable.get(segment.getName());
        this._segmentPosition = segment.getSegmentPosition();
        if (originatingIndex != null) {
            this._originatingIndex = originatingIndex;
            this._valueCloner = null;
            this._considerValueClone = originatingIndex.isConsiderValueClone();
            this._cloneableIndexValue = false;
            this._valueTypeKnown = false;
            this._valueTypeFinallySet = true;
        } else {
            this._originatingIndex = null;
            this._valueCloner = new ThreadLocal();
            String val = System.getProperty("com.gs.cacheManager.EmbeddedIndexProtection");
            Class valueClass = null;
            boolean embeddedIndexProtection = new Boolean(val != null ? val : "true");
            if (segment.isPropertySegment()) {
                int pos = serverTypeDesc.getTypeDesc().getFixedPropertyPosition(segment.getName());
                if (pos != -1) {
                    PropertyInfo property = serverTypeDesc.getTypeDesc().getFixedProperty(pos);
                    valueClass = property.getType();
                    this._valueType = valueClass;
                } else {
                    valueClass = Object.class;
                }
                this._valueTypeFinallySet = true;
            }
            if (!embeddedIndexProtection) {
                this._considerValueClone = false;
                this._cloneableIndexValue = false;
                this._valueTypeKnown = false;
            } else if (valueClass == null || valueClass.getName().equals("java.lang.Object")) {
                this._valueTypeKnown = false;
                this._considerValueClone = true;
                this._cloneableIndexValue = false;
            } else {
                this._valueTypeKnown = true;
                if (TypeDataIndex.isImmutableIndexValue(valueClass)) {
                    this._considerValueClone = false;
                    this._cloneableIndexValue = false;
                } else {
                    this._considerValueClone = true;
                    this._cloneableIndexValue = TypeDataIndex.isCloneableIndexValue(valueClass);
                }
            }
        }
        String name = segment.getName();
        this._fixedPropertyPosition = segment.isPropertySegment() || !segment.getName().contains(".") ? serverTypeDesc.getTypeDesc().getFixedPropertyPosition(name) : serverTypeDesc.getTypeDesc().getFixedPropertyPosition(name.substring(0, name.indexOf(".")));
    }

    public ISpaceCompoundIndexSegment getDefinitionSegment() {
        return this._segment;
    }

    public boolean isConsiderValueClone() {
        return this._considerValueClone;
    }

    public <K> K cloneIndexValue(K fieldValue, IEntryHolder entryHolder) {
        Object res;
        Class<?> clzz;
        if (this._originatingIndex == null && this._valueType == null && fieldValue != null) {
            this.updateValueType(fieldValue);
        }
        if (!this.isConsiderValueClone() || fieldValue == null) {
            return fieldValue;
        }
        if (this._originatingIndex != null) {
            return this._originatingIndex.cloneIndexValue(fieldValue, entryHolder);
        }
        Class<?> clazz = clzz = !this._valueTypeKnown ? fieldValue.getClass() : this.getValueType();
        if (!this._valueTypeKnown && TypeDataIndex.isImmutableIndexValue(clzz)) {
            return fieldValue;
        }
        if (this._valueCloner.get() == null) {
            this._valueCloner.set(new DefaultValueCloner());
        }
        if (!((res = this._valueCloner.get().cloneValue(fieldValue, this._cloneableIndexValue, clzz, entryHolder.getUID(), entryHolder.getClassName())) == fieldValue || fieldValue.hashCode() == res.hashCode() && fieldValue.equals(res))) {
            throw new RuntimeException("Entry Class: " + entryHolder.getClassName() + " - Wrong hashCode() or equals() implementation of " + fieldValue.getClass() + " class field");
        }
        return (K)res;
    }

    public Class<?> getValueType() {
        return this._originatingIndex != null ? this._originatingIndex.getValueType() : this._valueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateValueType(Object value) {
        if (this._valueTypeFinallySet || value == null) {
            return this._valueTypeFinallySet;
        }
        Class<?> type = value.getClass();
        if (this._valueType == null) {
            CompoundIndexSegmentTypeData compoundIndexSegmentTypeData = this;
            synchronized (compoundIndexSegmentTypeData) {
                if (this._valueType == null) {
                    this._valueType = type;
                }
            }
        }
        if (this._valueType != type && !this._valueType.isAssignableFrom(type)) {
            CompoundIndexSegmentTypeData compoundIndexSegmentTypeData = this;
            synchronized (compoundIndexSegmentTypeData) {
                this._valueType = TypeDataIndex.getCommonSuperType(type, this._valueType);
            }
        }
        if (this._valueType == Object.class) {
            this._valueTypeFinallySet = true;
        }
        return this._valueTypeFinallySet;
    }

    public TypeDataIndex getOriginatingIndex() {
        return this._originatingIndex;
    }

    public int getSegmentPoition() {
        return this._segmentPosition;
    }

    public int getFixedPropertyPos() {
        return this._fixedPropertyPosition;
    }

    public boolean isValueTypeFinallySet() {
        return this._valueTypeFinallySet;
    }
}

