/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metadata.index.ISpaceCompoundIndexSegment;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.ICompoundIndexValueHolder;
import java.security.InvalidParameterException;

@InternalApi
public class CompoundIndexValueHolder
implements ICompoundIndexValueHolder {
    private final Object[] _values;

    public CompoundIndexValueHolder(ISpaceCompoundIndexSegment[] segments, ServerEntry entry) {
        this._values = new Object[segments.length];
        for (int i = 0; i < segments.length; ++i) {
            this._values[i] = segments[i].getSegmentValue(entry);
        }
    }

    public CompoundIndexValueHolder(Object[] segmentValues) {
        this._values = segmentValues;
    }

    @Override
    public Object getValueBySegment(int segmentNumber) {
        if (segmentNumber < 1 || segmentNumber > this._values.length) {
            throw new InvalidParameterException();
        }
        return this._values[segmentNumber - 1];
    }

    @Override
    public int getNumSegments() {
        return this._values.length;
    }

    @Override
    public void setValueForSegment(Object value, int segmentNumber) {
        if (segmentNumber > this._values.length || segmentNumber < 1) {
            throw new IllegalArgumentException();
        }
        this._values[segmentNumber - 1] = value;
    }

    public boolean isExtendedMatchConditionHolder() {
        return false;
    }

    public int hashCode() {
        int hash = 17;
        for (int i = 0; i < this._values.length; ++i) {
            if (this._values[i] == null) continue;
            hash = hash * 31 + this._values[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ICompoundIndexValueHolder)) {
            return false;
        }
        ICompoundIndexValueHolder o = (ICompoundIndexValueHolder)other;
        if (this._values.length != o.getNumSegments()) {
            return false;
        }
        for (int i = 0; i < this._values.length; ++i) {
            if (this._values[i].equals(o.getValueBySegment(i + 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ICompoundIndexValueHolder o) {
        if (o == this) {
            return 0;
        }
        int res = 0;
        for (int i = 0; i < this._values.length; ++i) {
            Comparable v2;
            Comparable v1;
            if (o.getValueBySegment(i + 1) == this._values[i] || (res = (v1 = (Comparable)this._values[i]).compareTo(v2 = (Comparable)o.getValueBySegment(i + 1))) == 0) continue;
            return res;
        }
        return 0;
    }

    @Override
    public Object[] getValues() {
        return this._values;
    }
}

