/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.j_spaces.core.cache.AbstractMultiValueIndexHandler;
import com.j_spaces.core.cache.ArrayIndexHandler;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.CollectionIndexHandler;
import com.j_spaces.core.cache.CustomTypeDataIndex;
import com.j_spaces.core.cache.GeneralMultiValueIndexHandler;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.kernel.IObjectInfo;
import java.util.ArrayList;
import java.util.Iterator;

@InternalApi
public class CustomMultiValueTypeDataIndex<K>
extends CustomTypeDataIndex<K> {
    private final AbstractMultiValueIndexHandler<K> _multiValueIndexHandler;
    private final ISpaceIndex.MultiValuePerEntryIndexTypes _multiValueType;

    public CustomMultiValueTypeDataIndex(CacheManager cacheManager, ISpaceIndex index, int pos, int indexCreationNumber, ISpaceIndex.MultiValuePerEntryIndexTypes multiValueType) {
        super(cacheManager, index, pos, indexCreationNumber);
        this._multiValueType = multiValueType;
        switch (this._multiValueType) {
            case COLLECTION: {
                this._multiValueIndexHandler = new CollectionIndexHandler(this);
                break;
            }
            case ARRAY: {
                this._multiValueIndexHandler = new ArrayIndexHandler(this);
                break;
            }
            case GENERAL: {
                this._multiValueIndexHandler = new GeneralMultiValueIndexHandler(this);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public boolean isMultiValuePerEntryIndex() {
        return true;
    }

    @Override
    public void insertEntryIndexedField(IEntryCacheInfo pEntry, K fieldValue, TypeData pType) {
        this._multiValueIndexHandler.insertEntryIndexedField(pEntry, fieldValue, pType, pEntry.getBackRefs());
    }

    @Override
    public void insertEntryIndexedField(IEntryCacheInfo pEntry, K fieldValue, TypeData pType, ArrayList<IObjectInfo<IEntryCacheInfo>> insertBackRefs) {
        this._multiValueIndexHandler.insertEntryIndexedField(pEntry, fieldValue, pType, insertBackRefs);
    }

    @Override
    public int removeEntryIndexedField(IEntryHolder eh, ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs, K fieldValue, int refpos, boolean removeIndexedValue, IEntryCacheInfo pEntry) {
        return this._multiValueIndexHandler.removeEntryIndexedField(eh, deletedBackRefs, fieldValue, refpos, removeIndexedValue, pEntry);
    }

    @Override
    public int updateIndexValue(TypeData pType, IEntryHolder eh, IEntryCacheInfo pEntry, K original, K updated, ArrayList<IObjectInfo<IEntryCacheInfo>> originalBackRefs, int refpos, TypeDataIndex.UpdateIndexModes updateMode) {
        return this._multiValueIndexHandler.updateMultiValueIndex(pType, eh, pEntry, original, updated, originalBackRefs, refpos, updateMode);
    }

    @Override
    public int updateIndexValueUndexXtn(TypeData pType, IEntryHolder eh, IEntryCacheInfo pEntry, K previous, K updated, ArrayList<IObjectInfo<IEntryCacheInfo>> previousBackRefs, int refpos, boolean entry_double_update) {
        return this._multiValueIndexHandler.updateMultiValueIndexUndexXtn(pType, eh, pEntry, previous, updated, previousBackRefs, refpos);
    }

    @Override
    int consolidateIndexValueOnXtnEnd(IEntryHolder eh, IEntryCacheInfo pEntry, K keptValue, K deletedVlaue, ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs, int refpos, boolean onError) {
        return this._multiValueIndexHandler.consolidateMultiValueIndexOnXtnEnd(eh, pEntry, keptValue, deletedVlaue, deletedBackRefs, refpos, onError);
    }

    @Override
    protected int multiValueSize(Object mvo) {
        return this._multiValueIndexHandler.multiValueSize(mvo);
    }

    @Override
    protected Iterator<K> multiValueIterator(Object mvo) {
        return this._multiValueIndexHandler.multiValueIterator(mvo);
    }
}

