/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.GSByteArrayInputStream;
import com.gigaspaces.internal.io.GSByteArrayOutputStream;
import com.gigaspaces.internal.io.MarshalInputStream;
import com.gigaspaces.internal.io.MarshalOutputStream;
import com.gigaspaces.internal.utils.ClassLoaderThreadLocal;
import com.j_spaces.core.cache.IValueCloner;
import com.j_spaces.core.client.FieldValueCloningErrorException;

@InternalApi
public class DefaultValueCloner
implements IValueCloner {
    private static final byte[] _resetBuffer = new byte[]{121, 112};
    MarshalInputStream _mis = null;
    MarshalOutputStream _mos = null;
    GSByteArrayOutputStream _os;
    GSByteArrayInputStream _is;
    private static final int INITIAL_SIZE = 64;
    private static final ClassLoaderThreadLocal<IValueCloner> _valueClonerCache = new ClassLoaderThreadLocal<IValueCloner>(){

        @Override
        protected IValueCloner initialValue() {
            return new DefaultValueCloner();
        }
    };

    public static IValueCloner get() {
        return _valueClonerCache.get();
    }

    @Override
    public Object cloneValue(Object originalValue, boolean isCloneable, Class<?> clzz, String uid, String entryClassName) {
        if (isCloneable && clzz != null) {
            try {
                return clzz.getMethod("clone", new Class[0]).invoke(originalValue, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Object res;
            if (this._mis == null) {
                this._os = new GSByteArrayOutputStream(64);
                this._is = new GSByteArrayInputStream(this._os.getBuffer());
                this._mos = new MarshalOutputStream(this._os);
                this._mis = new MarshalInputStream(this._is);
            }
            this._mos.writeUnshared(originalValue);
            this._is.setBuffer(this._os.getBuffer(), this._os.getCount());
            Object object = res = this._mis.readUnshared();
            return object;
        }
        catch (Exception ex) {
            if (clzz == null) {
                clzz = originalValue.getClass();
            }
            throw new FieldValueCloningErrorException(uid, entryClassName, clzz.getName(), originalValue, ex);
        }
        finally {
            this.reset();
        }
    }

    public void reset() {
        try {
            if (this._mos != null) {
                this._is.reset();
                this._os.reset();
                this._mos.reset();
                byte[] buffer = this._is.getBuffer();
                this._is.setBuffer(_resetBuffer);
                this._mis.readObject();
                this._is.setBuffer(buffer);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

