/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ObjectIntegerMap;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.MatchResult;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.XtnStatus;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.SAIterBase;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.blobStore.IBlobStoreRefCacheInfo;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.list.ScanSingleListIterator;
import java.util.HashSet;
import java.util.Random;

@InternalApi
public class EntriesIter
extends SAIterBase
implements ISAdapterIterator<IEntryHolder> {
    private boolean _notRefreshCache;
    private IServerTypeDesc[] _types;
    private int _currentClass;
    private int _actualClass;
    private IScanListIterator<IEntryCacheInfo> _entries;
    private final ITemplateHolder _templateHolder;
    private final long _SCNFilter;
    private final long _leaseFilter;
    private IEntryCacheInfo _currentEntryCacheInfo;
    private IEntryHolder _currentEntryHolder;
    private boolean _doneWithCache;
    private HashSet<String> _entriesReturned;
    private ISAdapterIterator<IEntryHolder> _saIter;
    private boolean _firstFromCache = true;
    private final boolean _memoryOnly;
    private final boolean _transientOnly;
    private IEntryHolder _entryFromCache;
    private IEntryHolder _entryFromSA;
    private boolean _first = true;
    private ITypeDesc _typeDesc;
    private ObjectIntegerMap<String> _fifoClassesOrder;
    private final IServerTypeDesc _templateServerTypeDesc;
    private boolean _returnEntryCacheInfoOnly;
    private boolean _tryToUsePureIndexesBlobStore;
    private String[] _uids;
    private int _nextUidPos;
    private static final Random randomGenerator = new Random();

    public EntriesIter(Context context, ITemplateHolder template, IServerTypeDesc serverTypeDesc, CacheManager cacheManager, long SCNFilter, long leaseFilter, boolean memoryOnly, boolean transientOnly) throws SAException {
        super(context, cacheManager);
        this._templateServerTypeDesc = serverTypeDesc;
        this._memoryOnly = template.isMemoryOnlySearch() || memoryOnly;
        this._transientOnly = transientOnly;
        this._templateHolder = template;
        this._SCNFilter = SCNFilter;
        long l = this._leaseFilter = this._cacheManager.isBlobStoreCachePolicy() ? 0L : leaseFilter;
        if (!template.isEmptyTemplate()) {
            this._typeDesc = this._cacheManager.getTypeManager().getTypeDesc(template.getClassName());
        }
        if (template.getUidToOperateBy() != null || template.getMultipleUids() != null) {
            if (template.getMultipleUids() != null) {
                this._uids = template.getMultipleUids();
            } else {
                this._uids = new String[1];
                this._uids[0] = template.getUidToOperateBy();
            }
            if (this._cacheManager.isBlobStoreCachePolicy() && template.getCustomQuery() == null && template.isEmptyTemplate()) {
                this.setBringCacheInfoOnly(true);
            }
            return;
        }
        this._types = serverTypeDesc.getAssignableTypes();
        if (this._templateHolder.isFifoTemplate()) {
            int numOfFifoClasses = 0;
            boolean[] isFifo = new boolean[this._types.length];
            for (int i = 0; i < this._types.length; ++i) {
                if (!this._cacheManager.getTypeManager().isFifoType(this._types[i])) continue;
                isFifo[i] = true;
                ++numOfFifoClasses;
            }
            if (numOfFifoClasses == 0) {
                this._types = null;
                return;
            }
            if (numOfFifoClasses < this._types.length) {
                IServerTypeDesc[] onlyFifoTypes = new IServerTypeDesc[numOfFifoClasses];
                int j = 0;
                for (int i = 0; i < this._types.length; ++i) {
                    if (!isFifo[i]) continue;
                    onlyFifoTypes[j++] = this._types[i];
                }
                this._types = onlyFifoTypes;
            }
            this._fifoClassesOrder = CollectionsFactory.getInstance().createObjectIntegerMap();
            for (int k = 0; k < this._types.length; ++k) {
                this._fifoClassesOrder.put(this._types[k].getTypeName(), k);
            }
        }
        this._doneWithCache = false;
        if (this._cacheManager.isEvictableCachePolicy() && !this._cacheManager.isMemorySpace()) {
            this._entriesReturned = new HashSet();
        }
        if (this._types.length > 1) {
            int size = this._types.length - 1;
            if (!this._templateHolder.isFifoTemplate()) {
                this._actualClass = this.getMathRandom(size);
            }
        }
    }

    private int getMathRandom(int size) {
        return randomGenerator.nextInt(size);
    }

    @Override
    public IEntryHolder next() throws SAException {
        boolean memoryOverTimebasedeviction;
        if (this._uids != null) {
            return this.next_by_uid();
        }
        if (this._types == null) {
            return null;
        }
        boolean bl = memoryOverTimebasedeviction = this._memoryOnly && this._cacheManager.isTimeBasedEvictionStrategy();
        if (this._templateHolder.isFifoTemplate() && this._cacheManager.isEvictableCachePolicy() && !this._cacheManager.isMemorySpace() && !memoryOverTimebasedeviction) {
            return this.next_fifo();
        }
        while (!this._doneWithCache) {
            this.checkIfNext();
            if (this._currentEntryCacheInfo == null) {
                this._doneWithCache = true;
                if (this._cacheManager.isEvictableCachePolicy() && !this._cacheManager.isMemorySpace() && !this._memoryOnly && !this._transientOnly) {
                    this._saIter = this._cacheManager.getStorageAdapter().makeEntriesIter(this._templateHolder, this._SCNFilter, this._leaseFilter, this._types);
                }
                return this.saIterNext();
            }
            if (this._cacheManager.isEvictableCachePolicy() && !this._cacheManager.isMemorySpace() && !this._currentEntryHolder.isTransient() && !this._memoryOnly && !this._entriesReturned.add(this._currentEntryCacheInfo.getUID())) continue;
            return this._currentEntryHolder;
        }
        return this.saIterNext();
    }

    public IEntryHolder next_by_uid() throws SAException {
        this._currentEntryCacheInfo = null;
        this._currentEntryHolder = null;
        while (this._nextUidPos < this._uids.length) {
            String uid = this._uids[this._nextUidPos++];
            IEntryCacheInfo pEntry = null;
            IEntryHolder eh = null;
            pEntry = this._cacheManager.getPEntryByUid(uid);
            if (pEntry == null || this.invalidEntryCacheInfo(pEntry) || (this.isBringCacheInfoOnly() ? (eh = ((IBlobStoreRefCacheInfo)((Object)pEntry)).getEntryHolderIfInMemory()) != null && !this.match(eh) : this.invalidEntry(pEntry, eh = pEntry.getEntryHolder(this._cacheManager, this._context)) || !this.match(eh))) continue;
            this._currentEntryCacheInfo = pEntry;
            this._currentEntryHolder = eh;
            return this._currentEntryHolder;
        }
        return null;
    }

    public IEntryCacheInfo nextEntryCacheInfo() throws SAException {
        this.next();
        return this._currentEntryCacheInfo;
    }

    public Object nextObject() throws SAException {
        this.next();
        if (this.isBringCacheInfoOnly()) {
            return this._currentEntryCacheInfo;
        }
        return this._currentEntryHolder;
    }

    public IEntryCacheInfo getCurrentEntryCacheInfo() {
        return this._currentEntryCacheInfo;
    }

    public IEntryHolder getCurrentEntryHolder() {
        return this._currentEntryHolder;
    }

    private IEntryHolder next_fifo() throws SAException {
        IEntryHolder res;
        while (true) {
            IEntryHolder updated_res;
            if (this._first) {
                this._first = false;
                this._saIter = this._cacheManager.getStorageAdapter().makeEntriesIter(this._templateHolder, this._SCNFilter, this._leaseFilter, this._types);
            }
            if (this._saIter != null && this._entryFromSA == null) {
                this._entryFromSA = this.saIterNext();
                if (this._entryFromSA == null) {
                    this._saIter.close();
                    this._saIter = null;
                }
            }
            if (!this._doneWithCache && this._entryFromCache == null) {
                this.checkIfNext();
                if (this._currentEntryCacheInfo == null) {
                    this._doneWithCache = true;
                } else {
                    this._entryFromCache = this._currentEntryHolder;
                }
            }
            if (this._entryFromCache == null && this._entryFromSA == null) {
                return null;
            }
            res = null;
            boolean returnSA = false;
            if (this._entryFromCache != null && this._entryFromSA != null) {
                if (this._entryFromCache.getClassName().equals(this._entryFromSA.getClassName())) {
                    if (this._entryFromSA.getSCN() < this._entryFromCache.getSCN() || this._entryFromSA.getSCN() == this._entryFromCache.getSCN() && this._entryFromSA.getOrder() < this._entryFromCache.getOrder()) {
                        returnSA = true;
                    }
                } else {
                    int classCache;
                    int classSa = this._fifoClassesOrder.get(this._entryFromSA.getClassName());
                    returnSA = classSa < (classCache = this._fifoClassesOrder.get(this._entryFromCache.getClassName()));
                }
            } else if (this._entryFromSA != null) {
                returnSA = true;
            }
            if (returnSA) {
                res = this._entryFromSA;
                this._entryFromSA = null;
            } else {
                res = this._entryFromCache;
                this._entryFromCache = null;
            }
            if (res == null) break;
            if (!returnSA && !res.isTransient()) {
                if (!res.isMaybeUnderXtn()) {
                    res = null;
                    continue;
                }
                if ((res = this._cacheManager.getEntryByUidFromPureCache(res.getUID())) == null || !res.isMaybeUnderXtn()) {
                    res = null;
                    continue;
                }
                ITransactionalEntryData ed = res.getTxnEntryData();
                XtnEntry xtnEntry = ed.getWriteLockOwner();
                if (xtnEntry == null || xtnEntry.getStatus() != XtnStatus.BEGUN || ed.getWriteLockOperation() != 1 && ed.getWriteLockOperation() != 7) {
                    res = null;
                    continue;
                }
            }
            if (returnSA && (updated_res = this._cacheManager.getEntryByUidFromPureCache(res.getUID())) != null) {
                res = updated_res;
            }
            if (this._entriesReturned.add(res.getUID())) break;
            res = null;
        }
        this._context.setRawmatchResult(null, MatchResult.NONE, null, null);
        return res;
    }

    @Override
    public void close() throws SAException {
        if (this._entries != null) {
            this._entries.releaseScan();
        }
        if (this._saIter != null) {
            this._saIter.close();
        }
        super.close();
    }

    private void checkIfNext() {
        TypeData pType;
        if (this._currentClass >= this._types.length) {
            this._currentEntryCacheInfo = null;
            this._currentEntryHolder = null;
            return;
        }
        if (!this.moreEntriesForCurrentClass()) {
            if (!this._firstFromCache) {
                ++this._currentClass;
                ++this._actualClass;
            } else {
                this._firstFromCache = false;
            }
        }
        if (!this.moreEntriesForCurrentClass()) {
            while (this._currentClass < this._types.length) {
                if (this._actualClass >= this._types.length) {
                    this._actualClass = 0;
                }
                if ((pType = this._cacheManager.getTypeData(this._types[this._actualClass])) != null) {
                    this.getEntries(this._types[this._actualClass]);
                    if (this.moreEntriesForCurrentClass()) break;
                }
                ++this._currentClass;
                ++this._actualClass;
            }
            if (!this.moreEntriesForCurrentClass()) {
                this._currentEntryCacheInfo = null;
                this._currentEntryHolder = null;
                return;
            }
        }
        if (this.isRelevantEntry()) {
            return;
        }
        ++this._currentClass;
        ++this._actualClass;
        while (this._currentClass < this._types.length) {
            if (this._actualClass >= this._types.length) {
                this._actualClass = 0;
            }
            if ((pType = this._cacheManager.getTypeData(this._types[this._actualClass])) != null && (!this._templateHolder.isChangeById() || this._types[this._actualClass].getTypeName().equals(this._templateHolder.getServerTypeDesc()))) {
                this.getEntries(this._types[this._actualClass]);
                if (this.moreEntriesForCurrentClass() && this.isRelevantEntry()) {
                    return;
                }
            }
            ++this._currentClass;
            ++this._actualClass;
        }
        this._currentEntryCacheInfo = null;
        this._currentEntryHolder = null;
    }

    private boolean match(IEntryHolder eh) {
        return this._cacheManager.getEngine().getTemplateScanner().match(this._context, eh, this._templateHolder);
    }

    private void getEntries(IServerTypeDesc entryTypeDesc) {
        IScanListIterator<IEntryCacheInfo> res = this._cacheManager.getMatchingMemoryEntriesForScanning(this._context, entryTypeDesc, this._templateHolder, this._templateServerTypeDesc);
        if (this._context.isBlobStoreTryNonPersistentOp()) {
            if (this._context.isBlobStoreUsePureIndexesAccess() && this._context.isUsingIntersectedListForScanning()) {
                this.setBringCacheInfoOnly(true);
                this._tryToUsePureIndexesBlobStore = true;
            } else {
                boolean allNullsBlobStore;
                boolean bl = allNullsBlobStore = !this._templateHolder.isSqlQuery() && this._templateHolder.getXidOriginated() == null && this._templateHolder.getUidToOperateBy() == null;
                if (allNullsBlobStore && this._templateHolder.getEntryData().getFixedPropertiesValues() != null && this._templateHolder.getEntryData().getFixedPropertiesValues().length > 0) {
                    for (Object property : this._templateHolder.getEntryData().getFixedPropertiesValues()) {
                        if (property == null) continue;
                        allNullsBlobStore = false;
                        break;
                    }
                }
                this.setBringCacheInfoOnly(allNullsBlobStore);
            }
        }
        this._entries = res != null && res instanceof IEntryCacheInfo ? new ScanSingleListIterator<IEntryCacheInfo>((IStoredList)((Object)res), this._templateHolder.isFifoTemplate()) : res;
    }

    private boolean moreEntriesForCurrentClass() {
        return this._entries != null;
    }

    private IEntryHolder saIterNext() throws SAException {
        IEntryHolder entryHolder;
        block5: {
            IEntryHolder eh;
            if (this._saIter == null) {
                return null;
            }
            while (true) {
                if ((entryHolder = this._saIter.next()) == null) {
                    return null;
                }
                if (this._entriesReturned.contains(entryHolder.getUID())) continue;
                if (this._cacheManager.getEngine().isPartitionedSpace()) {
                    if (this._typeDesc == null || !this._typeDesc.getTypeName().equals(entryHolder.getClassName())) {
                        this._typeDesc = this._cacheManager.getTypeManager().getTypeDesc(entryHolder.getClassName());
                    }
                    if (!this._cacheManager.getEngine().isEntryFromPartition(entryHolder)) continue;
                }
                IEntryCacheInfo pEntry = null;
                if (this._notRefreshCache) break block5;
                if (this._templateHolder.isChangeById() && !entryHolder.getServerTypeDesc().getTypeName().equals(this._templateHolder.getServerTypeDesc().getTypeName())) continue;
                this._cacheManager.getEngine().getMemoryManager().monitorMemoryUsage(true);
                pEntry = this._cacheManager.insertEntryToCache(this._context, entryHolder, false, null, false, CacheManager.InitialLoadOrigin.NON);
                if (pEntry != null && ((eh = pEntry.getEntryHolder(this._cacheManager)) == entryHolder || this.match(eh))) break;
            }
            entryHolder = eh;
        }
        this._context.setRawmatchResult(null, MatchResult.NONE, null, null);
        this._currentEntryHolder = entryHolder;
        return entryHolder;
    }

    public void setNotRefreshCache() {
        this._notRefreshCache = true;
    }

    public void setBringCacheInfoOnly(boolean val) {
        this._returnEntryCacheInfoOnly = val;
    }

    public boolean isBringCacheInfoOnly() {
        return this._returnEntryCacheInfoOnly;
    }

    private boolean isRelevantEntry() {
        if (this._entries != null) {
            try {
                while (this._entries.hasNext()) {
                    IEntryHolder eh;
                    IEntryCacheInfo pEntry = this._entries.next();
                    if (pEntry == null) continue;
                    if (this._tryToUsePureIndexesBlobStore && !this._context.isBlobStoreUsePureIndexesAccess() && this.isBringCacheInfoOnly()) {
                        this.setBringCacheInfoOnly(false);
                    }
                    if (this._returnEntryCacheInfoOnly && pEntry.isBlobStoreEntry() && this._SCNFilter == 0L && this._leaseFilter == 0L) {
                        this._currentEntryHolder = null;
                        this._currentEntryCacheInfo = null;
                        if (this.invalidEntryCacheInfo(pEntry)) continue;
                        this._currentEntryCacheInfo = pEntry;
                        this._currentEntryHolder = ((IBlobStoreRefCacheInfo)((Object)pEntry)).getEntryHolderIfInMemory();
                        if (this._currentEntryHolder != null && !this.match(this._currentEntryHolder)) {
                            this._currentEntryHolder = null;
                            this._currentEntryCacheInfo = null;
                            continue;
                        }
                        return true;
                    }
                    if (pEntry.isBlobStoreEntry() && (pEntry.isDeleted() || !pEntry.preMatch(this._context, this._templateHolder)) || this.invalidEntry(pEntry, eh = pEntry.getEntryHolder(this._cacheManager)) || !this.match(eh)) continue;
                    this._currentEntryCacheInfo = pEntry;
                    this._currentEntryHolder = eh;
                    return true;
                }
            }
            catch (SAException sAException) {
                // empty catch block
            }
        }
        this._entries = null;
        return false;
    }

    private boolean invalidEntry(IEntryCacheInfo pEntry, IEntryHolder eh) {
        if (pEntry == null) {
            return true;
        }
        if (this._memoryOnly && !this._cacheManager.isResidentCacheEntry(pEntry)) {
            return true;
        }
        return this._cacheManager.isEvictableCachePolicy() && pEntry.isRemoving() || this._SCNFilter != 0L && eh.getSCN() < this._SCNFilter || this._leaseFilter != 0L && eh.isExpired(this._leaseFilter) && !this._cacheManager.getLeaseManager().isSlaveLeaseManagerForEntries() && !this._cacheManager.getEngine().isExpiredEntryStayInSpace(eh) || this._transientOnly && !eh.isTransient();
    }

    private boolean invalidEntryCacheInfo(IEntryCacheInfo pEntry) {
        return pEntry.isDeleted();
    }
}

