/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.cache.EvictableEntryCacheInfo;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.MemoryBasedEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;

@InternalApi
public class EntryCacheInfoFactory {
    public static IEntryCacheInfo createEntryCacheInfo(IEntryHolder EntryHolder2) {
        return new MemoryBasedEntryCacheInfo(EntryHolder2);
    }

    public static IEntryCacheInfo createEntryCacheInfo(IEntryHolder entryHolder, SpaceEngine engine) {
        MemoryBasedEntryCacheInfo ci = engine.getCacheManager().isEvictableCachePolicy() ? new EvictableEntryCacheInfo(entryHolder) : new MemoryBasedEntryCacheInfo(entryHolder);
        return ci;
    }

    public static IEntryCacheInfo createBlobStoreEntryCacheInfo(IEntryHolder entryHolder) {
        BlobStoreRefEntryCacheInfo eci = new BlobStoreRefEntryCacheInfo(entryHolder);
        ((IBlobStoreEntryHolder)((Object)entryHolder)).setBlobStoreResidentPart(eci);
        return eci;
    }

    public static IEntryCacheInfo createEntryCacheInfo(IEntryHolder entryHolder, int backRefsSize, boolean pin, SpaceEngine engine) {
        return engine.getCacheManager().isEvictableCachePolicy() ? new EvictableEntryCacheInfo(entryHolder, backRefsSize, pin) : new MemoryBasedEntryCacheInfo(entryHolder, backRefsSize);
    }
}

