/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.utils.concurrent.UncheckedAtomicIntegerFieldUpdater;
import com.gigaspaces.server.eviction.EvictableServerEntry;
import com.j_spaces.core.cache.MemoryBasedEntryCacheInfo;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

@InternalApi
public class EvictableEntryCacheInfo
extends MemoryBasedEntryCacheInfo
implements EvictableServerEntry {
    private static final long serialVersionUID = -2238541327938669250L;
    private static final int PENDING = 0;
    private static final int INCACHE = 1;
    private static final int PINNED = 2;
    private static final int REMOVING = 3;
    private static final int REMOVED = 4;
    private static final int RECENT_DELETE = 5;
    private volatile int _cacheStatus;
    private static final AtomicIntegerFieldUpdater<EvictableEntryCacheInfo> cacheStatusUpdater = UncheckedAtomicIntegerFieldUpdater.newUpdater(EvictableEntryCacheInfo.class, "_cacheStatus");
    private volatile boolean _notifyOnInsertionCompletion;
    private static final short NOT_INSERTED_TO_EVICTION_STRATEGY = 0;
    private static final short IN_EVICTION_STRATEGY = 1;
    private static final short REMOVED_FROM_EVICTION_STRATEGY = 2;
    private volatile short _evictionStrategyStatus;
    private volatile boolean _notifyOnRemovalFromEvictionStrategy;
    private volatile int _numOfCurrentEvictionStrategyCallers;
    private static final AtomicIntegerFieldUpdater<EvictableEntryCacheInfo> _numOfCurrentEvictionStrategyCallersUpdater = UncheckedAtomicIntegerFieldUpdater.newUpdater(EvictableEntryCacheInfo.class, "_numOfCurrentEvictionStrategyCallers");
    private volatile boolean _needToRemoveFromEvictionStrategy;
    private volatile Object _evictionBackRef;

    public EvictableEntryCacheInfo(IEntryHolder entryHolder) {
        super(entryHolder);
    }

    public EvictableEntryCacheInfo(IEntryHolder entryHolder, int backRefsSize) {
        this(entryHolder, backRefsSize, false);
    }

    public EvictableEntryCacheInfo(IEntryHolder entryHolder, int backRefsSize, boolean pinned) {
        super(entryHolder, backRefsSize);
        if (pinned) {
            this._cacheStatus = 2;
        }
    }

    @Override
    public void setEvictionPayLoad(Object evictionBackRef) {
        this._evictionBackRef = evictionBackRef;
    }

    @Override
    public Object getEvictionPayLoad() {
        return this._evictionBackRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPinned(boolean value, boolean waitIfPendingInsertion) {
        if (value) {
            if (this.isPinned()) {
                return true;
            }
            boolean res = cacheStatusUpdater.compareAndSet(this, 1, 2);
            if (res || !waitIfPendingInsertion) {
                return res;
            }
            if (this.isPending()) {
                this._notifyOnInsertionCompletion = true;
                EvictableEntryCacheInfo evictableEntryCacheInfo = this;
                synchronized (evictableEntryCacheInfo) {
                    while (this.isPending()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException("waiting for pinning interrupted " + e);
                        }
                    }
                }
            }
            res = cacheStatusUpdater.compareAndSet(this, 1, 2);
            return res;
        }
        this._cacheStatus = 1;
        return true;
    }

    @Override
    public boolean setPinned(boolean value) {
        return this.setPinned(value, false);
    }

    private boolean isPending() {
        return this._cacheStatus == 0;
    }

    @Override
    public boolean isPinned() {
        return this._cacheStatus == 2;
    }

    @Override
    public boolean isRemoving() {
        return this._cacheStatus == 3;
    }

    @Override
    public boolean setRemoving(boolean isPinned) {
        if (isPinned) {
            this._cacheStatus = 3;
            return true;
        }
        return cacheStatusUpdater.compareAndSet(this, 1, 3);
    }

    @Override
    public void setRemoved() {
        this._cacheStatus = 4;
    }

    @Override
    public boolean isRemoved() {
        return this._cacheStatus == 4;
    }

    @Override
    public boolean isRemovingOrRemoved() {
        return this.isRemoving() || this.isRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWaitersOnFailure() {
        EvictableEntryCacheInfo evictableEntryCacheInfo = this;
        synchronized (evictableEntryCacheInfo) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyEntryRemovedFromStrategy() {
        if (this.isRemovedFromEvictionStrategy()) {
            return;
        }
        this._notifyOnRemovalFromEvictionStrategy = true;
        EvictableEntryCacheInfo evictableEntryCacheInfo = this;
        synchronized (evictableEntryCacheInfo) {
            while (!this.isRemovedFromEvictionStrategy()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInCache(boolean checkPendingPin) {
        this._cacheStatus = 1;
        if (checkPendingPin && this._notifyOnInsertionCompletion) {
            EvictableEntryCacheInfo evictableEntryCacheInfo = this;
            synchronized (evictableEntryCacheInfo) {
                this.notifyAll();
            }
        }
    }

    @Override
    public boolean isInCache() {
        return this._cacheStatus == 1;
    }

    @Override
    public boolean isInserted() {
        return this.isInCache() || this.isPinned();
    }

    @Override
    public boolean wasInserted() {
        return this._cacheStatus != 0;
    }

    @Override
    public boolean isRecentDelete() {
        return this._cacheStatus == 5;
    }

    @Override
    public void setRecentDelete() {
        this._cacheStatus = 5;
    }

    public boolean isRemovedFromEvictionStrategy() {
        return this._evictionStrategyStatus == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemovedFromEvictionStrategy(boolean checkWaiters) {
        this._evictionStrategyStatus = (short)2;
        if (checkWaiters && this._notifyOnRemovalFromEvictionStrategy) {
            EvictableEntryCacheInfo evictableEntryCacheInfo = this;
            synchronized (evictableEntryCacheInfo) {
                this.notifyAll();
            }
        }
    }

    public boolean isInEvictionStrategy() {
        return this._evictionStrategyStatus == 1;
    }

    public void setInEvictionStrategy() {
        this._evictionStrategyStatus = 1;
    }

    public void verifyBeforeEntryRemoval() {
        this._needToRemoveFromEvictionStrategy = true;
        if (_numOfCurrentEvictionStrategyCallersUpdater.compareAndSet(this, 0, -1073741824)) {
            return;
        }
        EvictableEntryCacheInfo evictableEntryCacheInfo = this;
        synchronized (evictableEntryCacheInfo) {
            try {
                while (true) {
                    if (_numOfCurrentEvictionStrategyCallersUpdater.compareAndSet(this, 0, -1073741824)) {
                        return;
                    }
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean permitCallingEvictionStrategy() {
        if (this._needToRemoveFromEvictionStrategy || !this.isInEvictionStrategy()) {
            return false;
        }
        int res = _numOfCurrentEvictionStrategyCallersUpdater.incrementAndGet(this);
        return res > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCallingEvictionStrategy() {
        int res = _numOfCurrentEvictionStrategyCallersUpdater.decrementAndGet(this);
        if (res == 0 && this._needToRemoveFromEvictionStrategy) {
            EvictableEntryCacheInfo evictableEntryCacheInfo = this;
            synchronized (evictableEntryCacheInfo) {
                this.notifyAll();
            }
        }
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }
}

