/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.backport.java.util.concurrent.FastConcurrentSkipListMap;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.cache.ExtendedIndexIterator;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.IExtendedEntriesIndex;
import com.j_spaces.core.cache.RecentExtendedIndexUpdates;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.client.DuplicateIndexValueException;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.StoredListFactory;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.list.MultiStoredList;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ExtendedIndexHandler<K>
implements IExtendedEntriesIndex<K, IEntryCacheInfo> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    private final FastConcurrentSkipListMap<Object, IStoredList<IEntryCacheInfo>> _orderedStore;
    private final FastConcurrentSkipListMap<Object, IEntryCacheInfo> _uniqueOrderedStore;
    private final TypeDataIndex _index;
    private final RecentExtendedIndexUpdates _recentExtendedIndexUpdates;
    private static final boolean FORCE_ORDERED_SCAN = true;

    public ExtendedIndexHandler(TypeDataIndex index) {
        this._index = index;
        this._orderedStore = new FastConcurrentSkipListMap();
        this._uniqueOrderedStore = this._index.isUniqueIndex() ? this._orderedStore : null;
        this._recentExtendedIndexUpdates = index.getCacheManager().getEngine().getLeaseManager().isSupportsRecentExtendedUpdates() ? new RecentExtendedIndexUpdates(index.getCacheManager()) : null;
    }

    @Override
    public FastConcurrentSkipListMap<Object, IStoredList<IEntryCacheInfo>> getOrderedStore() {
        return this._orderedStore;
    }

    @Override
    public ConcurrentMap<Object, IStoredList<IEntryCacheInfo>> getNonUniqueEntriesStore() {
        return this._orderedStore;
    }

    @Override
    public ConcurrentMap<Object, IEntryCacheInfo> getUniqueEntriesStore() {
        return this._uniqueOrderedStore;
    }

    @Override
    public IStoredList<IEntryCacheInfo> getIndexEntries(K indexValue) {
        return this._orderedStore.get(indexValue);
    }

    @Override
    public IObjectInfo insertEntryIndexedField(IEntryCacheInfo pEntry, K fieldValue, TypeData pType, boolean alreadyCloned) {
        IObjectInfo<IEntryCacheInfo> oi;
        block13: {
            oi = null;
            if (this._index.isUniqueIndex()) {
                IEntryCacheInfo other;
                while (true) {
                    if ((other = this.getUniqueEntriesStore().putIfAbsent(fieldValue, pEntry)) == null) {
                        oi = pEntry;
                        break block13;
                    }
                    if (!other.isRemovingOrRemoved() && !other.isDeleted()) break;
                    this.getUniqueEntriesStore().remove(fieldValue, other);
                }
                DuplicateIndexValueException ex = new DuplicateIndexValueException(pEntry.getUID(), pEntry.getEntryHolder(this._index.getCacheManager()).getClassName(), this._index.getIndexDefinition().getName(), fieldValue, other.getUID());
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Duplicate value encountered on unique index insertion ", ex);
                }
                throw ex;
            }
            IStoredList<IEntryCacheInfo> newSL = null;
            IObjectInfo<IEntryCacheInfo> myoi = null;
            IObjectInfo<IEntryCacheInfo> otheroi = null;
            IStoredList currentSL = null;
            boolean first = true;
            ConcurrentMap<Object, IStoredList<IEntryCacheInfo>> store = this.getNonUniqueEntriesStore();
            while (true) {
                if (first) {
                    first = false;
                    if (!this._index.assumeUniqueValue()) {
                        currentSL = (IStoredList)store.get(fieldValue);
                    }
                }
                if (currentSL == null) {
                    if (!alreadyCloned && this._index.considerValueClone()) {
                        fieldValue = this._index.cloneIndexValue(fieldValue, pEntry.getEntryHolder(this._index.getCacheManager()));
                        alreadyCloned = true;
                    }
                    if ((currentSL = store.putIfAbsent(fieldValue, pEntry)) == null) {
                        oi = pEntry;
                        break block13;
                    }
                }
                if (currentSL.isMultiObjectCollection()) {
                    oi = currentSL.add(pEntry);
                    if (oi == null) {
                        store.remove(fieldValue, currentSL);
                        currentSL = null;
                        continue;
                    }
                    break block13;
                }
                if (newSL == null) {
                    newSL = StoredListFactory.createConcurrentList(pType.isAllowFifoIndexScans());
                }
                otheroi = newSL.addUnlocked(currentSL.getObjectFromHead());
                myoi = newSL.addUnlocked(pEntry);
                if (store.replace(fieldValue, currentSL, newSL)) break;
                newSL.removeUnlocked(otheroi);
                newSL.removeUnlocked(myoi);
                myoi = null;
                currentSL = null;
            }
            oi = myoi;
        }
        return oi;
    }

    @Override
    public void removeEntryIndexedField(IEntryHolder eh, Object fieldValue, IEntryCacheInfo pEntry, IObjectInfo oi) {
        if (this._index.isUniqueIndex()) {
            Object other;
            if (!this.getUniqueEntriesStore().remove(fieldValue, pEntry)) {
                // empty if block
            }
            Object object = other = this._index.considerValueClone() ? this._index.cloneIndexValue(fieldValue, pEntry.getEntryHolder(this._index.getCacheManager())) : fieldValue;
            if (!(other == fieldValue || fieldValue.hashCode() == other.hashCode() && fieldValue.equals(other) && ((Comparable)fieldValue).compareTo((Comparable)other) == 0)) {
                throw new RuntimeException("Entry Class: " + pEntry.getClassName() + " - Wrong hashCode() or equals() or Comparable.compareTo() implementation of " + fieldValue.getClass() + " class field, or field value changed while entry stored in space.");
            }
        } else {
            this.removeNonUniqueIndexedField(eh, fieldValue, pEntry, oi);
        }
    }

    private void removeNonUniqueIndexedField(IEntryHolder eh, Object fieldValue, IEntryCacheInfo pEntry, IObjectInfo oi) {
        ConcurrentMap<Object, IStoredList<IEntryCacheInfo>> store = this.getNonUniqueEntriesStore();
        do {
            IStoredList entries;
            if ((entries = (IStoredList)store.get(fieldValue)) == null) {
                throw new RuntimeException("Entry Class: " + eh.getClassName() + " - Wrong hashCode() or equals() or CompareTo implementation of " + fieldValue.getClass() + " class field , or field value changed while entry stored in space.");
            }
            if (entries.isMultiObjectCollection()) {
                IObjectInfo myoi = oi;
                if (myoi == pEntry && (myoi = entries.getHead()).getSubject() != pEntry) {
                    throw new RuntimeException("Entry Class: " + eh.getClassName() + " - Single-entry to multiple wrong OI ,  " + fieldValue.getClass() + " class field.");
                }
                if (oi != null) {
                    entries.remove(myoi);
                } else {
                    boolean res = entries.removeByObject(pEntry);
                    if (!res) {
                        throw new RuntimeException("Entry Class: " + eh.getClassName() + " - removeByObject on SL returned false ,  " + fieldValue.getClass() + " class field.");
                    }
                }
                if (!entries.invalidate()) break;
                store.remove(fieldValue, entries);
                break;
            }
            if (entries == pEntry) continue;
            throw new RuntimeException("Entry Class: " + eh.getClassName() + " - Single-entry Wrong hashCode() or equals() implementation of " + fieldValue.getClass() + " class field , or field value changed while entry stored in space.");
        } while (!store.remove(fieldValue, pEntry));
    }

    @Override
    public void onUpdate(IEntryCacheInfo eci) {
        if (this._recentExtendedIndexUpdates != null) {
            this._recentExtendedIndexUpdates.onUpdate(eci);
        }
    }

    @Override
    public void onUpdateEnd(IEntryCacheInfo eci) {
        if (this._recentExtendedIndexUpdates != null) {
            this._recentExtendedIndexUpdates.onUpdateEnd(eci);
        }
    }

    @Override
    public void onRemove(IEntryCacheInfo eci) {
        if (this._recentExtendedIndexUpdates != null) {
            this._recentExtendedIndexUpdates.onRemove(eci);
        }
    }

    @Override
    public int reapExpired() {
        if (this._recentExtendedIndexUpdates != null) {
            return this._recentExtendedIndexUpdates.reapExpired();
        }
        return 0;
    }

    @Override
    public IScanListIterator<IEntryCacheInfo> establishScan(K startPos, short relation, K endPos, boolean endPosInclusive) {
        return this.establishScan(startPos, relation, endPos, endPosInclusive, false);
    }

    @Override
    public IScanListIterator<IEntryCacheInfo> establishScan(K startPos, short relation, K endPos, boolean endPosInclusive, boolean ordered) {
        ExtendedIndexIterator<IEntryCacheInfo> res;
        long startTime = this._recentExtendedIndexUpdates != null ? System.currentTimeMillis() : 0L;
        ExtendedIndexIterator<IEntryCacheInfo> extendedIndexIterator = res = (ordered |= true) ? this.establishScanOrdered(startPos, relation, endPos, endPosInclusive) : this.establishScanUnOrdered(startPos, relation, endPos, endPosInclusive);
        if (this._recentExtendedIndexUpdates != null && !this._recentExtendedIndexUpdates.isEmpty()) {
            MultiStoredList<IEntryCacheInfo> msl = new MultiStoredList<IEntryCacheInfo>();
            msl.add(res);
            msl.add(this._recentExtendedIndexUpdates.iterator(startTime, res));
            return msl;
        }
        return res;
    }

    private ExtendedIndexIterator<IEntryCacheInfo> establishScanUnOrdered(K startPos, short relation, K endPos, boolean endPosInclusive) {
        boolean endInclusive;
        K end;
        boolean startinclusive;
        K start;
        short originalEndCondition;
        boolean reversedScan = relation == 4 || relation == 5;
        K originalStart = startPos;
        K originalEnd = endPos;
        short originalStartCondition = reversedScan ? (short)0 : relation;
        short s = originalEndCondition = !reversedScan ? (short)0 : relation;
        if (reversedScan) {
            start = endPos;
            startinclusive = endPosInclusive;
            end = startPos;
            endInclusive = relation == 5;
        } else {
            startinclusive = relation == 3;
            start = startPos;
            end = endPos;
            endInclusive = endPosInclusive;
        }
        FastConcurrentSkipListMap<Object, IStoredList<IEntryCacheInfo>> baseMap = this._orderedStore;
        NavigableMap<Object, Object> mapToScan = end == null ? (start != null ? baseMap.tailMap((Object)start, startinclusive) : baseMap) : (start != null ? baseMap.subMap((Object)start, startinclusive, (Object)end, endInclusive) : baseMap.headMap((Object)end, endInclusive));
        return new ExtendedIndexIterator<IEntryCacheInfo>(mapToScan, this._index, originalStart, originalStartCondition, originalEnd, originalEndCondition);
    }

    private ExtendedIndexIterator<IEntryCacheInfo> establishScanOrdered(K startPos, short relation, K endPos, boolean endPosInclusive) {
        NavigableMap<Object, IStoredList<IEntryCacheInfo>> baseMap;
        boolean reversedScan = relation == 4 || relation == 5;
        boolean startinclusive = relation == 3 || relation == 5;
        K originalStart = startPos;
        K originalEnd = endPos;
        short originalStartCondition = reversedScan ? (short)0 : relation;
        short originalEndCondition = !reversedScan ? (short)0 : relation;
        NavigableMap<Object, IStoredList<IEntryCacheInfo>> navigableMap = baseMap = reversedScan ? this._orderedStore.descendingMap() : this._orderedStore;
        NavigableMap<Object, IStoredList<IEntryCacheInfo>> mapToScan = endPos == null ? (startPos != null ? baseMap.tailMap(startPos, startinclusive) : baseMap) : (startPos != null ? baseMap.subMap(startPos, startinclusive, endPos, endPosInclusive) : baseMap.headMap(endPos, endPosInclusive));
        return new ExtendedIndexIterator<IEntryCacheInfo>(mapToScan, this._index, originalStart, originalStartCondition, originalEnd, originalEndCondition);
    }
}

