/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.cache.IExtendedIndexIterator;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import java.util.Iterator;
import java.util.NavigableMap;

@InternalApi
public class ExtendedIndexIterator<V>
implements IExtendedIndexIterator<V> {
    private final Iterator<IStoredList<V>> _iter;
    private IStoredListIterator<V> _pos;
    private IStoredList<V> _entries;
    private boolean _eof;
    private V _res;
    private final TypeDataIndex _idx;
    private boolean _randomScan;
    private final Object _originalStart;
    private final short _originalStartCondition;
    private final Object _originalEnd;
    private final short _originalEndCondition;

    public ExtendedIndexIterator(NavigableMap mapToScan, TypeDataIndex idx, Object originalStart, short originalStartCondition, Object originalEnd, short originalEndCondition) {
        this._iter = mapToScan.values().iterator();
        this._idx = idx;
        this._originalStart = originalStart;
        this._originalStartCondition = originalStartCondition;
        this._originalEnd = originalEnd;
        this._originalEndCondition = originalEndCondition;
    }

    @Override
    public boolean hasNext() {
        this._res = this.nextValue();
        return this._res != null;
    }

    @Override
    public V next() {
        V res = this._res;
        this._res = null;
        return res;
    }

    private V nextValue() {
        V res = null;
        while (true) {
            if (this._eof) {
                return null;
            }
            boolean newSl = false;
            if (this._entries == null) {
                if (this._iter.hasNext()) {
                    IStoredList<V> entries = this._iter.next();
                    if (entries.optimizeScanForSingleObject()) {
                        res = entries.getObjectFromHead();
                        if (res != null) {
                            return res;
                        }
                        newSl = true;
                    } else {
                        newSl = true;
                        this._pos = entries.establishListScan(this._randomScan);
                        this._entries = entries;
                    }
                } else {
                    this._eof = true;
                    return null;
                }
            }
            if (!newSl) {
                this._pos = this._entries.next(this._pos);
            }
            if (this._pos == null) {
                this._entries = null;
                continue;
            }
            res = this._pos.getSubject();
            if (res != null) break;
        }
        return res;
    }

    public void release() {
        if (this._entries != null) {
            this._entries.freeSLHolder(this._pos);
        }
        this._pos = null;
        this._entries = null;
    }

    protected void finalize() {
        this.release();
    }

    @Override
    public void releaseScan() {
        this.release();
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        if (this._idx == null) {
            return -1;
        }
        return this._idx.getPos();
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    public boolean isMultiValueIterator() {
        return true;
    }

    public void remove() {
        throw new RuntimeException(" not supported");
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return true;
    }

    public int hashCode() {
        return this._originalStart != null ? this._originalStart.hashCode() : (this._originalEnd != null ? this._originalEnd.hashCode() : this._idx.hashCode());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtendedIndexIterator)) {
            return false;
        }
        ExtendedIndexIterator other = (ExtendedIndexIterator)o;
        return this._idx == other._idx && TypeData.objectsEquality(this._originalStart, other._originalStart) && this._originalStartCondition == other._originalStartCondition && TypeData.objectsEquality(this._originalEnd, other._originalEnd) && this._originalEndCondition == other._originalEndCondition;
    }
}

