/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.backport.java.util.concurrent.FastConcurrentSkipListMap;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.j_spaces.core.cache.ExtendedIndexHandler;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.IExtendedEntriesIndex;
import com.j_spaces.core.cache.IExtendedIndex;
import com.j_spaces.core.cache.IExtendedIndexIterator;
import com.j_spaces.core.cache.RecentExtendedIndexUpdates;
import com.j_spaces.core.cache.SimpleCompoundIndexValueHolder;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.fifoGroup.ExtendedCompoundIndexFifoGroupsIterator;
import com.j_spaces.core.cache.fifoGroup.ExtendedIndexFifoGroupsIterator;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentMap;

@InternalApi
public class FifoGroupsExtendedIndexHandler<K>
implements IExtendedEntriesIndex<K, IEntryCacheInfo> {
    private final IExtendedIndex<K, IEntryCacheInfo> _base;
    private final FastConcurrentSkipListMap<Object, IStoredList<IEntryCacheInfo>> _orderedStore;
    private final TypeDataIndex _index;
    private final RecentExtendedIndexUpdates _recentExtendedIndexUpdates;
    private static final boolean FORCE_ORDERED_SCAN = false;

    public FifoGroupsExtendedIndexHandler(TypeDataIndex index, IExtendedIndex<K, IEntryCacheInfo> base, ISpaceIndex.FifoGroupsIndexTypes fifoGroupsIndexType) {
        if (fifoGroupsIndexType != ISpaceIndex.FifoGroupsIndexTypes.MAIN && fifoGroupsIndexType != ISpaceIndex.FifoGroupsIndexTypes.COMPOUND) {
            throw new UnsupportedOperationException();
        }
        this._base = base;
        this._orderedStore = ((ExtendedIndexHandler)this._base).getOrderedStore();
        this._index = index;
        this._recentExtendedIndexUpdates = null;
    }

    @Override
    public IObjectInfo insertEntryIndexedField(IEntryCacheInfo pEntry, K fieldValue, TypeData pType, boolean alreadyCloned) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEntryIndexedField(IEntryHolder eh, Object fieldValue, IEntryCacheInfo pEntry, IObjectInfo oi) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IExtendedIndexIterator<IEntryCacheInfo> establishScan(K startPos, short relation, K endPos, boolean endPosInclusive) {
        return this.establishScan((Object)startPos, relation, (Object)endPos, endPosInclusive, false);
    }

    @Override
    public IExtendedIndexIterator<IEntryCacheInfo> establishScan(K startPos, short relation, K endPos, boolean endPosInclusive, boolean ordered) {
        return (ordered |= false) ? this.establishScanOrdered(startPos, relation, endPos, endPosInclusive) : this.establishScanUnOrdered(startPos, relation, endPos, endPosInclusive);
    }

    @Override
    public void onUpdate(IEntryCacheInfo eci) {
        if (this._recentExtendedIndexUpdates != null) {
            this._recentExtendedIndexUpdates.onUpdate(eci);
        }
    }

    @Override
    public void onUpdateEnd(IEntryCacheInfo eci) {
        if (this._recentExtendedIndexUpdates != null) {
            this._recentExtendedIndexUpdates.onUpdateEnd(eci);
        }
    }

    @Override
    public void onRemove(IEntryCacheInfo eci) {
        if (this._recentExtendedIndexUpdates != null) {
            this._recentExtendedIndexUpdates.onRemove(eci);
        }
    }

    @Override
    public int reapExpired() {
        if (this._recentExtendedIndexUpdates != null) {
            return this._recentExtendedIndexUpdates.reapExpired();
        }
        return 0;
    }

    private IExtendedIndexIterator<IEntryCacheInfo> establishScanUnOrdered(K startPos, short relation, K endPos, boolean endPosInclusive) {
        NavigableMap<Object, IStoredList<IEntryCacheInfo>> mapToScan;
        boolean endInclusive;
        K end;
        boolean startinclusive;
        K start;
        boolean reversedScan;
        boolean bl = reversedScan = relation == 4 || relation == 5;
        if (reversedScan) {
            start = endPos;
            startinclusive = endPosInclusive;
            end = startPos;
            endInclusive = relation == 5;
        } else {
            startinclusive = relation == 3;
            start = startPos;
            end = endPos;
            endInclusive = endPosInclusive;
        }
        FastConcurrentSkipListMap<Object, IStoredList<IEntryCacheInfo>> baseMap = this._orderedStore;
        if (end == null) {
            mapToScan = start != null ? baseMap.tailMap((Object)start, startinclusive) : baseMap;
        } else {
            NavigableMap navigableMap = mapToScan = start != null ? baseMap.subMap((Object)start, startinclusive, (Object)end, endInclusive) : baseMap.headMap((Object)end, endInclusive);
        }
        if (this._index.isCompound()) {
            SimpleCompoundIndexValueHolder s = start != null ? (SimpleCompoundIndexValueHolder)start : (SimpleCompoundIndexValueHolder)end;
            Object nonFGVal = s.getValueBySegment(1);
            return new ExtendedCompoundIndexFifoGroupsIterator<IEntryCacheInfo>(mapToScan, this._index, nonFGVal);
        }
        return new ExtendedIndexFifoGroupsIterator<IEntryCacheInfo>(mapToScan, this._index);
    }

    private IExtendedIndexIterator<IEntryCacheInfo> establishScanOrdered(K startPos, short relation, K endPos, boolean endPosInclusive) {
        NavigableMap<Object, IStoredList<IEntryCacheInfo>> baseMap;
        boolean reversedScan = relation == 4 || relation == 5;
        boolean startinclusive = relation == 3 || relation == 5;
        NavigableMap<Object, IStoredList<IEntryCacheInfo>> navigableMap = baseMap = reversedScan ? this._orderedStore.descendingMap() : this._orderedStore;
        NavigableMap<Object, IStoredList<IEntryCacheInfo>> mapToScan = endPos == null ? (startPos != null ? baseMap.tailMap(startPos, startinclusive) : baseMap) : (startPos != null ? baseMap.subMap(startPos, startinclusive, endPos, endPosInclusive) : baseMap.headMap(endPos, endPosInclusive));
        return new ExtendedIndexFifoGroupsIterator<IEntryCacheInfo>(mapToScan, this._index);
    }

    @Override
    public ConcurrentMap<Object, IStoredList<IEntryCacheInfo>> getNonUniqueEntriesStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentMap<Object, IEntryCacheInfo> getUniqueEntriesStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FastConcurrentSkipListMap<Object, IStoredList<IEntryCacheInfo>> getOrderedStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStoredList<IEntryCacheInfo> getIndexEntries(K indexValue) {
        return this._orderedStore.get(indexValue);
    }
}

