/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.ILeasedEntryCacheInfo;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import java.util.ArrayList;
import java.util.logging.Logger;

@InternalApi
public class MemoryBasedEntryCacheInfo
implements IEntryCacheInfo {
    public static final int UID_HASH_INDICATOR = -1;
    private final IEntryHolder m_EntryHolder;
    private transient ArrayList<IObjectInfo<IEntryCacheInfo>> _backRefs;
    private int _latestIndexCreationNumber;
    private IStoredList<Object> _leaseManagerListRef;
    private IObjectInfo<Object> _leaseManagerPosRef;

    public MemoryBasedEntryCacheInfo(IEntryHolder entryHolder) {
        this.m_EntryHolder = entryHolder;
    }

    public MemoryBasedEntryCacheInfo(IEntryHolder entryHolder, int backRefsSize) {
        this.m_EntryHolder = entryHolder;
        this._backRefs = new ArrayList(backRefsSize);
    }

    @Override
    public IEntryHolder getEntryHolder(CacheManager cacheManager) {
        return this.m_EntryHolder;
    }

    public IEntryHolder getEntryHolder() {
        return this.m_EntryHolder;
    }

    @Override
    public IEntryHolder getEntryHolder(CacheManager cacheManager, Context context) {
        return this.m_EntryHolder;
    }

    @Override
    public boolean isDeleted() {
        return this.getEntryHolder().isDeleted();
    }

    @Override
    public ArrayList<IObjectInfo<IEntryCacheInfo>> getBackRefs() {
        return this._backRefs;
    }

    @Override
    public void setBackRefs(ArrayList<IObjectInfo<IEntryCacheInfo>> backRefs) {
        this._backRefs = backRefs;
    }

    @Override
    public IObjectInfo<IEntryCacheInfo> getMainListBackRef() {
        return this._backRefs == null ? null : this._backRefs.get(0);
    }

    @Override
    public boolean indexesBackRefsKept() {
        return true;
    }

    @Override
    public void setMainListBackRef(IObjectInfo<IEntryCacheInfo> mainListBackref) {
        this._backRefs.add(mainListBackref);
    }

    @Override
    public void setLeaseManagerListRefAndPosition(IStoredList<Object> entriesList, IObjectInfo<Object> entryPos) {
        this._leaseManagerListRef = entriesList;
        this._leaseManagerPosRef = entryPos;
    }

    @Override
    public IStoredList<Object> getLeaseManagerListRef() {
        return this._leaseManagerListRef;
    }

    @Override
    public IObjectInfo<Object> getLeaseManagerPosition() {
        return this._leaseManagerPosRef;
    }

    @Override
    public boolean isConnectedToLeaseManager() {
        return this.getLeaseManagerListRef() != null;
    }

    @Override
    public boolean isSameLeaseManagerRef(ILeasedEntryCacheInfo other) {
        return other.getLeaseManagerListRef() == this.getLeaseManagerListRef() && other.getLeaseManagerPosition() == this.getLeaseManagerPosition();
    }

    @Override
    public boolean isBlobStoreEntry() {
        return false;
    }

    @Override
    public Object getObjectStoredInLeaseManager() {
        return this.m_EntryHolder;
    }

    @Override
    public IServerTypeDesc getServerTypeDesc() {
        return this.m_EntryHolder.getServerTypeDesc();
    }

    @Override
    public int getLatestIndexCreationNumber() {
        return this._latestIndexCreationNumber;
    }

    @Override
    public void setLatestIndexCreationNumber(int val) {
        this._latestIndexCreationNumber = val;
    }

    @Override
    public String getClassName() {
        return this.getEntryHolder().getClassName();
    }

    @Override
    public void setEvictionPayLoad(Object evictionBackRef) {
        throw new RuntimeException("setEvictionBackref invalid here");
    }

    @Override
    public Object getEvictionPayLoad() {
        return null;
    }

    public boolean isTransient() {
        return this.getEntryHolder().isTransient();
    }

    @Override
    public String getUID() {
        return this.getEntryHolder().getUID();
    }

    @Override
    public void setInCache(boolean checkPendingPin) {
    }

    public boolean isInCache() {
        return true;
    }

    public boolean isInserted() {
        return true;
    }

    @Override
    public boolean setPinned(boolean value, boolean waitIfPendingInsertion) {
        return true;
    }

    @Override
    public boolean setPinned(boolean value) {
        return this.setPinned(value, false);
    }

    @Override
    public boolean isPinned() {
        return true;
    }

    @Override
    public boolean setRemoving(boolean isPinned) {
        return true;
    }

    @Override
    public boolean isRemoving() {
        return false;
    }

    @Override
    public void setRemoved() {
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public boolean isRemovingOrRemoved() {
        return false;
    }

    @Override
    public boolean wasInserted() {
        return true;
    }

    @Override
    public boolean isRecentDelete() {
        return false;
    }

    @Override
    public void setRecentDelete() {
        throw new RuntimeException("invalid usage !!!");
    }

    @Override
    public boolean preMatch(Context context, ITemplateHolder template) {
        throw new RuntimeException("invalid usage !!!");
    }

    @Override
    public IObjectInfo<IEntryCacheInfo> getHead() {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public IEntryCacheInfo getObjectFromHead() {
        return this;
    }

    @Override
    public void freeSLHolder(IStoredListIterator slh) {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public void remove(IObjectInfo oi) {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public void removeUnlocked(IObjectInfo oi) {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public boolean invalidate() {
        return false;
    }

    @Override
    public void dump(Logger logger, String msg) {
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public IStoredListIterator<IEntryCacheInfo> establishListScan(boolean random_scan) {
        return this;
    }

    @Override
    public IStoredListIterator<IEntryCacheInfo> next(IStoredListIterator<IEntryCacheInfo> slh) {
        return null;
    }

    @Override
    public IObjectInfo<IEntryCacheInfo> add(IEntryCacheInfo subject) {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public IObjectInfo<IEntryCacheInfo> addUnlocked(IEntryCacheInfo subject) {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public boolean removeByObject(IEntryCacheInfo obj) {
        return false;
    }

    @Override
    public boolean contains(IEntryCacheInfo obj) {
        return this == obj;
    }

    @Override
    public void setSubject(IEntryCacheInfo subject) {
    }

    @Override
    public IEntryCacheInfo getSubject() {
        return this;
    }

    @Override
    public boolean isMultiObjectCollection() {
        return false;
    }

    @Override
    public boolean optimizeScanForSingleObject() {
        return true;
    }

    @Override
    public boolean hasNext() throws SAException {
        return true;
    }

    @Override
    public IEntryCacheInfo next() throws SAException {
        return this;
    }

    @Override
    public void releaseScan() throws SAException {
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return false;
    }

    @Override
    public SpaceTypeDescriptor getSpaceTypeDescriptor() {
        return this.getEntryHolder().getEntryData().getSpaceTypeDescriptor();
    }

    @Override
    public Object getFixedPropertyValue(int position) {
        return this.getEntryHolder().getEntryData().getFixedPropertyValue(position);
    }

    @Override
    public Object getPropertyValue(String name) {
        return this.getEntryHolder().getEntryData().getPropertyValue(name);
    }

    @Override
    public Object getPathValue(String path) {
        return this.getEntryHolder().getEntryData().getPathValue(path);
    }

    @Override
    public int getVersion() {
        return this.getEntryHolder().getEntryData().getVersion();
    }

    @Override
    public long getExpirationTime() {
        return this.getEntryHolder().getEntryData().getExpirationTime();
    }

    @Override
    public int getHashCode(int id) {
        return this.getKey(id).hashCode();
    }

    @Override
    public Object getKey(int id) {
        if (id == -1) {
            return this.getUID();
        }
        return this.getEntryHolder().getEntryData().getFixedPropertyValue(id);
    }

    @Override
    public IStoredList<IEntryCacheInfo> getValue(int id) {
        return this;
    }

    @Override
    public boolean isNativeHashEntry() {
        return false;
    }

    @Override
    public void release() {
    }
}

