/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.j_spaces.core.cache.TypeData;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@InternalApi
public class PTypeMap {
    private volatile TypeData[] elementData;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock touchLock = this.rwl.readLock();
    private final Lock modifyLock = this.rwl.writeLock();

    public PTypeMap() {
        this.elementData = new TypeData[10];
    }

    public TypeData get(IServerTypeDesc typeDesc) {
        try {
            return this.elementData[typeDesc.getTypeId()];
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(IServerTypeDesc typeDesc, TypeData element) {
        int key = typeDesc.getTypeId();
        try {
            this.touchLock.lock();
            this.ensureCapacity(key);
            this.elementData[key] = element;
        }
        finally {
            this.touchLock.unlock();
        }
    }

    public void remove(IServerTypeDesc typeDesc) {
        int key = typeDesc.getTypeId();
        if (key >= this.elementData.length) {
            return;
        }
        try {
            this.touchLock.lock();
            this.elementData[key] = null;
        }
        finally {
            this.touchLock.unlock();
        }
    }

    private void ensureCapacity(int capacity) {
        if (capacity >= this.elementData.length) {
            try {
                this.touchLock.unlock();
                this.modifyLock.lock();
                this.increaseCapacity(capacity + 1);
            }
            finally {
                this.touchLock.lock();
                this.modifyLock.unlock();
            }
        }
    }

    private void increaseCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            TypeData[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            TypeData[] newData = new TypeData[newCapacity];
            System.arraycopy(oldData, 0, newData, 0, oldCapacity);
            this.elementData = newData;
        }
    }
}

