/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.core.Constants;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IStoredList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class PersistentGC
extends GSThread
implements Constants.CacheManager {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    private static final String OBJECT_CLASS = Object.class.getName();
    private final CacheManager _cacheManager;
    private boolean _shouldDie;
    private long _persistentGCInterval;
    private final Object _shutdownMonitor = new Object();

    PersistentGC(CacheManager cacheManager, SpaceConfigReader configReader) {
        super("Cache-PersistentGC");
        this.setDaemon(true);
        this._cacheManager = cacheManager;
        try {
            this._persistentGCInterval = configReader.getLongSpaceProperty("lease_manager.expiration_time_interval", String.valueOf(300000));
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to parse persistent GC interval (using default).", ex);
            }
            this._persistentGCInterval = 300000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isInterrupted()) {
            try {
                Object object = this._shutdownMonitor;
                synchronized (object) {
                    if (this._shouldDie) {
                        return;
                    }
                    if (this._persistentGCInterval > 0L) {
                        this._shutdownMonitor.wait(this._persistentGCInterval);
                    } else {
                        this._shutdownMonitor.wait();
                    }
                    if (this._shouldDie) {
                        return;
                    }
                }
                if (this._persistentGCInterval <= 0L) continue;
                this.cleanIndexTables();
            }
            catch (InterruptedException ie) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, this.getName() + " interrupted.", ie);
                }
                this.interrupt();
                break;
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, "Persistent gc caught error while cleaning up.", ex);
            }
        }
    }

    private void cleanIndexTables() throws SAException {
        IServerTypeDesc[] subTypeDescs;
        IServerTypeDesc templateType = this._cacheManager.getTypeManager().getServerTypeDesc(OBJECT_CLASS);
        for (IServerTypeDesc subTypeDesc : subTypeDescs = templateType.getAssignableTypes()) {
            TypeDataIndex[] indexes;
            TypeData typeData = this._cacheManager.getTypeData(subTypeDesc);
            if (typeData == null) continue;
            for (TypeDataIndex index : indexes = typeData.getIndexes()) {
                this.checkTemplates(index._RTTemplates);
                this.checkTemplates(index._NTemplates);
            }
            this.checkEntries(typeData.getNotifyUidTemplates());
            this.checkEntries(typeData.getReadTakeUidTemplates());
        }
    }

    private void checkTemplates(ConcurrentHashMap<Object, IStoredList<TemplateCacheInfo>[]> map) throws SAException {
        for (Map.Entry<Object, IStoredList<TemplateCacheInfo>[]> entry : map.entrySet()) {
            IStoredList<TemplateCacheInfo> valuesSL;
            IStoredList<TemplateCacheInfo>[] t_vec = entry.getValue();
            if (t_vec == null || !(valuesSL = t_vec[0]).invalidate()) continue;
            map.remove(entry.getKey(), t_vec);
        }
    }

    private <K, V> void checkEntries(ConcurrentHashMap<K, IStoredList<V>> map) {
        for (Map.Entry<K, IStoredList<V>> entry : map.entrySet()) {
            IStoredList<V> valuesSL = entry.getValue();
            if (valuesSL == null || !valuesSL.invalidate()) continue;
            map.remove(entry.getKey(), valuesSL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws SAException {
        Object object = this._shutdownMonitor;
        synchronized (object) {
            this._shouldDie = true;
            this._shutdownMonitor.notifyAll();
        }
        try {
            this.join();
        }
        catch (InterruptedException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, ex.toString(), ex);
            }
            throw new SAException("Failed shutting down " + this.getName(), ex);
        }
    }
}

