/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.query.extension.QueryExtensionEntryIterator;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.QueryExtensionIndexManagerWrapper;
import com.j_spaces.core.cache.SpaceServerEntryImpl;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.list.IScanListIterator;

@InternalApi
public class QueryExtensionIndexEntryIteratorWrapper
implements IScanListIterator<IEntryCacheInfo> {
    private final QueryExtensionIndexManagerWrapper manager;
    private final QueryExtensionEntryIterator iterator;
    private IEntryCacheInfo _nextEntry;
    private boolean _finished;

    public QueryExtensionIndexEntryIteratorWrapper(QueryExtensionIndexManagerWrapper manager, QueryExtensionEntryIterator iterator) {
        this.manager = manager;
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() throws SAException {
        this._nextEntry = null;
        do {
            if (this._finished || this.iterator == null || !this.iterator.hasNext()) {
                this._finished = true;
                return false;
            }
            this._nextEntry = this.nextImpl();
        } while (this._nextEntry == null);
        return true;
    }

    @Override
    public IEntryCacheInfo next() throws SAException {
        return this._nextEntry;
    }

    private IEntryCacheInfo nextImpl() throws SAException {
        try {
            String uid = this.iterator.nextUid();
            SpaceServerEntryImpl entry = uid != null ? this.manager.getByUid(uid) : null;
            return entry == null ? null : entry.getEntryCacheInfo();
        }
        catch (Exception ex) {
            throw new SAException(ex);
        }
    }

    @Override
    public void releaseScan() throws SAException {
        try {
            if (this.iterator != null) {
                this.iterator.close();
            }
        }
        catch (Exception ex) {
            throw new SAException(ex);
        }
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return true;
    }
}

