/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.query.extension.QueryExtensionEntryIterator;
import com.gigaspaces.query.extension.QueryExtensionManager;
import com.gigaspaces.query.extension.QueryExtensionProvider;
import com.gigaspaces.query.extension.QueryExtensionRuntimeInfo;
import com.gigaspaces.server.SpaceServerEntry;
import com.j_spaces.core.cache.QueryExtensionIndexEntryIteratorWrapper;
import com.j_spaces.core.cache.QueryExtensionIndexRemoveMode;
import com.j_spaces.core.cache.SpaceServerEntryImpl;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@InternalApi
public class QueryExtensionIndexManagerWrapper {
    private final QueryExtensionManager manager;
    private final ConcurrentMap<String, SpaceServerEntryImpl> indexedEntries = new ConcurrentHashMap<String, SpaceServerEntryImpl>();

    public QueryExtensionIndexManagerWrapper(QueryExtensionProvider provider, QueryExtensionRuntimeInfo info) {
        this.manager = provider.createManager(info);
    }

    public void close() throws IOException {
        this.manager.close();
    }

    public void introduceType(SpaceTypeDescriptor typeDescriptor) {
        this.manager.registerType(typeDescriptor);
    }

    public void insertEntry(SpaceServerEntryImpl entry, boolean fromTransactionalUpdate) {
        boolean inserted = this.manager.insertEntry(entry, false);
        if (inserted && !fromTransactionalUpdate) {
            SpaceServerEntryImpl exist = this.indexedEntries.putIfAbsent(entry.getUid(), entry);
            if (exist != null) {
                exist.waitForRemovalFromForeignIndex();
            }
            this.indexedEntries.put(entry.getUid(), entry);
        }
    }

    public void replaceEntry(SpaceServerEntryImpl entry) {
        boolean hasPreviousEntry = this.indexedEntries.containsKey(entry.getUid());
        boolean inserted = this.manager.insertEntry(entry, hasPreviousEntry);
        if (inserted || hasPreviousEntry) {
            if (hasPreviousEntry && !inserted) {
                this.indexedEntries.remove(entry.getUid());
            } else {
                this.indexedEntries.put(entry.getUid(), entry);
            }
        }
    }

    public void removeEntry(SpaceServerEntry entry, QueryExtensionIndexRemoveMode queryExtensionIndexRemoveMode, int removedVersion) {
        SpaceServerEntryImpl exist = (SpaceServerEntryImpl)this.indexedEntries.get(entry.getUid());
        if (exist != null) {
            if (queryExtensionIndexRemoveMode == QueryExtensionIndexRemoveMode.NO_XTN && !exist.equals(entry)) {
                throw new RuntimeException("invalid ForeignIndexableServerEntry in remove uid=" + entry.getUid());
            }
            this.manager.removeEntry(entry.getSpaceTypeDescriptor(), entry.getUid(), removedVersion);
            if (queryExtensionIndexRemoveMode == QueryExtensionIndexRemoveMode.NO_XTN) {
                this.indexedEntries.remove(entry.getUid(), entry);
                exist.setRemovedFromForeignIndex();
            }
        }
    }

    public boolean filter(String typeName, String path, String operation, Object actual, Object matchedAgainst) {
        return this.manager.accept(typeName, path, operation, actual, matchedAgainst);
    }

    public QueryExtensionIndexEntryIteratorWrapper scanIndex(String typeName, String path, String operation, Object subject) {
        QueryExtensionEntryIterator iterator = this.manager.queryByIndex(typeName, path, operation, subject);
        return new QueryExtensionIndexEntryIteratorWrapper(this, iterator);
    }

    public SpaceServerEntryImpl getByUid(String uid) {
        return (SpaceServerEntryImpl)this.indexedEntries.get(uid);
    }
}

