/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.ExtendedIndexIterator;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.list.IScanListIterator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class RecentExtendedIndexUpdates {
    private static final long RECENT_EXTENDED_UPDATE_TIME = 10000L;
    private final CacheManager _cacheManager;
    private final ConcurrentMap<String, RecentExtendedUpdatesInfo> _updates;
    private final AtomicInteger _size;

    public RecentExtendedIndexUpdates(CacheManager cacheManager) {
        this._cacheManager = cacheManager;
        this._updates = new ConcurrentHashMap<String, RecentExtendedUpdatesInfo>();
        this._size = new AtomicInteger();
    }

    public void onUpdate(IEntryCacheInfo eci) {
        if (!this._updates.containsKey(eci.getUID())) {
            this._size.incrementAndGet();
        }
        this._updates.put(eci.getUID(), new RecentExtendedUpdatesInfo(eci.getUID()));
    }

    public void onUpdateEnd(IEntryCacheInfo eci) {
        RecentExtendedUpdatesInfo r = (RecentExtendedUpdatesInfo)this._updates.get(eci.getUID());
        if (r != null) {
            r.setAfterUpdate();
        }
    }

    public void onRemove(IEntryCacheInfo eci) {
        Object res = this._updates.remove(eci.getUID());
        if (res != null) {
            this._size.decrementAndGet();
        }
    }

    public int reapExpired() {
        if (this.isEmpty()) {
            return 0;
        }
        int reaped = 0;
        long curtime = System.currentTimeMillis();
        for (RecentExtendedUpdatesInfo r : this._updates.values()) {
            Boolean res;
            long limit = r.getTime();
            if (limit + 10000L >= curtime || (res = Boolean.valueOf(this._updates.remove(r.getUid(), r))) == null) continue;
            this._size.decrementAndGet();
            ++reaped;
        }
        return reaped;
    }

    public IScanListIterator<IEntryCacheInfo> iterator(long startTime, ExtendedIndexIterator mainIter) {
        if (this.isEmpty()) {
            return null;
        }
        return new RecentExtendedUpdatesIter(this._cacheManager, this._updates, startTime, mainIter);
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    int size() {
        return this._size.get();
    }

    public static class RecentExtendedUpdatesIter
    implements IScanListIterator<IEntryCacheInfo> {
        private final CacheManager _cacheManager;
        private final long _start;
        private Iterator<RecentExtendedUpdatesInfo> _iter;
        private IEntryCacheInfo _cur;
        private final long _startTime;
        private final ExtendedIndexIterator _mainIter;

        RecentExtendedUpdatesIter(CacheManager cacheManager, ConcurrentMap<String, RecentExtendedUpdatesInfo> updates, long startTime, ExtendedIndexIterator mainIter) {
            this._cacheManager = cacheManager;
            this._start = System.currentTimeMillis();
            this._iter = updates.values().iterator();
            this._startTime = startTime;
            this._mainIter = mainIter;
        }

        @Override
        public boolean hasNext() throws SAException {
            this._cur = null;
            if (this._iter == null) {
                return false;
            }
            while (this._iter.hasNext()) {
                RecentExtendedUpdatesInfo r = this._iter.next();
                if (r.isAfterUpdate() && this._startTime > r.getTime()) continue;
                this._cur = this._cacheManager.getPEntryByUid(r.getUid());
                if (this._cur == null) continue;
                return true;
            }
            this._iter = null;
            return false;
        }

        @Override
        public IEntryCacheInfo next() throws SAException {
            IEntryCacheInfo cur = this._cur;
            this._cur = null;
            return cur;
        }

        @Override
        public void releaseScan() throws SAException {
        }

        @Override
        public int getAlreadyMatchedFixedPropertyIndexPos() {
            return -1;
        }

        @Override
        public String getAlreadyMatchedIndexPath() {
            return null;
        }

        @Override
        public boolean isAlreadyMatched() {
            return false;
        }

        @Override
        public boolean isIterator() {
            return true;
        }

        public int hashCode() {
            return this._mainIter.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecentExtendedUpdatesIter)) {
                return false;
            }
            return this._mainIter.equals(((RecentExtendedUpdatesIter)o)._mainIter);
        }
    }

    public static class RecentExtendedUpdatesInfo {
        private final String _uid;
        private volatile long _time;
        private volatile boolean _afterUpdate;

        RecentExtendedUpdatesInfo(String uid) {
            this._uid = uid;
            this._time = System.currentTimeMillis();
        }

        public String getUid() {
            return this._uid;
        }

        public long getTime() {
            return this._time;
        }

        public boolean isAfterUpdate() {
            return this._afterUpdate;
        }

        public void setAfterUpdate() {
            this._time = System.currentTimeMillis();
            this._afterUpdate = true;
        }
    }
}

