/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.cache.EntryCacheInfoFactory;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.list.IScanListIterator;

@InternalApi
public class ScanListSAIterator
implements IScanListIterator<IEntryCacheInfo> {
    private final ISAdapterIterator<IEntryHolder> _SAiter;
    private IEntryCacheInfo _nextObj;

    public ScanListSAIterator(ISAdapterIterator<IEntryHolder> list) {
        this._SAiter = list;
    }

    @Override
    public boolean hasNext() throws SAException {
        if (this._SAiter == null) {
            return false;
        }
        IEntryHolder next = this._SAiter.next();
        this._nextObj = next != null ? EntryCacheInfoFactory.createEntryCacheInfo(next) : null;
        return this._nextObj != null;
    }

    @Override
    public IEntryCacheInfo next() {
        return this._nextObj;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseScan() throws SAException {
        if (this._SAiter != null) {
            this._SAiter.close();
        }
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return true;
    }

    @Override
    public boolean isIterator() {
        return true;
    }
}

