/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import java.util.concurrent.atomic.AtomicLong;

@InternalApi
public class SequenceNumberGenerator {
    private final AtomicLong _seed = new AtomicLong();

    SequenceNumberGenerator() {
    }

    Long getNext() {
        return this._seed.incrementAndGet();
    }

    Long getCurrent() {
        return this._seed.get();
    }

    void updateIfGreater(long newCurrent) {
        long cur;
        do {
            if ((cur = this.getCurrent().longValue()) < newCurrent) continue;
            return;
        } while (!this._seed.compareAndSet(cur, newCurrent));
    }
}

