/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metadata.index.ISpaceCompoundIndexSegment;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.ICompoundIndexValueHolder;
import java.security.InvalidParameterException;

@InternalApi
public class SimpleCompoundIndexValueHolder
implements ICompoundIndexValueHolder {
    private Object _val1;
    private Object _val2;

    public SimpleCompoundIndexValueHolder(ISpaceCompoundIndexSegment[] segments, ServerEntry entry) {
        this._val1 = segments[0].getSegmentValue(entry);
        this._val2 = segments[1].getSegmentValue(entry);
    }

    public SimpleCompoundIndexValueHolder(Object val1, Object val2) {
        this._val1 = val1;
        this._val2 = val2;
    }

    @Override
    public Object getValueBySegment(int segmentNumber) {
        if (segmentNumber != 1 && segmentNumber != 2) {
            throw new InvalidParameterException();
        }
        return segmentNumber == 1 ? this._val1 : this._val2;
    }

    @Override
    public int getNumSegments() {
        return 2;
    }

    @Override
    public void setValueForSegment(Object value, int segmentNumber) {
        if (segmentNumber > 2 || segmentNumber < 1) {
            throw new IllegalArgumentException();
        }
        if (segmentNumber == 1) {
            this._val1 = value;
        } else {
            this._val2 = value;
        }
    }

    public int hashCode() {
        int hash = 17;
        if (this._val1 != null) {
            hash = hash * 31 + this._val1.hashCode();
        }
        if (this._val2 != null) {
            hash = hash * 31 + this._val2.hashCode();
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ICompoundIndexValueHolder)) {
            return false;
        }
        ICompoundIndexValueHolder o = (ICompoundIndexValueHolder)other;
        return this._val1.equals(o.getValueBySegment(1)) && this._val2.equals(o.getValueBySegment(2));
    }

    @Override
    public int compareTo(ICompoundIndexValueHolder o) {
        Comparable v2;
        Comparable v1;
        if (o == this) {
            return 0;
        }
        int res = 0;
        if (o.getValueBySegment(1) != this._val1 && (res = (v1 = (Comparable)this._val1).compareTo(v2 = (Comparable)o.getValueBySegment(1))) != 0) {
            return res;
        }
        if (o.getValueBySegment(2) != this._val2) {
            v1 = (Comparable)this._val2;
            v2 = (Comparable)o.getValueBySegment(2);
            res = v1.compareTo(v2);
        }
        return res;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this._val1, this._val2};
    }
}

