/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.server.SpaceServerEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;

@InternalApi
public class SpaceServerEntryImpl
implements SpaceServerEntry {
    public static long MAX_TIME_TO_WAIT_FOR_INDEX_REMOVAL = 180000L;
    private final ITransactionalEntryData _ted;
    private final IEntryCacheInfo _eci;
    private volatile boolean _removedFromForeignIndex;
    private volatile boolean _waitingForRemove;

    public SpaceServerEntryImpl(IEntryCacheInfo eci, CacheManager cm) {
        this._ted = eci.getEntryHolder(cm).getTxnEntryData();
        this._eci = eci;
    }

    @Override
    public String getUid() {
        return this._eci.getUID();
    }

    public IEntryCacheInfo getEntryCacheInfo() {
        return this._eci;
    }

    @Override
    public SpaceTypeDescriptor getSpaceTypeDescriptor() {
        return this._ted.getSpaceTypeDescriptor();
    }

    @Override
    public Object getFixedPropertyValue(int position) {
        return this._ted.getFixedPropertyValue(position);
    }

    @Override
    public Object getPropertyValue(String name) {
        return this._ted.getPropertyValue(name);
    }

    @Override
    public Object getPathValue(String path) {
        return this._ted.getPathValue(path);
    }

    @Override
    public int getVersion() {
        return this._ted.getVersion();
    }

    @Override
    public long getExpirationTime() {
        return this._ted.getExpirationTime();
    }

    public boolean isRemovedFromForeignIndex() {
        return this._removedFromForeignIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemovedFromForeignIndex() {
        this._removedFromForeignIndex = true;
        if (this._waitingForRemove) {
            SpaceServerEntryImpl spaceServerEntryImpl = this;
            synchronized (spaceServerEntryImpl) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRemovalFromForeignIndex() {
        if (this.isRemovedFromForeignIndex()) {
            return;
        }
        SpaceServerEntryImpl spaceServerEntryImpl = this;
        synchronized (spaceServerEntryImpl) {
            this._waitingForRemove = true;
            if (this.isRemovedFromForeignIndex()) {
                return;
            }
            long upto = System.currentTimeMillis() + MAX_TIME_TO_WAIT_FOR_INDEX_REMOVAL;
            long left = MAX_TIME_TO_WAIT_FOR_INDEX_REMOVAL;
            do {
                try {
                    this.wait(left);
                }
                catch (Exception ex) {
                    throw new RuntimeException("entry encountered exception while waiting for remove uid=" + this._eci.getUID() + " ex=" + ex);
                }
                if (!this.isRemovedFromForeignIndex()) continue;
                return;
            } while ((left = upto - System.currentTimeMillis()) > 0L);
            if (!this.isRemovedFromForeignIndex()) {
                throw new RuntimeException("entry is not removed after timed waiting uid=" + this._eci.getUID());
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        SpaceServerEntryImpl other = (SpaceServerEntryImpl)o;
        return this._eci == other._eci;
    }
}

